/**
 * $Id$
 *
 * トップノードの特殊フォルダの関数をまとめたヘッダファイル
 */
#ifndef INCLUDE_TF_RDBO_ROOT_H
#define INCLUDE_TF_RDBO_ROOT_H

#include "httpd.h"
#include "apr.h"
#include "apr_pools.h"
#include "tf_rdbo_util.h"
#include "tf_rdbo.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Declare public functions 
  ----------------------------------------------------------------------------*/
/**
 * rootreesearch (alllist) のDB検索.
 * この関数では、ユーザフォルダの情報だけを取得しています.
 * その他の特殊フォルダはtf_folder.c が保持する内部データだけで表現します.
 *
 * (note)
 *   この関数は以前、1つの関数divy_rdbo_roottreesearch() の中のif で表現されていました.
 *   しかし、複雑度が増し、しかも共通化できる箇所が数行しかなくなってしまったため、
 *   分離しました. その他の関数群も同じ扱いです.
 *
 * @param request_rec * apache request_rec構造体
 * @param divy_rdbo_resource ** 取得した特殊フォルダリソース群へのポインタ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_roottree_alllist(request_rec *r, divy_rdbo_resource **rdb_r);

/**
 * rootreesearch (sqlstmt) のDB検索.
 *
 * @param request_rec * apache request_rec構造体
 * @param divy_rdbo_resource ** 取得したSQL群へのポインタ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_roottree_sql(request_rec *r, divy_rdbo_resource **rdb_r);

/**
 * rootreesearch (reposdbsqlstmt) のDB検索.
 *
 * @param request_rec * apache request_rec構造体
 * @param divy_rdbo_resource ** 取得したSQL群へのポインタ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_roottree_reposdbsql(request_rec *r, divy_rdbo_resource **rdb_r);

/**
 * rootreesearch (execsqlstmt) のDB検索.
 *
 * @param request_rec * apache request_rec構造体
 * @param divy_rdbo_resource ** 取得したSQL群へのポインタ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_roottree_execsql(request_rec *r, divy_rdbo_resource **rdb_r);

/**
 * rootreesearch (grouplist) のDB検索.
 *
 * @param request_rec * apache request_rec構造体
 * @param divy_rdbo_resource ** 取得したグループ群へのポインタ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_roottree_grouplist(request_rec *r, divy_rdbo_resource **rdb_r);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_TF_RDBO_ROOT_H */

