/**
 * $Id$
 *
 * 特殊フォルダ「メッセージ」関連の関数をまとめたヘッダファイル
 */
#ifndef INCLUDE_TF_RDBO_SYSMSG_H
#define INCLUDE_TF_RDBO_SYSMSG_H

#include "apr.h"
#include "apr_pools.h"
#include "tf_rdbo_util.h"
#include "tf_rdbo.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Declare public functions 
  ----------------------------------------------------------------------------*/
/**
 * 指定されたSQL文、検索オプションによりシステムメッセージ情報を
 * リポジトリDBから検索して返却する(sysmsginformationsearch)
 *
 * @param params divy_rdbo_search_params * 入力パラメータ
 * @param screen divy_search_sysmsgis_iscreen * 入力値
 * @param output divy_rdbo_search_output * 出力結果へのポインタ(アロケート済み)
 * @return int 処理ステータス (0:成功 / 1:失敗)
 */
DIVY_DECLARE(int) divy_rdbo_sysmsginformationsearch(divy_rdbo_search_params *params,
						divy_search_sysmsgis_iscreen *screen,
						divy_rdbo_search_output *output);

/**
 * 指定されたmsgid が示すシステムメッセージを取得して返却する。
 *
 * select対象のテーブル: divy_sysmsg
 *
 * @param r request_rec *
 * @param msgid const char * msgidを表す文字列
 * @param sysmsg_pr divy_rdbo_sysmsg ** 取得したシステムメッセージ情報
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_get_sysmsg_property(request_rec *r, const char *msgid,
						divy_rdbo_sysmsg **sysmsg_pr);

/**
 * アクティブなシステムメッセージを取得する。
 *
 * select対象のテーブル: divy_sysmsg
 *
 * @param r request_rec *
 * @param sysmsg_pr divy_rdbo_sysmsg ** 取得したシステムメッセージ情報
 * 			アクティブなメッセージが1つもなければNULL。
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_get_active_sysmsg(request_rec *r,
						divy_rdbo_sysmsg **sysmsg_pr);

/**
 * アクティブなシステムメッセージ数を返却する。
 *
 * select対象のテーブル: divy_sysmsg
 *
 * @param r request_rec *
 * @param count int * メッセージ数
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_count_active_sysmsg(request_rec *r, int *count);

/**
 * 指定されたsysmsg_pr が表すシステムメッセージを新規登録する。
 *
 * insert対象のテーブル:  divy_sysmsg
 * (note) sysmsg_pr の必須項目
 *	msgid, active
 *	registdt は自動的に補完します。
 *	上記以外のデータは、指定されていた値をそのまま反映します。
 * (note)
 *	同じタイムスタンプ(msgid)を持つシステムメッセージは登録できません。
 *
 * @param r request_rec *
 * @param sysmsg_pr const divy_rdbo_sysmsg * 登録するシステムメッセージ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_insert_sysmsg_property(request_rec *r,
					const divy_rdbo_sysmsg *sysmsg_pr);

/**
 * 指定されたsysmsg_pr が表す内容でシステムメッセージを更新する。
 *
 * update 対象のテーブル: divy_sysmsg
 * (note) sysmsg_pr の必須項目(変更項目):
 *	active
 *	上記のうち、updatedtは自動的に補完します。
 * (note) 以下のデータは更新できません。
 *	msgid, registdt
 *	上記以外のデータは、指定されていた値をそのまま反映します。
 * (note) ts_ctxがない場合は失敗します。
 *
 * @param r request_rec *
 * @param sysmsg_pr const divy_rdbo_sysmsg * 更新するシステムメッセージ
 * @param ts_ctx divy_db_transaction_ctx * トランザクションコンテキスト
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_update_sysmsg_property(request_rec *r,
					const divy_rdbo_sysmsg *sysmsg_pr,
					divy_db_transaction_ctx *ts_ctx);

/**
 * 指定されたsysmsg_pr が示すシステムメッセージを削除する。
 *
 * delete 対象テーブル: divy_sysmsg
 *
 * @param r request_rec *
 * @param sysmsg_pr const divy_rdbo_sysmsg * 削除するシステムメッセージ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_remove_sysmsg_property(request_rec *r,
					const divy_rdbo_sysmsg *sysmsg_pr);

/**
 * 指定されたsrc_sysmsg_pr が示すシステムメッセージをdst_sysmsg_pr が示す
 * システムメッセージとしてコピーする。
 *
 * @param r request_rec *
 * @param src_sysmsg_pr const divy_rdbo_sysmsg * コピー元システムメッセージ
 * @param dst_sysmsg_pr const divy_rdbo_sysmsg * コピー先システムメッセージ
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_copy_sysmsg_property(request_rec *r,
					const divy_rdbo_sysmsg *src_sysmsg_pr,
					const divy_rdbo_sysmsg *dst_sysmsg_pr);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_TF_RDBO_SYSMSG_H */

