/**
 * $Id$
 *
 * util_ldap.h
 *
 * LDAPユーティリティ関数用ヘッダファイル
 *
 *
 */
#ifndef INCLUDE_UTIL_LDAP_H
#define INCLUDE_UTIL_LDAP_H

#include "httpd.h"
#include "apr.h"
#include "apr_pools.h"

#include "tfldaputil.h"
#include "tf_rdbo.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
  Define fixed values and define types.
  --------------------------------------------------------------*/
/* LDAP Result */
enum {
	TF_LDAP_FALSE = 0,         /* エラー                   */
	TF_LDAP_TRUE,              /* 正常                     */
	TF_LDAP_FAIL_SERVERDOWN,   /* LDAPサーバが停止していた */
	TF_LDAP_FAIL_OBJNOTFOUND,  /* LDAPからの結果がない     */
	TF_LDAP_FAIL_AUTHFAIL,     /* LDAP認証エラー           */
};

/* LDAP over ssl 認証の時に必要なタイプ */
#define LDAP_CA_TYPE_BASE64	2

/* LDAPの状態 */
enum {
	TF_LDAP_UNSET = 0,	/* LDAPが設定されていない */
	TF_LDAP_OFF,		/* LDAPを利用しない       */
	TF_LDAP_ON		/* LDAPを利用する         */
};

/**
 * LDAP SCOPE define
 */
#if APR_HAS_NETSCAPE_LDAPSDK
	#define TF_LDAP_SCOPE_BASE	0
	#define TF_LDAP_SCOPE_ONELEVEL	0
	#define TF_LDAP_SCOPE_SUBTREE	0
#elif APR_HAS_NOVELL_LDAPSDK
	#define TF_LDAP_SCOPE_BASE	0
	#define TF_LDAP_SCOPE_ONELEVEL	0
	#define TF_LDAP_SCOPE_SUBTREE	0
#elif APR_HAS_OPENLDAP_LDAPSDK
	#define TF_LDAP_SCOPE_BASE	LDAP_SCOPE_BASE
	#define TF_LDAP_SCOPE_ONELEVEL	LDAP_SCOPE_ONELEVEL
	#define TF_LDAP_SCOPE_SUBTREE	LDAP_SCOPE_SUBTREE
#elif APR_HAS_MICROSOFT_LDAPSDK
	#define TF_LDAP_SCOPE_BASE	0
	#define TF_LDAP_SCOPE_ONELEVEL	0
	#define TF_LDAP_SCOPE_SUBTREE	0
#elif APR_HAS_OTHER_LDAPSDK
	#define TF_LDAP_SCOPE_BASE	0
	#define TF_LDAP_SCOPE_ONELEVEL	0
	#define TF_LDAP_SCOPE_SUBTREE	0
#else
	#error "Error no LDAP SDK"
#endif

/*--------------------------------------------------------------
  Declare Public Functions
 *--------------------------------------------------------------*/	
/**
 * LDAPを利用しているユーザかを調べる
 *
 * @param	r request_rec *
 * @return  int TF_LDAP_TRUE(LDAPを利用) | TF_LDAP_FALSE(LDAP利用しない)
 */
LDAP_DECLARE(int) divy_util_ldap_use_ldap(request_rec *r);


/**
 * LDAPの初期化を行う
 * このコードはPostconfigから呼ばれることを意識しています。
 * その他での利用はしないでください。
 * 
 * @param s server_rec*			サーバリクエスト構造体
 * @param pconf apr_pool_t		プール
 */
LDAP_DECLARE(int) divy_util_ldap_initialize_config(server_rec *s, apr_pool_t *pconf);

/**
 * LDAPが利用するキャッシュ領域（共有メモリ）を作成する
 * (note)
 * 	この内部で共有メモリをプールを利用して作成します。
 * 	共有メモリの存続はプールの存続期間に縛られる為、
 * 	引数のプールには注意して利用してください。
 * この関数はpost_configから呼ばれることを意識して作られています。
 *
 * @param pchild apr_pool_t *		プール
 * @param s server_rec *		サーバリクエスト構造体
 *
 * @return TF_LDAP_TRUE 成功 | TF_LDAP_FALSE 失敗
 */
LDAP_DECLARE(int) divy_util_ldap_initialize(apr_pool_t *pool, server_rec *s);

/**
 * LDAPへユーザIDとパスワードのチェックを行なう
 *
 * @param r request_rec *		リクエスト構造体
 * @param userid const char *		ユーザID
 * @param passwd const char *		パスワード
 *
 * @return int
 *
 */
LDAP_DECLARE(int) divy_util_ldap_check_userid(request_rec *r,
					       	const char *userid,
					       	const char *passwd);
/**
 * LDAPからユーザの情報を取得する
 * divy_rdbo_get_user_property()と同じく構造体に値を埋めて返す。
 * (note)
 * 	パスワードは取得しないことになりました。(2004/12/14 Tue)
 *
 * @param r request_rec *
 * @param wp apr_pool_t * 取得結果が割り当てられるプール。
 * 			usr_pr のアロケート元と同じであること。
 * @param userid const char *
 * @param usr_pr divy_rdbo_usr *
 *
 */
LDAP_DECLARE(int) divy_util_ldap_get_user_property(request_rec *r,
					      apr_pool_t *wp,
					      const char *userid,
					      divy_rdbo_usr *usr_pr);
/**
 * LDAPの情報を元にTeamFileにユーザを新規作成する
 * (note)
 * 	LDAPから取得できる項目はuserid, password, fullname, mailaddress
 * 	それ以外の項目はすべてデフォルト値を設定するようにする
 *
 * @param r		request_rec *
 * @param userid	const char * ユーザID
 * @param password	const char * ユーザが入力したパスワード
 *
 * @return TF_LDAP_TRUE | TF_LDAP_FALSE
 */
LDAP_DECLARE(int) divy_util_ldap_found_create_user(request_rec *r, const char *userid,
							const char *password);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_UTIL_LDAP_H */

