/**
 * $Id$
 *
 * util_vscan.h
 *
 * TeamFile モジュールがウィルス検索プロバイダにアクセスするのに必要な手続きを
 * 宣言するヘッダファイル。
 *
 * 2004/10/04 Mon takehara NEW
 */
#ifndef INCLUDE_UTIL_VSCAN_H
#define INCLUDE_UTIL_VSCAN_H

#include "httpd.h"
#include "apr.h"
#include "apr_pools.h"
#include "tfr.h"
#include "tf_vscan.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Define fixed value
  ----------------------------------------------------------------------------*/
/**
 * 何もしないウィルス検索プロバイダを表す値(caseignore)
 * ウィルス検索をしてはならないかどうか判断するための定義値です。
 */
#define DIVY_VSC_OFF	"off"

#define DIVY_VSC_LIMIT_FILE_SIZE APR_INT64_C(4 * 1024 * 1024 * 1024)

/**
 * ウィルス検索プロバイダを利用できるかどうかを示す列挙型
 * (関数divy_vsc_has_license で使用される値)
 */
enum {
	DIVY_VSC_ST_ACTIVE = 1,		/* 有効である     */
	DIVY_VSC_ST_LICENSE_EXPIRE,	/* ライセンス切れ */
	DIVY_VSC_ST_INACTIVE,		/* 動作しない     */
};

/*------------------------------------------------------------------------------
  Define Public Functions
  ----------------------------------------------------------------------------*/
/**
 * ウィルス検索プロバイダ管理コンテキストを初期化する。
 * この関数は複数のスレッドからアクセスされてはなりません。
 * (note)
 * 	この関数は、ウィルス検索セッションを使用するどの全ての関数よりも先に
 * 	呼び出される必要があります。child_initステージが適切です。
 * (note)
 * 	この関数を複数回呼び出さないようコール元で保証して下さい。
 *
 * @param pchild apr_pool_t * Childプロセスとライフサイクルを共にするプール
 * @param s server_rec * main serverのserver_rec
 */
DIVY_DECLARE(void) init_vscprv_env(apr_pool_t *pchild, server_rec *s);

/**
 * 指定されたproviderTypeのウィルス検索プロバイダ(VscDataSource)を取得する。
 * (note)
 * 	プロバイダが初期化されていなければ、初期化してから返却します。
 * (note)
 * 	この関数は、mod_dav_tf モジュールでしか使用できないフック関数を使用
 * 	しているため、このモジュールの中でしか使用できません。
 * 	他のモジュールからCallしないこと。
 *
 * @param r request_rec *
 * @param providerType const char* ウィルス検索プロバイダタイプ
 * @return VscDataSource * ウィルス検索プロバイダ提供の構造体へのポインタ
 */
DIVY_DECLARE(VscDataSource *) lookup_vsc_provider(request_rec *r,
						const char *providerType);

/**
 * ウィルス検索プロバイダとの接続を行い、ウィルス検索可能な状態にする。
 * 取得したセッションはクリーンアップハンドラに自動的に登録されますので
 * 明示的にcloseSession する必要はありません。
 * ウィルスパターンデータベースのローディングも自動的に行います。
 *
 * @param r request_rec *
 * @param vscds VscDataSource * ウィルス検索プロバイダへのポインタ
 * @return VscSession * ウィルス検索エンジンとの接続状態
 */
DIVY_DECLARE(VscSession *) divy_get_vscsession(request_rec *r,
						VscDataSource *vscds);

/**
 * ウィルス検索プロバイダを利用できるかどうか。
 *
 * [ 利用可能な条件 ]
 *   * 適切なライセンスを持っていること
 *   * ウィルス検索プロバイダがOFFになっていないこと
 *
 * @param r request_rec *
 * @return int
 * 	DIVY_VSC_ST_ACTIVE         : 有効だった
 * 	DIVY_VSC_ST_INACTIVE       : OFFだった
 */
DIVY_DECLARE(int) divy_vsc_enable(request_rec *r);

/*------------------------------------------------------------------------------
  Define utility Public Functions
  ----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_UTIL_VSCAN_H */

