/***************************************************************************
                          ldapcache.c  -  description
                             -------------------
    begin                : Tue.  Apr., 15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/
#include "ldapcache.h"
#include "urlnode.h"
#include "tfldaputil.h"
#include "searchnode.h"


void
LDAPCache_removeSearchNode (RMMANAGER * pRMMgr, RM_HANDLE hUserData)
{
  SearchNode *pSearchNode;
  RM_ASSERT (pRMMgr);
  RM_ASSERT (hUserData);
  /* destroy search node */
  pSearchNode = (SearchNode *) RMHandleToPtr (pRMMgr, hUserData);
  RM_ASSERT (pSearchNode);
  SearchNode_Destroy (pSearchNode, pRMMgr);
  RMFree (pRMMgr, hUserData);
}


void
removeURLNode (RMMANAGER * pRMMgr, RM_HANDLE hUserData)
{
  URLNode *pURLNode;
  RM_ASSERT (pRMMgr);
  RM_ASSERT (hUserData);
  /* destroy search node */
  pURLNode = (URLNode *) RMHandleToPtr (pRMMgr, hUserData);
  RM_ASSERT (pURLNode);
  URLNode_Destroy (pURLNode, pRMMgr);
  RMFree (pRMMgr, hUserData);
}


/**
 *  0     :  failure
 *  else  :  success
 */
RM_HANDLE
LDAPCache_Create (RMMANAGER * pRMMgr, unsigned long unURLHashTblSize, unsigned long unSearchHashTblSize)
{
  RM_HANDLE hRet;
  LDAPCache *pCache;

  RM_ASSERT (pRMMgr);
  if (!unURLHashTblSize || !unSearchHashTblSize)
    return 0;

  hRet = RMMalloc (pRMMgr, sizeof (LDAPCache));
  pCache = (LDAPCache *) RMHandleToPtr (pRMMgr, hRet);
  if (!pCache)
    return 0;


  pCache->pRMMgr = pRMMgr;
  pCache->unEntryCount = 0;
  pCache->tmMark = 0;
  pCache->bMarked = 0;

  if (unURLHashTblSize < TF_LDAP_MINURLHASHSIZE)
    unURLHashTblSize = TF_LDAP_MINURLHASHSIZE;
  if (unSearchHashTblSize < TF_LDAP_MINSEARCHHASHSIZE)
    unSearchHashTblSize = TF_LDAP_MINSEARCHHASHSIZE;
  pCache->unURLHashTblSize = unURLHashTblSize;
  pCache->unSearchHashTblSize = unSearchHashTblSize;

  pCache->hhURLNodes = RMCalloc (pRMMgr, unURLHashTblSize * sizeof (RM_HANDLE));
  if (!pCache->hhURLNodes) {
    RMFree (pRMMgr, hRet);
    return 0;
  } else {
    return hRet;
  }

}

/**
 */
void
LDAPCache_Destroy (LDAPCache * pCache, RMMANAGER * pRMMgr)
{
  unsigned long unIndex;
  RM_HANDLE hList, *phList;
  RMULIST list;
  RM_ASSERT (pCache);

  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pCache->hhURLNodes);
  if (!phList)
    return;
  for (unIndex = 0; unIndex < pCache->unURLHashTblSize; unIndex++) {
    hList = phList[unIndex];
    if (hList) {
      if (RMUOK ==
	  RMUListAttach (pRMMgr, &list, 0, removeURLNode, &phList[unIndex])) {
	RMUListDestroy (&list);
      }
    }
  }
}

/*
 * Search URL node in cache.
 * If the node is found, handle will be returned
 * If not found, 0 will be returned.
 */
RM_HANDLE
LDAPCache_GetURLNode (LDAPCache * pCache, RMMANAGER * pRMMgr,
		      const char *pszURL)
{
  unsigned long unURLHashTblSize;
  unsigned long unHash;
  const char *pszNodeURL;
  RM_HANDLE hRet, hList, *phList;
  URLNode *pURLNode;
  RMULIST list;
  RMURESULT enuRet;

  RM_ASSERT (pCache);
  RM_ASSERT (pszURL);
  RM_ASSERT (pRMMgr);

  unURLHashTblSize = pCache->unURLHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pCache->hhURLNodes);
  RM_ASSERT (phList);

  unHash = TFHashString (1, pszURL);
  hList = phList[unHash % unURLHashTblSize];

  if (!hList) {
    return 0;
  } else {
    /* traverse the list */
    enuRet =
      RMUListAttach (pRMMgr, &list, 0, 0, &phList[unHash % unURLHashTblSize]);
    if (RMUOK != enuRet)
      return 0;
    for (enuRet = RMUListGoToHead (&list);
	 RMUOK == enuRet; enuRet = RMUListNext (&list)) {
      RMUListGetData (&list, &hRet);
      pURLNode = (URLNode *) RMHandleToPtr (pRMMgr, hRet);
      RM_ASSERT (pURLNode);
      pszNodeURL = (const char *) RMHandleToPtr (pRMMgr, pURLNode->hszURL);
      RM_ASSERT (pszNodeURL);
      if (strcmp (pszURL, pszNodeURL) == 0) {
	/* we found it */
	return hRet;
      }
    }
    /* not found in the list */
    return 0;
  }

/*  return hRet;*/
}


/*
 * Create a new URL node and insert it into cache.
 *  If a linked list exists in the hash table, the
 *  node will be inserted. If not, a list will be
 *  created. (does NOT check for duplicates)
 */
RM_HANDLE
LDAPCache_CreateURLNode (LDAPCache * pCache, RMMANAGER * pRMMgr,
			 const char *pszURL)
{
  unsigned long unURLHashTblSize;
  unsigned long unHash;
  unsigned int nIndex;
  RM_HANDLE hRet, hList, *phList;
  RMULIST list;

  RM_ASSERT (pCache);
  RM_ASSERT (pszURL);
  RM_ASSERT (pRMMgr);

  unURLHashTblSize = pCache->unURLHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pCache->hhURLNodes);
  RM_ASSERT (phList);

  unHash = TFHashString (1, pszURL);
  nIndex = unHash % unURLHashTblSize;
  hList = phList[nIndex];

  if (!hList) {
    /* create a new list */
    RM_VERIFY (RMUOK == RMUListCreate (pRMMgr, &list, 0, 0, &phList[nIndex]));
  } else {
    /* attach the list */
    if (RMUOK != RMUListAttach (pRMMgr, &list, 0, 0, &phList[nIndex]))
      return 0;
  }

  /* create the node */
  hRet = URLNode_Create (pRMMgr, pszURL, pCache->unSearchHashTblSize);
  if (!hRet)
    return 0;
  RMUListInsertHead (&list, (void *) hRet);

  pCache->unEntryCount++;
  return hRet;
}

void
LDAPCache_RemoveURLNode (LDAPCache * pCache, RMMANAGER * pRMMgr,
			 const char *pszURL)
{
  unsigned long unURLHashTblSize;
  unsigned long unHash;
  const char *pszNodeURL;
  RM_HANDLE hRet, hList, *phList;
  URLNode *pURLNode;
  RMULIST list;
  RMURESULT enuRet;

  RM_ASSERT (pCache);
  RM_ASSERT (pszURL);
  RM_ASSERT (pRMMgr);

  unURLHashTblSize = pCache->unURLHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pCache->hhURLNodes);
  RM_ASSERT (phList);

  unHash = TFHashString (1, pszURL);
  hList = phList[unHash % unURLHashTblSize];

  RM_ASSERT (hList);

  /* traverse the list */
  enuRet = RMUListAttach (pRMMgr, &list, 0,
			  removeURLNode, &phList[unHash % unURLHashTblSize]);
  RM_ASSERT (RMUOK == enuRet);
  for (enuRet = RMUListGoToHead (&list);
       RMUOK == enuRet; enuRet = RMUListNext (&list)) {
    RMUListGetData (&list, &hRet);
    pURLNode = (URLNode *) RMHandleToPtr (pRMMgr, hRet);
    RM_ASSERT (pCache);
    pszNodeURL = (const char *) RMHandleToPtr (pRMMgr, pURLNode->hszURL);
    RM_ASSERT (pszNodeURL);
    if (strcmp (pszURL, pszNodeURL) == 0) {
      /* we found it */
      RMUListRemoveCurrent (&list);
      pCache->unEntryCount--;
    }
  }
}

void
LDAPCache_Purge(LDAPCache * pCache, RMMANAGER * pRMMgr) {
  int unURLHashTblSize;
  int nIndex;
  RMULIST list;
  RM_HANDLE *phList;
  if (!pCache || !pRMMgr) {
    return;
  }
  unURLHashTblSize = (int) pCache->unURLHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pCache->hhURLNodes);
  
  for (nIndex = 0; nIndex < unURLHashTblSize; nIndex++) {
    RM_HANDLE hURLList = phList[nIndex];
    RMURESULT enuRet;
    if (hURLList) {
      enuRet = RMUListAttach (pRMMgr, &list, 0, 0, &phList[nIndex]);
      if (RMUOK != enuRet) {
	continue;
      }
      //list attach ok, traverse to find the URL node
      for (enuRet = RMUListGoToHead (&list);
	   RMUOK == enuRet; enuRet = RMUListNext (&list)) {
	URLNode *pURLNode;
	RM_HANDLE hRet;
	RM_HANDLE *pSchLists;
	const char *pszNodeURL;
	int nSearchTblSize;
	int nSchIndex;
	
	RMUListGetData (&list, &hRet);
	pURLNode = (URLNode *) RMHandleToPtr (pRMMgr, hRet);
	RM_ASSERT (pURLNode);
	
	pszNodeURL = (const char *) RMHandleToPtr (pRMMgr, pURLNode->hszURL);
	RM_ASSERT (pszNodeURL);

	//now let's  get the search nodes
	nSearchTblSize = (int) pURLNode->unHashTblSize;
	pSchLists = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pURLNode->hhSearchNodes);
	for (nSchIndex = 0; nSchIndex < nSearchTblSize; nSchIndex++) {
	  RM_HANDLE hSchList = pSchLists[nSchIndex];
	  if (hSchList) {
	    RMULIST schList;
	    RMURESULT enuSchNodeRet;
	    RMURESULT enuSchRet;
	    
	    enuSchRet = RMUListAttach (pRMMgr, &schList, 0, LDAPCache_removeSearchNode, &pSchLists[nSchIndex]);
	    if (RMUOK != enuSchRet) {
	      continue;
	    }
	    
	    //list attach ok, traverse to find the URL node
	    for (enuSchNodeRet = RMUListGoToHead (&schList);
		 RMUOK == enuSchNodeRet;
		 enuSchNodeRet = RMUListNext (&schList)) {
	      RM_HANDLE hRet;
              SearchNode *pSearchNode;
              const char *pszUserName;
	      
	      RMUListGetData (&schList, &hRet);
	      pSearchNode = (SearchNode *) RMHandleToPtr (pRMMgr, hRet);
	      RM_ASSERT (pSearchNode);
	      pszUserName = (const char *) RMHandleToPtr (pRMMgr, pSearchNode->hszUserName);
	      RM_ASSERT (pszUserName);

	      if(pSearchNode->tmLastBind < pCache->tmMark) {
		/* URLNode_RemoveSearchNode (pURLNode, pRMMgr, pszUserName);*/
		RMUListRemoveCurrent(&schList);

	      }
	    }
	  }
	}
      }
    }
  }
}


