/***************************************************************************
                          LDAPCache.h  -  description
                             -------------------
    begin                : Tue.  Apr., 15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/

#ifndef LDAPCACHE_H
#define LDAPCACHE_H

#include <apr.h>
#include <apr_time.h>
#include "rmmgr.h"
#include "urlnode.h"

typedef struct tagLDAPCache {
  RMMANAGER *pRMMgr;
  unsigned long unURLHashTblSize;	/* Size of hash table */
  unsigned long unSearchHashTblSize;	/* Size of hash table */
  unsigned long unEntryCount;		/* Current number of cache entries */
  apr_time_t tmMark;			/* Time that the cache was marked for purge */
  int bMarked;				/* Time that the cache was marked for purge */
  RM_HANDLE hhURLNodes;
} LDAPCache;

RM_HANDLE LDAPCache_Create (RMMANAGER * pRMMgr, unsigned long unURLHashTblSize, unsigned long unSearchHashTblSize);
void    LDAPCache_Destroy (LDAPCache * pCache, RMMANAGER * pRMMgr);
RM_HANDLE LDAPCache_GetURLNode (LDAPCache * pCache, RMMANAGER * pRMMgr, const char *pszURL);
RM_HANDLE LDAPCache_CreateURLNode (LDAPCache * pCache, RMMANAGER * pRMMgr, const char *pszURL);
void    LDAPCache_RemoveURLNode (LDAPCache * pCache, RMMANAGER * pRMMgr, const char *pszURL);
void	LDAPCache_Purge(LDAPCache * pCache, RMMANAGER * pRMMgr);
#endif /* LDAPCACHE_H */
