/***************************************************************************
                          searchnode.c  -  description
                             -------------------
    begin                : Tue.  Apr., 15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/
#include "searchnode.h"

RM_HANDLE
SearchNode_Create (RMMANAGER * pRMMgr, const char *pszUsername)
{
  RM_HANDLE hRet;
  SearchNode *pNode;

  RM_ASSERT (pRMMgr);
  if (!pszUsername)
    return 0;

  hRet = RMMalloc (pRMMgr, sizeof (SearchNode));
  pNode = (SearchNode *) RMHandleToPtr (pRMMgr, hRet);

  if (!pNode)
    return 0;

  pNode->hszUserName = RMUstrdup (pRMMgr, pszUsername, 0);
  pNode->tmLastBind = apr_time_now ();
  pNode->nValCount = 0;
  pNode->hszBindPW = 0;
  pNode->hszDN = 0;
  pNode->hhszVals = 0;
  return hRet;
}

void
SearchNode_Destroy (SearchNode * pNode, RMMANAGER * pRMMgr)
{
  /*
     RMFree();
     RM_ASSERT();
   */
  unsigned int nIndex, nValCount;
  RM_HANDLE hhszVals, *phszVals;

  RM_ASSERT (pNode);
  RM_ASSERT (pRMMgr);

  if (pNode->hszUserName)
    RMFree (pRMMgr, pNode->hszUserName);
  if (pNode->hszDN)
    RMFree (pRMMgr, pNode->hszDN);
  if (pNode->hszBindPW)
    RMFree (pRMMgr, pNode->hszBindPW);

  /* free attribute strings */
  nValCount = pNode->nValCount;
  if (nValCount) {
    RM_ASSERT (pNode->hhszVals);
    hhszVals = pNode->hhszVals;
    if(hhszVals) {
      phszVals = (RM_HANDLE *) RMHandleToPtr (pRMMgr, hhszVals);
      RM_ASSERT (phszVals);
      for (nIndex = 0; nIndex < nValCount; nIndex++) {
	/*RM_ASSERT(phszVals[nIndex]); */
	if (phszVals[nIndex])
	  RMFree (pRMMgr, phszVals[nIndex]);
      }
      RMFree (pRMMgr, hhszVals);
    } else {
      /*TODO: empty attribute array warning*/
    }
  }
}
