/***************************************************************************
                          searchnode.h  -  description
                             -------------------
    begin                : Tue.  Apr.,  15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/

#ifndef SEARCHNODE_H
#define SEARCHNODE_H

#include <apr.h>
#include <apr_time.h>
#include "rmmgr.h"

typedef struct tagSearchNode {
  RM_HANDLE hszUserName;	/* Cache key */
  RM_HANDLE hszDN;		/* DN returned from search */
  RM_HANDLE hszBindPW;		/* The most recently used bind password;
				   NULL if the bind failed */
  apr_time_t tmLastBind;	/* Time of last successful bind */
  RM_HANDLE hhszVals;		/* Values of queried attributes */
  int     nValCount;		/* count of attributes */
} SearchNode;

RM_HANDLE SearchNode_Create (RMMANAGER * pRMMgr, const char *pszUsername);
void    SearchNode_Destroy (SearchNode * pNode, RMMANAGER * pRMMgr);

#endif /* SEARCHNODE_H */
