/***************************************************************************
  $id:$
                          tfldaputil.h  -  description
                             -------------------
    begin                : Tue.  Apr., 15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/
#ifndef TFLDAPUTIL_H
#define TFLDAPUTIL_H

#include <apr.h>
#include <apr_ldap.h>
#include <apr_shm.h>
#include <apr_pools.h>
#include "ldapcache.h"
#include "rmmgr.h"

#define TF_LDAP_MINURLHASHSIZE		32
#define TF_LDAP_MINSEARCHHASHSIZE	32
#define TF_LDAP_DEFAULTSHMPATH  	"/tmp/tf_ldap_shm"
#define TF_LDAP_MINCACHEBYTES   	1*1024*1024
#define TF_LDAP_MINMEMBLOCKS   		1024
#define TF_LDAP_DEFURLHASHSIZE		1024
#define TF_LDAP_DEFSCHHASHSIZE		256
#define TF_LDAP_DEFAULTTTL      	60*APR_USEC_PER_SEC
#define TF_LDAP_DEFMARKPERCENT		50.0
#define TF_LDAP_DEFPURGEPERCENT		90.0
#define TF_LDAP_MAXMARKPERCENT		90.0
#define TF_LDAP_MAXPURGEPERCENT		99.0
#define TF_LDAP_FILTERBUFLEN    	8192
#define TF_LDAP_CONNMAXRETRY    	10
#define TF_LDAP_SEARCHRETRY     	10


#define TFLU_RDLOCK(pUtil)      	TFLDAPUtil_lock(pUtil, TFLUREADLOCK)
#define TFLU_WRLOCK(pUtil)      	TFLDAPUtil_lock(pUtil, TFLUWRITELOCK)
#define TFLU_UNLOCK(pUtil)      	TFLDAPUtil_lock(pUtil, TFLUUNLOCK)

/*
#define TFLU_RDLOCK(pUtil)		((void)0)
#define TFLU_WRLOCK(pUtil)		((void)0)
#define TFLU_UNLOCK(pUtil)		((void)0)
*/
/*
#define TMP_RDLOCK(pUtil)		TFLDAPUtil_lock(pUtil, TFLUREADLOCK)
#define TMP_WRLOCK(pUtil)		TFLDAPUtil_lock(pUtil, TFLUWRITELOCK)
#define TMP_UNLOCK(pUtil)		TFLDAPUtil_lock(pUtil, TFLUUNLOCK)
*/

#define TMP_RDLOCK(pUtil)		((void)0)
#define TMP_WRLOCK(pUtil)		((void)0)
#define TMP_UNLOCK(pUtil)		((void)0)




#if !defined(WIN32)
#define LDAP_DECLARE(type)            type
#define LDAP_DECLARE_NONSTD(type)     type
#define LDAP_DECLARE_DATA
#elif defined(LDAP_DECLARE_STATIC)
#define LDAP_DECLARE(type)            type __stdcall
#define LDAP_DECLARE_NONSTD(type)     type
#define LDAP_DECLARE_DATA
#elif defined(LDAP_DECLARE_EXPORT)
#define LDAP_DECLARE(type)            __declspec(dllexport) type __stdcall
#define LDAP_DECLARE_NONSTD(type)     __declspec(dllexport) type
#define LDAP_DECLARE_DATA             __declspec(dllexport)
#else
#define LDAP_DECLARE(type)            __declspec(dllimport) type __stdcall
#define LDAP_DECLARE_NONSTD(type)     __declspec(dllimport) type
#define LDAP_DECLARE_DATA             __declspec(dllimport)
#endif

typedef enum tagTFLRESULT {
  TFLROK,			/* operation successful */
  TFLRINVALIDARG,		/* argument(s) invalid */
  TFLROUTOFMEM,			/* out of memory */
  TFLRSHMINITFAILED,		/* failed to initialize shared memory */
  TFLRLDAPINITFAILED,		/* failed to initialize ldap client */
  TFLRBINDFAILED,		/* failed to bind to ldap server */
  TFLRCONNNOTFOUND,		/* LDAP connection not found(not likely to happen) */
  TFLRSERVERDOWN,		/* LDAP server down */
  TFLRSSLNOTSUPPORTED,		/* SSL connection is not supported */
  TFLRSEARCHFAILED,		/* LDAP search failed */
  TFLROBJNOTFOUND,		/* object(user) not found */
  TFLROBJNOTUNIQUE,		/* object(user) not unique */
  TFLRINVALIDPASSWD,		/* password invalid(empty) */
  TFLRAUTHFAILED		/* ldap auth failed */
} TFLRESULT;

typedef enum tagTFLULOCKTYPE {
  TFLUREADLOCK,
  TFLUWRITELOCK,
  TFLUUNLOCK
} TFLULOCKTYPE;
/*
 * LDAP Connections
 */

/* Values that the deref member can have */
typedef enum tagDEREFOPT {
  never = LDAP_DEREF_NEVER,
  searching = LDAP_DEREF_SEARCHING,
  finding = LDAP_DEREF_FINDING,
  always = LDAP_DEREF_ALWAYS
} DEREFOPT;


/*
 *  certificate file types
 */
typedef enum tagTFCATYPE {
  LDAP_CA_TYPE_UNKNOWN,
  LDAP_CA_TYPE_DER,
  LDAP_CA_TYPE_BASE64,
  LDAP_CA_TYPE_CERT7_DB
} TFCATYPE;

/* Structure representing an LDAP connection */
typedef struct tagTFLDAPConn {
  LDAP   *pLdap;
  int     bBound;		/* Flag to indicate whether this connection is bound yet */
  const char *pszHost;		/* Name of the LDAP server (or space separated list) */
  int     nPort;		/* Port of the LDAP server */
  DEREFOPT enuDeref;		/* how to handle alias dereferening */
  const char *pszBindDN;	/* DN to bind to server (can be NULL) */
  const char *pszBindPW;	/* Password to bind to server (can be NULL) */
  int     bSSL;			/* True if use SSL connection */
} TFLDAPConn;

/**
 *  Per Directory Configuration
 */
typedef struct tagTFLDAPConf {
  /*
   *  Customizable properties
   */
  char   *pszURL;		/* String representation of the URL */
  char   *pszBaseDN;		/* Base DN to do all searches from */
  char   *pszAttribute;		/* Attribute to search for */
  char  **ppszAttributes;	/* Array of all the attributes to return */
  int     scope;		/* Scope of the search */
  char   *pszFilter;		/* Filter to further limit the search  */
  DEREFOPT enuDeref;		/* Dereference option for LDAP server */

  int     bUserIsDN;		/* If true, connection->user is DN instead of userid */

  const char *pszHost;		/* Name of the LDAP server (or space separated list) */
  int     nPort;		/* Port of the LDAP server */
  const char *pszBindDN;	/* DN to bind to server (can be NULL) */
  const char *pszBindPW;	/* Password to bind to server (can be NULL) */
  int     bSSL;			/* True if use SSL connection */

  /*used by library */
  apr_pool_t *pPool;

} TFLDAPConf;

/**
 * LDAP utility creation options
 */
typedef struct tagTFLDAPOptions {
  const char *pszShmPath;		/* shared memory path */
  const char *pszCAFile;		/* CA file path */
  TFCATYPE enuCAType;			/* CA file type (see LDAP_CA_TYPE_xxxx) */
  
  apr_size_t unCacheBytes;		/* Size (in bytes) of shared memory cache */
  unsigned long unMaxMemBlocks;		/* max block count of mem manager */
  unsigned long unTTL;			/* TTL for search cache */
  
  double	fMarkPercentage;	/* when do we mark ? */
  double	fPurgePercentage;       /* whenn do we purge? */
  
  unsigned long unURLHashTblSize;	/* URL hash table size */
  unsigned long unSearchHashTblSize;	/* Search hash table size */
} TFLDAPOptions;


typedef void (*TFLDAPLOCKCB) (TFLULOCKTYPE enuLockType, void *pUserData);

typedef struct tagTFLDAPUtil {
  apr_pool_t *pPool;		/* pool from which this state is allocated */
  apr_shm_t *pShm;		/* shared mem pointer */
  RMMANAGER RMMgr;		/* relocatable mem manager */

  LDAPCache *pRootCache;	/* pointer to the root node of cache */
  TFLDAPLOCKCB pfnLockCB;
  void   *pvUserData;
  int     bSSLSupport;		/* does sdk support ssl? */
  char   *pszCAFile;
  TFCATYPE enuCAType;

  /* from TFLDAPOptions */
  const char *pszShmPath;	/* shared memory path */
  apr_size_t unCacheBytes;	/* Size (in bytes) of shared memory cache */
  unsigned long unMaxMemBlocks;	/* max block count of mem manager */
  unsigned long unTTL;		/* TTL for search cache */
  
  unsigned long	unMarkBytes;	/* when do we mark ? */
  unsigned long	unPurgeBytes;	/* when do we purge ? */
  unsigned long	unMarkBlocks;	/* when do we mark ? */
  unsigned long	unPurgeBlocks;	/* when do we purge ? */

  unsigned long unURLHashTblSize;	/* URL hash table size */
  unsigned long unSearchHashTblSize;	/* Search hash table size */

  TFLDAPConn connBind;		/* connection for retriving infomation */
  TFLDAPConn connAuth;		/* connection for Authentication */

} TFLDAPUtil;

LDAP_DECLARE(TFLDAPConf *)
TFLDAPConf_Create (apr_pool_t * pChildPool);
LDAP_DECLARE(TFLDAPUtil *)
TFLDAPUtil_Create (apr_pool_t * pChildPool, TFLDAPOptions * pOptions, TFLDAPLOCKCB pfnLockCB, void *pvUserData);
LDAP_DECLARE(void)
TFLDAPUtil_SetLockCallback (TFLDAPUtil * pUtil, TFLDAPLOCKCB pfnLockCB, void *pvUserData);
LDAP_DECLARE(void)
TFLDAPUtil_lock (TFLDAPUtil * pUtil, TFLULOCKTYPE enuLockType);
LDAP_DECLARE(TFLRESULT)
TFLDAPUtil_CheckUserID (TFLDAPUtil * pUtil,
			TFLDAPConf * pConf,
			apr_pool_t * pRequestPool,
			const char *pszUsername,
			const char *pszPasswd);

LDAP_DECLARE(TFLRESULT)
TFLDAPUtil_GetAttributes (TFLDAPUtil * pUtil,
			  TFLDAPConf * pConf,
			  apr_pool_t * pRequestPool,
			  const char *pszUsername,
			  char **ppszDN, char ***pppszAttributes);

TFLRESULT
TFLDAPUtil_openConnection (TFLDAPUtil * pUtil, TFLDAPConn * pConn);
TFLRESULT
TFLDAPUtil_closeConnection (TFLDAPUtil * pUtil, TFLDAPConn * pConn);

LDAP_DECLARE(const char *)
TFLDAPUtil_FormatMessage (TFLRESULT enuResult);

LDAP_DECLARE(unsigned long)
TFHashString (int nStr, ...);
#endif /* TFLDAPUTIL_H */
