/***************************************************************************
                          urlnode.c  -  description
                             -------------------
    begin                : Tue.  Apr., 15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/
#include "urlnode.h"
#include "searchnode.h"
#include "tfldaputil.h"


void
removeSearchNode (RMMANAGER * pRMMgr, RM_HANDLE hUserData)
{
  SearchNode *pSearchNode;
  RM_ASSERT (pRMMgr);
  RM_ASSERT (hUserData);
  /* destroy search node */
  pSearchNode = (SearchNode *) RMHandleToPtr (pRMMgr, hUserData);
  RM_ASSERT (pSearchNode);
  SearchNode_Destroy (pSearchNode, pRMMgr);
  RMFree (pRMMgr, hUserData);
}


RM_HANDLE
URLNode_Create (RMMANAGER * pRMMgr, const char *pszURL, unsigned long unHashTblSize)
{
  RM_HANDLE hRet;
  URLNode *pNode;

  RM_ASSERT (pRMMgr);
  if (!unHashTblSize || !pszURL)
    return 0;

  hRet = RMMalloc (pRMMgr, sizeof (URLNode));
  pNode = (URLNode *) RMHandleToPtr (pRMMgr, hRet);

  if (!pNode)
    return 0;

  pNode->unEntryCount = 0;
  pNode->tmMark = 0;

  if (unHashTblSize < 64)
    unHashTblSize = 64;
  pNode->unHashTblSize = unHashTblSize;

  pNode->hszURL = RMUstrdup (pRMMgr, pszURL, 0);
  if (!pNode->hszURL)
    return 0;

  pNode->hhSearchNodes =
    RMCalloc (pRMMgr, unHashTblSize * sizeof (RM_HANDLE));
  if (!pNode->hhSearchNodes) {
    RMFree (pRMMgr, pNode->hszURL);
    return 0;
  } else {
    return hRet;
  }
}

void
URLNode_Destroy (URLNode * pNode, RMMANAGER * pRMMgr)
{
  unsigned long unIndex;
  RM_HANDLE hList, *phList;
  RMULIST list;

  RM_ASSERT (pRMMgr);
  RM_ASSERT (pNode);
  RMFree (pRMMgr, pNode->hszURL);
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pNode->hhSearchNodes);
  if (!phList)
    return;
  for (unIndex = 0; unIndex < pNode->unHashTblSize; unIndex++) {
    hList = phList[unIndex];
    if (hList) {
      if (RMUOK ==
	  RMUListAttach (pRMMgr, &list, 0, removeSearchNode,
			 &phList[unIndex])) {
	RMUListDestroy (&list);
      }
    }
  }
}

/**
 *  try to find a search node
 *    return handle to the node if found
 *    NULL if not found.
 */
RM_HANDLE
URLNode_GetSearchNode (URLNode * pNode, RMMANAGER * pRMMgr,
		       const char *pszUsername)
{
  unsigned long unHashTblSize;
  unsigned long unHash;
  const char *pszNodeUsername;
  RM_HANDLE hRet, hList, *phList;
  SearchNode *pSearchNode;
  RMULIST list;
  RMURESULT enuRet;

  RM_ASSERT (pNode);
  RM_ASSERT (pszUsername);
  RM_ASSERT (pRMMgr);

  unHashTblSize = pNode->unHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pNode->hhSearchNodes);
  RM_ASSERT (phList);

  unHash = TFHashString (1, pszUsername);
  hList = phList[unHash % unHashTblSize];

  if (!hList) {
    return 0;
  } else {
    /* traverse the list */
    enuRet =
      RMUListAttach (pRMMgr, &list, 0, 0, &phList[unHash % unHashTblSize]);
    if (RMUOK != enuRet)
      return 0;
    for (enuRet = RMUListGoToHead (&list);
	 RMUOK == enuRet; enuRet = RMUListNext (&list)) {
      RMUListGetData (&list, &hRet);
      pSearchNode = (SearchNode *) RMHandleToPtr (pRMMgr, hRet);
      RM_ASSERT (pSearchNode);
      pszNodeUsername =
	(const char *) RMHandleToPtr (pRMMgr, pSearchNode->hszUserName);
      RM_ASSERT (pszNodeUsername);
      if (strcmp (pszUsername, pszNodeUsername) == 0) {
	/* we found it */
	return hRet;
      }
    }
    /* not found in the list */
    return 0;
  }
}


RM_HANDLE
URLNode_CreateSearchNode (URLNode * pNode, RMMANAGER * pRMMgr,
			  const char *pszUsername)
{
  unsigned long unHashTblSize;
  unsigned long unHash;
  unsigned int nIndex;
  RM_HANDLE hRet, hList, *phList;
  RMULIST list;

  RM_ASSERT (pNode);
  RM_ASSERT (pszUsername);
  RM_ASSERT (pRMMgr);

  unHashTblSize = pNode->unHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pNode->hhSearchNodes);
  RM_ASSERT (phList);

  unHash = TFHashString (1, pszUsername);
  nIndex = unHash % unHashTblSize;
  hList = phList[nIndex];

  if (!hList) {
    /* create a new list */
    RM_VERIFY (RMUOK == RMUListCreate (pRMMgr, &list, 0, 0, &phList[nIndex]));
  } else {
    /* attach the list */
    if (RMUOK != RMUListAttach (pRMMgr, &list, 0, 0, &phList[nIndex]))
      return 0;
  }

  /* create the node */
  hRet = SearchNode_Create (pRMMgr, pszUsername);
  if (!hRet)
    return 0;
  RMUListInsertHead (&list, (void *) hRet);

  pNode->unEntryCount++;
  return hRet;
}

void
URLNode_RemoveSearchNode (URLNode * pNode, RMMANAGER * pRMMgr,
			  const char *pszUsername)
{
  unsigned long unHashTblSize;
  unsigned long unHash;
  const char *pszNodeUsername;
  RM_HANDLE hRet, hList, *phList;
  SearchNode *pSearchNode;
  RMULIST list;
  RMURESULT enuRet;

  RM_ASSERT (pNode);
  RM_ASSERT (pszUsername);
  RM_ASSERT (pRMMgr);

  unHashTblSize = pNode->unHashTblSize;
  phList = (RM_HANDLE *) RMHandleToPtr (pRMMgr, pNode->hhSearchNodes);
  RM_ASSERT (phList);

  unHash = TFHashString (1, pszUsername);
  hList = phList[unHash % unHashTblSize];

  RM_ASSERT (hList);

  /* traverse the list */
  enuRet = RMUListAttach (pRMMgr, &list, 0,
			  removeSearchNode, &phList[unHash % unHashTblSize]);
  RM_ASSERT (RMUOK == enuRet);
  for (enuRet = RMUListGoToHead (&list);
       RMUOK == enuRet; enuRet = RMUListNext (&list)) {
    RMUListGetData (&list, &hRet);
    pSearchNode = (SearchNode *) RMHandleToPtr (pRMMgr, hRet);
    RM_ASSERT (pSearchNode);
    pszNodeUsername =
      (const char *) RMHandleToPtr (pRMMgr, pSearchNode->hszUserName);
    RM_ASSERT (pszNodeUsername);
    if (strcmp (pszUsername, pszNodeUsername) == 0) {
      /* we found it */
      RMUListRemoveCurrent (&list);
      pNode->unEntryCount--;
    }
  }
}
