/***************************************************************************
                          urlnode.h  -  description
                             -------------------
    begin                : Tue.  Apr., 15 2004
    copyright            : (C) 2004 by Lei Jiang
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/

#ifndef URLNODE_H
#define URLNODE_H

#include <apr.h>

#include <apr_time.h>
#include "rmmgr.h"


typedef struct tagURLNode {
  RM_HANDLE hszURL;		/* URL of this node */

  unsigned long unHashTblSize;	/* Size of hash table */
  unsigned long unEntryCount;	/* Current number of cache entries */
  apr_time_t tmMark;		/* Time that the cache became 3/4 full */
  RM_HANDLE hhSearchNodes;
} URLNode;

RM_HANDLE URLNode_Create (RMMANAGER * pRMMgr, const char *pszURL, unsigned long unHashTblSize);
void    URLNode_Destroy (URLNode * pNode, RMMANAGER * pRMMgr);
RM_HANDLE URLNode_GetSearchNode (URLNode * pNode, RMMANAGER * pRMMgr, const char *pszUsername);
RM_HANDLE URLNode_CreateSearchNode (URLNode * pNode, RMMANAGER * pRMMgr, const char *pszUsername);
void    URLNode_RemoveSearchNode (URLNode * pNode, RMMANAGER * pRMMgr, const char *pszUsername);
#endif /* URLNODE_H */
