/**
 * $Id$
 *
 * mod_dav_tf.c
 *
 * 2003/01/30 Thu takehara 新規作成
 */ 

#include "apr.h"
#include "apr_strings.h"
#include "apr_base64.h"
#include "apr_tables.h"
#include "apr_thread_mutex.h"
#include "apr_time.h"
#if APR_HAVE_UNISTD_H
#include <unistd.h>     /* for getpid */
#endif	/* APR_HAVE_UNISTD_H */
#include "apr_network_io.h"

/* Apache header files */
#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "http_request.h"
#include "ap_mpm.h"
#include "ap_regex.h"
#include "mod_dav.h"
#include "mod_auth.h"

/* グローバル変数の定義を行うためにdefineする */
#define DIVY_GLOBAL_VALUE_DEFINE

/* TeamFile headers */
#include "mod_dav_tf.h"
#include "tf_db.h"
#include "tf_array.h"
#include "util_db.h"
#include "tf_ml.h"
#include "util_ml.h"
#include "util.h"
#include "liveprop.h"
#include "auth.h"
#include "tf_rdbo.h"
#include "util_thread.h"
#include "tf_provider.h"
#include "util_ldap.h"
#include "util_vscan.h"
#include "tf_valuecache.h"
#include "tf_logger.h"
#ifdef TF_SUPPORT_CIPHER_STORAGE
#include "util_crypt.h"
#endif
#include "tf_jobs.h"

/* (note) USB Token 機能は今のところ停止しておきます */
#ifdef TF_USE_USBTOKEN
/* ラインセンスクエリー用ライブラリのヘッダファイル */
#include "tfscdif.h"
#endif	/* TF_USE_USBTOKEN */

#ifdef DIVY_SUPPORT_PLUGIN
#include "tf_plugin.h"
#endif	/* DIVY_SUPPORT_PLUGIN */

#include "tf_confirmreading.h"

/*--------------------------------------------------------------
  Define macros
  --------------------------------------------------------------*/
/**
 * child に値があればその値を返却し、値が無ければparentの値を
 * 返却するマクロ
 * (note)
 * 	field が示す変数がchar * 型ではない場合には意図した動作に
 * 	ならないかもしれません。注意して下さい。
 */
#define DIVY_INHERIT_VALUE(parent, child, field) \
                ((child)->field ? (child)->field : (parent)->field)

/**
 * child に値があればその値を返却し、値が無ければparentの値を
 * 返却するマクロ(field がapr_int64_t の時だけ利用できます)
 *
 * field は DIVY_INT64_C_UNSET で初期化されていなければなりません。
 */
#define DIVY_INHERIT_INT64_VALUE(parent, child, field) \
                ((child)->field != DIVY_INT64_C_UNSET ? \
		 (child)->field : (parent)->field)
/**
 * child に値があればその値を返却し、値が無ければparentの値を
 * 返却するマクロ(field がapr_int32_t, int の時だけ利用できます)
 *
 * field は DIVY_INT32_C_UNSET で初期化されていなければなりません。
 */
#define DIVY_INHERIT_INT32_VALUE(parent, child, field) \
                ((child)->field != DIVY_INT32_C_UNSET ? \
		 (child)->field : (parent)->field)

/*--------------------------------------------------------------
  Define values
  --------------------------------------------------------------*/
/*
 * DAVプロバイダとして登録される時の名前
 */
#define DAV_PROVIDER_NAME "tf"

/**
 * サーバライセンスキーに含まれるライセンス情報を取得するためのキー値の定義
 */

/* ライセンスユーザの数 */
#define DIVY_SLKEY_USERCNT	"u"

/* ライセンスユーザを超えて登録できるユーザ数 */
#define DIVY_SLKEY_ALLOWCNT	"ua"
/*
 * 機能オプションのビット値 (bitが立っていると機能あり)
 *   1bit: メール送信機能
 *   2bit: DB連携機能
 *   3bit: LDAP機能
 *   4bit: ウィルス検索機能
 *   5bit: 自動暗号化
 *   6bit: 自動削除
 *   7bit: アクション拡張コマンド
 */
#define DIVY_SLKEY_FUNCOPT	"fopt"
#define DIVY_SLKEY_FUNCOPT_MASK	0x0000007f

/* 機能オプションのビット値を表す値 */
#define DIVY_SLKEY_FUNCOPT_MAIL			0x01
#define DIVY_SLKEY_FUNCOPT_DB			0x02
#define DIVY_SLKEY_FUNCOPT_LDAP			0x04
#define DIVY_SLKEY_FUNCOPT_VSC			0x08
#define DIVY_SLKEY_FUNCOPT_ENCCIPHER	0x10
#define DIVY_SLKEY_FUNCOPT_AUTODEL		0x20
#define DIVY_SLKEY_FUNCOPT_EXTCMD		0x40

/*
 * 機能オプションビットが立っているかどうか(1/0)を判別するマクロ
 * @param fopt int 機能オプションのOR値
 * @param pos int 調べたいビット値
 * @return int 1/0
 */
#define DIVY_SLKEY_OPT(fopt, pos)	\
	((((fopt) & DIVY_SLKEY_FUNCOPT_MASK) & (pos)) > 0 ? 1 : 0)

/* ライセンスチェックに使用するネットワークインターフェースのデバイス名 */
#define DIVY_SLKEY_NIFNAME	"nif"

/* ライセンスされたネットワークアドレス */
#define DIVY_SLKEY_NIP	"nip"

/* ライセンス発行日時 (epochタイム) */
#define DIVY_SLKEY_STARTTM	"st"

/* _parse_svrlicensekey のステータス値 */
#define DIVY_SLICENSE_ST_OK	0
#define DIVY_SLICENSE_ST_INVALIDFMT 1
#define DIVY_SLICENSE_ST_INVALIDIP	2

/**
 * ライセンスデータにアクセスするための認証ユーザID/パスワード
 */
#define DIVY_ACT_USERID	"tfsuser"
#define DIVY_ACT_PASSWD	"TeAmFiLe0701"

/*--------------------------------------------------------------
  Declare values
  --------------------------------------------------------------*/
extern module AP_MODULE_DECLARE_DATA dav_tf_module;

/*--------------------------------------------------------------
  Declare prototype private functions
  --------------------------------------------------------------*/
static void *dav_divy_create_dir_config(apr_pool_t *p, char *dir);
static void *dav_divy_merge_dir_config(apr_pool_t *p, void *base, void *overrides);
static void *dav_divy_create_server_config(apr_pool_t *p, server_rec *s);
static void *dav_divy_merge_server_config(apr_pool_t *p, void *base,
                                         void *overrides);
static int  dav_divy_post_config(apr_pool_t *pconf, apr_pool_t *plog, 
                                apr_pool_t *ptemp, server_rec *s);
static void dav_divy_child_init(apr_pool_t *pchild, server_rec *s);
static int  dav_divy_post_read(request_rec *r);
#if 0	/* 2005/02/08 fixups は結果的に処理内容が無くなったのでコメントアウト */
static int dav_divy_fixups(request_rec *r);
#endif
static apr_status_t dav_divy_child_exit(void *data);
static void init_mutex_env(apr_pool_t *p);
static void destroy_mutex_env(void);
static void init_log_env(request_rec *r);
static int _parse_svrlicensekey(apr_pool_t *p,
				const char *svrlicensekey,
				dav_divy_server_conf *sconf);
#ifdef TF_USE_USBTOKEN
static int _query_license(request_rec *r);
#endif	/* TF_USE_USBTOKEN */
/*
 * コマンドハンドラのプロトタイプ
 */
static const char *dav_divy_dbmstype_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_dbmsname_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_hostname_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_hostport_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_dbname_cmd(cmd_parms *cmd, void *config, 
                                         const char *arg1);
static const char *dav_divy_username_cmd(cmd_parms *cmd, void *config, 
                                         const char *arg1);
static const char *dav_divy_password_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_dbpool_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_dbvhostshare_cmd(cmd_parms *cmd, void *config,
                                         int arg1);
static const char *dav_divy_dbrefreshinterval_cmd(cmd_parms *cmd, void *config,
	                                         const char *arg1);
static const char *dav_divy_dbminspareconn_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_dbmaxspareconn_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1);
static const char *dav_divy_fsrootpath_cmd(cmd_parms *cmd, void *config, 
                                           const char *arg1);
static const char *dav_divy_maxresource_per_dir_cmd(cmd_parms *cmd, 
                                                    void *config, 
                                                    const char *arg1);
static const char *dav_divy_serverlicensekey_cmd(cmd_parms *cmd, 
                                                    void *config, 
                                                    const char *arg1);
static const char *dav_divy_dblicensekey_cmd(cmd_parms *cmd, 
                                                 void *config, const char *arg1);
static const char *dav_divy_auth_cmd(cmd_parms *cmd,
						void *config,
						const char *arg1);
static const char *dav_divy_auth_login_ignore_inspection_ipaddrs_cmd(
							cmd_parms *cmd, void *config, const char *l);
static const char *dav_divy_mail_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_mailhost_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_mailport_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_mailadminaddr_cmd(cmd_parms *cmd,
                                        void *config, const char *arg1);
static const char *dav_divy_mlusername_cmd(cmd_parms *cmd,
                                        void *config, const char *arg1);
static const char *dav_divy_mlpassword_cmd(cmd_parms *cmd,
                                        void *config, const char *arg1);
static const char *dav_divy_mailencoding_cmd(cmd_parms *cmd,
                                        void *config, const char *arg1);
static const char *dav_divy_mlserversend_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_mltemplateroot_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_mlnotifyact_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_mloneclickurl_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_mledit_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_mlrepfromaddr_cmd(cmd_parms *cmd,
					void *config, const char *arg1, const char *arg2);
static const char *dav_divy_mlsendinterval_cmd(cmd_parms *cmd,
					void *config, const char* arg1);

static const char *dav_divy_defaultmaxquotasize_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_defaultmaxquotares_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_maxfilesize_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_showgroup_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_ldap_shmcachebyte_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_shmpath_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_search_cache_ttl_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_max_mem_blocks_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_markpercentage(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_purgepercentage(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_cert_auth_file_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_cert_file_type_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_ssl_support_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_use_ldap_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_ldap_basedn_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_binddn_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_bindpw_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_filter_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_scope_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_host_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_port_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_url_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_map_user_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_map_passwd_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_map_fullname_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_map_mailaddr_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_map_comment_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_found_create_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_ldap_sync_property_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_ldap_allow_user_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_allow_user_regex_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_ldap_user_options(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_autoindex_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_stylesheetroot_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_syncgroupuri_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_maxuser_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_emcrypt_password(cmd_parms *cmd,
	       				void *config, int arg1);
static const char *dav_divy_vscan_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_vscstreammethod_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_vschostname_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_vschostport_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_vsccmd_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_trashfolder_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_brandname_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_tfversion_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_extenduserst_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_notifyservename_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_useusbktoken_cmd(cmd_parms *cmd,
					void *config, int arg1);
#ifdef DIVY_SUPPORT_PRINTER
static const char *dav_divy_netprint_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_prprintgroupname_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_prname_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
#endif	/* DIVY_SUPPORT_PRINTER */
#ifdef DIVY_SUPPORT_PREFLIGHT_PLUGIN
static const char *dav_divy_plrootpath_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_plgroupset_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
#endif	/* DIVY_SUPPORT_PREFLIGHT_PLUGIN */
static const char *dav_divy_thumbnail_cmd(cmd_parms *cmd,
					void *config, int arg1);
#ifdef DAV_SUPPORT_POST_HANDLING
static const char *dav_divy_syscgiroot_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
#endif	/* DAV_SUPPORT_POST_HANDLING */
#ifdef DIVY_SUPPORT_PASSPOLICY
static const char *dav_divy_passpolicty_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_passpolicyoptions_cmd(cmd_parms *cmd,
					void *config, const char *l);
#endif	/* DIVY_SUPPORT_PASSPOLICY */
#ifdef DIVY_SUPPORT_LOGACCESS
static const char *dav_divy_logaccess_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
#endif	/* DIVY_SUPPORT_LOGACCESS */
static const char *dav_divy_defaultresponselanguage_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_supportedlanguages_cmd(cmd_parms *cmd, void *config,
	                                       const char *arg1);
static const char *dav_divy_forcelanguage_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_autodelete_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_autodeleteallowip(cmd_parms *cmd,
					void *config, const char *l);
static const char *dav_divy_chunkput_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_execengine_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_execoncmd_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_execmatch_cmd(cmd_parms *cmd,
					void *config, const char* arg1);
static const char *dav_divy_rproxyuse_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_forcedelete_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_rproxymatch_cmd(cmd_parms *cmd,
					void *config, const char *l);
static const char *dav_divy_rproxyschema_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_rproxyhttpport_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_rproxyhttpsport_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_syscgiconnectport_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_syscgiconnectschema_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_notifyserverport_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_notifyserverschema_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_logoperation_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_grpconstraints_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_licenseuploader_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_groupleader_cmd(cmd_parms *cmd,
					void *config, int arg1);
#ifdef DIVY_SUPPORT_PASSPOLICY
static const char *dav_divy_passpolicyexclusion(cmd_parms *cmd,
					void *config, const char *l);
#endif	/* DIVY_SUPPORT_PASSPOLICY */
static const char *dav_divy_confirmreading_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_confirmreading_reservedday_cmd(cmd_parms *cmd,
					void *config, const char *arg1);
static const char *dav_divy_extendsysmsg_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_groupquota_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_admin_allow_ip_cmd(cmd_parms *cmd,
					void *config, const char* l);
static const char *dav_divy_disable_webfolder_link_cmd(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_disable_change_password(cmd_parms *cmd,
				    void *config, int arg1);
static const char *dav_divy_master_password(cmd_parms *cmd,
					void *config, const char* arg1);
static const char *dav_divy_upload_only_user_is_download_allow_time(
                    cmd_parms *cmd, 
					void *config, const char* arg1);
static const char *dav_divy_use_session(cmd_parms* cmd,
					void *config, int arg1);
static const char *dav_divy_use_access_control(cmd_parms* cmd,
					void *config, int arg1);
static const char *dav_divy_session_timeout(cmd_parms* cmd,
					void *config, const char *arg1);
static const char *dav_divy_default_access_rule(cmd_parms* cmd,
					void* config, const char *arg1);
static const char *dav_divy_failed_login_lockout(cmd_parms* cmd,
					void* config, const char *arg1,
                                  const char *arg2,
								  const char *arg3);
static const char *dav_divy_shorten_url(cmd_parms* cmd,
					void* config, int arg1);
static const char *dav_divy_tfbox_cmd(cmd_parms* cmd,
					void* config, int arg1);
static const char *dav_divy_serverpolicy_cmd(cmd_parms *cmd,
					void* config, const char *l);
static const char *dav_divy_usememcache_cmd(cmd_parms *cmd,
					void* config, int arg1);
static const char *dav_divy_memcache_servers_cmd(cmd_parms *cmd,
					void* config, const char *l);
static const char *dav_divy_use_saml_cmd(cmd_parms* cmd,
					void* config, int arg1);
static const char *dav_divy_saml_idp_meta_cmd(cmd_parms *cmd,
					void* config, const char *arg1);
static const char* dav_divy_saml_privatekeypath_cmd(cmd_parms *cmd,
					void* config, const char *arg1);
static const char* dav_divy_saml_x509certificatepath_cmd(cmd_parms *cmd,
					void* config, const char *arg1);
static const char* dav_divy_saml_nameid_match_mailaddr(cmd_parms *cmd,
					void* config, int arg1);
static const char* dav_divy_custom_image_path_cmd(cmd_parms *cmd,
					void* config, const char *arg1);
static const char *dav_divy_use_uploadpolicy_cmd(cmd_parms *cmd,
					void* config, int arg1);
static const char *dav_divy_use_2fa_cmd(cmd_parms *cmd,
					void* config, int arg1);
static const char *dav_divy_2fa_cycle(cmd_parms *cmd,
					void* config, const char *arg1, const char *arg2);
static const char *dav_divy_2fa_type(cmd_parms *cmd,
					void* config, const char *arg1);
static const char *dav_divy_2fa_stage(cmd_parms *cmd,
					void* config, const char *arg1);
#ifdef TF_SUPPORT_CIPHER_STORAGE
static const char *dav_divy_cipher_storage(cmd_parms *cmd,
					void *config, int arg1);
static const char *dav_divy_cipher_storage_key(cmd_parms *cmd,
					void *config, const char* arg1);
static const char *dav_divy_cipher_storage_cipher_type(cmd_parms *cmd,
					void *config, const char* arg1);
#endif

static void dav_divy_register_hooks(apr_pool_t *p);

/*--------------------------------------------------------------
  Create & Initialize DAV-provider Hook structure
  --------------------------------------------------------------*/
static const dav_provider dav_divy_provider = {
    &dav_divy_hooks_repository,   /* Repository        */
    &dav_divy_hooks_propdb,       /* Property database */
    &dav_divy_hooks_locks,        /* Lock              */
    NULL,                         /* Versioning        */
    NULL,                         /* Binding           */
    &dav_divy_hooks_search        /* Search            */
};

/*------------------------------------------------------------------------------
  Declar prototype functions
  ----------------------------------------------------------------------------*/
/**
 * mod_dav_tf のサーバコンフィグ構造体を取得する。
 *
 */
DIVY_DECLARE(dav_divy_server_conf *) dav_divy_get_server_config(server_rec *s)
{
	return (dav_divy_server_conf *) ap_get_module_config(s->module_config, &dav_tf_module);
}

/**
 * mod_dav_tf の ディレクトリコンフィグ構造体を取得する。
 *
 */
DIVY_DECLARE(dav_divy_dir_conf *) dav_divy_get_dir_config(request_rec *r)
{
	return (dav_divy_dir_conf *) ap_get_module_config(r->per_dir_config, &dav_tf_module);
}


/**
 * グループフォルダの表示を行っても良いかどうか。
 *
 */
DIVY_DECLARE(int) divy_enable_groupview(request_rec *r)
{
	const int *accessdeny;
	dav_divy_dir_conf *conf = dav_divy_get_dir_config(r);

	/* アクセス拒否リストを取得 */
	accessdeny = divy_get_accessdeny(r);

	if ((accessdeny == NULL || accessdeny[DIVY_FOLDER_ID_group] == 0) &&
	    conf->show_group == DIVY_SHOWGROUP_ON) {
		return 1;
	}
	else {
		return 0;
	}
}

/**
 * プライベートコレクションの表示を行っても良いかどうか。
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int 良いかどうか (1: OK / 0: だめ)
 */
DIVY_DECLARE(int) divy_enable_userfolderview(request_rec *r)
{
	const int *accessdeny = divy_get_accessdeny(r);

	if (accessdeny == NULL || accessdeny[DIVY_FOLDER_ID_user] == 0) {
		return 1;
	}
	else {
		return 0;
	}
}

/**
 * ごみ箱フォルダ機能をサポートしているかどうか
 *
 */
DIVY_DECLARE(int) divy_support_trashfolder(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->trashfolder == DIVY_TRASHFOLDER_ON) {
		return 1;
	}
	else {
		return 0;
	}
}

/**
 * ごみ箱フォルダに対するアクセスを行ってもよいかどうか。
 *
 */
DIVY_DECLARE(int) divy_enable_trashfolder_access(request_rec *r)
{
	const char *trashfolder = apr_table_get(r->subprocess_env,
					DIVY_APENV_ENABLETRASH);

	if (DIVY_APENV_IS_ON(trashfolder)) {
		return 1;
	}
	else {
		return 0;
	}
}

/**
 * 拡張ユーザステータス機能をサポートしているかどうか
 *
 */
DIVY_DECLARE(int) divy_support_extenduserstatus(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->extenduserst == DIVY_EXTENDUSERST_ON) {
		return 1;
	}
	/* ON 以外は全て未サポート扱いとする */
	else {
		return 0;
	}
}

#ifdef DIVY_SUPPORT_PASSPOLICY
/**
 * パスワードポリシー機能をサポートしているかどうか
 * (note) サポート条件
 *   * パスワードポリシープロパティが有効であること
 *   * LDAPが有効でないこと
 *
 */
DIVY_DECLARE(int) divy_support_passpolicy(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->passpolicy == DIVY_PASSPOLICY_ON) {
		if (dconf->ldap == TF_LDAP_ON) {
			/* 警告を出しておく */
			ERRLOG0(r->pool, APLOG_WARNING, DIVY_FST_IERR + DIVY_SST_SYNTAX,
					"Could not make both of LDAP and PaswordPolicy be effective."
					"Please check configuration.");
			return 0;	/* そしてパスワードポリシーを無効にする */
		}
		return 1;
	}
	/* ON 以外は全て未サポート扱いとする */
	else {
		return 0;
	}
}
#endif	/* DIVY_SUPPORT_PASSPOLICY */

/**
 * メール送信をサポートしているかどうか.
 *
 */
DIVY_DECLARE(int) divy_support_mail(request_rec *r)
{
	dav_divy_server_conf *sconf = dav_divy_get_server_config(r->server);
	dav_divy_dir_conf    *dconf = dav_divy_get_dir_config(r);

	return (sconf->use_mail_opt &&
                          (strcmp(dconf->mail, DIVY_ML_OFF) != 0) ? 1 : 0);
}

/**
 * Chunk PUT をサポートしているかどうか.
 *
 */
DIVY_DECLARE(int) divy_support_chunkput(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	/* ON に設定されていなければOFF扱い */
	return (dconf->chunkput == DIVY_CHUNKPUT_ON) ? 1 : 0;
}

/**
 * 操作ログ機能をサポートしているかどうか.
 *
 */
DIVY_DECLARE(int) divy_support_logoperation(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	/* 操作ログがon でユーザ拡張ステータスもon のときだけサポート */
	if (dconf->logoperation == DIVY_LOGOPERATION_ON &&
		dconf->extenduserst == DIVY_EXTENDUSERST_ON) {
		return 1;
	}
	return 0;
}

/**
 * グループ制約属性をサポートしているかどうか.
 * (2007/09/13 Thu)
 *   この機能はグループリーダ機能のサポート有無と同値になりました
 */
DIVY_DECLARE(int) divy_support_grpconstraints(request_rec *r)
{
	return divy_support_groupleader(r);
}

/**
 * ライセンスアップローダをサポートしているかどうか.
 *
 */
DIVY_DECLARE(int) divy_support_licenseuploader(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	/* ライセンスアップローダがon の時だけサポート */
	return (dconf->licenseuploader == DIVY_LICENSEUPLOADER_ON) ? 1 : 0;
}

/**
 * グループリーダ機能をサポートしているかどうか.
 *
 */
DIVY_DECLARE(int) divy_support_groupleader(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	/* グループ管理者機能がon でユーザ拡張ステータスもon のときだけサポート */
	if (dconf->groupleader == DIVY_GROUPLEADER_ON &&
		dconf->extenduserst == DIVY_EXTENDUSERST_ON) {
		return 1;
	}
	return 0;
}

/**
 * システムメッセージ拡張をサポートしているかどうか.
 *
 */
DIVY_DECLARE(int) divy_support_extendsysmsg(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	/* 拡張メッセージ機能がOnの時だけサポートする */
	if (dconf->extendsysmsg == DIVY_EXTENDSYSMSG_ON) {
		return 1;
	}

	return 0;
}

/**
 * グループクォータ拡張をサポートしているかどうか.
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_groupquota(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	/* グループクォータ機能がOnの時だけサポートする */
	if (dconf->groupquota == DIVY_GROUPQUOTA_ON) {
		return 1;
	}

	return 0;
}

/**
 * ブラウザのWebフォルダの表示をなくすか？
 *
 * @param request_req *
 * @param int 表示しないかどうか（1: 表示しない / 0:表示する）
 */
DIVY_DECLARE(int) divy_disable_webfolerlink(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->disablewebfolderlink == DIVY_DISABLE_WEBFOLDERLINK_ON) {
		return 1;
	}

	return 0;
}


/** 
 * ブラウザ セッション をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_session(request_rec *r)
{
	/* セッションは強制する 3.0.0-2より */
	return 1;
}

/** 
 * アドレス制限機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_access_control(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->useaccesscontrol == DIVY_ACCESS_CONTROL_ON) {
		return 1;
	}

	return 0;
}

/**
 * ログインロックアウト機能をサポートしているかどうか
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_failedlogin_lockout(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->failedloginlockout == DIVY_FAILED_LOGIN_LOCKOUT_ON) {
		return 1;
	}

	return 0;
}

/**
 * 短縮URL機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_shorten(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->shortenurl == DIVY_SHORTEN_URL_ON) {
		return 1;
	}

	return 0;
}

/**
 * memcache機能を有効にしているか？
 *
 * @param request_rec *
 * @return int (1: 有効 / 0: 無効)
 */
DIVY_DECLARE(int) divy_enable_memcache(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->usememcache == DIVY_TFMEMCACHE_ON) {
		return 1;
	}

	return 0;
}

/**
 * SAML機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_saml(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->usesaml == DIVY_USE_SAML_ON) {
		return 1;
	}

	return 0;
}

/**
 * アップロードポリシーをサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_upload_policy(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->useuploadpolicy == DIVY_USE_UPLOAD_POLICY_ON) {
		return 1;
	}

	return 0;
}

/**
 * 二段階認証をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_2FA(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->use2fa == DIVY_USE_2FA_ON) {
		return 1;
	}

	return 0;
}

/**
 * 指定されたbit 値を元に、クライアントに通知するサポート機能の有無を表す文字列を組み立てる.
 *
 */
DIVY_DECLARE(char *) divy_build_supportedfunc_str(request_rec *r, unsigned int funcbit)
{
	apr_pool_t *p = r->pool;
	char *funcstr = "";
	char *ch;

	if (funcbit == 0) {
		/* (note) デフォルト値は機能が増えたら変えること */
		return apr_pstrdup(p, "000000000000000");
	}

	/* 自分自身のメール監視状態取得機能 */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_OWNERMLWATCH) ? "1" : "0";
	funcstr = apr_pstrdup(p, ch);

	/* グループ制約属性 */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_GROUPCONSTRAINTS) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* グループリーダ機能 */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_GROUPLEADER) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* ユーザ種類(管理者) */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_UTYPE_ADMIN) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* ユーザ種類(グループリーダ) */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_UTYPE_GROUPLEADER) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* ユーザ種類(一般ユーザ) */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_UTYPE_NORMAL) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* ユーザ種類(制限ユーザ) */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_UTYPE_LIMITED) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* ファイルチケットの有無 */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_FILETICKET) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* Otherユーザを管理下に置くことができるかどうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_CONTROLOTHERUSER) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* 開封通知機能が有効かどうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_CONFIRMREADING) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* グループクォータ機能が有効かどうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_GROUPQUOTA) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* アクセス制御機能が有効かどうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_ACCESS_CONTROL) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* BOX機能が有効化どうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_BOX) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* アップロードポリシー機能が有効化どうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_UPLOADPOLICY) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	/* Two Factor Authentication(2FA)機能が有効かどうか */
	ch = (funcbit & DIVY_SUPPORTEDFUNC_2FA) ? "1" : "0";
	funcstr = apr_pstrcat(p, funcstr, ch, NULL);

	return funcstr;

}

/**
 * 指定した機能が専用クライアントによってサポートされているかどうか調べる
 * (1: サポートしている / 0: サポートしていない)
 *
 */
DIVY_DECLARE(int) divy_get_clientinfo(request_rec *r, divy_clfunc_type type)
{
	const char *clinfo;
	char ch = '\0';
	int len = 0, ret = 0;

	/* ヘッダ値を取得 */
	clinfo = apr_table_get(r->headers_in, DIVY_HEADER_REQ_CLIENT_INFO);
	if (IS_FILLED(clinfo)) len = strlen(clinfo);
	if (len > (int)type) ch = clinfo[(int)type];	/* (note) type はindexと同じ */

	switch (type) {
		/* プロダクト種別 -> TeamFileクライアントかどうか */
		case DIVY_CLFUNC_PRODUCTTYPE:
			ret = -1;	/* デフォルトは未定 */
			if (ch == 'm') {
				ret = 1;
			}
			else if (ch == 'o') {
				ret = 0;
			}
			break;

		/* クライアント種別 -> エクスプローラかどうか */
		case DIVY_CLFUNC_CLIENTTYPE:
			ret = -1;	/* デフォルトは未定 */
			if (ch == 'e') {
				ret = 1;
			}
			else if (ch == 'c') {
				ret = 0;
			}
			break;

		/* グループ制約属性サポートの有無 */
		case DIVY_CLFUNC_GROUPCONSTRAINTS:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;

			break;
		/* グループ管理者機能サポートの有無 */
		case DIVY_CLFUNC_GROUPLEADER:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;
			break;
		/* グループクォータ機能サポートの有無 */
		case DIVY_CLFUNC_GROUPQUOTA:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;
			break;
		/* アクセス制御の有無 */
		case DIVY_CLFUNC_ACCESSCONTROL:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;
			break;
		/* BOX機能の有無 */
		case DIVY_CLFUNC_BOX:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;
			break;
		/* アップロードポリシーの有無 */
		case DIVY_CLFUNC_UPLOADPOLICY:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;
			break;
		/* Two Factor Authentication(2FA)の有無 */
		case DIVY_CLFUNC_2FA:
			ret = 0;	/* デフォルトは未サポート */
			ret = (ch == '1') ? 1 : 0;
			break;
		default:
			ret = -1;	/* 未定 */
			break;
	}

	return ret;
}


/*------------------------------------------------------------------------------
  Define private functions
  ----------------------------------------------------------------------------*/
/**
 * dir config 生成
 */
static void *dav_divy_create_dir_config(apr_pool_t *p, char *dir)
{
	dav_divy_dir_conf *newconf = apr_pcalloc(p, sizeof(dav_divy_dir_conf));

	/* Location で指定されたパスの後の / を取り除く */
	if (dir != NULL) {
		char *root_uri = dav_divy_remove_endslash(p, dir);
		ap_no2slash(root_uri);
		ap_getparents(root_uri);

		newconf->root_uri = root_uri;
	}
	/* auth_on が未設定であることを明示する */
	newconf->auth_on    = DIVY_AUTH_UNSET;
	newconf->authignoreipaddrs = NULL;
	newconf->show_group = DIVY_SHOWGROUP_UNSET;

	/* ldapが未設定であることを明示する */
	newconf->ldap          = TF_LDAP_UNSET;
	newconf->ldapallowuser = NULL;
	newconf->ldapallowuserregex = NULL;
	newconf->ldapuseroptions = DIVY_LDAP_OPT_UNSET;
	newconf->ldapmaxresquota = DIVY_INT64_C_UNSET;
	newconf->ldapusernotfoundaction = DIVY_INT32_C_UNSET;

	/* 未設定であることを明示する */
	newconf->dbpool              = DIVY_DBPOOL_UNSET;
	newconf->dbminspareconn      = DIVY_INT32_C_UNSET;
	newconf->dbmaxspareconn      = DIVY_INT32_C_UNSET;
	newconf->maxresource_per_dir = DIVY_INT32_C_UNSET;
	newconf->maxfilesize         = DIVY_INT64_C_UNSET;
	newconf->autoindex           = DIVY_AUTOINDEX_UNSET;
	newconf->syncgrpuri          = DIVY_SYNCGRPURI_UNSET;
	newconf->mlserversend        = DIVY_MLSERVERSEND_UNSET;
	newconf->mlnotifyact         = DIVY_MLNOTIFYACT_UNSET;
	newconf->mloneclickurl       = DIVY_MLONECLICKURL_UNSET;
	newconf->mledit              = DIVY_MLEDIT_UNSET;
        newconf->mlrepfromaddr       = NULL;
        newconf->mlrepfromname       = NULL;
        newconf->mlusername          = NULL;
        newconf->mlpassword          = NULL;
        newconf->mlsendinterval      = DIVY_INT32_C_UNSET;
	newconf->maxuser             = DIVY_INT32_C_UNSET;
	newconf->encryptpassword     = DIVY_ENCRYPTPASSWORD_UNSET;
	newconf->streammethod        = DIVY_STREAMMETHOD_UNSET;
	newconf->trashfolder         = DIVY_TRASHFOLDER_UNSET;
	newconf->extenduserst        = DIVY_EXTENDUSERST_UNSET;
#ifdef DIVY_SUPPORT_PRINTER
	newconf->netprint            = DIVY_NETPRINT_UNSET;
#endif	/* DIVY_SUPPORT_PRINTER */
	newconf->thumbnail           = DIVY_THUMBNAIL_UNSET;
#ifdef DIVY_SUPPORT_PASSPOLICY
	newconf->passpolicy           = DIVY_PASSPOLICY_UNSET;
	newconf->passpolicy_opt       = DIVY_PASSPOLICY_OPT_UNSET;
	newconf->passpolicy_exs       = NULL;
#endif	/* DIVY_SUPPORT_PASSPOLICY */
#ifdef DIVY_SUPPORT_LOGACCESS
	newconf->logaccess           = DIVY_LOGACCESS_UNSET;
#endif	/* DIVY_SUPPORT_LOGACCESS */
	newconf->autodelete          = DIVY_AUTODELETE_UNSET;
	newconf->autodel_allowipaddrs= NULL;
	newconf->chunkput            = DIVY_CHUNKPUT_UNSET;
	newconf->execengine          = DIVY_EXECENGINE_UNSET;
	newconf->execoncmd           = NULL;
	newconf->execmatch			 = NULL;
	newconf->forcedelete         = DIVY_FORCEDELETE_UNSET;
	newconf->rproxyuse           = DIVY_RPROXYUSE_UNSET;
	newconf->rproxymatch         = NULL;
	newconf->rproxyschema        = DIVY_RPROXY_SCHEMA_UNSET;
	newconf->rproxyhttpport      = DIVY_INT32_C_UNSET;
	newconf->rproxyhttpsport     = DIVY_INT32_C_UNSET;
	newconf->syscgiconnectport   = DIVY_INT32_C_UNSET;
	newconf->syscgiconnectschema = DIVY_SYSCGI_CONNECT_SCHEMA_UNSET;
	newconf->notifyserverport    = DIVY_INT32_C_UNSET;
	newconf->notifyserverschema  = DIVY_NOTIFYSERVER_SCHEMA_UNSET;
	newconf->logoperation        = DIVY_LOGOPERATION_UNSET;
	newconf->licenseuploader     = DIVY_LICENSEUPLOADER_UNSET;
	newconf->groupleader         = DIVY_GROUPLEADER_UNSET;
	newconf->confirmreading      = DIVY_CONFIRMREADING_UNSET;
	newconf->extendsysmsg        = DIVY_EXTENDSYSMSG_UNSET;
	newconf->groupquota			 = DIVY_GROUPQUOTA_UNSET;
	newconf->cr_reservedday      = DIVY_INT32_C_UNSET;
	newconf->ldapsslsupport      = 0;
	newconf->allowadminipaddrs   = NULL;
	newconf->disablewebfolderlink = DIVY_DISABLE_WEBFOLDERLINK_UNSET;
	newconf->disablechangepassword = DIVY_DISABLE_CHANGE_PASSWORD_UNSET;
	newconf->masterpassword      = NULL;
	newconf->uldownloadallowtime = 0;
	newconf->usesession          = DIVY_USE_SESSION_UNSET;
	newconf->sessiontimeout      = DIVY_SESSION_TIMEOUT_INFINITY; /* 無制限 */
	newconf->useaccesscontrol    = DIVY_ACCESS_CONTROL_UNSET;
	newconf->defaultaccessrule   = DIVY_DEFAULT_ACCESS_RULE_OFF;
	newconf->failedloginlockout  = DIVY_FAILED_LOGIN_LOCKOUT_UNSET;
	newconf->shortenurl          = DIVY_SHORTEN_URL_UNSET;
	newconf->tfbox               = DIVY_TFBOX_UNSET;
	newconf->tfserverpolicyheader= NULL;
	newconf->tfboxpolicylimit    = 0;	/* 無制限 */
	newconf->tfboxdisableformat  = DIVY_BOX_DISABLE_FORMAT_NONE;
	newconf->usememcache		 = DIVY_TFMEMCACHE_UNSET;
	newconf->memd				 = NULL;
	newconf->usesaml			 = DIVY_USE_SAML_UNSET;
	newconf->idpmeta             = NULL;
	newconf->saml_privatekeypath = NULL;
	newconf->saml_x509certificatepath = NULL;
	newconf->tfbrowserstyle      = DIVY_BROWSER_STYLE_NONE;
	newconf->saml_matchedmailaddr = DIVY_SAML_MATCHED_MAIL_UNSET;
	newconf->lockoutlimit        = 0;
	newconf->unlocktime          = 0;
	newconf->unlockretrycount    = 0;
	newconf->useuploadpolicy     = DIVY_USE_UPLOAD_POLICY_UNSET;
	newconf->use2fa              = DIVY_USE_2FA_UNSET;
	newconf->cyclebasetime2fa    = 0;
	newconf->cycleperiod2fa      = NULL;
	newconf->type2fa             = DIVY_2FA_TYPE_UNSET;
	newconf->stage2fa            = DIVY_2FA_USE_STAGE_UNSET;
	newconf->boxdisablewildcardmailaddr = 0;
	newconf->boxwithoutmail      = BOX_WITHOUTMAIL_NONE;
#ifdef TF_SUPPORT_CIPHER_STORAGE
	newconf->cipherstorage       = DIVY_CIPHER_STORAGE_UNSET;
	newconf->cipherstoragekey    = NULL;
	newconf->cipherstoragetype   = 0;
#endif
	return newconf;
}

/**
 * dir config マージ
 */
static void *dav_divy_merge_dir_config(apr_pool_t *p, 
                                     void *base, void *overrides)
{
	dav_divy_dir_conf *parent = base;
	dav_divy_dir_conf *child  = overrides;
	dav_divy_dir_conf *newconf;

	newconf = apr_pcalloc(p, sizeof(dav_divy_dir_conf));

	/*
	 * 常にchild の値を使用する(継承禁止)
	 */
	newconf->root_uri = child->root_uri;

	/*
	 * overridesで値が定義されていたらそれを新たな
	 * Directory configとして採用する
	 */
	/* Auth */
	newconf->divyauth = DIVY_INHERIT_VALUE(parent, child, divyauth);
	newconf->auth_on  = DIVY_INHERIT_VALUE(parent, child, auth_on);
	newconf->authignoreipaddrs = DIVY_INHERIT_VALUE(parent, child, authignoreipaddrs);

	/* Repository DB */
	newconf->dbmstype = DIVY_INHERIT_VALUE(parent, child, dbmstype);
	newconf->hostname = DIVY_INHERIT_VALUE(parent, child, hostname);
	newconf->hostport = DIVY_INHERIT_VALUE(parent, child, hostport);
	newconf->dbname   = DIVY_INHERIT_VALUE(parent, child, dbname);
	newconf->username = DIVY_INHERIT_VALUE(parent, child, username);
	newconf->password = DIVY_INHERIT_VALUE(parent, child, password);

	/* DB Connection Pool */
	newconf->dbpool         = DIVY_INHERIT_VALUE(parent, child, dbpool);
	newconf->dbminspareconn = DIVY_INHERIT_INT32_VALUE(parent, child, dbminspareconn);
	newconf->dbmaxspareconn = DIVY_INHERIT_INT32_VALUE(parent, child, dbmaxspareconn);

	/* dbmsname を組み立てる (2004.08.23 Mon)
	 * コンフィグとしては読み込まず自動生成することになりました) */
	newconf->dbmsname = divy_db_build_reposdbmsname(p, newconf);

	/* FileSystem */
	newconf->fsrootpath = DIVY_INHERIT_VALUE(parent, child, fsrootpath);
	newconf->maxresource_per_dir =
			DIVY_INHERIT_INT32_VALUE(parent, child, maxresource_per_dir);

	/* Mail */
	newconf->mail     = DIVY_INHERIT_VALUE(parent, child, mail);
	newconf->mailhost = DIVY_INHERIT_VALUE(parent, child, mailhost);
	newconf->mailport = DIVY_INHERIT_VALUE(parent, child, mailport);
	newconf->mailadminaddr = DIVY_INHERIT_VALUE(parent, child, mailadminaddr);
	newconf->mailencoding  = DIVY_INHERIT_VALUE(parent, child, mailencoding);
	newconf->mlserversend  = DIVY_INHERIT_VALUE(parent, child, mlserversend);
	newconf->mltemplateroot= DIVY_INHERIT_VALUE(parent, child, mltemplateroot);
	newconf->mlnotifyact   = DIVY_INHERIT_VALUE(parent, child, mlnotifyact);
	newconf->mloneclickurl = DIVY_INHERIT_VALUE(parent, child, mloneclickurl);
        newconf->mledit        = DIVY_INHERIT_VALUE(parent, child, mledit);
        newconf->mlrepfromaddr = DIVY_INHERIT_VALUE(parent, child, mlrepfromaddr);
        newconf->mlrepfromname = DIVY_INHERIT_VALUE(parent, child, mlrepfromname);
        newconf->mlusername    = DIVY_INHERIT_VALUE(parent, child, mlusername);
        newconf->mlpassword    = DIVY_INHERIT_VALUE(parent, child, mlpassword);
        newconf->mlsendinterval= DIVY_INHERIT_VALUE(parent, child, mlsendinterval);
	newconf->notifyservername   = DIVY_INHERIT_VALUE(parent, child, notifyservername);
	newconf->notifyserverport   = DIVY_INHERIT_VALUE(parent, child, notifyserverport);
	newconf->notifyserverschema = DIVY_INHERIT_VALUE(parent, child, notifyserverschema);

	/* Misc .. */
	newconf->maxfilesize= DIVY_INHERIT_INT64_VALUE(parent, child, maxfilesize);
	newconf->show_group = DIVY_INHERIT_VALUE(parent, child, show_group);
	newconf->maxuser    = DIVY_INHERIT_INT32_VALUE(parent, child, maxuser);

	/* LDAP */
	newconf->ldap       = DIVY_INHERIT_VALUE(parent, child, ldap);
	newconf->ldapbasedn = DIVY_INHERIT_VALUE(parent, child, ldapbasedn);
	newconf->ldapbinddn = DIVY_INHERIT_VALUE(parent, child, ldapbinddn);
	newconf->ldapbindpw = DIVY_INHERIT_VALUE(parent, child, ldapbindpw);
	newconf->ldapattr   = DIVY_INHERIT_VALUE(parent, child, ldapattr);
	newconf->ldapfilter = DIVY_INHERIT_VALUE(parent, child, ldapfilter);
	newconf->ldapscope  = DIVY_INHERIT_VALUE(parent, child, ldapscope);
	newconf->ldaphost   = DIVY_INHERIT_VALUE(parent, child, ldaphost);
	newconf->ldapport   = DIVY_INHERIT_VALUE(parent, child, ldapport);
	newconf->ldapurl    = DIVY_INHERIT_VALUE(parent, child, ldapurl);
	newconf->ldapmapuserattr =
	       		DIVY_INHERIT_VALUE(parent, child, ldapmapuserattr);
	newconf->ldapmappasswordattr =
	       		DIVY_INHERIT_VALUE(parent, child, ldapmappasswordattr);
	newconf->ldapmapfullnameattr =
	       		DIVY_INHERIT_VALUE(parent, child, ldapmapfullnameattr);
	newconf->ldapmapmailaddrattr =
	       		DIVY_INHERIT_VALUE(parent, child, ldapmapmailaddrattr);
	newconf->ldapmapcommentattr =
	       		DIVY_INHERIT_VALUE(parent, child, ldapmapcommentattr);
	newconf->ldapfoundcreate =
	       		DIVY_INHERIT_VALUE(parent, child, ldapfoundcreate);
	newconf->ldapsyncproperty =
	       		DIVY_INHERIT_VALUE(parent, child, ldapsyncproperty);
	newconf->ldapallowuser =
			DIVY_INHERIT_VALUE(parent, child, ldapallowuser);
	newconf->ldapallowuserregex =
			DIVY_INHERIT_VALUE(parent, child, ldapallowuserregex);
	newconf->ldapsslsupport = parent->ldapsslsupport;
	newconf->ldapuseroptions = DIVY_INHERIT_VALUE(parent, child, ldapuseroptions);
	newconf->ldapmaxresquota = DIVY_INHERIT_INT64_VALUE(parent, child, ldapmaxresquota);
	newconf->ldapusernotfoundaction = DIVY_INHERIT_INT32_VALUE(parent, child, ldapusernotfoundaction);

	/* autoindex */
	newconf->autoindex      = DIVY_INHERIT_VALUE(parent, child, autoindex);
	newconf->stylesheetroot = DIVY_INHERIT_VALUE(parent, child, stylesheetroot);

	/* sync group uri */
	newconf->syncgrpuri = DIVY_INHERIT_VALUE(parent, child, syncgrpuri);

	/* encryption user password */
	newconf->encryptpassword = DIVY_INHERIT_VALUE(parent, child, encryptpassword);

	/* trash-folder */
	newconf->trashfolder = DIVY_INHERIT_VALUE(parent, child, trashfolder);

	/* Virus Scan */
	newconf->vscan        = DIVY_INHERIT_VALUE(parent, child, vscan);
	newconf->streammethod = DIVY_INHERIT_VALUE(parent, child, streammethod);
	newconf->vschostname  = DIVY_INHERIT_VALUE(parent, child, vschostname);
	newconf->vschostport  = DIVY_INHERIT_VALUE(parent, child, vschostport);
	newconf->vsccmd       = DIVY_INHERIT_VALUE(parent, child, vsccmd);

	/* Extended User Status */
	newconf->extenduserst = DIVY_INHERIT_VALUE(parent, child, extenduserst);

#ifdef DIVY_SUPPORT_PRINTER
	/* print function */
	newconf->netprint = DIVY_INHERIT_VALUE(parent, child, netprint);
	newconf->printergroupname = DIVY_INHERIT_VALUE(parent, child, printergroupname);
	newconf->printername      = DIVY_INHERIT_VALUE(parent, child, printername);
#endif	/* DIVY_SUPPORT_PRINTER */
#ifdef DIVY_SUPPORT_PREFLIGHT_PLUGIN
	newconf->plrootpath  = DIVY_INHERIT_VALUE(parent, child, plrootpath);
	newconf->plgroupset = DIVY_INHERIT_VALUE(parent, child, plgroupset);
#endif	/* DIVY_SUPPORT_PREFLIGHT_PLUGIN */
	newconf->thumbnail   = DIVY_INHERIT_VALUE(parent, child, thumbnail);

#ifdef DIVY_SUPPORT_PASSPOLICY
	newconf->passpolicy     = DIVY_INHERIT_VALUE(parent, child, passpolicy);
	newconf->passpolicy_opt = DIVY_INHERIT_VALUE(parent, child, passpolicy_opt);
	newconf->passpolicy_exs = DIVY_INHERIT_VALUE(parent, child, passpolicy_exs);
#endif	/* DIVY_SUPPORT_PASSPOLICY */
#ifdef DIVY_SUPPORT_LOGACCESS
	newconf->logaccess      = DIVY_INHERIT_VALUE(parent, child, logaccess);
#endif	/* DIVY_SUPPORT_LOGACCESS */
	newconf->autodelete     = DIVY_INHERIT_VALUE(parent, child, autodelete);
	newconf->autodel_allowipaddrs = DIVY_INHERIT_VALUE(parent, child, autodel_allowipaddrs);

	newconf->chunkput       = DIVY_INHERIT_VALUE(parent, child, chunkput);

	/* Action extension command */
	newconf->execengine     = DIVY_INHERIT_VALUE(parent, child, execengine);
	newconf->execoncmd      = DIVY_INHERIT_VALUE(parent, child, execoncmd);
	newconf->execmatch		= DIVY_INHERIT_VALUE(parent, child, execmatch);

	/* Force-Delete function */
	newconf->forcedelete    = DIVY_INHERIT_VALUE(parent, child, forcedelete);

	/* Reverse-Proxy function */
	newconf->rproxyuse      = DIVY_INHERIT_VALUE(parent, child, rproxyuse);
	newconf->rproxymatch    = DIVY_INHERIT_VALUE(parent, child, rproxymatch);
	newconf->rproxyschema   = DIVY_INHERIT_VALUE(parent, child, rproxyschema);
	newconf->rproxyhttpport = DIVY_INHERIT_INT32_VALUE(parent, child, rproxyhttpport);
	newconf->rproxyhttpsport= DIVY_INHERIT_INT32_VALUE(parent, child, rproxyhttpsport);

	/* System-CGI */
	newconf->syscgiconnectport   = DIVY_INHERIT_INT32_VALUE(parent, child, syscgiconnectport);
	newconf->syscgiconnectschema = DIVY_INHERIT_VALUE(parent, child, syscgiconnectschema);

	/* Operation log */
	newconf->logoperation = DIVY_INHERIT_VALUE(parent, child, logoperation);

	/* License Uploader */
	newconf->licenseuploader = DIVY_INHERIT_VALUE(parent, child, licenseuploader);

	/* Group-leader */
	newconf->groupleader = DIVY_INHERIT_VALUE(parent, child, groupleader);

	/* Confirm-Reading */
	newconf->confirmreading = DIVY_INHERIT_VALUE(parent, child, confirmreading);
	newconf->cr_reservedday = DIVY_INHERIT_INT32_VALUE(parent, child, cr_reservedday);

	/* extend-Sysmsg */
	newconf->extendsysmsg   = DIVY_INHERIT_VALUE(parent, child, extendsysmsg);

	/* group-quota */
	newconf->groupquota		= DIVY_INHERIT_VALUE(parent, child, groupquota);

	/* allow admin ip address  */
	newconf->allowadminipaddrs = DIVY_INHERIT_VALUE(parent, child, allowadminipaddrs);

	/* disablewebfolderlink */
	newconf->disablewebfolderlink = DIVY_INHERIT_VALUE(parent, child, disablewebfolderlink);

	/* disablechangepassword */
	newconf->disablechangepassword = DIVY_INHERIT_VALUE(parent, child, disablechangepassword);

	/* masterpassword */
	newconf->masterpassword = DIVY_INHERIT_VALUE(parent, child, masterpassword);

	/* upload only user is download allow time */
	newconf->uldownloadallowtime = DIVY_INHERIT_VALUE(parent, child, uldownloadallowtime);

	/* use session */
	newconf->usesession = DIVY_INHERIT_VALUE(parent, child, usesession);

	/* session time out */
	newconf->sessiontimeout = DIVY_INHERIT_VALUE(parent, child, sessiontimeout);

	/* access control */
	newconf->useaccesscontrol = DIVY_INHERIT_VALUE(parent, child, useaccesscontrol);

	/* default access rule */
	newconf->defaultaccessrule = DIVY_INHERIT_VALUE(parent, child, defaultaccessrule);

	/* failedloginlockout */
	newconf->failedloginlockout = DIVY_INHERIT_VALUE(parent, child, failedloginlockout);

	/* lockoutmilit */
	newconf->lockoutlimit = DIVY_INHERIT_VALUE(parent, child, lockoutlimit);

	/* unlocktime */
	newconf->unlocktime = DIVY_INHERIT_VALUE(parent, child, unlocktime);

	/* unlockretrycount */
	newconf->unlockretrycount = DIVY_INHERIT_VALUE(parent, child, unlockretrycount);

	/* shortenurl */
	newconf->shortenurl = DIVY_INHERIT_VALUE(parent, child, shortenurl);

	/* tfbox */
	newconf->tfbox = DIVY_INHERIT_VALUE(parent, child, tfbox);

	/* tfserverpolicyheader */
	newconf->tfserverpolicyheader = DIVY_INHERIT_VALUE(parent, child, tfserverpolicyheader);

	/* tfboxpolicylimit */
	newconf->tfboxpolicylimit = DIVY_INHERIT_VALUE(parent, child, tfboxpolicylimit);

	/* tfboxdisableformat */
	newconf->tfboxdisableformat = DIVY_INHERIT_VALUE(parent, child, tfboxdisableformat);

	/* usememcache */
	newconf->usememcache = DIVY_INHERIT_VALUE(parent, child, usememcache);

	/* mt */
	newconf->memd = DIVY_INHERIT_VALUE(parent, child, memd);

	/* SAML */
	newconf->usesaml = DIVY_INHERIT_VALUE(parent, child, usesaml);

	/* IdP meta data */
	newconf->idpmeta = DIVY_INHERIT_VALUE(parent, child, idpmeta);

	/* SAML Private Key path */
	newconf->saml_privatekeypath = DIVY_INHERIT_VALUE(parent, child, saml_privatekeypath);

	/* SAML X.509 Certificate Path */
	newconf->saml_x509certificatepath = DIVY_INHERIT_VALUE(parent, child, saml_x509certificatepath);

	/* tfbrowserstyle */
	newconf->tfbrowserstyle = DIVY_INHERIT_VALUE(parent, child, tfbrowserstyle);

	/* saml_matchedmailaddr */
	newconf->saml_matchedmailaddr = DIVY_INHERIT_VALUE(parent, child, saml_matchedmailaddr);

	/* useuploadpolicy */
	newconf->useuploadpolicy = DIVY_INHERIT_VALUE(parent, child, useuploadpolicy);

	/* use2fa */
	newconf->use2fa = DIVY_INHERIT_VALUE(parent, child, use2fa);

	/* cyclebasetime2fa */
	newconf->cyclebasetime2fa = DIVY_INHERIT_VALUE(parent, child, cyclebasetime2fa);

	/* cycleperiod2fa */
	newconf-> cycleperiod2fa = DIVY_INHERIT_VALUE(parent, child, cycleperiod2fa);
	/* type2fa */
	newconf->type2fa = DIVY_INHERIT_VALUE(parent, child, type2fa);

	/* stage2fa */
	newconf->stage2fa = DIVY_INHERIT_VALUE(parent, child, stage2fa);

	/* boxdisablewildcardmailaddr */
	newconf->boxdisablewildcardmailaddr = DIVY_INHERIT_VALUE(parent, child, boxdisablewildcardmailaddr);

	/* boxwithoutmail */
	newconf->boxwithoutmail = DIVY_INHERIT_VALUE(parent, child, boxwithoutmail);

#ifdef TF_SUPPORT_CIPHER_STORAGE
	/* cipher storage */
	newconf->cipherstorage = DIVY_INHERIT_VALUE(parent, child, cipherstorage);

	/* cipher storage key */
	newconf->cipherstoragekey = DIVY_INHERIT_VALUE(parent, child, cipherstoragekey);

	/* cipher storage type */
	newconf->cipherstoragetype = DIVY_INHERIT_VALUE(parent, child, cipherstoragetype);
#endif
	return newconf;
}

/**
 * server config 生成
 */
static void *dav_divy_create_server_config(apr_pool_t *p, server_rec *s)
{
	dav_divy_server_conf *newconf = apr_palloc(p, sizeof(dav_divy_server_conf));
	char *pid = apr_psprintf(p, "%"APR_PID_T_FMT, getpid());

	/* 初期化 */
	newconf->svrlicensekey     = NULL;
	newconf->dblicense_h       = NULL;
	newconf->dbrefreshinterval = DIVY_INT32_C_UNSET;	/* デフォルト値 */
	newconf->contract_user_cnt = DIVY_INT32_C_UNSET;
	newconf->allow_user_cnt    = DIVY_INT32_C_UNSET;
	newconf->use_mail_opt      = 0;
	newconf->use_db_opt        = 0;
	newconf->use_ldap_opt      = 0;
	newconf->use_vsc_opt       = 0;	/* 無効がデフォルト */
	newconf->use_enccipher_opt = 0;
	newconf->use_autodel_opt   = 0;
	newconf->use_extcmd_opt    = 0;
	newconf->starttime_exp     = NULL;
	newconf->ltimestamp        = 0L;

	newconf->ldapshmpath	   = apr_pstrcat(p, DIVY_LDAP_SHM_PATH, pid, NULL);
	newconf->ldapcachebyte	   = TF_LDAP_UNSET;	/* デフォルト値 */
	newconf->ldapsearch_cache_ttl = 0;
	newconf->ldapcert_auth_file = NULL;
	newconf->ldapcert_file_type = LDAP_CA_TYPE_BASE64;
	newconf->ldap_maxmemBlocks = 0;
	newconf->ldapMarkPercentage = 0.0;
	newconf->ldapPurgePercentage = 0.0;
	newconf->ldapURLHashTblSize = 0;
	newconf->ldapSearchHashTblSize = 0;

	newconf->brandname = NULL;
	newconf->tfversion = DIVY_VERSION;
	newconf->useusbtoken = DIVY_USEUSBTOKEN_UNSET;
#ifdef DIVY_SUPPORT_PLUGIN
	newconf->pluginroot = NULL;
#endif	/* DIVY_SUPPORT_PLUGIN */
#ifdef DAV_SUPPORT_POST_HANDLING
	newconf->syscgirootpath = NULL;
#endif	/* DAV_SUPPORT_POST_HANDLING */
	newconf->supported_languages = NULL;
	newconf->default_lang        = NULL;
	newconf->force_lang          = NULL;
	newconf->tfcustomimagepath   = NULL;

	return newconf;
}

/**
 * server config マージ
 */
static void *dav_divy_merge_server_config(apr_pool_t *p, 
                                        void *base, void *overrides)
{
	dav_divy_server_conf *newconf;
	dav_divy_server_conf *parent = base;
	dav_divy_server_conf *child  = overrides;
	
	newconf = apr_pcalloc(p, sizeof(dav_divy_server_conf));

	/* override してはならない値 */
	newconf->dbrefreshinterval = parent->dbrefreshinterval;
	newconf->ldapshmpath	   = parent->ldapshmpath;
	newconf->ldapcachebyte	   = parent->ldapcachebyte;
	newconf->ldapsearch_cache_ttl = parent->ldapsearch_cache_ttl;
	newconf->ldapcert_auth_file = parent->ldapcert_auth_file;
	newconf->ldapcert_file_type = parent->ldapcert_file_type;
	newconf->ldapMarkPercentage = parent->ldapMarkPercentage;
	newconf->ldapPurgePercentage = parent->ldapPurgePercentage;
	newconf->ldapURLHashTblSize = parent->ldapURLHashTblSize;
	newconf->ldapSearchHashTblSize = parent->ldapSearchHashTblSize;
#ifdef DIVY_SUPPORT_PLUGIN
	newconf->pluginroot = parent->pluginroot;
#endif	/* DIVY_SUPPORT_PLUGIN */

	/*
	 * overridesで値が定義されていたらそれを新たな
	 * server configとして採用する
	 */
	/* サーバライセンスキー */
	if (child->svrlicensekey) {
		/* (note)
		 *	contract_user_cnt 以下のコンフィグはsvrlicensekey を
		 *	パースして得られる値。ディレクティブにある訳ではないので、
		 *	svrlicensekey がoverrideされるのならそれに従う必要あり
		 */
		newconf->svrlicensekey     = child->svrlicensekey;
		newconf->contract_user_cnt = child->contract_user_cnt;
		newconf->allow_user_cnt    = child->allow_user_cnt;
		newconf->use_mail_opt      = child->use_mail_opt;
		newconf->use_db_opt        = child->use_db_opt;
		newconf->use_ldap_opt      = child->use_ldap_opt;
		newconf->use_vsc_opt       = child->use_vsc_opt;
		newconf->use_enccipher_opt = child->use_enccipher_opt;
		newconf->use_autodel_opt   = child->use_autodel_opt;
		newconf->use_extcmd_opt    = child->use_extcmd_opt;
		newconf->starttime_exp     = child->starttime_exp;
	}
	else {
		newconf->svrlicensekey     = parent->svrlicensekey;
		newconf->contract_user_cnt = parent->contract_user_cnt;
		newconf->allow_user_cnt    = parent->allow_user_cnt;
		newconf->use_mail_opt      = parent->use_mail_opt;
		newconf->use_db_opt        = parent->use_db_opt;
		newconf->use_ldap_opt      = parent->use_ldap_opt;
		newconf->use_vsc_opt       = parent->use_vsc_opt;
		newconf->use_enccipher_opt = parent->use_enccipher_opt;
		newconf->use_autodel_opt   = parent->use_autodel_opt;
		newconf->use_extcmd_opt    = parent->use_extcmd_opt;
		newconf->starttime_exp     = parent->starttime_exp;
	}

	/* DBプロバイダライセンスキー */
	newconf->dblicense_h = DIVY_INHERIT_VALUE(parent, child, dblicense_h);

	/* ブランド名 */
	newconf->brandname = DIVY_INHERIT_VALUE(parent, child, brandname);

	/* バージョン */
	newconf->tfversion = DIVY_INHERIT_VALUE(parent, child, tfversion);

	/* USBトークン利用可否 */
	newconf->useusbtoken = DIVY_INHERIT_VALUE(parent, child, useusbtoken);

	/* システムCGIルートパス */
#ifdef DAV_SUPPORT_POST_HANDLING
	newconf->syscgirootpath = DIVY_INHERIT_VALUE(parent, child, syscgirootpath);
#endif	/* DAV_SUPPORT_POST_HANDLING */

	/* サポート言語セット */
	newconf->supported_languages = DIVY_INHERIT_VALUE(parent, child, supported_languages);

	/* デフォルト言語タグ */
	newconf->default_lang = DIVY_INHERIT_VALUE(parent, child, default_lang);

	/* 強制言語タグ */
	newconf->force_lang = DIVY_INHERIT_VALUE(parent, child, force_lang);

	/* custom image path */
	newconf->tfcustomimagepath = DIVY_INHERIT_VALUE(parent, child, tfcustomimagepath);

	return newconf;
}

#ifndef DIVY_VERSION
#define DIVY_VERSION ""
#endif

/**
 * post_configステージにおいて呼び出されるハンドラ.
 *
 * TeamFile のバージョンをバージョンテーブルに追加する。
 * responseヘッダ"Server:"の中にバージョン名が表示されるようになります。
 * その他、初期化処理を行っています。
 *
 * @param pconf apr_pool_t * s->process->pconf のこと。Config用プール
 * @param plog  apr_pool_t * s->process->pool のサブプール
 * @param ptemp apr_pool_t * s->process->pconf のサブプール。直ぐに破棄されます
 * @param s server_rec * main serverのserver_rec
 * @return int ステータス(OK 以外を戻すと何がおきるかわかりません)
 */
static int  dav_divy_post_config(apr_pool_t *pconf, apr_pool_t *plog, 
                                apr_pool_t *ptemp, server_rec *s)
{
	int ret;
	dav_divy_server_conf *sconf = dav_divy_get_server_config(s);
#ifdef DIVY_SUPPORT_PLUGIN
	int flag;
#endif	/* DIVY_SUPPORT_PLUGIN */

	/* コンポーネント名の一覧にこのモジュール名称を追加する */
	if (IS_FILLED(sconf->brandname)) {
		ap_add_version_component(pconf,
			apr_psprintf(pconf, "%s/"DIVY_VERSION, sconf->brandname));
	}
	else {
		ap_add_version_component(pconf, DIVY_PRODUCT_NAME"/"DIVY_VERSION);
	}

	/* MPMの情報を取得して記録する */
	dav_divy_query_mpm_info();

	/*
	 * ライブラリ用ロガー関数を設定する
	 * (note) 利用するロガーは ap_log_perror関数
	 */
	divy_set_lerrlogger((divy_lerrlog_t)ap_log_perror);

	/*
	 * プロバイダライブラリマネージャ専用処理
	 */

	/* マネージャの初期化 */
	ret = divy_init_providers_env(pconf);
	if (ret != DIVY_LIB_ST_OK) {
		ERRLOG0(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_PROC,
			"Failed to initialize provider manager.");
	}

	/* static リンクされたxxx プロバイダライブラリの初期化 */
	ret = divy_register_preloaded_lib_provider();
	if (ret != DIVY_LIB_ST_OK) {
		ERRLOG0(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_PROC,
			"Failed to preload provider library.");
	}

	/*
	 * 登録された全てのxxx プロバイダライブラリの初期化ハンドラを
	 * コールバックする
	 */
	ret = divy_run_lib_init_func(pconf);
	if (ret != DIVY_LIB_ST_OK) {
		ERRLOG0(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_PROC,
			"Failed to execute init provider library.");
	}


	/*
	 * LDAPの共有メモリを作成する
	 */
	divy_util_ldap_initialize_config(s, pconf);
			
#ifdef DIVY_SUPPORT_PLUGIN
	flag = divy_pcache_get_flag(s->process->pool, DIVY_PCACHE_FLG_GL_PLLOADER);
	/* 1度目の呼び出し時には何もしない */
	if (!flag) {
		divy_pcache_set_flag(s->process->pool, 1, DIVY_PCACHE_FLG_GL_PLLOADER);
	}
	/* 2度目の呼び出しの時 */
	else {
		/* TeamFile プラグインローダーの初期化 */
		ret = divy_pi_init(sconf->pluginroot, pconf);
		if (ret) {
			ERRLOG0(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_PROC,
					"Failed to initialize plugin-loader.");
		}
	}
#endif	/* DIVY_SUPPORT_PLUGIN */

	/*
	 * watchdogの設定 
	 */
	dav_divy_start_watchdog(pconf, plog, ptemp, s);

	return OK;
}

/**
 * child_init ステージにおいて呼び出されるハンドラ.
 *
 * @param pchild apr_pool_t * s->process->pconf のサブプール。
 *                            Childプロセスとライフサイクルを共にします
 * @param s server_rec * main serverのserver_rec (vhostの情報も持っています)
 *                       post_config と同じです。
 */
static void dav_divy_child_init(apr_pool_t *pchild, server_rec *s)
{
	int threaded = 0;

	TRACE_S(s);
	
	/* thread-mutexの生成と初期化を行う */
	init_mutex_env(pchild);

	/* DBプロバイダ管理コンテキストの初期化 */
	init_dbprvmng_env(pchild, s);

	/* メールプロバイダコンテキストの初期化 */
	init_mlprv_env(pchild, s);

	/* ウィルス検索プロバイダコンテキストの初期化 */
	init_vscprv_env(pchild, s);

	/* LDAPの初期化処理 */
	divy_util_ldap_initialize(pchild, s);

	/* 特殊フォルダURIのプリコンパイル(初期化) */
	divy_precomp_uri_pattern(pchild);

	/* MPM の種類を設定する */
	ap_mpm_query(AP_MPMQ_IS_THREADED, &threaded);
	if (threaded) {
		dav_divy_set_mpm_type(DIVY_MPM_TYPE_THREAD);	/* スレッドタイプ */
	}
	else {
		dav_divy_set_mpm_type(DIVY_MPM_TYPE_PROCESS);	/* プロセスタイプ */
	}

	/*
	 * xxx プロバイダライブラリのChild init ハンドラをコールバックする
	 * (コールバック関数の呼び出し)
	 */
	divy_run_child_init(pchild);

#ifdef DIVY_SUPPORT_PLUGIN
	/* サーバプラグインのChild プロセス開始時の処理をコールバックする */
	divy_pi_cinit(pchild, s);
#endif	/* DIVY_SUPPORT_PLUGIN */

	/* Cleanupにコールバック関数を登録する */
	apr_pool_cleanup_register(pchild, s, dav_divy_child_exit,
	                          apr_pool_cleanup_null);
	return;
}

/**
 * Post_read_request ステージで呼び出されるハンドラ
 *
 * @param r request_rec * 最初にrequest_rec が得られるステージ
 * 			まだディレクトリコンフィグを解決できません。
 * @return int
 */
static int  dav_divy_post_read(request_rec *r)
{
	/* 通常ログ出力環境の初期化 */
	init_log_env(r);

#ifdef TF_USE_USBTOKEN
	/* ライセンスキーの取得要求 */
	(void) _query_license(r);
#endif	/* TF_USE_USBTOKEN */

#ifdef DIVY_SUPPORT_PLUGIN
	/* サーバプラグインのリクエストレベルの初期化処理 */
	divy_pi_rinit(r);
#endif	/* DIVY_SUPPORT_PLUGIN */

	/* グローバルCGI 環境変数を設定する */
	divy_cgi_setup_gl_envvars(r);

	return DECLINED;
}

#if 0	/* 2005/02/08 fixups は結果的に処理内容が無くなったのでコメントアウト */
/**
 * fixupsステージにおいて呼び出されるハンドラ
 * (note)
 * 	このステージはハンドラを処理するモジュールとは無関係に
 * 	呼び出されます。モジュール専用のフックではありません。
 *
 * @param r request_rec * (ハンドラ名は分かりません)
 * @return int
 */
static int dav_divy_fixups(request_rec *r)
{
	return DECLINED;
}
#endif

/**
 * Childプロセスの終了処理にて呼び出されるハンドラ.
 * (note)
 * 	Child 専用のプールpchild のクリーンアップハンドラとして
 * 	呼び出されます。
 * 	終了ステージは非常にsensitiveなので、あまり時間のかかる
 * 	処理をやってはなりません。
 *
 * @param data void * server_rec構造体へのポインタ
 * @return apr_status_t 処理ステータス(APR_SUCCESS)
 */
static apr_status_t dav_divy_child_exit(void *data)
{
	server_rec *s = data;
	
	TRACE_S(s);
	
	/* thread-mutexの破棄を行う */
	destroy_mutex_env();

	/* DBプロバイダ管理コンテキストの破棄を行う */
	destroy_dbprvmng_env();

	return APR_SUCCESS;
}

/**
 * DIVY内で共通に使用するMutexを生成・初期化する。
 * (note)
 * 	複数回コールされないステージで呼び出す必要があります。
 *
 * @param p apr_pool_t serverプールへのポインタ
 */
static void init_mutex_env(apr_pool_t *p)
{
	apr_status_t rv;
	
	/* init mutex の初期化 */
	rv = apr_thread_mutex_create(&init_mutex, APR_THREAD_MUTEX_UNNESTED, p);
	if (rv != APR_SUCCESS) {
		ERRLOG1(p, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to create init_mutex.(code = %d)", rv);
	}

	/* scanner mutex の初期化 */
	rv = apr_thread_mutex_create(&scanner_mutex, APR_THREAD_MUTEX_UNNESTED, p);
	if (rv != APR_SUCCESS) {
		ERRLOG1(p, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to create scanner_mutex.(code = %d)", rv);
	}

	/* autoindex mutex の初期化 */
	rv = apr_thread_mutex_create(&autoindex_mutex, APR_THREAD_MUTEX_UNNESTED, p);
	if (rv != APR_SUCCESS) {
		ERRLOG1(p, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to create autoindex_mutex.(code = %d)", rv);
	}

	/* license mutex の初期化 */
	rv = apr_thread_mutex_create(&license_mutex, APR_THREAD_MUTEX_UNNESTED, p);
	if (rv != APR_SUCCESS) {
		ERRLOG1(p, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to create license_mutex.(code = %d)", rv);
	}
}

/**
 * DIVY内で共通に使用するMutexを破棄する。
 * (note)
 * 	複数回コールされないステージで呼び出す必要があります。
 */
static void destroy_mutex_env()
{
	apr_status_t st;

	/* init mutex の破棄 */
	st = apr_thread_mutex_destroy(init_mutex);
	if (st != APR_SUCCESS) {
		ERRLOG1(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to destroy init_mutex.(code = %d)", st);
	}

	/* scanner mutex の破棄 */
	st = apr_thread_mutex_destroy(scanner_mutex);
	if (st != APR_SUCCESS) {
		ERRLOG1(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to destroy scanner_mutex.(code = %d)", st);
	}

	/* autoindex mutex の破棄 */
	st = apr_thread_mutex_destroy(autoindex_mutex);
	if (st != APR_SUCCESS) {
		ERRLOG1(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to destroy autoindex_mutex.(code = %d)", st);
	}

	/* license mutex の破棄 */
	st = apr_thread_mutex_destroy(license_mutex);
	if (st != APR_SUCCESS) {
		ERRLOG1(NULL, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
			"Failed to destroy license_mutex.(code = %d)", st);
	}
}

/**
 * ログマクロが使用する環境を初期化する。
 * (note)
 *	この関数は、r->pool にログ出力に必要な情報(divy_errlog_ctxへのポインタ)をキャッシュします。
 *	この情報はログ関数のエラーレベル分けのために使用されます。
 * (note)
 *	この関数は、request_rec が手に入り、かつVirtual Host の解決が終了している
 *	ステージ以降で、ただ１回だけコールされる必要があります。
 *	複数回コールした場合、予期しない問題が起きる可能性もあります。
 *
 * @param s server_rec * ログ出力に使用されることになるserver_rec 構造体
 */
static void init_log_env(request_rec *r)
{
	/* エラーログコンテキストの生成 */
	(void) divy_logger_create(r);
}

/**
 * 指定されたサーバライセンスキー文字列 ciphertext をパースして、
 * 各種オプションを取り出し、解析結果をsconf に格納して返却する。
 *
 * @param p apr_pool_t *
 * @param ciphertext const char * サーバライセンス
 * @param sconf dav_divy_server_conf * サーバコンフィグ
 * @return 処理ステータス
 *		DIVY_SLICENSE_ST_OK         : 成功
 *		DIVY_SLICENSE_ST_INVALIDFMT : 正しいフォーマットではなかった
 *		DIVY_SLICENSE_ST_INVALIDIP  : IPアドレスが一致しなかった
 */
static int _parse_svrlicensekey(apr_pool_t *p,
				const char *svrlicensekey,
				dav_divy_server_conf *sconf)
{
	char *plaintext;
	char *token, *key, *val;
	char *tok_cntx, *key_cntx;

	/* 
	 * 取得したライセンスキーを復号化＆解析して、値を取り出す
	 */
	plaintext = (char *) dav_divy_decipher_svrlicense(p, svrlicensekey);
	if (plaintext == NULL) {
		/* サーバライセンスキーが正しいフォーマットではない または
		 * 改竄されていた */
		return DIVY_SLICENSE_ST_INVALIDFMT;
	}

	/*
	 * ";" でトークンを分ける
	 */
	while ((token = apr_strtok(plaintext, ";", &tok_cntx)) != NULL) {
		if (token == NULL) break;
		plaintext = NULL;
		/*
		 * "=" でトークンを分ける
		 */
		key = apr_strtok(token, "=", &key_cntx);
		if (IS_EMPTY(key)) return DIVY_SLICENSE_ST_INVALIDFMT;

		val = apr_strtok(NULL, "=", &key_cntx);
		if (IS_EMPTY(val)) return DIVY_SLICENSE_ST_INVALIDFMT;

		if (strcmp(key, DIVY_SLKEY_USERCNT) == 0) {
			if (dav_divy_isdigit_str(val)) {
				sconf->contract_user_cnt = atoi(val);
			}
			else {
				return DIVY_SLICENSE_ST_INVALIDFMT;
			}
		}
		else if (strcmp(key, DIVY_SLKEY_ALLOWCNT) == 0) {
			if (dav_divy_isdigit_str(val)) {
				sconf->allow_user_cnt = atoi(val);
			}
			else {
				return DIVY_SLICENSE_ST_INVALIDFMT;
			}
		}
		else if (strcmp(key, DIVY_SLKEY_FUNCOPT) == 0) {
			apr_uint32_t fopt;

			if (dav_divy_isdigit_str(val)) {
				fopt = atoi(val);
			}
			else {
				return DIVY_SLICENSE_ST_INVALIDFMT;
			}

			sconf->use_mail_opt       = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_MAIL);
			sconf->use_db_opt         = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_DB);
			sconf->use_ldap_opt       = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_LDAP);
			sconf->use_vsc_opt        = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_VSC);
			sconf->use_enccipher_opt  = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_ENCCIPHER);
			sconf->use_autodel_opt    = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_AUTODEL);
			sconf->use_extcmd_opt     = DIVY_SLKEY_OPT(fopt, DIVY_SLKEY_FUNCOPT_EXTCMD);
		}
		else if (strcmp(key, DIVY_SLKEY_NIFNAME) == 0) {
			sconf->nifname = apr_pstrdup(p, val);
		}
		else if (strcmp(key, DIVY_SLKEY_NIP) == 0) {
			sconf->nip = apr_pstrdup(p, val);
		}
		else if (strcmp(key, DIVY_SLKEY_STARTTM) == 0) {
			apr_time_t tmp_time;

			/* ANSI time_t -> apr_time_t */
			(void) apr_time_ansi_put(&tmp_time, (time_t)atol(val));

			/* apr_time_t -> apr_time_exp_t */
			sconf->starttime_exp = apr_pcalloc(p,
							sizeof(apr_time_exp_t));
			(void) apr_time_exp_lt(sconf->starttime_exp, tmp_time);
		}
	}

	/* ノードロックライセンスのチェック */
	if (IS_EMPTY(sconf->nip) || IS_EMPTY(sconf->nifname)) {
		return DIVY_SLICENSE_ST_INVALIDIP;	/* ノード情報がセットされていない */
	}
	else {
		/* nifname に割り当てられたIPアドレスを取得 */
		char *nodeip = divy_get_netifaddr(p, sconf->nifname);

		if (IS_EMPTY(nodeip) || strcmp(nodeip, sconf->nip) != 0) {
			/* IPアドレスがセットされていなかった or IPアドレスが一致しなかった */
			return DIVY_SLICENSE_ST_INVALIDIP;
		}
	}


	return DIVY_SLICENSE_ST_OK;
}

#ifdef TF_USE_USBTOKEN
/**
 * ライセンスデータの取得を要求する.
 *
 */
static int _query_license(request_rec *r)
{
	tfscd_error *err;
	tfs_config conf = { 0 };
	tfscd_access_ticket act;
	int i, ret, len;
	apr_pool_t *p = r->server->process->pool;
	dav_divy_server_conf *sconf = dav_divy_get_server_config(r->server);
	time_t timestamp;
	int flag;
	apr_status_t rv;

	/* USBトークン機能を利用しない場合 */
	if (sconf->useusbtoken != DIVY_USEUSBTOKEN_ON) {
		return 0;
	}

	/* ライセンス取得状況のチェック */
	flag = divy_pcache_get_flag(r->connection->pool, DIVY_PCACHE_FLG_KA_LICENSEKEY);
	if (flag) {
		return 0;
	}

	/* アクセスチケットの生成 */
	memset(act.uid, '\0', sizeof(act.uid));
	memset(act.passwd, '\0', sizeof(act.passwd));
	strcpy(act.uid, DIVY_ACT_USERID);
	strcpy(act.passwd, DIVY_ACT_PASSWD);

	/* タイムスタンプ取得要求 */
	if ((err = tfscd_get_config(&act, TFSCD_DATATYPE_TMSTAMP, &conf)) != NULL) {
		/* ライセンスデータが無くなった */
		if (tfscd_error_getcode(err) == TFSCD_DAT_ERR_NOTFOUND) {
			ERRLOG0(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_DATA, "License expired.");

			if (IS_FILLED(sconf->svrlicensekey)) {
				/* mutex ロックをかけてからNULL、0クリアする */
				if ((rv = apr_thread_mutex_lock(license_mutex)) != APR_SUCCESS) {
					ERRLOG1(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
							"Failed to mutex lock.(code = %d)", rv);
					tfscd_destroy_config(&conf);
					return 1;
				}
				sconf->svrlicensekey = NULL;
				sconf->ltimestamp    = 0L;	/* 0クリアする */

				if ((rv = apr_thread_mutex_unlock(license_mutex)) != APR_SUCCESS) {
					ERRLOG1(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
							"Failed to mutex unlock.(code = %d)", rv);
					/* 続ける */
				}
			}
		}
		else {
			ERRLOG1(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_DATA,
					"Failed to get license data(tm).(%s)", tfscd_error_tomsg(err));
		}
		tfscd_destroy_config(&conf);
		tfscd_error_destroy(err);

		return 1;
	}
	timestamp = conf.timestamp;
	tfscd_destroy_config(&conf);

	/* データが新しければライセンスキーの問い合わせ */
	if (sconf->ltimestamp == 0 || sconf->ltimestamp != timestamp) {
		char *svrlicensekey = NULL, *dblicensekey;

		if ((err = tfscd_get_config(&act, TFSCD_DATATYPE_SLKEY, &conf)) != NULL) {
			ERRLOG1(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_DATA,
					"Failed to get license data.(%s)", tfscd_error_tomsg(err));
			sconf->svrlicensekey = NULL;
			tfscd_destroy_config(&conf);
			tfscd_error_destroy(err);

			return 1;
		}

		/* サーバライセンスキー */
		svrlicensekey = apr_pstrdup(p, (char *)tfscd_varray_get(conf.lckeys, 0));

		if ((rv = apr_thread_mutex_lock(license_mutex)) != APR_SUCCESS) {
			ERRLOG1(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
					"Failed to mutex lock.(code = %d)", rv);
			tfscd_destroy_config(&conf);
			return 1;
		}

		ret = _parse_svrlicensekey(p, svrlicensekey, sconf);
		if (ret == DIVY_SLICENSE_ST_INVALIDFMT) {
			sconf->svrlicensekey = NULL;
			/* サーバライセンスキーが正しいフォーマットではない または
			 * 改竄されていた */
			ERRLOG0(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_DATA,
					"Invalid format key found.");
		}
		else if (ret == DIVY_SLICENSE_ST_INVALIDIP) {
			sconf->svrlicensekey = NULL;
			/* ライセンスされたノード上でTeamFileが動いていない */
			ERRLOG0(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_DATA,
					"This server machine was not licensed node."
					"Please check this machine.");
		}
		else {
				sconf->svrlicensekey = svrlicensekey;
		}

		/* DBライセンスキー */
		sconf->dblicense_h = apr_hash_make(p);
		len = tfscd_varray_getlength(conf.lckeys);
		for (i = 1; i < len; i++) {
			dblicensekey = (char *) tfscd_varray_get(conf.lckeys, i);
			if (divy_db_parse_licensekey(p, dblicensekey, sconf->dblicense_h)) {
				ERRLOG0(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_DATA,
						"Invalid dblicense key format found.");
			}
		}
		sconf->ltimestamp = timestamp;

		tfscd_destroy_config(&conf);

		if ((rv = apr_thread_mutex_unlock(license_mutex)) != APR_SUCCESS) {
			ERRLOG1(r->pool, APLOG_ERR, DIVY_FST_IERR + DIVY_SST_OS,
					"Failed to mutex unlock.(code = %d)", rv);
			/* 続ける */
		}

		/* 取得フラグをセット */
		divy_pcache_set_flag(r->connection->pool, 1, DIVY_PCACHE_FLG_KA_LICENSEKEY);
	}

	return 0;
}
#endif	/* TF_USE_USBTOKEN */

/*
 * コマンドハンドラ関数群の定義
 */
static const char *dav_divy_dbmstype_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->dbmstype = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

/**
 * (2004/08/23 Mon) TfDbDbmsname の取得は廃止されました。
 * 代わりに内部で自動生成されることになっています。ですので、
 * 以下は何もしません。下位互換性、バイナリ互換性の目的で
 * 残してあります。*/
static const char *dav_divy_dbmsname_cmd(cmd_parms *cmd, 
                                        void *config, const char *arg1)
{
#if 0
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->dbmsname = apr_pstrdup(cmd->pool, arg1);
#endif
	return NULL;
}

static const char *dav_divy_hostname_cmd(cmd_parms *cmd, 
                                        void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->hostname = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_hostport_cmd(cmd_parms *cmd, 
                                        void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	conf->hostport = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_dbname_cmd(cmd_parms *cmd, 
                                        void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->dbname = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_username_cmd(cmd_parms *cmd, 
                                        void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->username = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_password_cmd(cmd_parms *cmd, 
                                        void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->password = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_dbpool_cmd(cmd_parms *cmd, void *config,
                                         const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (strcasecmp(arg1, "Off") == 0) {
		conf->dbpool = DIVY_DBPOOL_OFF;	/* DB コネクションプールを利用しない */
	}
	else if (strcasecmp(arg1, "On") == 0) {
		conf->dbpool = DIVY_DBPOOL_ON;	/* DB コネクションプールを利用する */
	}
	else if (strcasecmp(arg1, "without-thread") == 0) {
		/* DB コネクションプールは利用するがスレッドは使わない */
		conf->dbpool = DIVY_DBPOOL_NOTHREAD;
	}
	else {
		/* エラー終了 */
		return "The value of \"TfDbPool\" directive is invalid."
			"Please set \"on\" or \"off\" or \"without-thread\"";
	}

	return NULL;
}


/*
 * (2004/08/23 Mon) TfDbVhostShare は廃止されました。
 * 下位互換性、バイナリ互換性維持の目的で残しておきますが利用されてはいません。
 * また今後も利用してはなりません。*/
static const char *dav_divy_dbvhostshare_cmd(cmd_parms *cmd, void *config,
						int arg1)
{
#if 0
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->dbvhostshare = DIVY_VHOSTSHARE_ON;
	}
	else {
		conf->dbvhostshare = DIVY_VHOSTSHARE_OFF;
	}
#endif

	return NULL;
}

static const char *dav_divy_dbrefreshinterval_cmd(cmd_parms *cmd, void *config,
	                                         const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, 
					&dav_tf_module);

	/* グローバル指定されていること */
	const char *err = ap_check_cmd_context(cmd, GLOBAL_ONLY);
	if (err != NULL) {
		return err;
	}

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfDbRefreshInterval\" must be a positive digit";
	}

	conf->dbrefreshinterval = atoi(arg1);
	return NULL;
}

static const char *dav_divy_dbminspareconn_cmd(cmd_parms *cmd, void *config,
	                                         const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *) config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfDbMinSpareConn\" must be a positive digit";
	}

	conf->dbminspareconn = (apr_int32_t) atoi(arg1);
	if (conf->dbmaxspareconn > 0 && conf->dbminspareconn > conf->dbmaxspareconn) {
		return "The value of \"TfDbMinSpareConn\" must be smaller than "
			"the value of \"TfDbMaxSpareConn\".";
	}
	return NULL;
}

static const char *dav_divy_dbmaxspareconn_cmd(cmd_parms *cmd, void *config,
						const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *) config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfDbMaxSpareConn\" must be a positive digit";
	}

	conf->dbmaxspareconn = (apr_int32_t) atoi(arg1);
	if (conf->dbminspareconn > 0 && conf->dbminspareconn > conf->dbmaxspareconn) {
		return "The value of \"TfDbMaxSpareConn\" must be greater than "
			"the value of \"TfDbMinSpareConn\".";
	}

	return NULL;
}

static const char *dav_divy_fsrootpath_cmd(cmd_parms *cmd, 
                                           void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1 == NULL || *arg1 == '\0') {
		return "The value of \"TfFsRootPath\" directive is missing.";
	}

	conf->fsrootpath = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}


static const char *dav_divy_maxresource_per_dir_cmd(cmd_parms *cmd, 
							void *config, 
							const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *) config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfMaxResourcePerDir\" must be a positive digit";
	}

	conf->maxresource_per_dir = (apr_int32_t) atoi(arg1);
	return NULL;
}

static const char *dav_divy_serverlicensekey_cmd(cmd_parms *cmd, 
                                                 void *config, const char *arg1)
{
	int ret;
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, 
					&dav_tf_module);

	if (arg1 == NULL || *arg1 == '\0') {
		/* ライセンスキーがなければApacheを起動させない */
		return "The \"TfServerLicenseKey\" config is missing."
			"Please check it.";
	}

	/* ライセンスキーの取得 */
	conf->svrlicensekey = apr_pstrdup(cmd->pool, arg1);

	/* ライセンスキーをパースして、conf にその結果を入れておく */
	ret = _parse_svrlicensekey(cmd->pool, conf->svrlicensekey, conf);
	if (ret == DIVY_SLICENSE_ST_INVALIDFMT) {
		/* サーバライセンスキーが正しいフォーマットではない または
		 * 改竄されていた */
		return "The \"TfServerLicenseKey\" config has "
			"invalid format key. Please check it.";
	}
	else if (ret == DIVY_SLICENSE_ST_INVALIDIP) {
		/* ライセンスされたノード上でTeamFileが動いていない */
		return "This server machine was not licensed node."
		       "Please check this machine.";
	}

	return NULL; 
}

static const char *dav_divy_dblicensekey_cmd(cmd_parms *cmd, 
                                                 void *config, const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);

	if (arg1 == NULL || *arg1 == '\0') {
		return "The \"TfDbLicenseKey\" config is missing."
			"Please check it.";
	}

	if (conf->dblicense_h == NULL) {
		conf->dblicense_h = apr_hash_make(cmd->pool);
	}

	/* DBライセンスキーをパースして、conf にその結果を入れておく */
	if (divy_db_parse_licensekey(cmd->pool, arg1, conf->dblicense_h)) {
		/* 正しいフォーマットではない または改竄されていた */
		return "The \"TfDbLicenseKey\" config has invalid format key."
			"Please check it.";
	}

	return NULL; 
}

static const char *dav_divy_auth_cmd(cmd_parms *cmd,
					 void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* divyauthを利用するか確認する */
	if (strcasecmp(arg1, "ON") == 0) {
		conf->auth_on = DIVY_AUTH_ON;
		return NULL;
	}
	else {
		/*
		 * TeamFile の認証機構を利用しない (2005/02/08)
		 * (note)
		 *   他の認証機構では、結果的にTeamFileにログインすることは
		 *   難しいので排除してしまいました。
		 */
		conf->auth_on = DIVY_AUTH_OFF;
		return NULL;
	}

	return NULL;
}

static const char *dav_divy_auth_login_ignore_inspection_ipaddrs_cmd(
								cmd_parms *cmd, void *config, const char *l)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	apr_status_t rv;
	apr_ipsubnet_t *ipsub;
	char *s;

	conf->authignoreipaddrs = NULL;

	while (l[0]) {
		char *w = ap_getword_white(cmd->pool, &l);

		if (IS_FILLED(w)) {
			s = divy_strchr(w, '/');
			if (s != NULL) {
				*s++ = '\0';
			}
			ipsub = NULL;
			rv = apr_ipsubnet_create(&ipsub, w, s, cmd->pool);
			if (rv == APR_SUCCESS && ipsub != NULL) {
				if (conf->authignoreipaddrs == NULL) {
					conf->authignoreipaddrs= divy_array_make(cmd->pool, 5);
				}
				divy_array_add(conf->authignoreipaddrs, ipsub);
			}
		}
	}

	return NULL;
}

static const char *dav_divy_mail_cmd(cmd_parms *cmd,
					     void *config, const char *arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, 
					&dav_tf_module);
	dav_divy_dir_conf *dconf = (dav_divy_dir_conf *)config;

	if (strcasecmp(arg1, "On") == 0) {
		dconf->mail = "default";
	}
	else if (strcasecmp(arg1, "Off") == 0) {
		dconf->mail = DIVY_ML_OFF;	/* 何もしてはならないことを示す */
	}
	else {
		dconf->mail = apr_pstrdup(cmd->pool, arg1);
	}

	/*
	 * メールプロバイダはOffではないのに、メールのライセンスが
	 * 認められていない場合はエラーを出力するがエラーにはしない
	 */
	if (strcasecmp(dconf->mail, "Off") != 0 &&
		IS_FILLED(sconf->svrlicensekey) && sconf->use_mail_opt == 0) {
		ERRLOG0(NULL, APLOG_WARNING, DIVY_FST_CERR + DIVY_SST_DATA,
			"The license of mail cannot be recognized. "
			"The function of mail was disabled.");
	}

	return NULL;
}

static const char *dav_divy_mailhost_cmd(cmd_parms *cmd,
					     void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->mailhost = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_mailport_cmd(cmd_parms *cmd,
					     void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfMlHostport\" must be a positive digit";
	}
	conf->mailport = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_mailadminaddr_cmd(cmd_parms *cmd,
                                             void *config, const char *arg1)
{
        dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

        conf->mailadminaddr = apr_pstrdup(cmd->pool, arg1);
        return NULL;
}

static const char *dav_divy_mlusername_cmd(cmd_parms *cmd,
                                           void *config, const char *arg1)
{
        dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
        conf->mlusername = apr_pstrdup(cmd->pool, arg1);
        return NULL;
}

static const char *dav_divy_mlpassword_cmd(cmd_parms *cmd,
                                           void *config, const char *arg1)
{
        dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
        conf->mlpassword = apr_pstrdup(cmd->pool, arg1);
        return NULL;
}

static const char *dav_divy_mailencoding_cmd(cmd_parms *cmd,
					    void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->mailencoding = apr_pstrdup(cmd->pool, arg1);

	if (strcasecmp(conf->mailencoding, ML_CHARSET_UTF8) == 0) 
		conf->mailencoding = ML_CHARSET_UTF_8;

	return NULL;
}

static const char *dav_divy_mlserversend_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_FILLED(arg1) && strcasecmp(arg1, "on") == 0) {
		conf->mlserversend = DIVY_MLSERVERSEND_ON;
	}
	else if (IS_FILLED(arg1) && strcasecmp(arg1, "middle") == 0) {
		conf->mlserversend = DIVY_MLSERVERSEND_MIDDLE;
	}
	else {
		conf->mlserversend = DIVY_MLSERVERSEND_OFF;
	}

	return NULL;
}

static const char *dav_divy_mltemplateroot_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1 == NULL || *arg1 == '\0') {
		return "The value of \"TfMlTemplateRoot\" directive is missing.";
	}

	conf->mltemplateroot = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_mlnotifyact_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->mlnotifyact = DIVY_MLNOTIFYACTD_ON;
	}
	else {
		conf->mlnotifyact = DIVY_MLNOTIFYACT_OFF;
	}

	return NULL;
}

static const char *dav_divy_mloneclickurl_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->mloneclickurl = DIVY_MLONECLICKURL_ON;
	}
	else {
		conf->mloneclickurl = DIVY_MLONECLICKURL_OFF;
	}

	return NULL;

}

static const char *dav_divy_mledit_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->mledit = DIVY_MLEDITL_ON;
	}
	else {
		conf->mledit = DIVY_MLEDIT_OFF;
	}

	return NULL;
}

static const char *dav_divy_mlrepfromaddr_cmd(cmd_parms *cmd,
					void *config, const char *arg1, const char* arg2)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1 == NULL || *arg1 == '\0') {
		return "The value of \"TfRepFromAddr\" directive is missing.";
	}

	conf->mlrepfromaddr = apr_pstrdup(cmd->pool, arg1);

	if (IS_FILLED(arg2)) {
		conf->mlrepfromname = apr_pstrdup(cmd->pool, arg2);
	}

	return NULL;

}

static const char *dav_divy_mlsendinterval_cmd(cmd_parms *cmd,
					void *config, const char* arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfMlSendInterval\" must be a positive digit";
	}

	if (arg1) {
		conf->mlsendinterval = apr_atoi64(arg1);
	}
	else {
		conf->mlsendinterval = 0;
	}

	return NULL;
}

/**
 * (2004/08/26 Thu) TfDefaultMaxQuotaSize の取得は廃止されました。
 * 下位互換性、バイナリ互換性維持の目的で残しておきますが利用されてはいません。
 * また今後も利用してはなりません。*/
static const char *dav_divy_defaultmaxquotasize_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
#if 0
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfDefaultMaxQuotaSize\" must be a positive digit";
	}
	conf->defaultmaxquotasize = apr_atoi64(arg1);
#endif

	return NULL;
}

/**
 * (2004/08/26 Thu) TfDefaultMaxQuotaRes の取得は廃止されました。
 * 下位互換性、バイナリ互換性維持の目的で残しておきますが利用されてはいません。
 * また今後も利用してはなりません。*/
static const char *dav_divy_defaultmaxquotares_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
#if 0
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfDefaultMaxQuotaRes\" must be a positive digit";
	}

	conf->defaultmaxquotares = apr_atoi64(arg1);
#endif

	return NULL;
}


static const char *dav_divy_maxfilesize_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfMaxFilesize\" must be a positive digit";
	}
	conf->maxfilesize = apr_atoi64(arg1);

	return NULL;
}

static const char *dav_divy_showgroup_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->show_group = DIVY_SHOWGROUP_ON;
	}
	else {
		conf->show_group = DIVY_SHOWGROUP_OFF;
	}

	return NULL;
}

static const char* dav_divy_ldap_shmcachebyte_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{

	dav_divy_server_conf *conf =
	       	ap_get_module_config(cmd->server->module_config,
			       				&dav_tf_module);
	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"Tfldapcachebyte\" must be a positive digit";
	}

	conf->ldapcachebyte = atoi(arg1);

	return NULL;
}

static const char *dav_divy_ldap_shmpath_cmd(cmd_parms *cmd,
					void *config, const char* arg1)
{

	dav_divy_server_conf *conf =
	       	ap_get_module_config(cmd->server->module_config,
			       				&dav_tf_module);

	if (arg1 == NULL || *arg1 == '\0') {
		return "The value of \"TfLDAPShmPath\" directive is missing.";
	}

	conf->ldapshmpath = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_search_cache_ttl_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{

	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config,
							&dav_tf_module);
	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfLDAPCacheTTL\" most be a positive digit";
	}

	conf->ldapsearch_cache_ttl = atol(arg1);

	return NULL;
}

static const char *dav_divy_ldap_max_mem_blocks_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config,
							&dav_tf_module);
	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfLDAPMaxMemBlocks\" most be a positive digit";
	}

	conf->ldap_maxmemBlocks = atol(arg1);

	return NULL;
}

static const char *dav_divy_ldap_markpercentage(cmd_parms *cmd,
					void *config, const char *arg1)
{
	double percentage = 0.0;

	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config,
							&dav_tf_module);
	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfLDAPMarkPercentage\" most be a positive digit";
	}
	percentage = atol(arg1);
	if (percentage < 0.0 || percentage > 100.0) {
		return "Please specify or more 0 less than 100 value.";
	}
	
	conf->ldapMarkPercentage = atol(arg1);

	return NULL;
}
					
static const char *dav_divy_ldap_purgepercentage(cmd_parms *cmd,
					void *config, const char *arg1)
{
	double percentage = 0.0;

	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config,
							&dav_tf_module);
	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfLDAPPurePercentage\" most be a positive digit";
	}
	percentage = atol(arg1);
	if (percentage < 0.0 || percentage > 100.0) {
		return "Please specify or more 0 less than 100 value.";
	}
	
	conf->ldapPurgePercentage = atol(arg1);

	return NULL;
}

static const char *dav_divy_ldap_cert_auth_file_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, 
					&dav_tf_module);
	conf->ldapcert_auth_file = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_cert_file_type_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	/* (note) ここは固定値なので入れない */
	return NULL;
}

static const char *dav_divy_ldap_ssl_support_cmd(cmd_parms *cmd,
					void *config, int arg1)
{

	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapsslsupport = arg1;

	return NULL;
}

static const char *dav_divy_use_ldap_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->ldap = TF_LDAP_ON;
	}
	else {
		conf->ldap = TF_LDAP_OFF;
	}

	/*
	 * LDAP 機能が有効にされているのだが、LDAPライセンスが無い時には
	 * 警告文を出力しておく
	 */
	if (conf->ldap == TF_LDAP_ON &&
		IS_FILLED(sconf->svrlicensekey) && sconf->use_ldap_opt == 0) {
		ERRLOG0(NULL, APLOG_WARNING, DIVY_FST_CERR + DIVY_SST_DATA,
			"The license of LDAP cannot be recognized. "
			"The function of LDAP was disabled.");
	}

	return NULL;
}

static const char *dav_divy_ldap_basedn_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapbasedn = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_binddn_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapbinddn = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_bindpw_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapbindpw = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (IS_EMPTY(arg1)) {
		return "Please specify the attribute to search.";
	}

	conf->ldapattr = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_filter_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapfilter = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_scope_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	int scope = 0;
	if (strcasecmp(arg1, "sub") == 0) {
		scope = TF_LDAP_SCOPE_SUBTREE;
	}
	else if (strcasecmp(arg1, "base") == 0) {
		scope = TF_LDAP_SCOPE_BASE;
	}
       	else if (strcasecmp(arg1, "one") == 0) {
		scope =TF_LDAP_SCOPE_ONELEVEL;
	}
	else {
		return "LDAP Scope set error.";
	}

	conf->ldapscope = scope;

	return NULL;
}
static const char *dav_divy_ldap_host_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldaphost = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_port_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfLDAPHostport\" must be a positive digit";
	}

	conf->ldapport = atoi(arg1);

	return NULL;
}
static const char *dav_divy_ldap_url_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapurl = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_map_user_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapmapuserattr = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_map_passwd_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapmappasswordattr = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_ldap_map_fullname_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapmapfullnameattr = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
static const char *dav_divy_ldap_map_mailaddr_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapmapmailaddrattr = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
static const char *dav_divy_ldap_map_comment_attr_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapmapcommentattr = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
static const char *dav_divy_ldap_found_create_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapfoundcreate = arg1;

	return NULL;
}

static const char *dav_divy_ldap_sync_property_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->ldapsyncproperty  = arg1;

	return NULL;
}

static const char *dav_divy_ldap_allow_user_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{

	char *userid = NULL;
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	userid = apr_pstrdup(cmd->pool, arg1);

	if (conf->ldapallowuser == NULL) {
		conf->ldapallowuser = divy_array_make(cmd->pool, 3);
	}
	divy_array_add(conf->ldapallowuser, userid);

	return NULL;
}

static const char *dav_divy_ldap_allow_user_regex_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	ap_regex_t *preg;

	preg = ap_pregcomp(cmd->pool, arg1, (AP_REG_EXTENDED | AP_REG_NOSUB));
	if (preg == NULL) {
		return apr_psprintf(cmd->pool, "\"TfLDAPAllowUserRegEx\" value has invalid regular expression. Please check it. (expression: \"%s\")", conf->ldapallowuserregex);

	}

	conf->ldapallowuserregex = apr_pstrdup(cmd->pool, arg1);

	ap_pregfree(cmd->pool, preg);

	return NULL;
}

static const char *dav_divy_ldap_user_options(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	char *w, *key, *val, *ctx;

	/* [書式]
	 * NotUserFolder NotDBFolder MaxQuota=***MB UserNotFoundAction=delete|disable
	 */
	if (strcasecmp(arg1, "NotUserFolder") == 0) {
		/* NotUserFolder */
		conf->ldapuseroptions |= DIVY_LDAP_OPT_NOTUSERFOLDER;
	} else if (strcasecmp(arg1, "NotGroupFolder") == 0) {
		/* NotGroupFolder */
		conf->ldapuseroptions |= DIVY_LDAP_OPT_NOTGROUPFOLDER;
	} else if (strcasecmp(arg1, "NotDBFolder") == 0) {
		/* NotDBFolder */
		conf->ldapuseroptions |= DIVY_LDAP_OPT_NOTDBFOLDER;
	} else if (strcasecmp(arg1, "NotReposDBFolder") == 0) {
		/* NotReposDBFolder */
		conf->ldapuseroptions |= DIVY_LDAP_OPT_NOTREPOSDBFOLDER;
	} else if (strncasecmp(arg1, "MaxQuota=", 9) == 0) {
		/* MaxQuota=***MB */
		w = apr_pstrdup(cmd->pool, arg1);
		key = apr_strtok(w, "=", &ctx);
		if (IS_EMPTY(key))
			return "The value of \"TfLDAPUserOptions\" param MaxQuota is missing. for example MaxQuota=1073741824 (1GB) ";
		val = apr_strtok(NULL, "=", &ctx);
		if (IS_EMPTY(val))
			return "The value of \"TfLDAPUserOptions\" param MaxQuota is missing. for example MaxQuota=1073741824 (1GB)";
		if (!dav_divy_isdigit_str(val)) 
			return "The value of \"TfLDAPUserOptions\" param MaxQuota is missing. for example MaxQuota=1073741824 (1GB)";

		conf->ldapmaxresquota = apr_atoi64(val);

	} else if (strncasecmp(arg1, "UserNotFoundAction" ,18 ) == 0) {
		w = apr_pstrdup(cmd->pool, arg1);
		/* UserNotFoundAction=delete|disable */
		key = apr_strtok(w, "=", &ctx);
		if (IS_EMPTY(key)) return "The value of \"TfLDAPUserOptions\" directive is missing.";
		val = apr_strtok(NULL, "=", &ctx);
		if (IS_EMPTY(val)) return "The value of \"TfLDAPUserOptions\" directive is missing.";
		if (strcasecmp(val, "delete") == 0) {
			conf->ldapusernotfoundaction = DIVY_LDAP_NOTFOUNDUSERACTION_DELETE;
		} else if (strcasecmp(val, "disable") == 0) {
			conf->ldapusernotfoundaction = DIVY_LDAP_NOTFOUNDUSERACTION_DISABLE;
		} else {
			return "The value of \"TfLDAPUserOptions\" directive is missing. (UserNotFoundAction=delete | disable)";
		}
	} else {
		/* 知らない項目が列挙されていた */
		return "The value of \"TfLDAPUserOptions\" directive is missing.";
	}

	return NULL;
}

static const char *dav_divy_autoindex_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->autoindex = DIVY_AUTOINDEX_ON;
	}
	else {
		conf->autoindex = DIVY_AUTOINDEX_OFF;
	}

	return NULL;
}

static const char *dav_divy_stylesheetroot_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1 == NULL || *arg1 == '\0') {
		return "The value of \"TfStyleSheetRoot\" directive is missing.";
	}

	conf->stylesheetroot = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_syncgroupuri_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_FILLED(arg1) && strcasecmp(arg1, "on") == 0) {
		conf->syncgrpuri = DIVY_SYNCGRPURI_ON;
	}
	else if (IS_FILLED(arg1) && strcasecmp(arg1, "middle") == 0) {
		conf->syncgrpuri = DIVY_SYNCGRPURI_MIDDLE;
	}
	else {
		conf->syncgrpuri = DIVY_SYNCGRPURI_OFF;
	}

	return NULL;
}

static const char *dav_divy_maxuser_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1 == NULL || *arg1 == '\0') {
		return "The value of \"TfMaxUser\" directive is missing.";
	}

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfMaxUser\" must be digit";
	}

	conf->maxuser = (apr_int32_t) atoi(arg1);
	return NULL;
}

static const char *dav_divy_emcrypt_password(cmd_parms *cmd,
					     void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->encryptpassword = DIVY_ENCRYPTPASSWORD_ON;
	}
	else {
		conf->encryptpassword = DIVY_ENCRYPTPASSWORD_OFF;
	}

	return NULL;
}

static const char *dav_divy_vscan_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_EMPTY(arg1) || strcasecmp(arg1, "off") == 0) {
		conf->vscan = DIVY_VSC_OFF;	/* ウィルス検索機能off */
	}
	/* "on" は恐らく間違いであろう。NGにする */
	else if (strcasecmp(arg1, "on") == 0) {
		return "The value of \"TfVscan\" must be \"off\" or "
			"the name of anti-virus provider.";
	}
	else {
		conf->vscan = apr_pstrdup(cmd->pool, arg1);
	}

	return NULL;
}

static const char *dav_divy_vscstreammethod_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->streammethod = DIVY_STREAMMETHOD_ON;
	}
	else {
		conf->streammethod = DIVY_STREAMMETHOD_OFF;
	}

	return NULL;
}

static const char *dav_divy_vschostname_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->vschostname = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_vschostport_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	/* arg1 が数値かどうかをチェック */
	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfVscHostport\" must be digit.";
	}

	conf->vschostport = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_vsccmd_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->vsccmd = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_trashfolder_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->trashfolder = DIVY_TRASHFOLDER_ON;
	}
	else {
		conf->trashfolder = DIVY_TRASHFOLDER_OFF;
	}

	return NULL;

}

static const char *dav_divy_brandname_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);
	conf->brandname = apr_pstrdup(cmd->pool, arg1);
	return NULL; 
}

static const char *dav_divy_tfversion_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);

	if (arg1) {
		conf->tfversion = apr_pstrdup(cmd->pool, arg1);
	}
	else {
		conf->tfversion = apr_pstrdup(cmd->pool, DIVY_VERSION);
	}

	return NULL;
}

static const char *dav_divy_extenduserst_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->extenduserst = DIVY_EXTENDUSERST_ON;
	}
	else {
		conf->extenduserst = DIVY_EXTENDUSERST_OFF;
	}

	return NULL;
}

static const char *dav_divy_notifyservename_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->notifyservername = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_useusbktoken_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);

	if (arg1) {
		sconf->useusbtoken = DIVY_USEUSBTOKEN_ON;
	}
	else {
		sconf->useusbtoken = DIVY_USEUSBTOKEN_OFF;
	}

	return NULL;
}

#ifdef DIVY_SUPPORT_PRINTER
static const char *dav_divy_netprint_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->netprint = DIVY_NETPRINT_ON;
	}
	else {
		conf->netprint = DIVY_NETPRINT_OFF;
	}

	return NULL;
}
#endif	/* DIVY_SUPPORT_PRINTER */

#ifdef DIVY_SUPPORT_PRINTER
static const char *dav_divy_prprintgroupname_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->printergroupname = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
#endif	/* DIVY_SUPPORT_PRINTER */

#ifdef DIVY_SUPPORT_PRINTER
static const char *dav_divy_prname_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->printername = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
#endif	/* DIVY_SUPPORT_PRINTER */

#ifdef DIVY_SUPPORT_PREFLIGHT_PLUGIN
static const char *dav_divy_plrootpath_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->plrootpath = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
#endif	/* DIVY_SUPPORT_PREFLIGHT_PLUGIN */

#ifdef DIVY_SUPPORT_PREFLIGHT_PLUGIN
static const char *dav_divy_plgroupset_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{

	dav_divy_dir_conf *conf;

	if (IS_FILLED(arg1)) {
		conf = (dav_divy_dir_conf *)config;
		if (conf->plgroupset == NULL) {
			conf->plgroupset = divy_cset_make(cmd->pool);
		}
		divy_cset_set(conf->plgroupset, apr_pstrdup(cmd->pool, arg1));
	}
	return NULL;
}
#endif	/* DIVY_SUPPORT_PREFLIGHT_PLUGIN */

static const char *dav_divy_thumbnail_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->thumbnail = DIVY_THUMBNAIL_ON;
	}
	else {
		conf->thumbnail = DIVY_THUMBNAIL_OFF;
	}

	return NULL;
}

#ifdef DAV_SUPPORT_POST_HANDLING
static const char *dav_divy_syscgiroot_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);

	/* グローバル指定されていること */
	const char *err = ap_check_cmd_context(cmd, GLOBAL_ONLY);
	if (err != NULL) {
		return err;
	}
	sconf->syscgirootpath = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}
#endif	/* DAV_SUPPORT_POST_HANDLING */

#ifdef DIVY_SUPPORT_PLUGIN
static const char *dav_divy_pluginroot_cmd(cmd_parms *cmd, void *config,
	                                       const char *arg1)
{
	dav_divy_server_conf *conf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);

	/* グローバル指定されていること */
	const char *err = ap_check_cmd_context(cmd, GLOBAL_ONLY);
	if (err != NULL) {
		return err;
	}

	conf->pluginroot = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}
#endif	/* DIVY_SUPPORT_PLUGIN */

#ifdef DIVY_SUPPORT_PASSPOLICY
static const char *dav_divy_passpolicty_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->passpolicy = DIVY_PASSPOLICY_ON;
	}
	else {
		conf->passpolicy = DIVY_PASSPOLICY_OFF;
	}

	return NULL;
}
#endif	/* DIVY_SUPPORT_PASSPOLICY */

#ifdef DIVY_SUPPORT_PASSPOLICY
static const char *dav_divy_passpolicyoptions_cmd(cmd_parms *cmd,
					void *config, const char *l)
{
	char action;
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	conf->passpolicy_opt = DIVY_PASSPOLICY_OPT_UNSET;

	while (l[0]) {
		char *w = ap_getword_conf(cmd->pool, &l);
		action = '\0';

		if (*w == '+') {
			action = *(w++);
		}

		if (strcasecmp(w, "Base") == 0) {
			conf->passpolicy_opt |= DIVY_PASSPOLICY_OPT_BASE;
		}
		else {
			/* 拡張性を考慮して無視する */
			continue;
		}
	}

	return NULL;
}
#endif	/* DIVY_SUPPORT_PASSPOLICY */

#ifdef DIVY_SUPPORT_LOGACCESS
static const char *dav_divy_logaccess_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_FILLED(arg1) && strcasecmp(arg1, "on") == 0) {
		conf->logaccess = DIVY_LOGACCESS_ON;
	}
	else if (IS_FILLED(arg1) && strcasecmp(arg1, "on-all") == 0) {
		conf->logaccess = DIVY_LOGACCESS_ONALL;
	}
	else {
		conf->logaccess = DIVY_LOGACCESS_OFF;
	}

	return NULL;
}
#endif	/* DIVY_SUPPORT_LOGACCESS */

static const char *dav_divy_defaultresponselanguage_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);
	sconf->default_lang = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_supportedlanguages_cmd(cmd_parms *cmd, void *config,
	                                       const char *arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);

	if (sconf->supported_languages == NULL) {
		sconf->supported_languages = divy_cset_make(cmd->pool);
	}
	divy_cset_set(sconf->supported_languages, apr_pstrdup(cmd->pool, arg1));

	return NULL;
}

static const char *dav_divy_forcelanguage_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_server_conf *sconf =
		ap_get_module_config(cmd->server->module_config, &dav_tf_module);
	sconf->force_lang = apr_pstrdup(cmd->pool, arg1);

	return NULL;
}

static const char *dav_divy_autodelete_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->autodelete = DIVY_AUTODELETE_ON;
	}
	else {
		conf->autodelete = DIVY_AUTODELETE_OFF;
	}

	return NULL;
}

static const char *dav_divy_autodeleteallowip(cmd_parms *cmd,
					void *config, const char *l)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	apr_status_t rv;
	apr_ipsubnet_t *ipsub;
	char *s;

	conf->autodel_allowipaddrs = NULL;

	while (l[0]) {
		char *w = ap_getword_conf(cmd->pool, &l);

		if (IS_FILLED(w)) {
			s = divy_strchr(w, '/');
			if (s != NULL) {
				*s++ = '\0';
			}
			ipsub = NULL;
			rv = apr_ipsubnet_create(&ipsub, w, s, cmd->pool);
			if (rv == APR_SUCCESS && ipsub != NULL) {
				if (conf->autodel_allowipaddrs == NULL) {
					conf->autodel_allowipaddrs = divy_array_make(cmd->pool, 5);
				}
				divy_array_add(conf->autodel_allowipaddrs, ipsub);
			}
		}
	}

	return NULL;
}

static const char *dav_divy_chunkput_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->chunkput = DIVY_CHUNKPUT_ON;
	}
	else {
		conf->chunkput = DIVY_CHUNKPUT_OFF;
	}

	return NULL;
}

static const char *dav_divy_execengine_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->execengine = DIVY_EXECENGINE_ON;
	}
	else {
		conf->execengine = DIVY_EXECENGINE_OFF;
	}

	return NULL;
}

static const char *dav_divy_execoncmd_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->execoncmd = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_execmatch_cmd(cmd_parms *cmd,
					void *config, const char* arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->execmatch = apr_pstrdup(cmd->pool, arg1);

	if (IS_FILLED(conf->execmatch)) {
		ap_regex_t *preg;

		preg = ap_pregcomp(cmd->pool, conf->execmatch, (AP_REG_EXTENDED | AP_REG_NOSUB));
 		if (preg == NULL) {
			return apr_psprintf(cmd->pool, "\"TfExecMatch\" value has invalid regular expression. Please check it. (expression: \"%s\")", conf->execmatch);
		}

		ap_pregfree(cmd->pool, preg);
	}

	return NULL;	
}

static const char *dav_divy_rproxyuse_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->rproxyuse = DIVY_RPROXYUSE_ON;
	}
	else {
		conf->rproxyuse = DIVY_RPROXYUSE_OFF;
	}

	return NULL;
}

static const char *dav_divy_forcedelete_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->forcedelete = DIVY_FORCEDELETE_ON;
	}
	else {
		conf->forcedelete = DIVY_FORCEDELETE_OFF;
	}

	return NULL;
}

static const char *dav_divy_rproxymatch_cmd(cmd_parms *cmd,
					void *config, const char *l)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->rproxymatch = apr_pstrdup(cmd->pool, l);

	/* 正しい正規表現かどうか検証してみる */
	if (IS_FILLED(conf->rproxymatch)) {
		ap_regex_t *preg;

		preg = ap_pregcomp(cmd->pool, conf->rproxymatch, (AP_REG_EXTENDED | AP_REG_NOSUB));
		if (preg == NULL) {
			return apr_psprintf(cmd->pool, "\"TfRProxyMatch\" value has invalid regular expression. "
					"Please check it. (expression: \"%s\")", conf->rproxymatch);
		}
		ap_pregfree(cmd->pool, preg);
	}

	return NULL;
}

static const char *dav_divy_rproxyschema_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (IS_FILLED(arg1)) {
		if (strcasecmp(arg1, "auto") == 0) {
			conf->rproxyschema = DIVY_RPROXY_SCHEMA_AUTO;
		}
		else if (strcasecmp(arg1, "http") == 0) {
			conf->rproxyschema = DIVY_RPROXY_SCHEMA_HTTP;
		}
		else if (strcasecmp(arg1, "https") == 0) {
			conf->rproxyschema = DIVY_RPROXY_SCHEMA_HTTPS;
		}
		else {
			return "The value of \"TfRProxySchema\" is invalid. "
					"Please set \"http\" or \"https\", \"auto\"";
		}
	}
	else {
		conf->rproxyschema = DIVY_RPROXY_SCHEMA_AUTO;
	}

	return NULL;
}

static const char *dav_divy_rproxyhttpport_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (IS_FILLED(arg1) && dav_divy_isdigit_str(arg1)) {
		conf->rproxyhttpport = atoi(arg1);
	}
	else {
		conf->rproxyhttpport = DIVY_RPROXY_HTTPPORT_DEFAULT;
	}
	return NULL;
}

static const char *dav_divy_rproxyhttpsport_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (IS_FILLED(arg1) && dav_divy_isdigit_str(arg1)) {
		conf->rproxyhttpsport = atoi(arg1);
	}
	else {
		conf->rproxyhttpsport = DIVY_RPROXY_HTTPSPORT_DEFAULT;
	}
	return NULL;
}

static const char *dav_divy_syscgiconnectport_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_FILLED(arg1)) {
		if (strcasecmp(arg1, "auto") == 0) {
			conf->syscgiconnectport = DIVY_SYSCGI_CONNECT_PORT_AUTO;
		}
		else if (dav_divy_isdigit_str(arg1)) {
			conf->syscgiconnectport = atoi(arg1);
		}
		else {
			return "The value of \"TfSysCgiConnectPort\" is invalid. "
					"Please set \"(digit)\" or \"auto\"";
		}
	}
	else {
		conf->syscgiconnectport = DIVY_SYSCGI_CONNECT_PORT_AUTO;	/* デフォルトはauto */
	}
	return NULL;
}

static const char *dav_divy_syscgiconnectschema_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_FILLED(arg1)) {
		if (strcasecmp(arg1, "auto") == 0) {
			conf->syscgiconnectschema = DIVY_SYSCGI_CONNECT_SCHEMA_AUTO;
		}
		else if (strcasecmp(arg1, "http") == 0) {
			conf->syscgiconnectschema = DIVY_SYSCGI_CONNECT_SCHEMA_HTTP;
		}
		else if (strcasecmp(arg1, "https") == 0) {
			conf->syscgiconnectschema = DIVY_SYSCGI_CONNECT_SCHEMA_HTTPS;
		}
		else {
			return "The value of \"TfSysCgiConnectSchema\" is invalid. "
					"Please set \"http\" or \"https\", \"auto\"";
		}
	}
	else {
		conf->syscgiconnectschema = DIVY_SYSCGI_CONNECT_SCHEMA_AUTO;
	}
	return NULL;
}

static const char *dav_divy_notifyserverport_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (IS_FILLED(arg1)) {
		if (strcasecmp(arg1, "auto") == 0) {
			conf->notifyserverport = DIVY_NOTIFYSERVER_PORT_AUTO;	/* 自動認識 */
		}
		else if (dav_divy_isdigit_str(arg1)) {
			conf->notifyserverport = atoi(arg1);
		}
		else {
			return "The value of \"TfNotifyServerPort\" is invalid. "
					"Please set \"(digit)\" or \"auto\"";
		}
	}
	else {
		conf->notifyserverport = DIVY_NOTIFYSERVER_PORT_AUTO;	/* 自動認識 */
	}

	return NULL;
}

static const char *dav_divy_notifyserverschema_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (IS_FILLED(arg1)) {
		if (strcasecmp(arg1, "auto") == 0) {
			conf->notifyserverschema = DIVY_NOTIFYSERVER_SCHEMA_AUTO;
		}
		else if (strcasecmp(arg1, "http") == 0) {
			conf->notifyserverschema = DIVY_NOTIFYSERVER_SCHEMA_HTTP;
		}
		else if (strcasecmp(arg1, "https") == 0) {
			conf->notifyserverschema = DIVY_NOTIFYSERVER_SCHEMA_HTTPS;
		}
		else {
			return "The value of \"TfNotifyServerSchema\" is invalid. "
					"Please set \"http\" or \"https\", \"auto\"";
		}
	}
	else {
		conf->notifyserverschema = DIVY_NOTIFYSERVER_SCHEMA_AUTO;
	}

	return NULL;
}

static const char *dav_divy_logoperation_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_FILLED(arg1) && strcasecmp(arg1, "on") == 0) {
		conf->logoperation = DIVY_LOGOPERATION_ON;
	}
	else {
		conf->logoperation = DIVY_LOGOPERATION_OFF;
	}

	return NULL;
}

static const char *dav_divy_grpconstraints_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	/* (2007/09/13 Thu)
	 * このディレクティブは存在していますが、動作しないようになりました.
	 * TfGroupLeader に集約します. */
	return NULL;
}

static const char *dav_divy_licenseuploader_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->licenseuploader = DIVY_LICENSEUPLOADER_ON;
	}
	else {
		conf->licenseuploader = DIVY_LICENSEUPLOADER_OFF;
	}

	return NULL;
}

static const char *dav_divy_groupleader_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->groupleader = DIVY_GROUPLEADER_ON;
	}
	else {
		conf->groupleader = DIVY_GROUPLEADER_OFF;
	}

	return NULL;
}

#ifdef DIVY_SUPPORT_PASSPOLICY
static const char *dav_divy_passpolicyexclusion(cmd_parms *cmd,
					void *config, const char *l)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	char *w, *e, *end;

	conf->passpolicy_exs = NULL;

	/* [ 書式 ]
	 * ip="xxx.xxx.xxx.xxx/nn,zzz.zzz.zzz.zzz/mm" [AND | OR] uid="xxxx"
	 * (note) uid の値には半角スペースあり. ap_getword_conf では取得できない
	 */

	/* ip の処理 */
	w = divy_strstr_c(l, "ip=");
	if (w != NULL) {
		apr_ipsubnet_t *ipsub;
		apr_status_t rv;
		char *c, *s;

		w += 3;	/* "ip=" を除外 */
		e = NULL;
		if (*w == '"') {
			end = divy_strchr(++w, '"'); /* 終端の「"」を探す */
			if (end != NULL) {
				e = apr_pstrndup(cmd->pool, w, end - w);
			}
		}

		while (e != NULL && e[0]) {
			c = ap_getword_nc(cmd->pool, &e, ' ');
			if (c == NULL) break;

			s = divy_strchr(c, '/');
			if (s != NULL) {
				*s++ = '\0';
			}

			ipsub = NULL;
			rv = apr_ipsubnet_create(&ipsub, c, s, cmd->pool);
			if (rv == APR_SUCCESS && ipsub != NULL) {
				if (conf->passpolicy_exs == NULL) {
					conf->passpolicy_exs = apr_pcalloc(cmd->pool, sizeof(divy_passpolicy_exclusion));
					conf->passpolicy_exs->cond = DIVY_PASSPOLICY_EXCLUSION_OR;
				}

				if (conf->passpolicy_exs->ipaddrs == NULL) {
					conf->passpolicy_exs->ipaddrs = divy_array_make(cmd->pool, 5);
				}
				divy_array_add(conf->passpolicy_exs->ipaddrs, ipsub);
			}
		}
	}

	/* uid の処理 */
	w = divy_strstr(l, "uid=");
	if (w != NULL) {
		w += 4;	/* "uid=" を除外 */
		e = NULL;
		if (*w == '"') {
			end = divy_strchr(++w, '"'); /* 終端の「"」を探す */
			if (end != NULL) {
				e = apr_pstrndup(cmd->pool, w, end - w);
			}
		}

		if (e != NULL) {
			if (conf->passpolicy_exs == NULL) {
				conf->passpolicy_exs = apr_pcalloc(cmd->pool, sizeof(divy_passpolicy_exclusion));
				conf->passpolicy_exs->cond = DIVY_PASSPOLICY_EXCLUSION_OR;
			}
			conf->passpolicy_exs->uid_reg = ap_pregcomp(cmd->pool, e, (AP_REG_EXTENDED | AP_REG_NOSUB));
		}
	}

	/* AND / OR の処理(ip, uid が存在していたときだけやればいい) */
	while (l[0] && conf->passpolicy_exs != NULL) {
		/* (note)
		 * この書き方だと uid="AND |OR|root" AND ip="xxx" の場合、最初のANDにも合致
		 * するように見える. しかし、区切り規則から"AND"や"OR"が先頭から始まるのは
		 * 条件式のAND/ORだけ.だから問題なし
		 */
		w = ap_getword_conf(cmd->pool, &l);
		if (IS_EMPTY(w)) break;

		if (strcmp(w, "AND") == 0) {
			conf->passpolicy_exs->cond = DIVY_PASSPOLICY_EXCLUSION_AND;
		}
		else if (strcmp(w, "OR") == 0) {
			conf->passpolicy_exs->cond = DIVY_PASSPOLICY_EXCLUSION_OR;
		}
		else {	/* 無視 */
		}
	}

	return NULL;
}
#endif	/* DIVY_SUPPORT_PASSPOLICY */

static const char *dav_divy_confirmreading_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->confirmreading = DIVY_CONFIRMREADING_ON;
	}
	else {
		conf->confirmreading = DIVY_CONFIRMREADING_OFF;
	}

	return NULL;
}

static const char *dav_divy_confirmreading_reservedday_cmd(cmd_parms *cmd,
					void *config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_EMPTY(arg1) || !dav_divy_isdigit_str(arg1)) {
		/* デフォルト値を使う */
		conf->cr_reservedday = DIVY_CONFIRMREADING_DEFAULT_RESERVEDDAY;
	}
	else {
		conf->cr_reservedday = atoi(arg1);
		if (conf->cr_reservedday > 9999 || conf->cr_reservedday < 0) {
			/* 値が大きすぎたら、デフォルト値を使う */
			conf->cr_reservedday = DIVY_CONFIRMREADING_DEFAULT_RESERVEDDAY;
		}
	}

	return NULL;
}

static const char *dav_divy_extendsysmsg_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->extendsysmsg = DIVY_EXTENDSYSMSG_ON;
	}
	else {
		conf->extendsysmsg = DIVY_EXTENDSYSMSG_OFF;
	}

	return NULL;

}

static const char *dav_divy_groupquota_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->groupquota = DIVY_GROUPLEADER_ON;
	}
	else {
		conf->groupquota = DIVY_GROUPLEADER_OFF;
	}

	return NULL;


}

static const char* dav_divy_admin_allow_ip_cmd(cmd_parms *cmd,
					void *config, const char* l)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	apr_status_t rv;
	apr_ipsubnet_t *ipsub;
	char *s;

	conf->allowadminipaddrs = NULL;

	while(l[0]) {
		char *w = ap_getword_white(cmd->pool, &l);

		if (IS_FILLED(w)) {
			s = divy_strchr(w, '/');
			if (s != NULL) {
				*s++ = '\0';
			}
			ipsub = NULL;
			rv = apr_ipsubnet_create(&ipsub, w, s, cmd->pool);
			if (rv == APR_SUCCESS && ipsub != NULL) {
				if (conf->allowadminipaddrs == NULL) {
					conf->allowadminipaddrs = divy_array_make(cmd->pool, 5);
				}
				divy_array_add(conf->allowadminipaddrs, ipsub);
			}
		}
	}

	/* 一件でも設定があった場合は、ローカルホストも追加しておく
	 * パスワードなどの変更が行えなくなる為
	 */
	if (divy_array_getlength(conf->allowadminipaddrs) > 0)
	{
		rv = apr_ipsubnet_create(&ipsub, "127.0.0.1", "255.255.255.255", cmd->pool);
		if (rv == APR_SUCCESS && ipsub != NULL)
		{
			divy_array_add(conf->allowadminipaddrs, ipsub);
		}

#if APR_HAVE_IPV6
		rv = apr_ipsubnet_create(&ipsub, "::1", NULL, cmd->pool);

		if (rv == APR_SUCCESS && ipsub != NULL)
		{
			divy_array_add(conf->allowadminipaddrs, ipsub);
		}
	}
#endif

	return NULL;
}

static const char *dav_divy_disable_webfolder_link_cmd(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->disablewebfolderlink = DIVY_DISABLE_WEBFOLDERLINK_ON;
	}
	else {
		conf->disablewebfolderlink = DIVY_DISABLE_WEBFOLDERLINK_OFF;
	}

	return NULL;
}

static const char *dav_divy_disable_change_password(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		conf->disablechangepassword = DIVY_DISABLE_CHANGE_PASSWORD_ON;
	}
	else {
		conf->disablechangepassword = DIVY_DISABLE_CHANGE_PASSWORD_OFF;
	}

	return NULL;
}

static const char *dav_divy_master_password(cmd_parms *cmd,
		                    void *config, const char* arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	conf->masterpassword = apr_pstrdup(cmd->pool, arg1);
	return NULL;
}

static const char *dav_divy_upload_only_user_is_download_allow_time(
							cmd_parms* cmd, void* config, const char* arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_EMPTY(arg1) || !dav_divy_isdigit_str(arg1)) {
		conf->uldownloadallowtime = 0; /* 0秒つまり許可しない */
	}
	else {
		conf->uldownloadallowtime = atoi(arg1);
		/* 一日以上の設定はできません */
		if (conf->uldownloadallowtime > 86400 || conf->uldownloadallowtime < 0) {
			conf->uldownloadallowtime = 0; /* 許可しない */
		}
	}

	return NULL;
}

static const char *dav_divy_use_session(cmd_parms* cmd, void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->usesession = DIVY_USE_SESSION_ON;
	}
	else {
		conf->usesession = DIVY_USE_SESSION_OFF;
	}

	return NULL;
}

static const char *dav_divy_use_access_control(cmd_parms* cmd, void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->useaccesscontrol = DIVY_ACCESS_CONTROL_ON;
	}
	else {
		conf->useaccesscontrol = DIVY_ACCESS_CONTROL_OFF;
	}

	return NULL;
}

static const char *dav_divy_session_timeout(cmd_parms* cmd,
											void* config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	
	if (IS_EMPTY(arg1) || !dav_divy_isdigit_str(arg1)) {
		conf->sessiontimeout = DIVY_SESSION_TIMEOUT_INFINITY;
	}
	else {
		conf->sessiontimeout = (apr_int32_t) atoi(arg1);
	}

	return NULL;
}

static const char *dav_divy_default_access_rule(cmd_parms* cmd,
											void* config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (IS_EMPTY(arg1)) {
		/* EMPTYだとこの関数はこないけど */
		conf->defaultaccessrule = DIVY_DEFAULT_ACCESS_RULE_ALLOW;
	}
	else {
		if (strcasecmp(arg1, "allow") == 0) {
			conf->defaultaccessrule = DIVY_DEFAULT_ACCESS_RULE_ALLOW;
		}
		else if (strcasecmp(arg1, "deny") == 0) {
			conf->defaultaccessrule = DIVY_DEFAULT_ACCESS_RULE_DENY;
		} 
		else {
			/* 理解できない文字列の場合は許可 */
			conf->defaultaccessrule = DIVY_DEFAULT_ACCESS_RULE_ALLOW;
		}
	}

	return NULL;
}
	
static const char *dav_divy_failed_login_lockout(cmd_parms* cmd,
		                    void* config, const char *arg1, const char*arg2, const char* arg3)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		if (!dav_divy_isdigit_str(arg1)) {
			return "invalid	value of \"TfFailedLoginControl\" number number number";
		}
		conf->lockoutlimit = atoi(arg1);
	}

	/* ロック回数制限(>0)があることは機能がOnであることと同じ */
	if (conf->lockoutlimit > 0) {
		conf->failedloginlockout = DIVY_FAILED_LOGIN_LOCKOUT_ON;

		if (arg2) {
			if(!dav_divy_isdigit_str(arg2)) {
				return "invalid	value of \"TfFailedLoginControl\" number number number";
			}
			conf->unlocktime = atoi(arg2);
		}
	}
	else {
		conf->failedloginlockout = DIVY_FAILED_LOGIN_LOCKOUT_OFF;
	}

	/* リトライまでの時間が設定されていた場合は、その繰り返し回数を調べる */
	if (conf->unlocktime > 0) {
		if (arg3) {
			if(!dav_divy_isdigit_str(arg3)) {
				return "invalid	value of \"TfFailedLoginControl\" number number number";
			}
			conf->unlockretrycount = atoi(arg3);
		}
	}

	return NULL;
}

static const char *dav_divy_shorten_url(cmd_parms* cmd, void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->shortenurl = DIVY_SHORTEN_URL_ON;
	}
	else {
		conf->shortenurl = DIVY_SHORTEN_URL_OFF;
	}

	return NULL;
}

static const char *dav_divy_tfbox_cmd(cmd_parms* cmd, void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->tfbox = DIVY_TFBOX_ON;
	}
	else {
		conf->tfbox = DIVY_TFBOX_OFF;
	}

	return NULL;
}

static const char *dav_divy_serverpolicy_cmd(cmd_parms *cmd,
					void* config, const char *l)
{
	char *key = NULL, *val = NULL, *header = NULL;
	int found = 0;
	char *token = NULL, *key_cntx = NULL;

	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	while(l[0]) {
		key = ap_getword_white(cmd->pool, &l);
		if (header != NULL) 
			header = apr_psprintf(cmd->pool, "%s %s", header, key);
		else
			header = apr_pstrdup(cmd->pool, key);

		if (IS_FILLED(key)) {
			found = 0;	/* 初期化 */
			val = divy_strchr(key, '=');
			if (val != NULL) {
				*val++ = '\0';
			}

			/* boxlimit=<number> */
			if (strcmp(key, "boxlimit") == 0) {
				conf->tfboxpolicylimit = apr_atoi64(val);
				found=1;	/* 知っているポリシー */
			}
			else 
			/* boxdisableformat=list,xml,json */
			if (strcmp(key, "boxdisableformat") == 0) {
				while ((token = apr_strtok(val, ",", &key_cntx)) != NULL) {
					if (token == NULL) break;
					val = NULL;

					if (strcmp(token, "list") == 0) {
						conf->tfboxdisableformat |= DIVY_BOX_DISABLE_FORMAT_LIST;
					}
					else
					if (strcmp(token, "xml") == 0) {
						conf->tfboxdisableformat |= DIVY_BOX_DISABLE_FORMAT_XML;
					}
					else
					if (strcmp(token, "json") == 0) {
						conf->tfboxdisableformat |= DIVY_BOX_DISABLE_FORMAT_JSON;
					}
					else 
					if (strcmp(token, "rss") == 0) {
						conf->tfboxdisableformat |= DIVY_BOX_DISABLE_FORMAT_RSS;
					}
				}
				found=1;	/* 知っているポリシー */
			}
			else 
			if (strcmp(key, "browserstyle") == 0) {
				while ((token = apr_strtok(val, ",", &key_cntx)) != NULL) {
					if (token == NULL) break;
					val = NULL;
					if (strcmp(token, "invisiblebrand") == 0) {
						/* ログイン画面にブランドが分る表示をしない */
						conf->tfbrowserstyle |=
									DIVY_BROWSER_STYLE_INVISIBLE_BRAND;
					}
					if (strcmp(token, "oldloginpage") == 0) {
						/* 古いログイン画面(2.4.0-1以前) SAML適用前 */
						conf->tfbrowserstyle |=
									DIVY_BROWSER_STYLE_OLDLOGINPAGE;
					}
				}
				found=1;	/* 知っているポリシー */
			}
			else
			/* box開封者のメールアドレスにワイルドカードは設定できないポリシー */
			if (strcasecmp(key, "boxdisablewildcardmailaddr") == 0) {
				conf->boxdisablewildcardmailaddr = 1;
				found=1;	/* 知っているポリシー */
			}

			/* BOXに登録したユーザにメールを送らない */
			if (strcasecmp(key, "boxwithoutmail") == 0) {
				if (strcasecmp(val, "user") == 0) {
					conf->boxwithoutmail = BOX_WITHOUTMAIL_USER;
				}
				else if (strcasecmp(val, "all") == 0) {
					conf->boxwithoutmail = BOX_WITHOUTMAIL_ALL;
				}
				found=1;	/* 知っているポリシー */
			}

			/* ポリシーはここに追加していくこと */

			if (found == 0) {
				/* 知らない設定があった */
				return apr_psprintf(cmd->pool, "unsupported policy. Please check derective. policyword=[%s]", key);
			}
		}
	}
	
	if (header != NULL) {
		if (conf->tfserverpolicyheader == NULL) {
			conf->tfserverpolicyheader = apr_pstrdup(cmd->pool, header);
		}
		else {
			conf->tfserverpolicyheader = apr_psprintf(cmd->pool, "%s,%s", conf->tfserverpolicyheader, header);
		}
	}

	return NULL;
}

static const char *dav_divy_usememcache_cmd(cmd_parms *cmd,
												 void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->usememcache = DIVY_TFMEMCACHE_ON;
	}
	else {
		conf->usememcache = DIVY_TFMEMCACHE_OFF;
	}

	return NULL;
}

static const char *dav_divy_memcache_servers_cmd(cmd_parms *cmd,
					void* config, const char *l)
{
	char *s = NULL;
	const char *hostname = cmd->server->server_hostname;
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	divy_memcache_create(cmd->pool, hostname, &conf->memd);

	while(l[0]) {
		s = ap_getword_white(cmd->pool, &l);
		if (IS_FILLED(s)) {
			if (divy_memcache_add_server(cmd->pool, conf->memd, s) != 0) {
				return apr_psprintf(cmd->pool,
					 "failed to add memcached server. [server=%s]", s);
			}
		}
		else {
			return "Please check memcached setting. \"TfMemcacheServers\" is EMPTY.";
		}
	}

	return NULL;
}

static const char *dav_divy_use_saml_cmd(cmd_parms *cmd,
												 void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->usesaml = DIVY_USE_SAML_ON;
		conf->tfbrowserstyle &= ~DIVY_BROWSER_STYLE_OLDLOGINPAGE;
	}
	else {
		conf->usesaml = DIVY_USE_SAML_OFF;
	}

	return NULL;
}

static const char *dav_divy_saml_idp_meta_cmd(cmd_parms *cmd,
											void* config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	divy_saml_idp_metadata *idpmeta = NULL;

	if (conf->usesaml == DIVY_USE_SAML_ON && arg1) {
		if (divy_saml_open_metadata(cmd->pool, arg1, &idpmeta)) {
			return "failed to SAML IdP metadata parse error.";
		}
	}

	conf->idpmeta = idpmeta;

	return NULL;
}

static const char* dav_divy_saml_privatekeypath_cmd(cmd_parms *cmd,
											void* config, const char *arg1)
{
	apr_status_t rv;
	apr_finfo_t finfo  = { 0 };
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (conf->usesaml == DIVY_USE_SAML_ON && arg1) {
		conf->saml_privatekeypath = apr_pstrdup(cmd->pool, arg1);

		rv = apr_stat(&finfo, conf->saml_privatekeypath, APR_FINFO_MTIME, cmd->pool);
		if (rv != APR_SUCCESS) {
			return "SAML sign private key path invalid";
		}
	}

	return NULL;
}

static const char* dav_divy_saml_x509certificatepath_cmd(cmd_parms *cmd,
											void* config, const char *arg1)
{
	apr_status_t rv;
	apr_finfo_t finfo  = { 0 };
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (conf->usesaml == DIVY_USE_SAML_ON && arg1) {
		conf->saml_x509certificatepath = apr_pstrdup(cmd->pool, arg1);

		rv = apr_stat(&finfo, conf->saml_x509certificatepath, 
												APR_FINFO_MTIME, cmd->pool);
		if (rv != APR_SUCCESS) {
			return "SAML sign public certificate path invalid";
		}
	}
	return NULL;
}

static const char* dav_divy_saml_nameid_match_mailaddr(cmd_parms *cmd,
											void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->saml_matchedmailaddr = DIVY_SAML_MATCHED_MAIL_ON;
	}
	else {
		conf->saml_matchedmailaddr = DIVY_SAML_MATCHED_MAIL_OFF;
	}

	return NULL;
}

static const char* dav_divy_custom_image_path_cmd(cmd_parms *cmd,
											void* config, const char *arg1)
{
	dav_divy_server_conf *conf =
	       	ap_get_module_config(cmd->server->module_config,
			       				&dav_tf_module);
	if (arg1) {
		conf->tfcustomimagepath = apr_pstrdup(cmd->pool, arg1);
	}

	return NULL;
}

static const char *dav_divy_use_uploadpolicy_cmd(cmd_parms *cmd,
												 void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->useuploadpolicy = DIVY_USE_UPLOAD_POLICY_ON;
	}
	else {
		conf->useuploadpolicy = DIVY_USE_UPLOAD_POLICY_OFF;
	}

	return NULL;
}

static const char *dav_divy_use_2fa_cmd(cmd_parms *cmd, void* config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->use2fa = DIVY_USE_2FA_ON;
	}
	else {
		conf->use2fa = DIVY_USE_2FA_OFF;
	}

	return NULL;
}

static const char *dav_divy_2fa_cycle(cmd_parms *cmd, void* config,
											const char *arg1, const char* arg2)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	char *period, *day, *month;

	if (!dav_divy_isdigit_str(arg1)) {
		return "The value of \"TfTwoFactorAuthenticationCycle\" must be a positive digit.";
	}

	conf->cyclebasetime2fa = apr_atoi64(arg1);
	if (conf->cyclebasetime2fa < 1 || conf->cyclebasetime2fa > 24) {
		return "The value of \"TfTwoFactorAuthenticationCycle\" directive is missing.(ex, 1-24 0-365d or 0-12m)";
	}


	if (arg2) {
		period = apr_pstrdup(cmd->pool, arg2);
		ap_str_tolower(period);
		day = dav_divy_find_prestr(cmd->pool, period, "d");
		month = dav_divy_find_prestr(cmd->pool, period, "m");
		if (IS_EMPTY(day) && IS_EMPTY(month)) {
			return "The value of \"TfTwoFactorAuthenticationCycle\" directive is missing.(ex, 1-24 0-365d or 0-12m)";
		}
		conf->cycleperiod2fa = apr_pstrdup(cmd->pool, period);
	}

	return NULL;
}

static const char *dav_divy_2fa_type(cmd_parms *cmd,
											void* config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	
	if (arg1) {
		if (strcmp(arg1, "totp-only") == 0) {
			conf->type2fa = DIVY_2FA_TYPE_OTP_ONLY;
		}
		else {
			conf->type2fa = DIVY_2FA_TYPE_DEFAULT;
		}
	}

	return NULL;
}

static const char *dav_divy_2fa_stage(cmd_parms *cmd,
											void* config, const char *arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	if (arg1) {
		if (strcmp(arg1, "box") == 0) {
			conf->stage2fa = DIVY_2FA_USE_STAGE_BOX_ONLY;
		}
		else {
			conf->stage2fa = DIVY_2FA_USE_STAGE_ALL;
		}
	}

	return NULL;

}


#ifdef TF_SUPPORT_CIPHER_STORAGE
static const char *dav_divy_cipher_storage(cmd_parms *cmd,
					void *config, int arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	if (arg1) {
		conf->cipherstorage = DIVY_CIPHER_STORAGE_ON;
	}
	else {
		conf->cipherstorage = DIVY_CIPHER_STORAGE_OFF;
	}

	return NULL;
}
#endif
#ifdef TF_SUPPORT_CIPHER_STORAGE
static const char *dav_divy_cipher_storage_key(cmd_parms *cmd,
					void *config, const char* arg1)
{
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;
	char *digest;
	char *base64_str = NULL;
	apr_size_t base64_len;

	if (conf->cipherstorage != DIVY_CIPHER_STORAGE_ON) 
		return NULL; /* 無視 */

	if (IS_EMPTY(arg1))
		return "The invalid value of \"TfFsCipherKey\".";

#define TF_SHA1_DIGEST_SIZE 20
	if (strncmp(arg1, "/", 1) == 0) {
		/* 先頭が/はファイルパス(とみなす) */
		digest = apr_pcalloc(cmd->pool, sizeof(char) * TF_SHA1_DIGEST_SIZE);
		if (!tf_cipher_file2sha1(cmd->pool, arg1, digest) || IS_EMPTY(digest)) {
			return "Failed to \"TfFsCipherKey\". file path ??";
		}
	}
	else {
		/* 以外はパスフレーズ文字列 */
		digest = apr_pcalloc(cmd->pool, sizeof(char) * TF_SHA1_DIGEST_SIZE);

		if (!tf_cipher_str2sha1(cmd->pool, arg1, digest) || IS_EMPTY(digest)) {
			return "Failed to \"TfFsCipherkey\" string.";
		}
	}

	base64_str = apr_pcalloc(cmd->pool,
			sizeof(char) * (apr_base64_encode_len(TF_SHA1_DIGEST_SIZE) + 1));
	base64_len = apr_base64_encode(base64_str, digest, TF_SHA1_DIGEST_SIZE);
	base64_str[base64_len + 1] = '\0';
	
#undef TF_SHA1_DIGEST_SIZE

	if (IS_EMPTY(base64_str)) {
		return "Failed initialize to cipher key";
	}

	conf->cipherstoragekey = apr_pstrdup(cmd->pool, base64_str);

	return NULL;
}
#endif
#ifdef TF_SUPPORT_CIPHER_STORAGE
static const char *dav_divy_cipher_storage_cipher_type(cmd_parms *cmd,
					void *config, const char* arg1)
{
	int type = 0;
	dav_divy_dir_conf *conf = (dav_divy_dir_conf *)config;

	type = tf_crypt_get_ciphertype(arg1);

	if (!type) {
		return "Failed to storage cipher type. \"des-cfb, des-ofb, "
			   "des3-cfb, des3-ofb, bf-cfb, bf-ofb, cast5-ofb, case5-cfb,"
			   "aes128-cfb, aes128-ofb, aes192-cfb, aes192-ofb, aes256-cfb,"
			   "aes256-ofb\"";
	}

	conf->cipherstoragetype = type;

	return NULL;
}
#endif

/**
 * register hook
 */
static void dav_divy_register_hooks(apr_pool_t *p)
{
	/* Apache hook */
	ap_hook_post_config(dav_divy_post_config, NULL, NULL, APR_HOOK_MIDDLE);
	ap_hook_child_init(dav_divy_child_init, NULL, NULL, APR_HOOK_MIDDLE);
	ap_hook_post_read_request(dav_divy_post_read, NULL, NULL, APR_HOOK_MIDDLE);
#if 0	/* 2005/02/08 fixups は結果的に処理内容が無くなったのでコメントアウト */
	ap_hook_fixups(dav_divy_fixups, NULL, NULL, APR_HOOK_MIDDLE);
#endif
#if 0
	ap_hook_auth_checker(dav_divy_check_auth,NULL, NULL, APR_HOOK_REALLY_FIRST);
#endif
#if AP_MODULE_MAGIC_AT_LEAST(20080403,1)
	ap_hook_check_authn(dav_divy_authenticate_user, NULL, NULL, APR_HOOK_MIDDLE,
						AP_AUTH_INTERNAL_PER_CONF);
#else
	ap_hook_check_user_id(dav_divy_authenticate_user, NULL, NULL, APR_HOOK_REALLY_FIRST);
#endif
	ap_hook_note_auth_failure(dav_divy_hook_tf_auth_failure, NULL, NULL,
								APR_HOOK_MIDDLE);

	/* mod_dav hook */
	
	/* 指定されたliveプロパティのプロパティIDを取得する関数をフックに登録 */
	dav_hook_find_liveprop(dav_divy_find_liveprop, 
	                       NULL, NULL, APR_HOOK_MIDDLE);
	
	/* Liveプロパティとその値を取り出しXMLとして返す関数をフックに登録 */
	dav_hook_insert_all_liveprops(dav_divy_insert_all_liveprops, 
	                              NULL, NULL, APR_HOOK_MIDDLE);
	
	/* register the namespace URIs */
	dav_register_liveprop_group(p, &dav_divy_liveprop_group);

	/* mod_dav のDAVプロバイダとしてこのプロバイダを登録する */
	dav_register_provider(p, DAV_PROVIDER_NAME, &dav_divy_provider);


	/* authのTeamFileプロバイダとしてこのプロバイダを登録する */

	ap_register_auth_provider(p, AUTHN_PROVIDER_GROUP, "teamfile",
                                  AUTHN_PROVIDER_VERSION,
                                  &authn_tf_provider,
                                  AP_AUTH_INTERNAL_PER_CONF);

	ap_register_auth_provider(p, AUTHZ_PROVIDER_GROUP, "tf-user",
                                  AUTHZ_PROVIDER_VERSION,
                                  &authz_tf_provider,
                                  AP_AUTH_INTERNAL_PER_CONF);
								


}

/*--------------------------------------------------------------
  Define structures and tables
  --------------------------------------------------------------*/

/**
 * コマンドテーブル 
 */
static const command_rec dav_divy_cmds[] = {
	AP_INIT_TAKE1("TfDbDbmstype", dav_divy_dbmstype_cmd, NULL, ACCESS_CONF,
			"The dbms type name of repository database."),
        AP_INIT_TAKE1("TfDbDbmsname", dav_divy_dbmsname_cmd, NULL, ACCESS_CONF,
			"The dbms name of repository database."),
	AP_INIT_TAKE1("TfDbHostname", dav_divy_hostname_cmd, NULL, ACCESS_CONF,
			"The hostname of repository database."),
	AP_INIT_TAKE1("TfDbHostport", dav_divy_hostport_cmd, NULL, ACCESS_CONF,
			"The port number of repository database."),
	AP_INIT_TAKE1("TfDbDbname",   dav_divy_dbname_cmd, NULL, ACCESS_CONF,
			"The database name of repository database."),
	AP_INIT_TAKE1("TfDbUsername", dav_divy_username_cmd, NULL, ACCESS_CONF,
			"The user account id of repository database."),
	AP_INIT_TAKE1("TfDbPassword", dav_divy_password_cmd, NULL, ACCESS_CONF,
			"The user account password of repository database."),
	AP_INIT_TAKE1("TfDbPool", dav_divy_dbpool_cmd, NULL, ACCESS_CONF,
			"Enable db connection pool."),
	AP_INIT_FLAG("TfDbVhostShare", dav_divy_dbvhostshare_cmd, NULL, ACCESS_CONF,
			"Control whether db connection is shared by virtualhosts."),
	AP_INIT_TAKE1("TfDbRefreshInterval", dav_divy_dbrefreshinterval_cmd,
			NULL, RSRC_CONF,
			"The refresh interval seconds of db connection stored in pool."),
	AP_INIT_TAKE1("TfDbMinSpareConn", dav_divy_dbminspareconn_cmd, NULL, ACCESS_CONF,
			"The minimum number of db connection which are kept spare."),
	AP_INIT_TAKE1("TfDbMaxSpareConn", dav_divy_dbmaxspareconn_cmd, NULL, ACCESS_CONF,
			"The maximum number of db connection which are kept spare."),
	AP_INIT_TAKE1("TfFsRootPath", dav_divy_fsrootpath_cmd, NULL, ACCESS_CONF,
			"The file system root path that saved resource files."),
	AP_INIT_TAKE1("TfMaxResourcePerDir", dav_divy_maxresource_per_dir_cmd,
			NULL, ACCESS_CONF,
			"The number of max resources per directory."),
	AP_INIT_TAKE1("TfServerLicenseKey", dav_divy_serverlicensekey_cmd, 
			NULL, RSRC_CONF, "The TeamFile server license key."),
	AP_INIT_TAKE1("TfDbLicenseKey", dav_divy_dblicensekey_cmd, 
			NULL, RSRC_CONF, "The database-provider license key."),
	AP_INIT_TAKE1("TfAuth", dav_divy_auth_cmd, NULL, ACCESS_CONF,
			"TeamFile Authenticate Type."),
	AP_INIT_RAW_ARGS("TfAuthloginignoreinspectionipaddrs",
			dav_divy_auth_login_ignore_inspection_ipaddrs_cmd,
			NULL, ACCESS_CONF, "TeamFile login ignore inspection is address."),
	AP_INIT_TAKE1("TfMail", dav_divy_mail_cmd, NULL, ACCESS_CONF,
			"The Mail type of Mail system."),
	AP_INIT_TAKE1("TfMlHostname", dav_divy_mailhost_cmd, NULL, ACCESS_CONF,
			"The MailServer hostname of mailsystem"),
        AP_INIT_TAKE1("TfMlHostport", dav_divy_mailport_cmd, NULL, ACCESS_CONF,
                        "The MailHostPort of mail system"),
        AP_INIT_TAKE1("TfMlAdminAddr", dav_divy_mailadminaddr_cmd, NULL,
                        ACCESS_CONF,
                        "The Administrator mail address of divy mail system."),
        AP_INIT_TAKE1("TfMlUsername", dav_divy_mlusername_cmd, NULL,
                        ACCESS_CONF, "SMTP auth user name"),
        AP_INIT_TAKE1("TfMlPassword", dav_divy_mlpassword_cmd, NULL,
                        ACCESS_CONF, "SMTP auth password"),
        AP_INIT_TAKE1("TfMlEncoding", dav_divy_mailencoding_cmd, NULL,
                        ACCESS_CONF, "The Encoding system of mail is specified."),
	AP_INIT_TAKE1("TfMlServerSend", dav_divy_mlserversend_cmd, NULL,
			ACCESS_CONF, "Auto mail function"),
	AP_INIT_TAKE1("TfMlTemplateRoot", dav_divy_mltemplateroot_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The path of mail template"),
	AP_INIT_FLAG("TfMlNotifyAction", dav_divy_mlnotifyact_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Send notification mail if you operated something."),
	AP_INIT_FLAG("TfMlEnableOneClickURL", dav_divy_mloneclickurl_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Attachment of parent folder url for sending mail."),
	AP_INIT_FLAG("TfMlEdit", dav_divy_mledit_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable mail-edit function."),
	AP_INIT_TAKE12("TfMlRepFromAddr", dav_divy_mlrepfromaddr_cmd, NULL,
			ACCESS_CONF, "The Replace mail watch from address."),
	AP_INIT_TAKE1("TfMlSendInterval", dav_divy_mlsendinterval_cmd, NULL,
			ACCESS_CONF, "interval of sendmail(unofficial.:p)"),
	AP_INIT_TAKE1("TfDefaultMaxQuotaSize", 
			dav_divy_defaultmaxquotasize_cmd, NULL, ACCESS_CONF, 
			"The limit number of user-quota bytes"),
	AP_INIT_TAKE1("TfDefaultMaxQuotaRes", dav_divy_defaultmaxquotares_cmd,
			NULL, ACCESS_CONF, 
			"The limit number of user-quota files"),
	AP_INIT_TAKE1("TfMaxFileSize", dav_divy_maxfilesize_cmd, NULL, ACCESS_CONF,
			"The max file size that the user can upload file by one operation."),
	AP_INIT_FLAG("TfShowGroup", dav_divy_showgroup_cmd, NULL,
			ACCESS_CONF, "Enable access group folder via browser and web-folder."),
	AP_INIT_TAKE1("TfLDAPCacheByte", dav_divy_ldap_shmcachebyte_cmd,
			NULL, RSRC_CONF, "Size of a shard memory."),
	AP_INIT_TAKE1("TfLDAPShmPath", dav_divy_ldap_shmpath_cmd,
			NULL, RSRC_CONF, "Path of a access path shard memory."),
	AP_INIT_TAKE1("TfLDAPCacheTTL",
		       	dav_divy_ldap_search_cache_ttl_cmd,
			NULL, RSRC_CONF, "Search cache TTL."),
	AP_INIT_TAKE1("TfLDAPMaxMemBlocks",
			dav_divy_ldap_max_mem_blocks_cmd,
			NULL, RSRC_CONF, "LDAP max block count of mem manager"),
	AP_INIT_TAKE1("TfLDAPMarkPercentage",
			dav_divy_ldap_markpercentage,
			NULL, RSRC_CONF, "LDAP when do we mark? "),
	AP_INIT_TAKE1("TfLDAPPurgePercentage",
			dav_divy_ldap_purgepercentage,
			NULL, RSRC_CONF, "LDAP when do we purge?"),
	AP_INIT_TAKE1("TfLDAPCertAuthFile",
			dav_divy_ldap_cert_auth_file_cmd,
			NULL, RSRC_CONF, "sert auth file."),
	AP_INIT_TAKE1("TfLDAPCertFileType",
			dav_divy_ldap_cert_file_type_cmd,
			NULL, RSRC_CONF, "sert file type."),
	AP_INIT_FLAG("TfLDAPSSLSupport",
			dav_divy_ldap_ssl_support_cmd,
			NULL, RSRC_CONF, "LDAP ssl support"),
	AP_INIT_FLAG("TfLDAP", dav_divy_use_ldap_cmd,
			NULL, ACCESS_CONF, "LDAP use."),
	AP_INIT_TAKE1("TfLDAPBaseDN",
			dav_divy_ldap_basedn_cmd,
			NULL, ACCESS_CONF, "LDAP BaseDN"),
	AP_INIT_TAKE1("TfLDAPBindDN",
			dav_divy_ldap_binddn_cmd,
			NULL, ACCESS_CONF, "LDAP BIND DN"),
	AP_INIT_TAKE1("TfLDAPBindPW",
			dav_divy_ldap_bindpw_cmd,
			NULL, ACCESS_CONF, "LDAP BIND Password"),
	AP_INIT_TAKE1("TfLDAPAttr",
			dav_divy_ldap_attr_cmd,
			NULL, ACCESS_CONF, "LDAP bind attribute"),
	AP_INIT_TAKE1("TfLDAPFilter",
			dav_divy_ldap_filter_cmd,
			NULL, ACCESS_CONF, "LDAP Search Filter"),
	AP_INIT_TAKE1("TfLDAPScope",
			dav_divy_ldap_scope_cmd,
			NULL, ACCESS_CONF,
		       	"LDAP Search Scope [ one | sun | base ]"),
	AP_INIT_TAKE1("TfLDAPHost",
			dav_divy_ldap_host_cmd,
			NULL, ACCESS_CONF, "LDAP Host"),
	AP_INIT_TAKE1("TfLDAPHostPort",
			dav_divy_ldap_port_cmd,
			NULL, ACCESS_CONF, "LDAP Port"),
	AP_INIT_TAKE1("TfLDAPUrl",
			dav_divy_ldap_url_cmd,
			NULL, ACCESS_CONF, "LDAP URL"),
	AP_INIT_TAKE1("TfLDAPMapUserAttr",
			dav_divy_ldap_map_user_attr_cmd,
			NULL, ACCESS_CONF, "UserID to the attribute of LDAP"),
	AP_INIT_TAKE1("TfLDAPMapPasswordAttr",
			dav_divy_ldap_map_passwd_attr_cmd,
			NULL, ACCESS_CONF,
		       	"User Password to the attribute of LDAP"),
	AP_INIT_TAKE1("TfLDAPMapFullNameAttr",
			dav_divy_ldap_map_fullname_attr_cmd,
			NULL, ACCESS_CONF,
		       	"User FullName to the attribute of LDAP"),
	AP_INIT_TAKE1("TfLDAPMapMailAddAttr",
			dav_divy_ldap_map_mailaddr_attr_cmd,
			NULL, ACCESS_CONF,
		       	"User Mail Address to the attribute of LDAP"),
	AP_INIT_TAKE1("TfLDAPMapCommentAttr",
			dav_divy_ldap_map_comment_attr_cmd,
			NULL, ACCESS_CONF,
		       	"User Comment(description) to the attribute of LDAP"),
	AP_INIT_FLAG("TfLDAPFoundCreate",
			dav_divy_ldap_found_create_cmd,
			NULL, ACCESS_CONF,
		       	"User exists in LDAP,"
		        "Account is created automatically"),
	AP_INIT_FLAG("TfLDAPSyncProperty",
			dav_divy_ldap_sync_property_cmd,
			NULL, ACCESS_CONF, "LDAP Sync Property"),
	AP_INIT_ITERATE("TfLDAPAllowUser",
			dav_divy_ldap_allow_user_cmd,
			NULL, ACCESS_CONF,
		       	"The user list which does not perform LDAP management"),
	AP_INIT_RAW_ARGS("TfLDAPAllowUserRegEx",
			dav_divy_ldap_allow_user_regex_cmd, NULL,
			RSRC_CONF | ACCESS_CONF,
			"The regex match user which does not preform LDAP management"),
	AP_INIT_ITERATE("TfLDAPOptions",
			dav_divy_ldap_user_options, NULL,
			RSRC_CONF | ACCESS_CONF, "The LDAP User Options."),
	AP_INIT_FLAG("TfAutoIndex", dav_divy_autoindex_cmd, NULL,
			ACCESS_CONF, "Enable autoindex via browser."),
	AP_INIT_TAKE1("TfStyleSheetRoot", dav_divy_stylesheetroot_cmd, NULL,
			RSRC_CONF | ACCESS_CONF,
			"The path of stylesheet for autoindex."),
	AP_INIT_TAKE1("TfSyncGroupUri", dav_divy_syncgroupuri_cmd, NULL,
			ACCESS_CONF, "Make group name accord with group URI."),
	AP_INIT_TAKE1("TfMaxUser", dav_divy_maxuser_cmd, NULL, RSRC_CONF | ACCESS_CONF,
			"The maximum number of contract user."),
	AP_INIT_FLAG("TfEncryptPassword", dav_divy_emcrypt_password, NULL,
			ACCESS_CONF, "Encryption of a user password."),
	AP_INIT_TAKE1("TfVscan", dav_divy_vscan_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The type of Virus provider."),
	AP_INIT_FLAG("TfVscStreamMethod", dav_divy_vscstreammethod_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Use stream-method API for Virus Scanning."),
	AP_INIT_TAKE1("TfVscHostname", dav_divy_vschostname_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The hostname of Anti-Virus Engine."),
	AP_INIT_TAKE1("TfVscHostport", dav_divy_vschostport_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The port number of Anti-Virus Engine."),
	AP_INIT_TAKE1("TfVscCmd", dav_divy_vsccmd_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The commandline of Anti-Virus Engine."),
	AP_INIT_FLAG("TfTrashFolder", dav_divy_trashfolder_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable trash-folder function."),
	AP_INIT_TAKE1("TfBrandName", dav_divy_brandname_cmd,
			NULL, RSRC_CONF, "The name of Brand"),
	AP_INIT_TAKE1("TfServerVersion", dav_divy_tfversion_cmd,
			NULL, RSRC_CONF, "This version"),
	AP_INIT_FLAG("TfExtendUserStatus", dav_divy_extenduserst_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable extended user status function."),
	AP_INIT_TAKE1("TfNotifyServerName", dav_divy_notifyservename_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The hostname for notifyaction."),
	AP_INIT_FLAG("TfUseUsbToken", dav_divy_useusbktoken_cmd, NULL,
			RSRC_CONF, "Use usbtoken device for management license data."),
#ifdef DIVY_SUPPORT_PRINTER
	AP_INIT_FLAG("TfNetPrint", dav_divy_netprint_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable printer function."),
	AP_INIT_TAKE1("TfPrPrinterGroupName", dav_divy_prprintgroupname_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The name of group-printer."),
	AP_INIT_TAKE1("TfPrName", dav_divy_prname_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The name of printer."),
#endif	/* DIVY_SUPPORT_PRINTER */
#ifdef DIVY_SUPPORT_PREFLIGHT_PLUGIN
	AP_INIT_TAKE1("TfPlRootPath", dav_divy_plrootpath_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The pre-flight input-directory path."),
	AP_INIT_TAKE1("TfPlGroupSet", dav_divy_plgroupset_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The pre-flight group name."),
#endif	/* DIVY_SUPPORT_PREFLIGHT_PLUGIN */
	AP_INIT_FLAG("TfThumbnail", dav_divy_thumbnail_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Thumbnail function."),
#ifdef DAV_SUPPORT_POST_HANDLING
	AP_INIT_TAKE1("TfSysCgiRoot", dav_divy_syscgiroot_cmd, NULL,
			RSRC_CONF, "The System-CGI directory path"),
#endif	/* DAV_SUPPORT_POST_HANDLING */
#ifdef DIVY_SUPPORT_PLUGIN
	AP_INIT_TAKE1("TfPluginRoot", dav_divy_pluginroot_cmd, NULL,
			RSRC_CONF, "The plugin's root directory path"),
#endif	/* DIVY_SUPPORT_PLUGIN */
#ifdef DIVY_SUPPORT_PASSPOLICY
	AP_INIT_FLAG("TfPassPolicy", dav_divy_passpolicty_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Password-Policy function."),
	AP_INIT_RAW_ARGS("TfPassPolicyOptions", dav_divy_passpolicyoptions_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Set Password-Policy options"),
#endif	/* DIVY_SUPPORT_PASSPOLICY */
#ifdef DIVY_SUPPORT_LOGACCESS
	AP_INIT_TAKE1("TfLogAccess", dav_divy_logaccess_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable LogAccess function."),
#endif	/* DIVY_SUPPORT_LOGACCESS */
	AP_INIT_TAKE1("TfDefaultResponseLanguage", dav_divy_defaultresponselanguage_cmd, NULL,
			RSRC_CONF, "Set default resonse language."),
	AP_INIT_ITERATE("TfSupportedLanguages", dav_divy_supportedlanguages_cmd, NULL,
			RSRC_CONF, "The set of supported lanugages"),
	AP_INIT_TAKE1("TfForceLanguage", dav_divy_forcelanguage_cmd, NULL,
			RSRC_CONF, "Set forced resonse language."),
	AP_INIT_FLAG("TfAutoDelete", dav_divy_autodelete_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable AutoDelete function."),
	AP_INIT_RAW_ARGS("TfAutoDeleteAllowIP", dav_divy_autodeleteallowip, NULL,
			RSRC_CONF | ACCESS_CONF, "Allow IP address mask for AutoDelete function."),
	AP_INIT_FLAG("TfChunkPUT", dav_divy_chunkput_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Support Chunk-PUT function."),
	AP_INIT_FLAG("TfExecEngine", dav_divy_execengine_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Support action-extension command function."),
	AP_INIT_TAKE1("TfExecOnCmd", dav_divy_execoncmd_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The commandline of action-extension command."),
	AP_INIT_TAKE1("TfExecMatch", dav_divy_execmatch_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The regular expression for matching Execcmd."),
	AP_INIT_FLAG("TfForceDelete", dav_divy_forcedelete_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Delete USER or GROUP that have some resources."),
	AP_INIT_FLAG("TfRProxyUse", dav_divy_rproxyuse_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Work in cooperation with reverse-proxy."),
	AP_INIT_RAW_ARGS("TfRProxyMatch", dav_divy_rproxymatch_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The regular expression for matching reverse-proxy server in Via header"),
	AP_INIT_TAKE1("TfRProxySchema", dav_divy_rproxyschema_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The schema name connecting from Client."),
	AP_INIT_TAKE1("TfRProxyHttpPort", dav_divy_rproxyhttpport_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The HTTP connection port number of reverse-proxy."),
	AP_INIT_TAKE1("TfRProxyHttpsPort", dav_divy_rproxyhttpsport_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The HTTPS connection port number of reverse-proxy."),
	AP_INIT_TAKE1("TfSysCgiConnectPort", dav_divy_syscgiconnectport_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The port number connecting from System-CGI."),
	AP_INIT_TAKE1("TfSysCgiConnectSchema", dav_divy_syscgiconnectschema_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The schema name connecting from System-CGI."),
	AP_INIT_TAKE1("TfNotifyServerPort", dav_divy_notifyserverport_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The port number for notifyaction"),
	AP_INIT_TAKE1("TfNotifyServerSchema", dav_divy_notifyserverschema_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The schema name for notifyaction"),
	AP_INIT_TAKE1("TfLogOperation", dav_divy_logoperation_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Operation-Log function."),
	AP_INIT_TAKE1("TfGroupConstraints", dav_divy_grpconstraints_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Group-Constraints function."),
	AP_INIT_FLAG("TfLicenseUploader", dav_divy_licenseuploader_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable license-uploader function."),
	AP_INIT_FLAG("TfGroupLeader", dav_divy_groupleader_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable group-leader function."),
#ifdef DIVY_SUPPORT_PASSPOLICY
	AP_INIT_RAW_ARGS("TfPassPolicyExclusion", dav_divy_passpolicyexclusion, NULL,
			RSRC_CONF | ACCESS_CONF, "Exclusion rule using by IP or UserID for Password-Policy."),
#endif	/* DIVY_SUPPORT_PASSPOLICY */
	AP_INIT_FLAG("TfConfirmReading", dav_divy_confirmreading_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Confirm-Reading function."),
	AP_INIT_TAKE1("TfConfirmReadingReservedDay", dav_divy_confirmreading_reservedday_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "The reservation day of confirmreading until auto-deletion."),
	AP_INIT_FLAG("TfExtendSysmsg", dav_divy_extendsysmsg_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Extend-Sysmsg function."),
	AP_INIT_FLAG("TfGroupQuota", dav_divy_groupquota_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable Group-Quota function."),
	AP_INIT_RAW_ARGS("TfAdminAllowIP", dav_divy_admin_allow_ip_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Allow IP adress mask for administrator."),
	AP_INIT_FLAG("TfDisableWebFolderLink", dav_divy_disable_webfolder_link_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Disable Browser WebFolderLink."),
	AP_INIT_FLAG("TfDisableChangePassword", dav_divy_disable_change_password, NULL,
			RSRC_CONF | ACCESS_CONF, "Disable Browser change password."),
	AP_INIT_TAKE1("TfMasterPassword", dav_divy_master_password, NULL,
			RSRC_CONF | ACCESS_CONF, "Master Password"),
	AP_INIT_TAKE1("TfUploadOnlyUserisdownloadAllowTime",
			dav_divy_upload_only_user_is_download_allow_time, NULL,
			RSRC_CONF | ACCESS_CONF, "upload only user is download allow time."),
	AP_INIT_FLAG("TfUseSession", dav_divy_use_session, NULL,
			RSRC_CONF | ACCESS_CONF, "Use browser session"),
	AP_INIT_TAKE1("TfSessionTimeOut",
			dav_divy_session_timeout, NULL,
			RSRC_CONF | ACCESS_CONF, "The Browser session time out."),
	AP_INIT_FLAG("TfAccessControl", dav_divy_use_access_control, NULL,
			RSRC_CONF | ACCESS_CONF, "Use Access Control"),
	AP_INIT_TAKE1("TfDefaultAccessRule", dav_divy_default_access_rule, NULL,
			RSRC_CONF | ACCESS_CONF, "default access control rule"),
	AP_INIT_TAKE123("TfFailedLoginControl", dav_divy_failed_login_lockout, NULL,
			RSRC_CONF | ACCESS_CONF, "failed login control"),
	AP_INIT_FLAG("TfShortenURL", dav_divy_shorten_url, NULL,
			RSRC_CONF | ACCESS_CONF, "Use shorten url"),
	AP_INIT_FLAG("TfBOX", dav_divy_tfbox_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable BOX(share) function."),
	AP_INIT_RAW_ARGS("TfServerPolicy", dav_divy_serverpolicy_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "server policy"),
	AP_INIT_FLAG("TfUseMemcache", dav_divy_usememcache_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Enable memcache function."),
	AP_INIT_RAW_ARGS("TfMemcacheServers", dav_divy_memcache_servers_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "memcached servers."),
	AP_INIT_FLAG("TfUseSAML", dav_divy_use_saml_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "Use SAML"),
	AP_INIT_TAKE1("TfSAMLIdPMetaDataPath", dav_divy_saml_idp_meta_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "SAML IdP metadata file path"),
	AP_INIT_TAKE1("TfSAMLXMLPrivateKeyPath", dav_divy_saml_privatekeypath_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "SAML XML Private Key Path"),
	AP_INIT_TAKE1("TfSAMLXMLPublicCertificatePath", dav_divy_saml_x509certificatepath_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "SAML XML Public Certificate Path"),
	AP_INIT_FLAG("TfSAMLMatchedMailAddr",  dav_divy_saml_nameid_match_mailaddr, NULL,
		RSRC_CONF | ACCESS_CONF, "SAML NameID matched TeamFile MailAddress"),
	AP_INIT_TAKE1("TfCustomImagePath", dav_divy_custom_image_path_cmd, NULL,
			RSRC_CONF, "Custom image Path"),
	AP_INIT_FLAG("TfUseUploadPolicy", dav_divy_use_uploadpolicy_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "use upload policy function."),
	AP_INIT_FLAG("TfTwoFactorAuthentication", dav_divy_use_2fa_cmd, NULL,
			RSRC_CONF | ACCESS_CONF, "use Two Factor Authentication function."),
	AP_INIT_TAKE12("TfTwoFactorAuthenticationCycle", dav_divy_2fa_cycle, NULL,
			RSRC_CONF | ACCESS_CONF, "Cycle for Two Factor Authentication function."),
	AP_INIT_TAKE1("TfTwoFactorAuthenticationType", dav_divy_2fa_type, NULL,
			RSRC_CONF | ACCESS_CONF, "Type for Two Factor Authentication function."),
	AP_INIT_TAKE1("TfTwoFactorAuthenticationStage", dav_divy_2fa_stage, NULL,
			RSRC_CONF | ACCESS_CONF, "Use stage for Two Factor Authentication function."),
#ifdef TF_SUPPORT_CIPHER_STORAGE
	AP_INIT_FLAG("TfFsCipherStorage", dav_divy_cipher_storage, NULL,
			RSRC_CONF | ACCESS_CONF, "The cipher of storage."),
	AP_INIT_TAKE1("TfFsCipherKey", dav_divy_cipher_storage_key, NULL,
			RSRC_CONF | ACCESS_CONF, "The cipher storage key. please set to file path or PassPhrase."),
	AP_INIT_TAKE1("TfFsCipherType", dav_divy_cipher_storage_cipher_type, NULL, RSRC_CONF | ACCESS_CONF, "The cipher storage type. \"des-cfb, des-ofb, des3-cfb, des3-ofb, bf-cfb, bf-ofb, cast5-ofb, case5-cfb, aes128-cfb, aes128-ofb, aes192-cfb, aes192-ofb, aes256-cfb, aes256-ofb\""),
#endif
	{NULL}
};

/**
 * Dispatch list for API hooks
 */
AP_DECLARE_MODULE(dav_tf) = {
    STANDARD20_MODULE_STUFF, 
    dav_divy_create_dir_config,     /* create per-dir    config structures */
    dav_divy_merge_dir_config,      /* merge  per-dir    config structures */
    dav_divy_create_server_config,  /* create per-server config structures */
    dav_divy_merge_server_config,   /* merge  per-server config structures */
    dav_divy_cmds,                  /* table of config file commands       */
    dav_divy_register_hooks         /* register hooks                      */
};


