/***************************************************************************
                          rmmgr.h  -  relocatable memory manager
                             -------------------
    begin                : Fri.  Apr., 2 2004
    copyright            : (C) 2004 Teamfile team
    email                : jiang-lei@8107.co.jp
 ***************************************************************************/
#ifndef RMMGR_H
#define RMMGR_H
/*
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
*/
#include <apr.h>
#include <apr_strings.h>
#ifdef RM_DEBUG
#include <assert.h>
#endif /* RM_DEBUG */


#define RM_MAGIC           0xD9A38968
#define RM_MIN_RAW_LEN     64*1024	
#define RM_DEFAULT_MARGIN  1024	
#ifdef RM_DEBUG
#define RM_ASSERT(x)          assert(x)
#define RM_VERIFY(x)          RM_ASSERT(x)
#define RMMalloc(pMgr, size)  RMMallocDebug(pMgr, size, __FILE__, __LINE__)
#define RMCalloc(pMgr, size)  RMCallocDebug(pMgr, size, __FILE__, __LINE__)
#else /* RM_DEBUG */
#define RM_ASSERT(x)          ((void)0)
#define RM_VERIFY(x)          (x)
#endif /* RM_DEBUG */

typedef unsigned long RM_SIZE_T;
typedef unsigned long RM_OFF_T;
typedef RM_OFF_T RM_USER_DATA_T;
typedef RM_OFF_T RM_HANDLE;

typedef enum tagRMLOCKTYPE {
  RMLTREADLOCK,
  RMLTWRITELOCK,
  RMLTUNLOCK
} RMLOCKTYPE;

typedef enum tagRMRESULT {
  RMRSOK,
  RMRSINVALIDARG,		/* invalid argument(s) */
  RMRSNOMOREBLOCKS,		/* maximum block number reached */
  RMRSMAGICMISMATCH		/* manager magic mismatch */
} RMRESULT;

typedef void (*RMLOCKCB) (RMLOCKTYPE enuLockType, void *pvUserData);

typedef struct tagRMManager {
  void   *pBaseAddress;

  RMLOCKCB pfnLockCB;
  void   *pvLockData;		

  RMRESULT enuLastError;

  RM_SIZE_T unSize;
} RMMANAGER;

typedef struct tagRMSizePair {
  RM_SIZE_T unFirst;
  RM_SIZE_T unSecond;
} RMSIZEPAIR;


typedef struct tagRMFixedMngData {
  unsigned int nRMMagic;
  unsigned int sAllocCounter;
  unsigned int sFreeCounter;

  RM_SIZE_T unMargin;
  RM_SIZE_T unMngAreaLength;

  RM_SIZE_T unStgAreaLength;
  RM_SIZE_T unStgUsed;

  int     sRecordStackMax;
  int     sAllocatedBlockCount;
  int     sAvailableBlockCount;

  short   sAttachedManagerCount;
  RM_USER_DATA_T unUserData;
} RMFIXEDMNGDATA;

typedef struct tagRMBlockRec {
  unsigned int sBlockNo;
  RM_OFF_T unBlockHead;
  RM_SIZE_T unBlockLength;

#ifdef RM_DEBUG
  const char *pszFile;
  int     nLine;
#endif				/* RM_DEBUG */

} RMBLOCKREC;


RMRESULT RMCreate (RMMANAGER * pRMManager, void *pBaseAddress,
		   RM_SIZE_T unRawLength, int sMaxBlocks,
		   RMLOCKCB pfnLockCB, void *pvLockData);
RMRESULT RMAttach (RMMANAGER * pRMManager, void *pBaseAddress,
		   RMLOCKCB pfnLockCB, void *pvLockData);
RMRESULT RMSetUserData (RMMANAGER * pRMManager, RM_USER_DATA_T UserData);
RMRESULT RMGetUserData (RMMANAGER * pRMManager, RM_USER_DATA_T * pUserData);
 /*RMRESULT RMDumpState(RMMANAGER* pRMManager, FILE* pOutput, int bDumpBlockInfo); */
void    RMSetLockCallback (RMMANAGER * pRMManager, RMLOCKCB pfnLockCB,
			   void *pvUserData);

#ifdef RM_DEBUG
RM_HANDLE RMMallocDebug (RMMANAGER * pRMManager, RM_SIZE_T unSize,
			 const char *pszFile, int nLine);
RM_HANDLE RMCallocDebug (RMMANAGER * pRMManager, RM_SIZE_T unSize,
			 const char *pszFile, int nLine);
#else
RM_HANDLE RMMalloc (RMMANAGER * pRMManager, RM_SIZE_T unSize);
RM_HANDLE RMCalloc (RMMANAGER * pRMManager, RM_SIZE_T unSize);
#endif /* RM_DEBUG */

RM_HANDLE RMRealloc (RMMANAGER * pRMManager, RM_HANDLE hMem,
		     RM_SIZE_T unNewSize);
void   *RMHandleToPtr (RMMANAGER * pRMManager, RM_HANDLE hMem);
void    RMFree (RMMANAGER * pRMManager, RM_HANDLE hMem);
RM_SIZE_T RMGetMargin (RMMANAGER * pRMManager);
void    RMSetMargin (RMMANAGER * pRMManager, RM_SIZE_T unNewValue);
void    RMPurge (RMMANAGER * pRMManager);

int     rmGetMaxBlockCount (RMMANAGER * pRMManager);
int     rmGetAllocatedBlockCount (RMMANAGER * pRMManager);
RMRESULT rmGetAllocatedBlock (RMMANAGER * pRMManager, int nIndex,
			      RMBLOCKREC * pRec);
int     rmGetAvailableBlockCount (RMMANAGER * pRMManager);
RMRESULT rmGetAvailableBlock (RMMANAGER * pRMManager, int nIndex,
			      RMBLOCKREC * pRec);
int     rmGetMngAreaLength (RMMANAGER * pRMManager);
int     rmGetStgAreaLength (RMMANAGER * pRMManager);
int     rmGetStgUsage (RMMANAGER * pRMManager);
int     rmGetAllocCount (RMMANAGER * pRMManager);
int     rmGetFreeCount (RMMANAGER * pRMManager);


typedef RM_HANDLE (*RMULINSERTCALLBACK) (RMMANAGER * pRMMgr, void *pUserData);
typedef void (*RMULREMOVECALLBACK) (RMMANAGER * pRMMgr, RM_HANDLE hUserData);

typedef enum tagRMURESULT {
  RMUOK,
  RMUNOTIMPLEMENTED,		/* feature not implemented */
  RMUINVALIDARG,		/* invalid argument(s) */
  RMUMALLOCFAILED,		/* malloc failed */
  RMUDATACORRUPTED,		/* data corrupted */
  RMUNOMOREELEMENT,		/* no more element(at the beginning or the end of list) */
  RMUEMPTYLIST,			/* list is empty */
  RMUINVALIDPOSITION		/* current position is invalid */
} RMURESULT;

typedef struct tagRMULISTNODE {
  RM_HANDLE hData;
  RM_HANDLE hPrev;
  RM_HANDLE hNext;
} RMULISTNODE;

typedef struct tagRMULISTWALKER {
  RM_HANDLE hHead;
  RMULISTNODE *pHead;
  RM_HANDLE hTail;
  RMULISTNODE *pTail;
  RM_HANDLE hCurrent;
  RMULISTNODE *pCurrent;
} RMULISTWALKER;

typedef struct tagRMULIST {
  RMMANAGER *pRMMgr;
  RM_HANDLE *phHead;
  RMULISTWALKER stWalker;
          RMULINSERTCALLBACK pfnInsertCB;
          RMULREMOVECALLBACK pfnRemoveCB;
} RMULIST;

RM_HANDLE RMUstrdup (RMMANAGER * pRMMgr, const char *pszSrc, char **ppszDst);

RMURESULT RMUListCreate (RMMANAGER * pRMMgr, RMULIST * pList,
			 RMULINSERTCALLBACK pfnInsertCB,
			 RMULREMOVECALLBACK pfnRemoveCB, RM_HANDLE * phHead);
RMURESULT RMUListAttach (RMMANAGER * pRMMgr, RMULIST * pList,
			 RMULINSERTCALLBACK pfnInsertCB,
			 RMULREMOVECALLBACK pfnRemoveCB, RM_HANDLE * phHead);
RMURESULT RMUListDestroy (RMULIST * pList);
int     RMUListIsEmpty (RMULIST * pList);
RMURESULT RMUListInsertHead (RMULIST * pList, void *pUserData);
RMURESULT RMUListInsertTail (RMULIST * pList, void *pUserData);
RMURESULT RMUListRemoveHead (RMULIST * pList);
RMURESULT RMUListRemoveTail (RMULIST * pList);
RMURESULT RMUListRemoveCurrent (RMULIST * pList);
RMURESULT RMUListGoToHead (RMULIST * pList);
RMURESULT RMUListGoToTail (RMULIST * pList);
RMURESULT RMUListGoTo (RMULIST * pList, unsigned int unPos);
RMURESULT RMUListPrev (RMULIST * pList);
RMURESULT RMUListNext (RMULIST * pList);
RMURESULT RMUListGetData (RMULIST * pList, RM_HANDLE * phData);
RM_HANDLE RMUListGetHead (RMULIST * pList);
#endif /* RMMGR_H */
