/**
 * $Id$
 *
 * BOX周りの操作を行う関数、構造体の定義&宣言
 *
 * (note)
 *  BOX対応するための関数群が定義されています.
 */
#include "apr.h"
#include "apr_pools.h"
#include "apr_strings.h"
#include "apr_hash.h"
#include "apr_time.h"
#include "apr_network_io.h"
#include "httpd.h"
#include "http_protocol.h"
#include "mod_dav.h"

#include "mod_dav_tf.h"
#include "tf_parser.h"
#include "tf_rdbo_box.h"
#include "tf_box.h"
#include "tf_autoindex.h"
#include "util.h"
#include "util_auth.h"

APLOG_USE_MODULE(dav_tf);

/**
 * BOX機能をサポートしているか？
 */
DIVY_DECLARE(int) divy_support_tfbox(request_rec *r)
{
	dav_divy_dir_conf *dconf = dav_divy_get_dir_config(r);

	if (dconf->tfbox == DIVY_TFBOX_ON) {
		return 1;
	}

	return 0;
}

/**
 * 短縮URLが有効化どうか
 *
 */
DIVY_DECLARE(int) divy_enable_box_shorten(request_rec *r, const dav_resource *resource) 
{
	divy_uri_spec *u_spec = resource->info->rdb_r->u_spec;
	divy_linkedlist_t *ll;
	apr_hash_t *parsed_h = NULL;

	TRACE(r->pool);

	if (u_spec == NULL) 
		return 0;

	if (u_spec->infotype != DIVY_INFOTYPE_shorten) {
		return 0;
	}

	/* BOXとして処理をしていい短縮のURLなのかを調べます */
	/* URLのパラメータにcmd=boxの場合だけBOXとして処理をさせます */
	if (dav_divy_parse_urlparam(r->pool, r->args, &parsed_h) == 0) {
		if (parsed_h != NULL) {
			ll = apr_hash_get(parsed_h, DIVY_URIPARAM_CMD, APR_HASH_KEY_STRING);
			if ((ll != NULL) && strcmp(ll->val, DIVY_CMD_BOX) == 0) {
				return 1;
			}
		}
	}

	return 0; /* BOXが有効なURLではない */
}

