/**
 * $Id$
 *
 * エラーロガー関数の定義
 *
 */
#include "apr.h"
#include "apr_strings.h"
#include "apr_pools.h"
#include "httpd.h"
#include "http_log.h"
#include "tf_logger.h"
#include "tf_valuecache.h"

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Declare private functions
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Define public functions
  ----------------------------------------------------------------------------*/
/**
 * エラーロガーコンテキストを生成する.
 *
 */
DIVY_DECLARE(divy_errlog_ctx *) divy_logger_create(request_rec *r)
{
	divy_errlog_ctx *lctx;

	if (r == NULL) return NULL;
	lctx = apr_pcalloc(r->pool, sizeof(divy_errlog_ctx));

	lctx->s        = r->server;
	lctx->usrid    = "-";	/* この時点では取得できないかもしれない */
	lctx->location = "-";   /* この時点では取得できないかもしれない */

	/* キャッシュする */
	divy_pcache_set_data(r->pool, lctx, DIVY_PCACHE_DAT_REQ_LOGENV);

	return lctx;
}

/**
 * エラーロガーコンテキストにアクセスユーザIDを書き込む.
 *
 */
DIVY_DECLARE(void) divy_logger_set_userid(request_rec *r, const char *usrid)
{
	divy_errlog_ctx *lctx;

	if (r == NULL || IS_EMPTY(usrid)) return;

	if ((lctx = divy_pcache_get_data(r->pool, DIVY_PCACHE_DAT_REQ_LOGENV)) != NULL) {
		lctx->usrid = apr_pstrdup(r->pool, usrid);
	}
}

/**
 * エラーロガーコンテキストにロケーション名を書き込む.
 *
 */
DIVY_DECLARE(void) divy_logger_set_location(request_rec *r, const char *location)
{
	divy_errlog_ctx *lctx;

	if (r == NULL || IS_EMPTY(location)) return;

	if ((lctx = divy_pcache_get_data(r->pool, DIVY_PCACHE_DAT_REQ_LOGENV)) != NULL) {
		lctx->location = apr_pstrdup(r->pool, location);
	}
}

/**
 * level のエラーメッセージmsg をロガーで出力する.
 * (ERRLOG0 - ERRLOG3 までのマクロが利用できない場合に限定して使用すること)
 *
 */
DIVY_DECLARE(void) divy_logger_outmsg(request_rec *r, int level, const char *msg)
{
	divy_errlog_ctx *lctx = NULL;

	if (IS_EMPTY(msg)) return;

	if (r != NULL) {
		const char *location = "-", *usrid = "-";
		lctx = divy_pcache_get_data(r->pool, DIVY_PCACHE_DAT_REQ_LOGENV);

		if (IS_FILLED(lctx->location)) {
			location = lctx->location;
		}
		if (IS_FILLED(lctx->usrid)) {
			usrid = lctx->usrid;
		}

		ap_log_error(NULL, 0, APLOG_MODULE_INDEX, level, 0, r->server, "%s %s %s", location, usrid, msg);
//					apr_psprintf(r->pool, "%s %s %s", location, usrid, msg));
	}
	else {
		char PREFIX_MSG[] = "- - ";
		char *s;
		int hlen = strlen(PREFIX_MSG);
		int slen = strlen(msg);
		int len  = slen + hlen;

		s = malloc(len + 1);
		memcpy(s, PREFIX_MSG, hlen);
		memcpy(s + hlen, msg, slen);
		s[len] = '\0';

		ap_log_error(NULL, 0, APLOG_MODULE_INDEX, level, 0, NULL, "%s", s);
		free(s);	// クリアーする */
	}
}

