/**
 * $Id$
 *
 * tf_misc.c
 *
 * tf_misc.h の実装。ヘッダファイルのコメントにも書きましたが、この
 * ファイルは動的に切り離せる機能をコールするためのヘルパー関数が
 * 定義されているだけです。本機能の実装は、別のどこかのファイルに
 * 書かれていますが、このファイルが知ったことではありません。
 * なので、本機能をここに実装しようとはしないで下さい。そのような
 * 試みの全ては、このファイルの存在意義から考えると、誤りです。
 *
 */
#include "apr.h"
#include "apr_pools.h"
#include "apr_strings.h"
#include "apr_hooks.h"
#include "tf_misc.h"

/*------------------------------------------------------------------------------
  Define Hook structure and function
  ----------------------------------------------------------------------------*/
/**
 * Hook構造体の定義と生成
 */
APR_HOOK_STRUCT(
	APR_HOOK_LINK(get_miscfunction)
	)

/**
 * 指定されたtype、name を定義するプロバイダであったとき、その機能を提供する
 * 関数を返却する構造体を作成 & 返却する。(セミコロンは付けないで下さい。)
 * (note)
 * 	type, name と一致しないプロバイダであった場合、MISC_DECLINED を返却し
 * 	関数へのポインタを返却しないこと。
 * 	逆に一致した場合、MISC_OK を返却し、関数へのポインタを返却すること。
 */

APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(divy, DIVY, int, get_miscfunction,
		(apr_pool_t *p, const char *func_t_name, void **func_p),
		(p, func_t_name, func_p), MISC_DECLINED)

/*-----------------------------------------------------------------------------
  Define public functions
  ---------------------------------------------------------------------------*/
/**
 * fromfmt でエンコードされている文字列fromstr を、tofmtでエンコードされている
 * 文字列tostrに変換して返却する。
 * (note)
 * 	tostr には(strlen(fromstr)*4+1) 文字分の領域を確保します。
 * 	fromstrの文字列はfromfmtが示すエンコードと一致していなければ
 * 	なりません。(失敗します)
 * (note)
 * 	この関数は、divy_misc_functions のポインタencode_str のヘルパーです。
 *
 * @param p apr_pool_t * 文字列を割り当てるプール
 * @param fromfmt const char * 変換前のエンコード
 * @param tofmt const char *   変換後のエンコード
 * @param fromstr char * 変換前の文字列
 * @param tostr char **  変換後の文字列
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_misc_encode_str(apr_pool_t *p, const char *fromfmt,
				const char *tofmt, char *fromstr, char **tostr)
{
	int ret;
	encode_str_t func;

	/* 実装を提供する関数を探す */
	ret = divy_run_get_miscfunction(p, "encode_str_t", (void **)&func);
	if (ret != MISC_OK) {
		/* モジュールが登録されていなければ何もしない */
		*tostr = fromstr;
		return 0;
	}

	/* 関数の実行 */
	return func(p, fromfmt, tofmt, fromstr, tostr);
}


