/**
 * $Id$
 *
 * メールプロバイダアクセス用関数の定義
 * tf_ml.c
 *
 */
#ifdef HAVE_CONFIG_H
#ifndef INCLUDE_UTIL_CONFIG_H
#define INCLUDE_UTIL_CONFIG_H
#include "config.h"
#endif	/* INCLUDE_UTIL_CONFIG_H */
#endif	/* HAVE_CONFIG_H */

/* Apache header files */
#include "apr.h"
#include "apr_pools.h"
#include "apr_hooks.h"

/* document management headers */
#include "tf_ml.h"

/*------------------------------------------------------------------------------
  Define Hook structure and function
  ----------------------------------------------------------------------------*/
/*
 * Hook構造体の定義と生成
 */
APR_HOOK_STRUCT(
	APR_HOOK_LINK(create_mldatasource)
	)

/**
 * 指定されたproviderType に一致するメールプロバイダであった時、
 * メールプロバイダ構造体を作成 & 返却する関数
 * のためのHook関数宣言。
 * メールプロバイダの初期化に利用します。
 */
APR_IMPLEMENT_EXTERNAL_HOOK_RUN_FIRST(divy, DIVY, int, create_mldatasource,
		(apr_pool_t *p, const char *providerType, MlDataSource **mlds),
		(p, providerType, mlds), ML_DECLINED)


/*--------------------------------------------------------------
 *   Define Private Functions
 *--------------------------------------------------------------*/

