/**
 * $Id$
 *
 * util_thread.c
 *
 * スレッド専用ユーティリティ関数
 *
 * 2003/12/24 Wed takehara NEW
 */
#ifdef HAVE_CONFIG_H
#ifndef INCLUDE_UTIL_CONFIG_H
#define INCLUDE_UTIL_CONFIG_H
#include "config.h"
#endif	/* INCLUDE_UTIL_CONFIG_H */
#endif	/* HAVE_CONFIG_H */

#include "apr.h"
#include "apr_lib.h"
#include "apr_portable.h"
#if APR_HAVE_PTHREAD_H
#include <pthread.h>
#endif

#include "util_thread.h"

/*--------------------------------------------------------------
  Define global value
  --------------------------------------------------------------*/
/**
 * MPMの種類を記録するグローバル変数
 * (ライフサイクル)
 * 	Child の生存期間と一致
 */
static divy_mpm_type _mpm_type = DIVY_MPM_TYPE_PROCESS;

/*--------------------------------------------------------------
  Define public function
  --------------------------------------------------------------*/
/**
 * 指定されたsignum のシグナルだけをアンブロックする。
 *
 */
DIVY_DECLARE(void) dav_divy_unblock_signal(int signum, int consider_mpm)
{
	sigset_t sig_mask;

	/* スレッドタイプのMPMの場合には、シグナルをブロックしない */
	if (consider_mpm && (_mpm_type == DIVY_MPM_TYPE_THREAD)) {
		return;
	}

	sigemptyset(&sig_mask);
	sigaddset(&sig_mask, signum);

#if defined(SIGPROCMASK_SETS_THREAD_MASK)
	sigprocmask(SIG_UNBLOCK, &sig_mask, NULL);
#else
	pthread_sigmask(SIG_UNBLOCK, &sig_mask, NULL);
#endif
}

/**
 * 指定されたthread_id が示すスレッドを取り消す(cancel)
 *
 */
DIVY_DECLARE(int) dav_divy_thread_cancel(apr_thread_t *thread_id)
{
	apr_status_t rv;
	apr_os_thread_t *os_thread;

	/* プラットフォーム独自のネイティブスレッド識別子を取得する */
	rv = apr_os_thread_get(&os_thread, thread_id);
	if (rv != APR_SUCCESS) {
		return 1;
	}

	/* 取り消しを要求する */
	return pthread_cancel(*os_thread);
}

/**
 * MPM の種類(プロセス型であるかスレッド型であるか)を設定する
 * この結果をスレッド動作の決定に使用します。
 * (note)
 * 	この関数は1プロセスに付き1度だけコールされるよう呼び出し元にて
 * 	保証して下さい。
 *
 * @param mpm_type divy_mpm_type MPMの種類を設定する
 */
DIVY_DECLARE(void) dav_divy_set_mpm_type(divy_mpm_type mpm_type)
{
	/* グローバル変数に設定する
	 * (note) 処理が競合しても気にしない。
	 */
	_mpm_type = mpm_type;
}


