/*
 * オプションを解析する
 *
 * $Id$
 */

#ifndef __TF_CMD_UTIL_PKGETOPT_H_
#define __TF_CMD_UTIL_PKGETOPT_H_

#include <map>
#include <onion/Utils.h>

#define		BADPRM		(int)0
#define		PKOPTOK		(int)1

class CPKGetOpt
{
private:
	typedef		std::map<OI_STRING_A, OI_STRING_A>	PK_STRING_MAP;

public:
	CPKGetOpt(int argc, char* const argv[], const char* optstring);
	~CPKGetOpt(void);
	int GetNextValue(OI_STRING_A& strValue);
	bool HasKey(const char* key);
	const char* GetLastError(void);

protected:
	void parse(int argc, char* const argv[], const char* optstring);
	void clear(void);
private:
	void addMap(OI_STRING_A strKey, OI_STRING_A strValue);
		
private:
	PK_STRING_MAP			m_mapOpts;
	PK_STRING_MAP::iterator m_mapIt;
	int						m_nResult;		// 内容の結果
	OI_STRING_A				m_strError;		// エラー文字
};



#endif
