/*
 * $Id$
 */

#ifndef __TF_CMD_PKTRANSACTIONHANDLER_H_
#define __TF_CMD_PKTRANSACTIONHANDLER_H_

#include "libteamfile/TFWsTransactionHandler.h"

class CPKTransactionHandler : public CTFWsTransactionHandler
{
public:
	CPKTransactionHandler(void);
	~CPKTransactionHandler(void);

	virtual void OnResultDAVMethod(const int nOIResult, const TFXMLCh* pszURI, TFDAVMETHOD enuMethod);

	/**
	 *	エラーが発生した際に戻ってくるハンドラ
	 *	@param oResult		OI_RESULT
	 *	@param	pszURI			const TFXMLCh*
	 *	@param	enuMethod		const TFDAVMETHOD
	 *	@return void
	 */
	virtual void OnErrorPrint(const int nOIResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod);

	virtual bool OnDebugExtString(TF_STRING_A& szExtString);

	virtual void OnDebugPrint(const char* pszString);

protected:
	int 					m_nResult;			///< onionの戻り値
	TF_STRING_W				m_strLastURI;		///< リクエストを出した最後のURI
	TFDAVMETHOD				m_enuLastMethod;	///< リクエストを出した最後のメソッド
	CTFLocalFileItem*		m_pItem;			///< デバック出力アイテム

};

#endif
