#include "PKCmdBase.h"
#include "PKGetOpt.h"
#include <stdlib.h>
#include <libteamfile/TFURL.h>
#include <libteamfile/TFServerResource.h>
#include <libteamfile/TFLocalFileUtils.h>
#include <libteamfile/TFPlatformsFactory.h>
#include <time.h>
#include <algorithm>
#include <sstream>

#ifdef SetPort
#undef SetPort
#endif

#ifdef _WIN32
#define USE_WINHTTP
#ifdef USE_WINHTTP
#include <winhttp.h>
#else
#include <wincon.h>
typedef int (*TFAPXY)(const char*, int*, char*, int*); 
#endif
#endif

CPKCmdBase::CPKCmdBase(void)
:m_enuResult(TF_CMD_OK),
 m_enuOutFmt(PKCMDOUTFMT_NONE)
{
	TFInitialize();
	GetServerManager().AddHandler(&m_cSysHandler);
	m_pItem = NULL;

}

CPKCmdBase::~CPKCmdBase(void)
{
	if (m_pItem)
	{
		CTFPlatformsFactory* pFactory = NULL;
		pFactory = new CTFPlatformsFactory;
		CTFLocalFileUtils* pUtils = pFactory->CreateLocalFileUtils();
		pUtils->Close(*m_pItem);

		if (pUtils) delete pUtils;
		if (pFactory) delete pFactory;
		delete m_pItem;
	}

	TFTerminate();
}

int
CPKCmdBase::Execute(int nArgc, char* const pszArgv[])
{
	CTFServerResource cSvrItem;
	OI_STRING_A	strOptBase;
	OI_STRING_A strValue;
	OI_STRING_A	strUsage;
	CTFURL		cURL;
	CMDMODE		enuMode = TFCMD_NONE;

	int			ch;
	bool		bResult = true;
	unsigned int nTimeOut= 10;

	strOptBase = "U:P:H:T:G:X:Y:S:VD:M:O:Z?f";

#ifdef _WIN32
	// win32
	::SetConsoleCtrlHandler(SignalHandler, TRUE);
#else
	// linux
#endif

#if 0
// 有効期限ハードコード============================
	struct tm t;
	t.tm_sec  = 0;
	t.tm_min  = 0;
	t.tm_hour = 23;
	t.tm_mday = 30;
	t.tm_mon  = 5;		// 0が1月
	t.tm_year = 2005-1900;
	time_t deadtime = mktime(&t);
	if (deadtime < time(NULL))
	{
		printf("sorry! license expired. \n");
		return TF_CMD_EXE_EXPIRED;
	}
// 有効期限ハードコード============================
#endif

	OnQueryProgramInfo(m_info);
	OnKnownOptions(m_strOpt);
	getEnv(cSvrItem);

	strOptBase += m_strOpt;
	CPKGetOpt cGetopt(nArgc, pszArgv, strOptBase.c_str());
	
	while ((ch = cGetopt.GetNextValue(strValue)) != 0)
	{
		TF_STRING_B strByte;

#ifdef WIN32
		strByte = (const TFXMLByte*)X(strValue.c_str()).UTF8().c_str();
#else
		// check env LANG
		if (true) 
		{
			// isUTF8
			strByte = (const TFXMLByte*)strValue.c_str();
		}
		else 
		{
			// nonUTF8
			strByte = (const TFXMLByte*)X(strValue.c_str()).UTF8().c_str();
		}

		// TF_STRING_B strByte = (const TFXMLByte*)strValue.c_str();
#endif

		CTFLocalFileUtils*   pUtils   = NULL;

		switch(ch)
		{
			case 'U':	// ユーザ名
				cSvrItem.SetUserID(C2W(strByte.c_str()));
				break;

			case 'P':	// パスワード
				cSvrItem.SetPassWord(C2W(strByte.c_str()));
				break;

			case 'H':	// ホスト名
				setServerInfo(cSvrItem, strValue);
				break;

			case 'T':	// ソケットタイムアウト
				// TODO: atoi()じゃ駄目でしょ
				nTimeOut = atoi((const char*)X(strByte.c_str()));
				cSvrItem.SetSocketTimeout(nTimeOut);
				break;

			case 'G':	// プロキシ
				cURL.parseURL(C2W(strByte.c_str()));
				cSvrItem.SetProxyHost(cURL.m_strHost.c_str());
				cSvrItem.SetProxyPort(cURL.m_nPort);
				break;

			case 'O':	// 出力形式
				MakeLowerA(strValue);
				if (strValue.compare("xml")==0)
					m_enuOutFmt = PKCMDOUTFMT_XML;
				else
					m_enuOutFmt = PKCMDOUTFMT_PLAIN;
				break;

			case 'X':	// プロキシユーザID
				cSvrItem.SetProxyUserID(C2W(strByte.c_str()));
				break;

			case 'Y':	// プロキシパスワード
				cSvrItem.SetProxyPassWord(C2W(strByte.c_str()));
				break;

			case 'S':	// クライアントSSL証明書パス
				break;

			case 'V':	// おしゃベリモード
				m_bVerbose = true;
				SetFeature(CTFWsTransactionHandler::TF_TRANS_FEATURE_VERBOSE, m_bVerbose);
				break;

			case 'M':	// モード
				MakeLowerA(strValue);
				if (strValue.compare("add")==0)
					enuMode = TFCMD_ADD;
				else
				if (strValue.compare("delete")==0)
					enuMode = TFCMD_DELETE;
				else
				if (strValue.compare("update")==0)
					enuMode = TFCMD_UPDATE;
				else
				if (strValue.compare("view")==0)
					enuMode = TFCMD_VIEW;
				else
					enuMode = TFCMD_NONE;

				bResult = (enuMode != TFCMD_NONE);

				break;

			case 'Z':	// 圧縮受信要求
				cSvrItem.SetUseCompression(true);
				break;

			case 'D':	// デバックモード
				setDebugMode(strValue.c_str());
				break;

			case '?':	// ヘルプ
				bResult = false;
				break;

			default:	// 基本パラメータ以外
				bResult = OnFoundParam(ch, strByte.c_str());
				break;

		}

		if (!bResult) 
		{
			// ここでのエラーはパラメーターエラーとなる
			m_enuResult = TF_CMD_PRM_INVALID_PARAM;
			break;
		}

	}

	CTFServerResource* pSvrItem;

	if (bResult)
	{

		// サーバアイテムの追加に成功したらコマンドベースで用意されている
		// 内容のチェックをする。
		// アイテムは内部で複製をしてくれる
		if (GetServerManager().AddServerItem((CTFServerResource*)&cSvrItem))
		{
			if (cmdBaseValidate())
			{
				// 基本設定に問題がない場合はサーバアイテムを設定する
				pSvrItem= GetServerManager().GetServerItem(0);
				if (pSvrItem == NULL) return TF_CMD_FAIL;
#ifdef WIN32
				if (!TF_STRING_W(pSvrItem->GetProxyHost()).empty())
				{
					TF_STRING_W strProxy = pSvrItem->GetProxyHost();
					std::transform(strProxy.begin(), strProxy.end(), strProxy.begin(), toupper);
					if (strProxy.compare(C2W("AUTO")) == 0)
					{
#ifdef USE_WINHTTP
						TF_STRING_W szScriptLocation, szByPass;
						WINHTTP_CURRENT_USER_IE_PROXY_CONFIG pProxyConfig;
						if (WinHttpGetIEProxyConfigForCurrentUser(&pProxyConfig) == TRUE)
						{
							BOOL bDetectProxy = pProxyConfig.fAutoDetect;
							BOOL bUseScript = (pProxyConfig.lpszAutoConfigUrl != NULL);

							std::list<TF_STRING_W> slProxyServer, slProxyBypass;
							ParseHostNameList(pProxyConfig.lpszProxy, slProxyServer);
							ParseHostNameList(pProxyConfig.lpszProxyBypass, slProxyBypass);

							std::list<TF_STRING_W>::iterator it;
							TF_STRING_W szTemp, szTempProtcol, szTempHost;
							INT iTempPort = 0;
							for (it = slProxyServer.begin(); it != slProxyServer.end(); it++ )
							{
								szTemp = *it;
								ParseProtocolAndHostname(szTemp, szTempProtcol, szTempHost);
								if ((szTempProtcol.length() == 0) || (szTempProtcol.compare(cURL.m_strProtocol) == 0))
								{
									strProxy = szTempHost;
									break;
								}
							}
							if (pProxyConfig.lpszAutoConfigUrl != NULL)
								szScriptLocation = pProxyConfig.lpszAutoConfigUrl;
							if (pProxyConfig.lpszProxyBypass != NULL)
								szByPass = pProxyConfig.lpszProxyBypass;

							bResult = TRUE;
						}
						const char* pszUserAgent = TFCMDAGENT;
						HINTERNET hSession = ::WinHttpOpen(X(pszUserAgent), WINHTTP_ACCESS_TYPE_DEFAULT_PROXY,WINHTTP_NO_PROXY_NAME,WINHTTP_NO_PROXY_BYPASS,0 );
						WINHTTP_AUTOPROXY_OPTIONS pOption;
						WINHTTP_PROXY_INFO pInfo;

						ZeroMemory(&pOption, sizeof(WINHTTP_AUTOPROXY_OPTIONS));
						// PACファイルの場所が分かっている場合
						if (szScriptLocation.empty() == FALSE)
						{
							pOption.lpszAutoConfigUrl = szScriptLocation.c_str();
							pOption.dwFlags |= WINHTTP_AUTOPROXY_CONFIG_URL;
						}

						pOption.dwFlags |= WINHTTP_AUTOPROXY_AUTO_DETECT;
						pOption.dwAutoDetectFlags = WINHTTP_AUTO_DETECT_TYPE_DHCP | WINHTTP_AUTO_DETECT_TYPE_DNS_A;
						pOption.fAutoLogonIfChallenged = FALSE;

						// これで一気にProxyを見つけることができます。
						// WINHTTPのエラーは120+XXXになる。
						BOOL bResult = ::WinHttpGetProxyForUrl(hSession, cSvrItem.GetURL(), &pOption, &pInfo);
						if (bResult ==  FALSE) 
						{
							DWORD dwErr = ::GetLastError();

							switch (dwErr)
							{
								case ERROR_WINHTTP_UNABLE_TO_DOWNLOAD_SCRIPT:
								case ERROR_WINHTTP_BAD_AUTO_PROXY_SCRIPT:
								case ERROR_WINHTTP_AUTODETECTION_FAILED:
								case ERROR_WINHTTP_AUTO_PROXY_SERVICE_ERROR:
								case ERROR_WINHTTP_INCORRECT_HANDLE_TYPE:
								case ERROR_WINHTTP_INTERNAL_ERROR:
								case ERROR_WINHTTP_INVALID_URL:
								case ERROR_WINHTTP_LOGIN_FAILURE:
								case ERROR_WINHTTP_OPERATION_CANCELLED:
								case ERROR_WINHTTP_UNRECOGNIZED_SCHEME:
								case ERROR_NOT_ENOUGH_MEMORY:
								default:
									/* TODO Proxyのエラーは纏めてしまう */
									m_enuResult = TF_CMD_PRM_AUTH_PROXY_FAIL;
							}
						}

						::WinHttpCloseHandle(hSession);

						if (bResult)
						{
							TF_STRING_W szProxyByPass;
							if (pInfo.lpszProxyBypass != NULL)
								szProxyByPass = pInfo.lpszProxyBypass;

							if (szProxyByPass.empty() != FALSE)
							{
								// 無視するホストがあります。
							}

							TF_STRING_W szProxyString;
							if (pInfo.lpszProxy != NULL)
								szProxyString = pInfo.lpszProxy;
							TF_STRING_W szProxyHost;
							INT iProxyPort = 0;

							if (pInfo.lpszProxy) ::GlobalFree((HGLOBAL)pInfo.lpszProxy);
							if (pInfo.lpszProxyBypass) ::GlobalFree((HGLOBAL)pInfo.lpszProxyBypass);

							if (ParseHostnameAndPortNumber(szProxyString, szProxyHost, iProxyPort))
							{
								pSvrItem->SetProxyHost(C2W(szProxyHost.c_str()));
								pSvrItem->SetProxyPort(iProxyPort);
							}
							else {
								m_enuResult = TF_CMD_PRM_AUTH_PROXY_FAIL;
							}

						}

#else	/* USE_WINHTTP */

						HMODULE h;
						h = LoadLibrary(X("libapxy.dll"));
						if (h != NULL)
						{
							int nEnable = 0;
							char host[1024] = {0};
							int port=0;

							TFAPXY pAproxy = (TFAPXY)GetProcAddress(h, "tf_apxy_ie_resolvproxy");
							if (pAproxy != NULL)
							{
								pAproxy((const char*)X(pSvrItem->GetURL()), &nEnable, host, &port);
								if (nEnable)
								{
									pSvrItem->SetProxyHost(C2W(TF_STRING_A(host).c_str()));
									pSvrItem->SetProxyPort(port);
								}
							}
						}
						FreeLibrary(h);
#endif	/* not USE_WINHTTP */

					}
				}

#endif /* WIN32 */

				// ハンドラの登録
				m_cTrans.SetHandler(this);
				m_cTrans.SetHandler(&m_cSysHandler);
				m_cTrans.SetHandler(&m_cNotifyHandler);

				// トランザクションの開始
				m_cTrans.StartTrans(pSvrItem->GetServerID());

				m_enuResult = OnIsValid(enuMode);
				bResult = (m_enuResult == TF_CMD_OK);
			}
			else {
				bResult = false;
			}
		}
	}

	int nResult = 0;
	// 正常に動かせるなら起動を開始する
	if (bResult || m_enuResult == TF_CMD_OK)
	{
		// 実行本体
		nResult = OnExecute(enuMode, pSvrItem);
	}
	else
	{
		// 失敗
		if (m_enuResult >= TF_CMD_PRM_ENCODE_ERROR && m_enuResult <= TF_CMD_PRM_INVALID_PARAM)
		{
			printHELP();
			nResult = (int)m_enuResult;
		}
		else
		{
			nResult = m_enuResult;
		}
	}

	// トランザクションの停止
	m_cTrans.EndTrans();

#ifdef _DEBUG
	std::cerr << "result : " << nResult << std::endl;
#endif

	return nResult;
}

bool
CPKCmdBase::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{
	return true;
}

bool
CPKCmdBase::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{
	return true;
}

void 
CPKCmdBase::OnKnownOptions(OI_STRING_A& strOpt)
{
}

CMDRESULT
CPKCmdBase::OnIsValid(CMDMODE enuMode)
{
	return TF_CMD_OK;
}

bool
CPKCmdBase::cmdBaseValidate(void)
{

	bool bResult = false;

	CTFServerResource* pSvrItem = GetServerManager().GetServerItem(0);
	if (pSvrItem != NULL)
	{
		if (!pSvrItem->IsValid())
		{
			if (TF_STRING_W(pSvrItem->GetURI()).empty())
			{
				// URIが存在しなかった
				m_enuResult = TF_CMD_PRM_HOST_UNKNOWN;
			}
			else 
			if (pSvrItem->GetPort() < 1)
			{
				// ポート番号が不正
				m_enuResult = TF_CMD_PRM_PORT_UNKNOWN;
			}
			else
			if (TF_STRING_W(pSvrItem->GetUserID()).empty())
			{
				// ユーザIDが存在しなかった
				m_enuResult = TF_CMD_PRM_USER_UNKNOWN;				
			}
			else
			if (TF_STRING_W(pSvrItem->GetPassWord()).empty())
			{
				// パスワードが存在しなかった
				m_enuResult = TF_CMD_PRM_PASS_UNKNOWN;
			}
			else
			{
				// 不明なエラー
				m_enuResult = TF_CMD_PRM_INVALID_PARAM;
			}
		}
		else
		{
			bResult = true;
		}
	}

	return bResult;
}

void CPKCmdBase::printHELP(void)
{
	OI_STRING_A strUsage;
	std::cerr << m_info.strProgName << " " << m_info.strVersion << std::endl;
	std::cerr << "Usage: " << m_info.strProgName << " < Option configuration >" << std::endl;

	if (!m_info.strDisc.empty())
	{
		std::cerr << m_info.strDisc		<< " " << std::endl;
	}

	std::cerr << "<< Basic configuration >>" << std::endl;
	std::cerr << "-U\t user id(env :PKUSER)" << std::endl;
	std::cerr << "-P\t password(env:PKPASS)" << std::endl;
	std::cerr << "-H\t target host URI [http://host.domain/location/](env:PKHOST)" << std::endl;
	std::cerr << "-T\t socket time out" << std::endl;
#ifdef _WIN32
	// プロキシの自動検出ができるのはWindowsだけ
	std::cerr << "-G\t proxy host (auto = Proxy Search Windows only) " << std::endl;
#else
	std::cerr << "-G\t proxy host" << std::endl;
#endif
	std::cerr << "-X\t proxy user id" << std::endl;
	std::cerr << "-Y\t proxy password" << std::endl;
	std::cerr << "-S\t SSL client certificate file path (not implement)" << std::endl;
	std::cerr << "-V\t version" << std::endl;
	std::cerr << "-M\t mode [ add | delete | update | view ]" << std::endl;
//	std::cerr << "-F\t file (未実装)" << std::endl;
	std::cerr << "-O\t out of format [ xml | plain(defailt) ]" << std::endl;
	std::cerr << "-Z\t request for complesion (env:PKCOMP=[true|false])" << std::endl;
	std::cerr << "-D\t debug mode [ file path ] " << std::endl;
	std::cerr << "-?\t this help.\n" << std::endl;

	std::cerr << "<< " << m_info.strProgName << " Option configuration >>" << std::endl;
	OI_STRING_A::iterator it = m_strOpt.begin();
	for (int nKey=0; it != m_strOpt.end(); )
	{
		nKey = *it;
		if ((nKey > 0x2f && nKey < 0x3a) || (nKey > 0x60 && nKey < 0x7b) || (nKey == 'f'))
		{
			if (OnQueryUsage(nKey, strUsage))
				std::cerr << "-" << (const char)nKey << "\t " << strUsage.c_str() << std::endl;
		}

		it++;
	}

}

void 
CPKCmdBase::getEnv(CTFServerResource& cSvrItem)
{
	// PKHOST
	const char* pszURL = getenv(CMD_ENV_HOST);
	if (IS_FILLED(pszURL))
	{
		OI_STRING_A strURL = pszURL;
		setServerInfo(cSvrItem, strURL);	
	}
	
	// PKUSER
	const char* pszUser = getenv(CMD_ENV_USER);
	if (IS_FILLED(pszUser))
		cSvrItem.SetUserID(C2W(pszUser));
	
	// PKPASS
	const char* pszPass = getenv(CMD_ENV_PASS);
	if (IS_FILLED(pszPass))
		cSvrItem.SetPassWord(C2W(pszPass));

	// PKCOMP
	const char* pszComp = getenv(CMD_ENV_COMP);
	if (IS_FILLED(pszComp))
	{
		OI_STRING_A strValue = pszComp;
		TrimRightA(strValue);
		TrimLeftA(strValue);
		if (strValue.compare("true") == 0)
			cSvrItem.SetUseCompression(true);
		else
			cSvrItem.SetUseCompression(false);
	}

	// PKDEBUG
	const char *pszDebug = getenv(CMD_ENV_DEBUG);
	if (IS_FILLED(pszDebug))
	{
		setDebugMode(pszDebug);
	}

	// HTTP_PROXY
	const char* pszProxy = getenv(CMD_ENV_HTTP_PROXY);
	if (IS_FILLED(pszProxy))
	{
		OI_STRING_A strProxy = pszProxy;
		CTFURL cURL1(C2W(strProxy.c_str()));
		cURL1.m_strHost;
	}
#ifdef _WIN32
#define putenv	_putenv
#endif
	putenv((char*)CMD_ENV_HOST);
	putenv((char*)CMD_ENV_USER);
	putenv((char*)CMD_ENV_PASS);
	putenv((char*)CMD_ENV_COMP);
	putenv((char*)CMD_ENV_HTTP_PROXY);
#undef putenv
}

void
CPKCmdBase::setServerInfo(CTFServerResource& cSvrItem, const OI_STRING_A strURL)
{
	if (strURL.empty()) return;
	
	CTFURL cURL(C2W(strURL.c_str()));
	cSvrItem.SetName(cURL.m_strHost.c_str());		// 名前
	cSvrItem.SetServerID(cURL.m_strHost.c_str());	// サーバID
	cSvrItem.SetHost(cURL.m_strHost.c_str());		// ホスト名

	TF_STRING_W strURI = cURL.m_strURI.c_str();
	if (strURI[strURI.size()-1] != '/') strURI += C2W("/");
	cSvrItem.SetURI(strURI.c_str());				// URI
	cSvrItem.SetUseSSL(cURL.IsHTTPS());				// SSL
	if (cURL.m_nPort != 0)
	{
		cSvrItem.SetPort(cURL.m_nPort);			// ポート
	}
	else
	{
		if (cURL.IsHTTP())
			cSvrItem.SetPort(80);
		else
			cSvrItem.SetPort(443);
	}			
}


bool
CPKCmdBase::setDebugMode(const char* path)
{
	
	// デバックモードを設定する
	SetFeature(CTFWsTransactionHandler::TF_TRANS_FEATURE_DEBUG, true);

	if (path == NULL) return true;

	CTFPlatformsFactory* pFactory = new CTFPlatformsFactory;
	CTFLocalFileUtils* pUtils = pFactory->CreateLocalFileUtils();
	pUtils = pFactory->CreateLocalFileUtils();

	// デバッグ用オブジェクトを作成する
	m_pItem = pFactory->CreateLocalFileItem();
	m_pItem->SetPath(0, (void*)path, sizeof(char));
	pUtils->Open(*m_pItem, CTFLocalFileUtils::TF_F_RDWR | CTFLocalFileUtils::TF_F_APPEND);

	if (pUtils) delete pUtils;
	if (pFactory) delete pFactory;

	return true;
}

#ifdef WIN32
bool 
CPKCmdBase::ParseHostNameList(LPWSTR szHostNames, std::list<TF_STRING_W>& lpHost)
{
	lpHost.clear();

	TF_STRING_W szNames = (szHostNames == NULL) ? X("") : szHostNames;
	TF_STRING_W szTemp;
	int index, indexcurrent;

	index = indexcurrent = 0;

	while (true)
	{
		index = szNames.find(X(":"));
		if (index < 0) {
			lpHost.push_back(szNames.substr(indexcurrent));
			break;
		}
		else
		{
			szTemp = szNames.substr(indexcurrent, index - indexcurrent);
			lpHost.push_back(szTemp);
			indexcurrent = index + 1;
		}

	}
	return true;
}

bool
CPKCmdBase::ParseProtocolAndHostname(TF_STRING_W szName, TF_STRING_W& szProtocol, TF_STRING_W &szHostname)
{
	TF_STRING_W szNameStr = szName;
	int index = szNameStr.find(X("="), 0);

	if (index < 0)
	{
		szProtocol = X("");
		szHostname = szName;
		return false;
	}
	else
	{
		szProtocol = szNameStr.substr(0, index);
		szHostname = szNameStr.substr(index + 1);
		return true;
	}

}

bool
CPKCmdBase::ParseHostnameAndPortNumber(TF_STRING_W szName, TF_STRING_W &szHostName, int &iPort)
{
	TF_STRING_W szNameStr = szName;
	TF_STRING_W szPort = X("0");
	int index = 0;

	index = szNameStr.find(X(":"), 0);
	if (index < 0)
	{
		szHostName = szName;
		iPort = 0;
	}
	else
	{
		szHostName = szNameStr.substr(0, index);
		int iPortTemp = _wtoi(szNameStr.substr(index + 1).c_str());
		if ((iPortTemp >= 0) && (iPortTemp <= 65535))
		{
			iPort = iPortTemp;
			return true;
		}
		else
		{
			iPort = 0;
		}
	}

	return false;
}

#endif /* WIN32 */
