#include "PKGetOpt.h"
#include <vector>

CPKGetOpt::CPKGetOpt(int argc, char* const argv[], const char* optstring)
{
	m_nResult = PKOPTOK;
	parse(argc, argv, optstring);
}

CPKGetOpt::~CPKGetOpt(void)
{
}

int
CPKGetOpt::GetNextValue(OI_STRING_A& strValue)
{
	int retch;
	strValue.erase();
	if (!m_mapOpts.size() || m_mapIt == m_mapOpts.end()) return 0;

	retch = m_mapIt->first.c_str()[0];
	strValue = m_mapIt->second.c_str();
	m_mapIt++;

	return retch;
}

bool 
CPKGetOpt::HasKey(const char* key)
{
	if (!m_mapOpts.size()) return false;
	return (m_mapOpts.find(key) != m_mapOpts.end());	
}

/*
	prog -A aaa --BBB=BBBBBB -C "CCC CCC" -DDD="DDDD DDDD" -E E\"E -F FFF\ FFF
	A		aaa
	BBB		BBBBBB
	C		CCC CCC
	DDD		DDDD DDDD
	E		E"E
	F		FFF FFF
 */
void
CPKGetOpt::parse(int argc, char* const argv[], const char* optstring)
{
	int nIndex = 1;
	int reset = 0;
	std::vector<OI_STRING_A>	vecopt;
	OI_STRING_A stropt = optstring;

	clear();

	while(argv[nIndex])
	{
		vecopt.push_back(argv[nIndex]);
		nIndex++;
	}

	int						nReset = 0;
	int						nList  = 0;
	OI_STRING_A				strTmp;
	OI_STRING_A				strKey, strValue;
	OI_STRING_A::size_type	pos = 0;

	int nSize = (int)vecopt.size();
	for (int i=0; i < nSize; i++)
	{
		strTmp = vecopt[i];
		if (nReset == 0)
		{
			strKey.erase();
			strValue.erase();
			if (strTmp[0] != '-')  
			{
				nList = 1;
			}
			else 
			{
				if (strTmp[1] == '\0') m_nResult = BADPRM;
//				if (nList) m_nResult = BADPRM;
				if (nList) nList = 0;

				strKey = strTmp.substr(1);
				nReset = 1;
			}
		}
		else {
			// オプションになにか引数がつく
			if (strTmp[0] != '-') 
			{
				strValue = strTmp;
				nReset = 0;
			}
			else
			{
				m_nResult = BADPRM;
			}
		}

		if (nList)
		{
			PK_STRING_MAP::iterator it = m_mapOpts.find("f");
			if (it != m_mapOpts.end())
			{
				OI_STRING_A strList = it->second;

				if (!strList.empty())
				{
					//f引数に同じパラメータがない時だけ追加する。（重複は認めない）
					if (strList.find(strTmp) != OI_STRING_A::npos) continue;
					strList += "!";
				}
				strList += strTmp;
				addMap("f", strList);
			}
			else
			{
				addMap("f", strTmp);
			}
		}
		else 
		{
			// 該当オプションが指定されているかをチェックする
			if (m_nResult != BADPRM && (pos = stropt.find(strKey)) != OI_STRING_A::npos)
			{
				if (stropt[pos+1] != ':')
				{
					addMap(strKey, "");
					nReset = 0;
				}
				else
				{
					if (nReset == 1 && i < nSize-1)
						continue;

					if (strValue.empty()) 
					{
						m_nResult = BADPRM;
					}
					else
					{
						addMap(strKey, strValue);
					}
				}
			}
			else
			{
				m_nResult = BADPRM;
			}
		}

		if (m_nResult == BADPRM) break;
	}

	if (m_nResult == BADPRM) {
		clear();
		addMap("?","");
	}

	if (m_mapOpts.size())
		m_mapIt = m_mapOpts.begin();
}

void
CPKGetOpt::clear(void)
{
	m_mapOpts.clear();
}

void 
CPKGetOpt::addMap(OI_STRING_A strKey, OI_STRING_A strValue)
{
	m_mapOpts[strKey] = strValue;
}

const char*
CPKGetOpt::GetLastError(void)
{
	return m_strError.c_str();
}
