#include "PKNotificationHandler.h"
#include "libteamfile/TFURL.h"
#include "libteamfile/oimap.h"

#ifdef _WIN32
#include <Windows.h>
#else
#include <unistd.h>
#endif



CPKNotificationHandler::CPKNotificationHandler(void)
{
	m_unRecv = 0;
}

CPKNotificationHandler::~CPKNotificationHandler(void)
{
}

bool
CPKNotificationHandler::OnInitializeProgressWindow(TFHANDLE *hHandle, TFTRANSMODE enuMode)
{

	*hHandle = NULL;
	m_unRecv = 0;

	// ユーザ作成は不要
	if (enuMode == TF_TRANS_MAKEUSER) return false;
	// グループ作成も不要
	if (enuMode == TF_TRANS_MAKEGROUP) return false;

#ifdef _WIN32
	CONSOLE_CURSOR_INFO lpinfo;
	// stdoutを取得する（これは閉じてはいけません OnTerminateProgressWindow() ）
	HANDLE h = ::GetStdHandle(STD_OUTPUT_HANDLE);
	if (h != INVALID_HANDLE_VALUE)
	{
		*hHandle = h;
		GetConsoleCursorInfo(h, &lpinfo);
		lpinfo.bVisible = false;	// カーソルを表示しない
		SetConsoleCursorInfo(h, &lpinfo);

		return true;
	}
#else
	*hHandle = stderr;
	return true;
#endif

	return false;

}

bool 
CPKNotificationHandler::OnPreSendProgressWindow(const TFXMLCh* str, TFHANDLE hHandle)
{
	if (!hHandle) return false;
	if (str == NULL) return false;

	TF_STRING_A strURI = (const char*)X(str);
	strURI += "\n";

#ifdef _WIN32
	DWORD pOutSize=0;
	::WriteConsole(hHandle, strURI.c_str(), (DWORD)strURI.length(), &pOutSize, NULL);
#else
#endif

	return true;
}

bool
CPKNotificationHandler::OnUpdateProgressWindow(const TFXMLCh* str, TFHANDLE hHandle, TF_SIZE_T unProgress, TF_SIZE_T unTotal)
{

	m_unRecv += unProgress;
	if (m_unRecv < 163840) 
		return true;


#ifdef _WIN32
	if (hHandle != NULL)
	{
		if (unTotal > 0)
		{
			char pch[50] = {0};
			DWORD pOutSize;
			int par = (int)(((double)unProgress / (double)unTotal) *100);
			int n = (int)(((double)unProgress / (double)unTotal) *10*5);
			sprintf(pch, "[%3d%%] " ,par);
			::WriteConsole(hHandle, pch, (DWORD)strlen(pch), &pOutSize, NULL);
			for(int i=0; i < n; i++)
			{
				pch[0] = NULL;
				::WriteConsole(hHandle, "#", 1, &pOutSize, NULL);
			}
			::WriteConsole(hHandle, "\r", 1, &pOutSize, NULL);
		}
		else
		{
			//::WriteConsole(hHandle, "\n", 1, NULL, NULL);
		}
	}
#else

	if (hHandle != NULL)
	{
		if (unTotal > 0)
		{
			int par = (int)(((double)unProgress / (double)unTotal) *100);
			int n = (int)(((double)unProgress / (double)unTotal) *10*5);
			char pch[1024] = {0};
			::fprintf((FILE*)hHandle, "[%3d%%] ", par);

			for(int i=0; i<n; i++)
				pch[i] = '#';

			::fprintf((FILE*)hHandle, "%s\r", pch);
		}
	}

#endif

	// 初期化
	m_unRecv = 0;

	return true;

}

bool
CPKNotificationHandler::OnTerminateProgressWindow(TFHANDLE hHandle)
{
#ifdef _WIN32
// コマンドラインでのハンドルはSTDOUTです。閉じてしまうと再利用できません
//	if (hHandle != NULL) ::CloseHandle(hHandle);
		// カーソルを元に戻す
		CONSOLE_CURSOR_INFO lpinfo;
		if (::GetConsoleCursorInfo(hHandle, &lpinfo))
		{
			lpinfo.bVisible = true;	//　カーソル表示を元に戻す
			::SetConsoleCursorInfo(hHandle, &lpinfo);
		}
#else
#endif
	return true;
}

bool
CPKNotificationHandler::OnQueryAuthRetryCount(int nRetry, TF_AUTH_CLASS enuAuthClass)
{
	return true;
}

TFDLGNOTIFYTYPE
CPKNotificationHandler::OnNotifyMessage(TFRESULT enuResult, int nNotifyType, CTFResourceItemList* pItemList)
{
	TFDLGNOTIFYTYPE nType;

	switch(enuResult)
	{
		case TF_RESULT_USER_RESOURCE_EXIST:		// ユーザにリソースが残っていた
		case TF_RESULT_GROUP_RESOURCE_EXIST:	// グループにリソースが残っていた
			nType = TF_DLG_NOTIFY_OK;
			break;

		default:
			nType = TF_DLG_NOTIFY_ALLOK;
			break;
	}

	return nType;

}

