#include "PKTransactionHandler.h"
#include "libteamfile/TFPlatformsFactory.h"
#include "libteamfile/TFLocalFileItem.h"
#include "libteamfile/TFLocalFileUtils.h"

#ifdef _WIN32
#include "Windows.h"
#endif

CPKTransactionHandler::CPKTransactionHandler(void)
{
	m_nResult = 0;
	m_enuLastMethod = TF_DAV_UNKNOWN;
}

CPKTransactionHandler::~CPKTransactionHandler(void)
{
}

void 
CPKTransactionHandler::OnResultDAVMethod(const int nOI_Result , const TFXMLCh* pszURI, TFDAVMETHOD enuMethod)
{
	m_nResult = nOI_Result;
	m_strLastURI = pszURI;
	m_enuLastMethod = enuMethod;

	OnErrorPrint(nOI_Result, pszURI, enuMethod);

}


void
CPKTransactionHandler::OnErrorPrint(const int nOI_RESULT , const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod)
{
}
bool
CPKTransactionHandler::OnDebugExtString(TF_STRING_A& szExtString)
{
#if _WIN32
	TCHAR pszDrive[_MAX_DRIVE+1];
	TCHAR pszPath[_MAX_PATH+1];
	TCHAR pszTitle[_MAX_FNAME+1];
	TCHAR pszExt[_MAX_EXT+1];

	TCHAR pszFullPath[_MAX_PATH+1]={0};
	GetModuleFileName(NULL, pszFullPath, _MAX_PATH);

	_tsplitpath(pszFullPath, pszDrive, pszPath, pszTitle, pszExt);

	szExtString = pszTitle;
	return true;
#else
#endif
	return false;
}

void
CPKTransactionHandler::OnDebugPrint(const char* pszString) 
{
	if (pszString == NULL) return;

	if (m_pItem == NULL || m_pItem->GetFD() < 0)
	{
		// デバッグの為の出力先が用意されていない場合は標準エラーにもっていく。
		CTFWsTransactionHandler::OnDebugPrint(pszString);
	}
	else
	{
		CTFPlatformsFactory* pFactory = new CTFPlatformsFactory();
		CTFLocalFileUtils* pUtils = pFactory->CreateLocalFileUtils();
		pUtils->Write(m_pItem->GetFD(), pszString, strlen(pszString));

		if (pUtils) delete pUtils;
		if (pFactory) delete pFactory;
	}
}
