#include "PKCmdDel.h"
#include "libteamfile/TFStringTokenizer.h"

CPKCmdDel::CPKCmdDel(void)
{
	m_bReg = false;
	m_bgFlag = false;
	m_brFlag = false;

	m_i64All = 0;
	m_i64Match = 0;
	m_pReg = new CTFRegex();
}

CPKCmdDel::~CPKCmdDel(void)
{
	delete m_pReg;
}

bool
CPKCmdDel::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{
	bool bResult = true;

	TF_STRING_W strValue;
	OI_STRING_A strAscii;

	strValue = (const TFXMLCh*)X(pszValue);
	strAscii = (const char*)X(pszValue);

	switch(nKey)
	{

		case 'g':
			m_bgFlag = true;
			break;

		case 'r':
			m_brFlag = true;
			break;

		case 't':
			m_strTargetURI = strValue.c_str();
			break;

		case 'x':
			m_bReg = true;
#ifdef WIN32
			m_strRegex = strValue.c_str();
#else
			m_strRegex = (const char*)X(strValue.c_str()).UTF8().c_str();
#endif
			break;

		default:
			m_enuResult = TF_CMD_PRM_INVALID_PARAM;
			bResult = false;
			break;
	}

	return bResult;
}

bool
CPKCmdDel::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{

	bool bResult = true;

	switch(nOpt)
	{
		case 'g':
			strUsage = "run deletion";
			break;

		case 'r':
			strUsage = "recursive search";
			break;

		case 't':
			strUsage = "target URI";
			break;

		case 'x':
			strUsage = "use regular expressions string";
			break;

		default:
			bResult = false;
			break;
	}

	return bResult;
}

void 
CPKCmdDel::OnKnownOptions(OI_STRING_A& strOpt)
{
	strOpt = "grt:x:";
}

CMDRESULT
CPKCmdDel::OnIsValid(CMDMODE enuMode)
{

	if (m_strTargetURI.empty()) 
		return TF_CMD_PRM_INVALID_PARAM;

	return TF_CMD_OK;	// TF_CMD_FAILを返すとusage出力にできる
}

void 
CPKCmdDel::OnQueryProgramInfo(CPKPROGINFO &info)
{
	info.strDisc		= "TeamFile DELETE CommandLine";
	info.strProgName	= "tfdel";
	info.strVersion		= TFCMDVERSION;
}

int
CPKCmdDel::OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem)
{

	CTFDavResource		cDavItem;
	TF_STRING_W			strURI = pSvrItem->GetURI();
	strURI += m_strTargetURI;
	cDavItem.SetURI(strURI.c_str());
	cDavItem.SetServerID(pSvrItem->GetServerID());

	CTFURL cURL(cDavItem.GetURI());
	if (cURL.m_bFolder)
	{
		if (m_bReg)
		{
#ifdef WIN32
#define PCRE_OPTIONS	0x0800
#else
#define PCRE_OPTIONS	0
#endif
			TF_STRING_A strPattern = X(cURL.m_strURI.c_str()).UTF8().c_str();
#ifdef WIN32
			strPattern += X(m_strRegex.c_str()).UTF8().c_str();
#else
			strPattern += m_strRegex.c_str();
#endif
			if ( !(m_pReg->AddPattern(strPattern.c_str(), PCRE_OPTIONS)) )
			{
				// 正規表現のパターン登録失敗
				return TF_CMD_PRM_REGEX_ERROR;
			}

			cDavItem.SetURI(cURL.m_strURI.c_str());
			CTFResourceProp* pProp = 0;
			if (!m_cTrans.List(&cDavItem, &pProp, m_brFlag))
			{
				switch(m_cTrans.GetLastError())
				{
					case TF_RESULT_NOTFOUND:
						return TF_CMD_FILE_NOTFOUND;
						break;

					default:
						return TF_CMD_FAIL;
				}
			}

			CTFDavResourceList* pDavList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pProp);
			if (pDavList)
			{
				CTFDavResource* pDavItem;
				for(pDavItem = NULL; pDavItem = (CTFDavResource*)pDavList->GetNextItem(); )
				{
					m_cItemList.AddItem((CTFDavResource*)pDavItem->Clone());
				}

				delete pProp;
			}

			pProp = NULL;

		}
		else
		{
			// 一件だけ削除となる
			cDavItem.SetURI(cURL.m_strURI.c_str());
			CTFResourceProp* pProp = 0;
			if (!m_cTrans.List(&cDavItem, &pProp, m_brFlag))
			{
				switch(m_cTrans.GetLastError())
				{
					case TF_RESULT_NOTFOUND:
						return TF_CMD_FILE_NOTFOUND;
						break;

					default:
						return TF_CMD_FAIL;
				}
			}
		}

	}
	else
	{
		// 一件だけ削除となる
		cDavItem.SetURI(cURL.m_strURI.c_str());
		CTFResourceProp* pProp = 0;
		if (!m_cTrans.List(&cDavItem, &pProp, m_brFlag))
		{
			switch(m_cTrans.GetLastError())
			{
				case TF_RESULT_NOTFOUND:
					return TF_CMD_FILE_NOTFOUND;
					break;

				default:
					return TF_CMD_FAIL;
			}
		}
	}

	bool bResult = false;
	if (m_bReg || m_cItemList.GetItemCount())
	{
		// 複数件ある場合は後から一覧を渡す為NULLとする。
		bResult = m_cTrans.Delete(&cDavItem, NULL);
	}
	else
	{
		if (m_bgFlag) {
			// アイテムそのものを削除する
			bResult = m_cTrans.Delete(&cDavItem, &cDavItem);
		}
		else {
			// 一覧の表示だけとする。
			if (m_bReg) {
				bResult = true;
				if (m_pReg->Search(X(cDavItem.GetURI()).UTF8().c_str()) != -1) 
				{
					std::cout << (const char*)X(cDavItem.GetURI()) << std::endl;
					m_i64All = m_i64Match = 1;
				}
			}
			else {
				std::cout << (const char*)X(cDavItem.GetURI()) << std::endl;
				bResult = true;
				m_i64All = m_i64Match = 1;
			}
		}
	}

	// エラー処理
	if (!bResult)
	{
		switch(m_cTrans.GetLastError())
		{
			case TF_RESULT_NOTFOUND:	// ファイルが無かった
				return TF_CMD_FILE_NOTFOUND;
				break;

			case TF_RESULT_FORBIDDEN:	// アクセスできなかった
				return TF_CMD_FILE_ACCESSDENIED;
				break;

			default:
				break;
		}

		return TF_CMD_FAIL;
	}
	else
	{
		// 成功
		if (!m_bgFlag)
		{
			// 但し消すファイル一覧だけを表示したよメッセージ
			std::cerr																		<< std::endl;
			std::cerr << "-- NOTICE -----------------------------------------------------"	<< std::endl;
			std::cerr << "Target " << m_i64All		<< " files"								<< std::endl;
			std::cerr << "Match  " << m_i64Match	<< " files"								<< std::endl;
			std::cerr																		<< std::endl;
			std::cerr << "The deleted file list was displayed."								<< std::endl;
			std::cerr << "Please apply [ -g ] flag to actually delete it."					<< std::endl;
			std::cerr << "---------------------------------------------------------------"	<< std::endl;
		}
	}

	return TF_CMD_OK;

}

bool
CPKCmdDel::OnQuerySelectedItems(TFDAVMETHOD enuMethod, TFTRANSMODE enuMode, CTFResourceItemList& pItemList)
{
	if (m_cItemList.IsEmpty()) return false;

	CTFResourceItem* pItem = NULL;
	CTFDavResource* pDavItem = NULL;
	while(pItem = m_cItemList.GetNextItem())
	{
		m_i64All++;

		pDavItem = TFLIB_DYNAMIC_CAST(CTFDavResource, pItem);
		if (!pDavItem) continue;

		if (m_bReg)
			// ヒットしなかった場合は対象にしない
			if (m_pReg->Search(X(pDavItem->GetURI()).UTF8().c_str()) == -1) continue;

		m_i64Match++;	// match !!!

		// run flagがなければ実際の削除は行わない。
		if (m_bgFlag)
		{
			pItemList.AddItem((CTFResourceItem*)pItem->Clone());
		}
		else
		{
			// 一覧の表示だけとする。
			std::cout << (const char*)X(pDavItem->GetURI()) << std::endl;
		}
	}

	// 全て渡したのでリストはクリアする
	m_cItemList.EmptyList();

	return true;
}

bool 
CPKCmdDel::OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod)
{
	// 削除の前のチェックは不要
	if (enuMode == TF_TRANS_DELETE && enuMethod == TF_DAV_DELETE && m_bReg)
	{
		return false;
	}

	return true;
}
