/*
 *	$Id$
 */

#include "libpkcmd/PKCmdBase.h"
#include "libteamfile/TFRegex.h"

class CPKCmdDel : 
	public CPKCmdBase
{
public:
	CPKCmdDel(void);
	~CPKCmdDel(void);

	void OnKnownOptions(OI_STRING_A& strOpt);
	void OnQueryProgramInfo(CPKPROGINFO &info);
	bool OnFoundParam(const int nKey, const TFXMLByte* pszValue);
	bool OnQueryUsage(const int nOpt, OI_STRING_A& strUsage);
	CMDRESULT OnIsValid(CMDMODE enuMode);
	int OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem);

	bool OnQuerySelectedItems(TFDAVMETHOD enuMethod, TFTRANSMODE enuMode, CTFResourceItemList& pItemList);
	bool OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod);

private:
	TF_STRING_W			m_strTargetURI;			//< 削除ターゲットのベースURI
	CTFResourceItemList	m_cItemList;			//< 削除対象ファイル

	CTFRegex*			m_pReg;
#ifdef WIN32
	TF_STRING_W			m_strRegex;
#else
	TF_STRING_A			m_strRegex;
#endif
	bool				m_bReg;
	bool				m_bgFlag;
	bool				m_brFlag;

	TF_SIZE_T			m_i64All;				// 削除対象全件
	TF_SIZE_T			m_i64Match;				// 実際に削除となる（正規表現時にマッチした件数）

};




