#include "PKCmdGet.h"
#include "libteamfile/TFStringTokenizer.h"
#include "libteamfile/TFLocalFileUtils.h"

CPKCmdGet::CPKCmdGet(void)
{
	m_strDownLoadPath.clear();
	m_bmove = false;
	m_b1Flag = false;
}

CPKCmdGet::~CPKCmdGet(void)
{
}

bool
CPKCmdGet::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{
	bool bResult = true;

	TF_STRING_W strValue;
	OI_STRING_A strAscii;

	strValue = (const TFXMLCh*)X(pszValue);
	strAscii = (const char*)X(pszValue);

	switch(nKey)
	{
		case 'm':
			m_bmove = true;
			break;

		case 'o':
			m_strDownLoadPath = strValue.c_str();
			break;

		case 't':
			m_strTargetURI = strValue.c_str();
			break;

		case '1':
			m_b1Flag = true;
			break;

		default:
			m_enuResult = TF_CMD_PRM_INVALID_PARAM;
			bResult = false;
			break;
	}

	return bResult;
}

bool
CPKCmdGet::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{

	bool bResult = true;

	switch(nOpt)
	{
		case 'm':
			strUsage = "move resource";
			break;

		case 'o':
			strUsage = "download localpath (default: current directory)";
			break;

		case 't':
			strUsage = "target URI";
			break;
		
		case '1':
			strUsage = "doesn't  stratum";
			break;

		default:
			bResult = false;
			break;
	}

	return bResult;
}

void 
CPKCmdGet::OnKnownOptions(OI_STRING_A& strOpt)
{
	strOpt = "mo:t:1";
}

CMDRESULT
CPKCmdGet::OnIsValid(CMDMODE enuMode)
{

	if (m_strDownLoadPath.empty())
	{
		m_strDownLoadPath = C2W(PKDLPATHDEF);
	}
	else 
	{
		CTFPlatformsFactory* pFuctory = new CTFPlatformsFactory;
		CTFLocalFileUtils* pUtil = pFuctory->CreateLocalFileUtils();
		CTFLocalFileItem* pLocalFile = pFuctory->CreateLocalFileItem();

		pLocalFile->SetPath(0, (void*)m_strDownLoadPath.c_str(), sizeof(TFXMLCh));
		bool bResult = pUtil->ResourceExist(*pLocalFile);

		delete pUtil;
		delete pLocalFile;
		delete pFuctory;
		if (!bResult) return TF_CMD_DOWNLOADFOLDER_NOTFOUND;	// ダウンロードフォルダ無し
	}
	if (m_strTargetURI.empty()) 
		return TF_CMD_PRM_INVALID_PARAM;

	return TF_CMD_OK;	// TF_CMD_FAILを返すとusage出力にできる
}

void 
CPKCmdGet::OnQueryProgramInfo(CPKPROGINFO &info)
{
	info.strDisc		= "TeamFile GET CommandLine";
	info.strProgName	= "tfget";
	info.strVersion		= TFCMDVERSION;
}

int
CPKCmdGet::OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem)
{

	TF_STRING_W	strFile;
	TF_STRING_W strFiles;

	CTFDavResource		cDavItem;
	TF_STRING_W			strURI = pSvrItem->GetURI();
	strURI += m_strTargetURI;
	cDavItem.SetURI(strURI.c_str());
	cDavItem.SetServerID(pSvrItem->GetServerID());

	// ダウンロードを開始する
	if (!m_b1Flag) 
	{
		CMDRESULT enuResult = TF_CMD_FAIL;
		bool bDownload = false;

		bDownload = m_cTrans.Download(&cDavItem);

		if (!bDownload) {
			switch (m_cTrans.GetLastError())
			{
			case TF_RESULT_NOTFOUND:
				enuResult = TF_CMD_FILE_NOTFOUND;	// DAVにファイルがない
				break;

			default:
				break;
			}

			return enuResult;
		}

	}
	else 
	{
		CTFResourceProp* pProp = NULL;
		if (!m_cTrans.List(&cDavItem, &pProp))
		{
			// ファイルが無かった
			CMDRESULT enuResult = TF_CMD_FAIL;
			switch(m_cTrans.GetLastError())
			{
				case TF_RESULT_NOTFOUND:
				case TF_RESULT_FORBIDDEN:
					enuResult = TF_CMD_FILE_NOTFOUND;
					break;

				default:
					break;
			}

			return enuResult;
		}

		//　リソースは必ず存在している
		bool bDownload = false;
		CTFDavResourceList* pDavList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pProp);
		if (pDavList->GetItemCount())
		{
			CTFResourceItemList cList;
			CTFDavResource* pDavItem = NULL;
			while(pDavItem = (CTFDavResource*)pDavList->GetNextItem())
			{
				cList.AddItem(pDavItem);
			}

			bDownload = m_cTrans.Download(pSvrItem->GetServerID(), &cList, false);
		}
		else
		{
			// 一件しかない
			bDownload = m_cTrans.Download(pProp);
		}

		// 結果確認
		if (!bDownload)
		{
			switch(m_cTrans.GetLastError())
			{
				case TF_RESULT_FORBIDDEN:
				case TF_RESULT_NOTFOUND:
				case TF_RESULT_BADREQUEST:
					return TF_CMD_FILE_NOTFOUND;
				default:
					return TF_CMD_FAIL;
			}
		}
	}

	// moveするなら削除する
	if (m_bmove)
	{
		if (!m_cTrans.Delete(&cDavItem, &cDavItem))
		{
			switch(m_cTrans.GetLastError())
			{
				case TF_RESULT_NOTFOUND:	// 削除された可能性があるが結果OK
				default:
					return TF_CMD_OK_ERROR;
			}
		}
	}

	return TF_CMD_OK;

}

void
CPKCmdGet::OnSetSystemPath(CTFLocalFileItem* pItem, int nType)
{
	if (CTFWsTransactionHandler::TF_SYSPATH_DOWNLOAD == nType)
		pItem->SetPath(nType, (void*)m_strDownLoadPath.c_str(), sizeof(TFXMLCh));
}

bool
CPKCmdGet::OnShowResource(CTFResourceItem* pItem)
{
	return true;	//　これはいじらない様に！
}

bool
CPKCmdGet::OnQueryDownloadItem(CTFLocalFileItem* pItem, CTFResourceItem* pHint)
{
	CTFDavResource* pDavItem = TFLIB_DYNAMIC_CAST(CTFDavResource, pHint);

	TF_STRING_W strURI;
	if (m_b1Flag)
	{
		CTFURL cURL(pDavItem->GetURI());
		strURI  = C2W("/");
		strURI += cURL.m_strName;
	}
	else
	{
		strURI = pDavItem->GetURI();
	}

    pItem->SetPath(0, (void*)strURI.c_str(), sizeof(TFXMLCh));

	return true;
}

void
CPKCmdGet::OnResultLocalResource( const TFTRANSMODE enuMode,
								  const TFDAVMETHOD enuMethod, 
										CTFLocalFileItem* pItem,
								  const TFRESULT nResult)
{

#ifdef _WIN32
	// ラインクリア出力には影響を与えない
	CONSOLE_SCREEN_BUFFER_INFO lpinfo;
	HANDLE h = ::GetStdHandle(STD_OUTPUT_HANDLE);
	if (h)
	{
		::GetConsoleScreenBufferInfo(h, &lpinfo);
		COORD cr;
		cr.X = lpinfo.dwCursorPosition.X;
		cr.Y = lpinfo.dwCursorPosition.Y;
		DWORD dwWritten;
		BOOL bResult = ::FillConsoleOutputCharacter(h, ' ', lpinfo.dwSize.X, cr, &dwWritten);
	}
#else
	//　出力に影響を与えるクリアです。
	::fprintf(stderr, "\x1b[2K"); // ラインクリア
#endif
	if (enuMethod == TF_DAV_GET)
	{
		TF_STRING_A strResult = pItem->GetPathA();
		RemoveDoubleSlashA(strResult);
		if (nResult == TF_RESULT_OK)
		{
			printf("[ OK ] %s\n", strResult.c_str());
		}
		else
		{
			printf("[FAIL] %s\n", strResult.c_str());
		}
	}
}


