/*
 *	$Id$
 */

#include "libpkcmd/PKCmdBase.h"
#include "libteamfile/TFRegex.h"

// デフォルトのダウンロードパス
#ifdef _WIN32
	#define PKDLPATHDEF		"."
#else
	#define PKDLPATHDEF		"./"
#endif

class CPKCmdGet :
	public CPKCmdBase
{
public:
	CPKCmdGet(void);
	~CPKCmdGet(void);

	void OnKnownOptions(OI_STRING_A& strOpt);
	void OnQueryProgramInfo(CPKPROGINFO &info);
	bool OnFoundParam(const int nKey, const TFXMLByte* pszValue);
	bool OnQueryUsage(const int nOpt, OI_STRING_A& strUsage);
	CMDRESULT OnIsValid(CMDMODE enuMode);
	int OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem);

	void OnSetSystemPath(CTFLocalFileItem* pItem, int nType);
	bool OnShowResource(CTFResourceItem* pItem);
	bool OnQueryDownloadItem(CTFLocalFileItem* pItem, CTFResourceItem* pHint);
	void OnResultLocalResource( const TFTRANSMODE enuMode,
								const TFDAVMETHOD enuMethod, 
									  CTFLocalFileItem* pItem,
								const TFRESULT nResult);
private:
	TF_STRING_W	m_strDownLoadPath;		//< ダウンロードパス
	TF_STRING_W m_strTargetURI;			//< ダウンロードターゲットURI
	bool		m_bUTF8;
	bool		m_bmove;				//< 移動モードならTRUE
	bool		m_b1Flag;				//< 一個取得モード
};




