#include "PKCmdGrp.h"
#include <libteamfile/TFResourcePropTFUser.h>
#include <libteamfile/TFStringTokenizer.h>
#include "PKCmdGrpXmlPrinter.h"

CPKCmdGrp::CPKCmdGrp(void)
					:m_bUntochedUse(false)
{
	m_strUsers.erase();
	m_nCAll = 0;
	m_bqFlag = false;
	m_strActive = C2W("");
	m_bSkipAvailableUser = false;
	m_bmFlag = false;
	m_strOwnerID = C2W("");
	m_bhFlag = false;
	m_strLastID = C2W("");
}

CPKCmdGrp::~CPKCmdGrp(void)
{
}

void 
CPKCmdGrp::OnQueryProgramInfo(CPKPROGINFO &info)
{
	info.strDisc		= "TeamFile GroupManagement CommandLine";
	info.strProgName	= "tfgrp";
	info.strVersion		= TFCMDVERSION;
}

CMDRESULT
CPKCmdGrp::OnIsValid(CMDMODE enuMode)
{

	if (enuMode == TFCMD_VIEW)
	{
		if (m_enuOutFmt == PKCMDOUTFMT_NONE)
			m_enuOutFmt = PKCMDOUTFMT_PLAIN;

		// -qフラグは付けられません。
		if (m_bqFlag)
			return TF_CMD_PRM_INVALID_PARAM;

	}

	// グループ名かIDがない場合はエラー
	if (TF_STRING_W(m_cGrpItem.GetName()).empty() && TF_STRING_W(m_cGrpItem.GetID()).empty())
	{
		return TF_CMD_PRM_INVALID_PARAM;
	}

	// 新規の場合はグループリーダー任命と解任が同時に指定はNG
	if (enuMode == TFCMD_ADD)
	{
		if (!m_strOwnerID.empty() && m_bmFlag)
			return TF_CMD_PRM_CONTRADICTION;
	}

	// 新規の場合、グループオーナーに指定しているユーザが
	// 所属ユーザにいない場合は矛盾エラー
	if (enuMode == TFCMD_ADD && !m_strOwnerID.empty())
	{
		if (m_strUsers.empty()) return TF_CMD_PRM_CONTRADICTION;
		if (m_strUsers.find(m_strOwnerID) == TF_STRING_W::npos) return TF_CMD_PRM_CONTRADICTION;
	}

	// アップデートの場合でサーバの値をもらう場合
	if (m_bUntochedUse && enuMode == TFCMD_UPDATE)
	{
		bool bResult=false;
		CTFResourceProp* pRList=0;

		bResult = m_cTrans.SearchGroup(GetServerManager().GetServerItem(0)->GetServerID(), &m_cGrpItem, &pRList, TF_SEARCH_GI_CONTENT);
		if (bResult)
		{
			CTFDavResourceList* pGrpList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pRList);
			if (pGrpList)
			{
				CTFResourcePropTFGroup* pGrpItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup, pGrpList->GetNextItem());
				if (pGrpItem)
				{
					if (TF_STRING_W(m_cGrpItem.GetID()).empty())
						m_cGrpItem.SetID(pGrpItem->GetID());
					if (m_strNewName.empty())
						m_strNewName = m_cGrpItem.GetName();
					if (TF_STRING_W(m_cGrpItem.GetComment()).empty())
						m_cGrpItem.SetComment(pGrpItem->GetComment());
					if (m_cGrpItem.GetGrpMailWatch() == TF_DAV_UNKNOWN)
					{
						TF_STRING_W strMailWatch;
						BuildMailWatch(pGrpItem->GetGrpMailWatch(), strMailWatch);
						m_cGrpItem.SetMailWatch(strMailWatch.c_str());
					}

					// group state
					if (m_cGrpItem.GetGroupState() == TF_GROUPSTATE_NONE)
						m_cGrpItem.SetGroupState(pGrpItem->GetGroupState());

					// group constraints
					if (m_cGrpItem.GetGroupConstraints() == TF_GROUPCONSTRAINTS_NONE)
						m_cGrpItem.SetGroupConstraints(pGrpItem->GetGroupConstraints());


				}
			}
		}
		else
		{
			return TF_CMD_FAIL;
		}

		if (pRList) delete pRList;
	}

	// 更新時にサーバの値を利用しないのに名前が空っぽだった場合は元の名前を利用
	if (enuMode == TFCMD_UPDATE)
	{
		// -qフラグは付けられません。
		if (m_bqFlag)
			return TF_CMD_PRM_INVALID_PARAM;

		if (!m_bUntochedUse && m_strNewName.empty())
		{
			m_strNewName = m_cGrpItem.GetName();
		}

		// アップデートはフォルダを作成することはできません
		if (!m_strFolders.empty())
			return TF_CMD_PRM_INVALID_PARAM;

	}

	if (enuMode == TFCMD_ADD)
	{
		// 追加モードはグループ名が存在しないと作成できない
		if (TF_STRING_W(m_cGrpItem.GetName()).empty())
		{
			return TF_CMD_PRM_NAME_UNKNOWN;
		}

		// -qフラグは付けられません。
		if (m_bqFlag)
			return TF_CMD_PRM_INVALID_PARAM;

	}

	// 削除以外の場合でグループが非アクティブの場合はフォルダを作れない（矛盾エラー）
	if (enuMode != TFCMD_DELETE)
	{
		if (m_cGrpItem.GetGroupState() == TF_GROUPSTATE_INACTIVE)
		{
			if (!m_strFolders.empty()) return TF_CMD_PRM_INVALID_PARAM;
		}
	}

	/*
	 * アイテムの中身をチェックする
	 * nameとIDはいずれかがはいっていればいいが名前を優先する
	 */
	if (!TF_STRING_W(m_cGrpItem.GetName()).empty())
		m_cGrpItem.SetID(C2W(""));

	return TF_CMD_OK;
}

bool
CPKCmdGrp::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{
	bool bResult = true;

	TF_STRING_W strValue;
	OI_STRING_A strAscii;

	strValue = (const TFXMLCh*)X(pszValue);
	strAscii = (const char*)X(pszValue);


	int			nDAVMethod = TF_DAV_UNKNOWN;
	CDavStringTokenizer cToken(NULL);
	TF_STRING_A	strMethod;
	TF_STRING_W	strMethods;
	TF_STRING_A	strGroupConstraintsA;
	int	nGroupConstraints = TF_GROUPCONSTRAINTS_NONE;

	switch(nKey)
	{
		case 'a':		// アクティブ
			m_strActive = strValue.c_str();
			{
				int nActive=0;
				if (m_strActive.compare(C2W("active")) == 0)
					nActive = TF_GROUPSTATE_ACTIVE;
				else if (m_strActive.compare(C2W("inactive")) == 0)
					nActive = TF_GROUPSTATE_INACTIVE;
				else
					bResult = false;


				if (bResult) m_cGrpItem.SetGroupState(nActive);
			}
			break;

		case 'b':		// グループ制約
			MakeLowerA(strAscii);
			cToken.SetToken(strAscii.c_str());
			cToken.SetDelimiter(",");
			while(cToken.GetNextToken(strGroupConstraintsA))
			{
				bResult = false;
				for(int i=0; TF_GROUP_CONSTRAINTS_TABLE[i].dwConstraints != TF_GROUPCONSTRAINTS_NONE; i++)
				{
					if (strGroupConstraintsA.compare(TF_GROUP_CONSTRAINTS_TABLE[i].szTagName) == 0)
					{
						nGroupConstraints |= TF_GROUP_CONSTRAINTS_TABLE[i].dwConstraints;
						bResult = true;
					}
				}
			}
			m_cGrpItem.SetGroupConstraints(nGroupConstraints);
			break;

		case 'h':		// ユーザ一覧まで表示する
			m_bhFlag = true;
			break;

		case 'i':		// グループID
			m_cGrpItem.SetName(strValue.c_str());
			break;

		case 'd':
			m_cGrpItem.SetID(strValue.c_str());
			break;

		case 'n':		// グループ名
			m_strNewName = strValue.c_str();
			break;

		case 'f':		// 初期作成フォルダ
			m_strFolders = strValue.c_str();
			break;

		case 'l':		// 任命したいグループリーダー
			m_strOwnerID = strValue.c_str();
			break;

		case 'm':		// このグループのオーナーを解任
			m_bmFlag = true;
			break;

		case 'c':		// コメント
			m_cGrpItem.SetComment(strValue.c_str());
			break;

		case 'q':		// 強制削除
			m_bqFlag = true;
			break;

		case 'w':		// メールウォッチ
			MakeUpperA(strAscii);
			cToken.SetToken(strAscii.c_str());
			cToken.SetDelimiter(",");
			while(cToken.GetNextToken(strMethod))
			{
				strMethods += X(strMethod.c_str());
				strMethods += X(" ");
			}
			m_cGrpItem.SetMailWatch(strMethods.c_str());
			break;

		case 's':	// サーバの値を利用
			m_bUntochedUse = true;
			break;

		case 'u':		// グループ所属ユーザ
			m_strUsers = strValue.c_str();
			break;

		default:
			bResult = false;
			break;
	}

	return bResult;
}

bool
CPKCmdGrp::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{
	switch(nOpt)
	{
	case 'a':
		strUsage = "active [ active | inactive ]";
		break;

	case 'b':
		strUsage = "group constraints [ write | showproperty | operationlog ]";
		break;

	case 'h':
		strUsage = "show available user (slow)";
		break;

	case 'i':
		strUsage = "group ID";
		break;

	case 'd':
		strUsage = "group ID(view only)";
		break;

	case 'n':
		strUsage = "new groupID(update only)";
		break;

	case 'f':
		strUsage = "default folder creation name. (comma delimitation)";
		break;

	case 'l':	// グループオーナー
		strUsage = "appointed group owner (userid)";
		break;
	
	case 'm':
		strUsage = "dismiss group owner";
		break;

	case 'c':
		strUsage = "group comment";
		break;

	case 'q':
		strUsage = "force delete. (delete only)";
		break;

	case 'w':
		strUsage = "mail watch (comma delimitation) [ get | put | delete | copy | move ]";
		break;

	case 's':
		strUsage = "the item not specified uses value of the response. (update only)";
		break;

	case 'u':
		strUsage = "belong to default user (comma delimitation)";
		break;

	default:
		return false;
		break;

	}

	return true;
}

void
CPKCmdGrp::OnKnownOptions(OI_STRING_A& strOpt)
{
	strOpt = "a:b:hi:d:c:f:l:mn:qw:u:s";
}

bool 
CPKCmdGrp::OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod)
{
	// deleteトランザクション時のdelete前のPROPFINDは行わない
	if (enuMode == TF_TRANS_DELETE && enuMethod == TF_DAV_DELETE)
	{
		return false;
	}
	
	return true;
}

int
CPKCmdGrp::OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem)
{
	CTFResourceProp* pPropList=0;
	bool bResult = false;

	// グループアイテムのURIを作成する
	TF_STRING_W strURI;
	strURI  = pSvrItem->GetRootURI();
	strURI += X(PKGRPRROOT);

	// グループアイテムにサーバIDを設定する
	m_cGrpItem.SetServerID(pSvrItem->GetServerID());

	m_enuResult = TF_CMD_FAIL;

	switch(enuMode)
	{
		case TFCMD_ADD:		// 追加
			m_enuResult = execAdd(pSvrItem, strURI);
			break;

		case TFCMD_DELETE:	// 削除
			m_enuResult = execDelete(pSvrItem, strURI);
			break;

		case TFCMD_UPDATE:	// 更新
			m_enuResult = execUpdate(pSvrItem, strURI);
			break;

		case TFCMD_VIEW:	// 内容確認
			m_enuResult = execView(pSvrItem);
			break;

	}

	return m_enuResult;
}

void 
CPKCmdGrp::OnErrorPrint(const OI_RESULT oResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod)
{
}

CMDRESULT 
CPKCmdGrp::execAdd(CTFServerResource* pSvrItem, TF_STRING_W& strGrpUri)
{
	CMDRESULT enuResult = TF_CMD_FAIL;
	bool bResult;

	// リクエストを行なうURIを作成する
	strGrpUri += m_cGrpItem.GetName();
	strGrpUri += X("/");
	m_cGrpItem.SetURI(strGrpUri.c_str());

	TF_STRING_W strName = (const TFXMLCh*)m_cGrpItem.GetName();

	CTFDavResource cDummyItem;
	cDummyItem.SetServerID(pSvrItem->GetServerID());
	cDummyItem.SetURI(pSvrItem->GetURI());

	m_cTrans.m_bSeqParentchk = false;	// 親フォルダのチェックをしない

	/*
	 *	MKCOLを行なう場合には名前に/がついていてはいけない
	 */
	size_t nPos = strName.rfind(X("/"));
	TF_STRING_W	strTmpName;
	if (nPos > 0)
	{
		strTmpName = strName.substr(nPos+1);
		m_cGrpItem.SetName(strTmpName.c_str());
	}

	bResult = m_cTrans.MakeColEx(&cDummyItem, TF_XML_BODY_GRP, (CTFResourceItem*)&m_cGrpItem);
	m_cGrpItem.SetName(strName.c_str());	// 元に戻す

	bool bRootUserFound=false;
	if (bResult)
	{
		CTFResourcePropTFUser cAdminUser;
		cAdminUser.SetServerID(pSvrItem->GetServerID());
		cAdminUser.SetUID(pSvrItem->GetUserID());

		CTFResourceItemList cUsrList;
		CTFResourceItemList cGrpList;
		cGrpList.AddItem((CTFResourceItem*)m_cGrpItem.Clone());

		// 所属ユーザを割り当てる
		if (!m_strUsers.empty())
		{
			TF_STRING_W strUser;
			CTFResourcePropTFUser	cUsrItem;

			CTFStringTokenizer cToken(m_strUsers.c_str(), C2W(","));
			while(cToken.GetNextToken(strUser))
			{
				// 割り当てするユーザに操作する自分自身のIDが含まれているか確認
				if (TF_STRING_W(pSvrItem->GetUserID()).compare(strUser.c_str()) == 0)
					bRootUserFound = true;

				cUsrItem.SetServerID(pSvrItem->GetServerID());
				cUsrItem.SetUID(strUser.c_str());
				cUsrList.AddItem((CTFResourceItem*)cUsrItem.Clone());
			}

		}	// if (!m_strUsers.empty())

		
		// 初期フォルダを作るときにグループにこのコマンドの操作者が
		// 所属されていない場合は一時的に所属させる
		if (!bRootUserFound && !m_strFolders.empty())
		{
			cUsrList.AddItem((CTFResourceItem*)cAdminUser.Clone());
		}

			// 割り当てユーザが正しく一人いた場合だけ処理
		if (cUsrList.GetItemCount() > 0)
		{
			// 割り当て処理
			bResult = m_cTrans.SetAvailableUser(pSvrItem->GetServerID(), &cGrpList, &cUsrList);
			if (bResult)
			{
				//　全て成功した
				enuResult = TF_CMD_OK;
			}
			else
			{
				// 割り当てに失敗したが正常エラーとする
				enuResult = TF_CMD_OK_ERROR;
			}
		}

		// 処理フォルダを作成する
		if (!m_strFolders.empty())
		{
			CTFResourceProp* pTmpList=0;
			TF_STRING_W	strGrpUri;

			// フォルダを作成するグループを問い合わせる
			bResult = m_cTrans.SearchGroup(pSvrItem->GetServerID(), &m_cGrpItem, &pTmpList, TF_SEARCH_GI_CONTENT);
			if (bResult)
			{
				CTFDavResourceList* pGrpList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pTmpList);
				if (pGrpList)
				{
					CTFResourcePropTFGroup* pGrpItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup, pGrpList->GetNextItem());
					if (pGrpItem)
						strGrpUri = pGrpItem->GetGroupCollectionUri();
				}
			}
			if (pTmpList) delete pTmpList;

			// グループのURIが分かった場合だけ処理
			if (!strGrpUri.empty())
			{
				TF_STRING_W strFolder;
				CTFStringTokenizer cToken(m_strFolders.c_str(), C2W(","));
				while(cToken.GetNextToken(strFolder))
				{
					bResult = m_cTrans.MakeCol(pSvrItem->GetServerID(), strGrpUri.c_str(), strFolder.c_str());
				}
			}

		}	// if (!m_strFolders.empty())

		// 一時的に追加した管理者ユーザをグループから除外する
		if (!bRootUserFound && !m_strFolders.empty())
		{
			TF_STRING_W strDelUsrURI;
			strDelUsrURI += m_cGrpItem.GetURI();
			strDelUsrURI += X(TF_AVAILABLE_USER_PREFIX);
			strDelUsrURI += pSvrItem->GetUserID();
			CTFDavResource cDavItem;
			cDavItem.SetURI(strDelUsrURI.c_str());

			bResult = m_cTrans.Delete(pSvrItem->GetServerID(), NULL, (CTFResourceItem*)&cDavItem);
		}

		// グループのオーナー設定ならば追加する
		if (!m_strOwnerID.empty())
		{
			enuResult = changeLeader(pSvrItem, TFCMD_ADD);
		}

	}
	else
	{
//		std::cerr << m_cTrans.GetLastError() << " failed in group making." << std::endl;

		// TODO: グループ作成のエラーを書きなさい
		switch(m_cTrans.GetLastError())
		{
			case TF_RESULT_CANTCREATEFOLDER:
				enuResult = TF_CMD_CANTCREATEFOLDER;
				break;

			case TF_RESULT_GROUP_RESOURCE_EXIST:
				enuResult = TF_CMD_GRP_EXIST;

				break;
			default:
				enuResult = TF_CMD_FAIL;
				break;

		}
	}

	if (bResult)
	{
		enuResult = TF_CMD_OK;
//		std::cerr << (const char*)X(m_cGrpItem.GetName()) << " created." << std::endl;
	}

	return enuResult;
}

CMDRESULT
CPKCmdGrp::execDelete(CTFServerResource* pSvrItem, TF_STRING_W& strGrpUri)
{
	CMDRESULT enuResult = TF_CMD_FAIL;
	bool bResult;

	strGrpUri += m_cGrpItem.GetName();
	strGrpUri += X("/");
	m_cGrpItem.SetURI(strGrpUri.c_str());

	if (!TF_STRING_W(m_cGrpItem.GetURI()).empty())
	{
		// bResult = m_cTrans.Delete(pSvrItem->GetServerID(), NULL, (CTFResourceItem*)&m_cGrpItem, m_bqFlag);
		bResult = m_cTrans.Delete(pSvrItem, &m_cGrpItem, m_bqFlag);
	}

	if (bResult)
	{
//		std::cerr << ((TF_STRING_W(m_cGrpItem.GetID()).empty()) ? (const char*)X(m_cGrpItem.GetName()) : (const char*)X(m_cGrpItem.GetID())) << " deleted." << std::endl;
		enuResult = TF_CMD_OK;
	}
	else
	{
//		std::cerr << m_cTrans.GetLastError() << " failed to delete group" << std::endl;
		switch(m_cTrans.GetLastError())
		{
			case TF_RESULT_FAILDDEPEND:
				enuResult = TF_CMD_GRP_DEL_FAIL;
				break;

			default:
				enuResult = TF_CMD_FAIL;
		}
	}

	return enuResult;
}

CMDRESULT
CPKCmdGrp::execView(CTFServerResource* pSvrItem)
{
	CMDRESULT enuResult = TF_CMD_FAIL;
	bool bResult;
	CTFResourcePropTFGroup* pGrpItem  = NULL;
	CTFDavResourceList*		pDavList2 = NULL;
	CTFResourceProp*		pPropList = 0;
//	TF_SEARCH_GI			enuType   = (TF_STRING_W(m_cGrpItem.GetName()).find(X("*")) != TF_STRING_W::npos)?TF_SEARCH_GI_DETAILLIST:TF_SEARCH_GI_CONTENT;
	TF_SEARCH_GI			enuType   = (TF_STRING_W(m_cGrpItem.GetName()).find(X("*")) != TF_STRING_W::npos)?TF_SEARCH_GI_TREELIST:TF_SEARCH_GI_CONTENT;

	if (enuType == TF_SEARCH_GI_DETAILLIST)
	{
		if (!m_bhFlag) m_bSkipAvailableUser = true;

		if (TF_STRING_W(m_cGrpItem.GetName()).size() == 1)
		{
			m_cGrpItem.SetID(X(""));
			m_cGrpItem.SetName(X(""));
		}	
		else 
		{
			m_cGrpItem.SetID(X(""));
			TF_STRING_W strName = m_cGrpItem.GetName();
			CTFURL cURL(strName.c_str());
			m_cGrpItem.SetName(cURL.m_strDir.c_str());
		}
	}


	bResult = m_cTrans.SearchGroup(pSvrItem->GetServerID(), &m_cGrpItem, &pPropList, enuType);
	if (bResult)
	{
		CTFDavResourceList* pDavList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pPropList);
		if (pDavList)
		{
			pGrpItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup, pDavList->GetNextItem());
			if (pGrpItem)
			{
/*
				// 所属ユーザを探す
				CTFResourceProp* pAvaUsrList=0;
				bResult = m_cTrans.SearchGroup(pSvrItem->GetServerID(), &m_cGrpItem, &pAvaUsrList, TF_SEARCH_GI_AVAILABLEUSER);

				if (pAvaUsrList)
				{
					pDavList2 = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pAvaUsrList);
				}


				// 出力処理
				if (m_enuOutFmt == PKCMDOUTFMT_XML)
					printXML(*pGrpItem, *pDavList2);
				else
					printPlain(*pGrpItem, *pDavList2);

				if (pAvaUsrList) delete pAvaUsrList;
*/

			} // if (pGrpItem)

		} 

		if (m_nCAll)
		{
			if (m_enuOutFmt == PKCMDOUTFMT_XML)
			{
				std::cout <<	"</groupinformation>"	<< std::endl;
			}

			enuResult = TF_CMD_OK;		// 正常終了
		}
	}
	else
	{
		if (TF_RESULT_NOTFOUND == m_cTrans.GetLastError())
		{
			enuResult = TF_CMD_GRP_NOT_FOUND;		// グループが存在しなかった
		}
		else
		{
			enuResult = TF_CMD_FAIL;				// 不明なエラー
		}
	}

	if (pPropList) delete pPropList;

	return enuResult;
}

CMDRESULT
CPKCmdGrp::execUpdate(CTFServerResource* pSvrItem, TF_STRING_W& strGrpUri)
{
	CMDRESULT	enuResult		= TF_CMD_FAIL;
	bool		bResult			= false;
	bool		bPatchResult	= false;
	TF_STRING_W	strURI;

	strURI  = strGrpUri;
	strURI += m_cGrpItem.GetName();
	strURI += X("/");
	m_cGrpItem.SetURI(strURI.c_str());

	m_cTrans.m_bSeqParentchk = false;	// 親フォルダのチェックをしない
	bPatchResult = m_cTrans.PatchProperty(pSvrItem->GetServerID(), NULL, TF_XML_BODY_GRP, &m_cGrpItem);

	if (bPatchResult)
	{
		enuResult = TF_CMD_OK;

		// サーバの値を利用しない場合はユーザ一覧を削除する
		if (!m_bUntochedUse)
		{
			CTFResourceProp*	pUsers=0;
			CTFDavResourceList*	pDavItems;
			bResult = m_cTrans.SearchGroup(pSvrItem->GetServerID(), &m_cGrpItem, &pUsers, TF_SEARCH_GI_AVAILABLEUSER);
			if (pUsers)
			{
				pDavItems = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pUsers);
				CTFDavResource* pItem;
				for (; pItem = TFLIB_DYNAMIC_CAST(CTFDavResource, pDavItems->GetNextItem()); )
				{
					if (!m_cTrans.Delete(&m_cGrpItem, pItem))
					{
						// グループから外す事ができなかった。
						enuResult = TF_CMD_GRP_RELEASE_USER_FAIL;
					}
				}
			}
			if (pUsers) delete pUsers;
		}

		if (!m_strUsers.empty())
		{
			CTFResourcePropTFUser	cUsrItem;
			CTFResourceItemList		cUsers;
			CTFResourceItemList		cGroups;
			cGroups.AddItem((CTFResourceItem*)m_cGrpItem.Clone());

			CTFStringTokenizer cToken(m_strUsers.c_str(), C2W(","));
			TF_STRING_W strUser;
			while(cToken.GetNextToken(strUser))
			{
				cUsrItem.SetServerID(pSvrItem->GetServerID());
				cUsrItem.SetUID(strUser.c_str());
				cUsers.AddItem((CTFResourceItem*)cUsrItem.Clone());
			}

			if (cUsers.GetItemCount() > 0)
			{
				bResult = m_cTrans.SetAvailableUser(pSvrItem->GetServerID(), &cGroups, &cUsers);
			}
		}
	}
	else
	{
		enuResult = TF_CMD_FAIL;
		if (TF_RESULT_NORESULT == m_cTrans.GetLastError()) enuResult = TF_CMD_GRP_NOT_FOUND;

//		std::cerr << m_cTrans.GetLastError() << " filed to update." << std::endl;
	}

	// グループリーダーを解任か任命するか？
	if (bPatchResult && ( m_bmFlag || !m_strOwnerID.empty()) )
		enuResult = changeLeader(pSvrItem, TFCMD_UPDATE);

	// -------------------------------------------------------------------------------------
	// 名前変更の処理は一番最後にやること。そうしないと移動してからだと遅い場合もあります。
	// -------------------------------------------------------------------------------------
	// 名前の変更が発生している場合はリネーム処理を行なう
	// 但しパッチが成功していない場合は行なわない
	if (bPatchResult && m_strNewName.compare(m_cGrpItem.GetName()) != 0)
	{
		TF_STRING_W	strDstURI;
		strDstURI  = X(PKGRPRROOT);
		strDstURI += X(m_strNewName.c_str());
		strDstURI += X("/");

		CTFResourceItemList cItems;
		cItems.AddItem((CTFResourceItem*)m_cGrpItem.Clone());

		bResult = m_cTrans.ReName(pSvrItem->GetServerID(), m_cGrpItem.GetURI(), strDstURI.c_str());
		if (bResult)
		{
			enuResult = TF_CMD_OK;
		}
		else
		{
			enuResult = TF_CMD_FAIL;
//			std::cerr << m_cTrans.GetLastError() << " failed to rename." << std::endl;
		}
	}

//	if (enuResult == TF_CMD_OK || enuResult == TF_CMD_OK_ERROR) 
//		std::cerr << (const char*)X(m_cGrpItem.GetName()) << " update success." << std::endl;

	return enuResult;
}

void 
CPKCmdGrp::printPlain(CTFResourcePropTFGroup& cGrp, CTFDavResourceList& cList)
{

	if (!m_bhFlag)
	{
		TF_STRING_A cdate,mdate;
		FormatTimeISO8601(cdate, cGrp.GetCreationDate());
		FormatTimeISO8601(mdate, cGrp.GetLastModified());
		TF_STRING_A strActive;
		if (cGrp.GetGroupState() & TF_GROUPSTATE_ACTIVE)
			strActive = "active";
		else
			strActive = "inactive";

		std::cout	<< "-------------------------------------------"				<< std::endl;
		std::cout	<<	"No       \t: "		<< m_nCAll								<< "\n"
					<<	"GroupName\t: "		<< (const char*)X(cGrp.GetName())		<< "\n"
					<<	"GroupID  \t: "		<< (const char*)X(cGrp.GetID())			<< "\n"
					<<	"Active   \t: "		<< strActive.c_str()					<< "\n"
					<<	"Owner    \t: "		<< (const char*)X(cGrp.GetGroupOwnerName()) << " " << (const char*)X(cGrp.GetGroupOwnerID()) << "\n"
					<<	"Created  \t: "		<< cdate.c_str()						<< "\n"
					<<	"Lastmodified\t: "	<< mdate.c_str()						<< "\n"
					<<	"Comment  \t: "		<< (const char*)X(cGrp.GetComment())	<< "\n"
					<<	"Constraints\t: "	<< (const char*)X(cGrp.GetGroupConstraintsString())	<< std::endl;
		std::cout	<<	"MailWatch\t:";
		int nMw = cGrp.GetGrpMailWatch();
		if (nMw & TF_DAV_GET)
			std::cout << " GET";
		if (nMw & TF_DAV_PUT)
			std::cout << " PUT";
		if (nMw & TF_DAV_DELETE)
			std::cout << " DELETE";
		if (nMw & TF_DAV_COPY)
			std::cout << " COPY";
		if (nMw & TF_DAV_MOVE)
			std::cout << " MOVE";
		std::cout << std::endl;
	}

	if (!m_bSkipAvailableUser)
	{
		bool bFirst = true;
		if (!m_bhFlag)
		{
			std::cout << "AvailableUser\t: ";
		}
		else {
			std::cout << "\""<< (const char*)X(cGrp.GetName()) << "\",";
		}

		CTFResourcePropTFUser* pUsrItem;
		for (; pUsrItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFUser, cList.GetNextItem()); )
		{
			if (bFirst)
			{
				std::cout << "\"";
				bFirst = false;
			}
			else
			{
				std::cout << ",\"";
			}

			std::cout << (const char*)X(pUsrItem->GetName()) << "(" << (const char*)X(pUsrItem->GetUID()) << ")" << "\"";
		}
	}

	if (m_bhFlag)
	{
		std::cout << std::endl;
	}
	else
	{
		std::cout << "\n-------------------------------------------" << std::endl;
		std::cout << std::endl;
	}
}

void 
CPKCmdGrp::printXML(CTFResourcePropTFGroup& cGrp, CTFDavResourceList* pList)
{
	CPKCmdGrpXmlPrinter	cXMLPrinter;
	cXMLPrinter.PrintGroupItem(cGrp, pList);
}

bool
CPKCmdGrp::OnShowResource(CTFResourceItem* pItem)
{
	TFITEMTYPE enuType = pItem->GetType();
	CTFResourcePropTFGroup* pGrpItem;
	CTFDavResourceList*		pDavList = NULL;

	// グループの場合だけ処理
	if (enuType == TFITEM_MNG_GRP && m_enuOutFmt != PKCMDOUTFMT_NONE)
	{
		bool bResult;

		pGrpItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup, pItem);
		if (pGrpItem == NULL) return false;
		m_nCAll++;

		CTFResourceProp* pAvaUsrList=0;
		if (!m_bSkipAvailableUser)
			bResult = m_cTrans.SearchGroup(pItem->GetServerID(), pGrpItem, &pAvaUsrList, TF_SEARCH_GI_AVAILABLEUSER);

		if (pAvaUsrList) pDavList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pAvaUsrList);

		if (m_strLastID.compare(pGrpItem->GetID()) != 0)
		{
			if (m_enuOutFmt == PKCMDOUTFMT_XML)
			{
				if (m_nCAll == 1)
				{
					std::cout << "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\n" << std::endl;
					std::cout << "<groupinformation>" << std::endl;
				}

				printXML(*pGrpItem, pDavList);
			}
			else 
			{
				printPlain(*pGrpItem, *pDavList);
			}
		}

		if (pGrpItem->GetChildCount())
		{
			if (m_strLastID.compare(pGrpItem->GetID()) != 0)
			{
				m_strLastID = pGrpItem->GetID();
				CTFResourceProp* pPropList = NULL;
				bResult = m_cTrans.SearchGroup(pGrpItem->GetServerID(), pGrpItem, &pPropList, TF_SEARCH_GI_TREELIST);
			}
		}
	}

	return true;
}

CMDRESULT 
CPKCmdGrp::changeLeader(CTFServerResource* pSvrItem, CMDMODE enuMode)
{
	CMDRESULT enuResult = TF_CMD_FAIL;

	CTFResourceProp* pProp = 0;
	bool bResult = m_cTrans.SearchGroup(pSvrItem->GetServerID(), &m_cGrpItem, &pProp, TF_SEARCH_GI_CONTENT);
	if (bResult)
	{
		// 成功
		CTFDavResourceList* pDavList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pProp);
		CTFResourcePropTFGroup* pGrpItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup, pDavList->GetNextItem());

		// 解任する
		// 失敗しても気にしない
		if (m_bmFlag && !TF_STRING_W(pGrpItem->GetGroupOwnerID()).empty())
		{
			if (m_cTrans.PatchProperty(pSvrItem->GetServerID(), NULL, TF_XML_BODY_CHGLEADER_DISMISS, pGrpItem))
			{
				enuResult = TF_CMD_OK;
				pGrpItem->SetGroupOwnerID(C2W("")); //　後のためにグループIDを削除する
			}
		}

		// 任命する
		if (!m_strOwnerID.empty())
		{
			// 任命
			if (TF_STRING_W(pGrpItem->GetGroupOwnerID()).empty())
			{
				pGrpItem->SetGroupOwnerID(m_strOwnerID.c_str());
				if (m_cTrans.PatchProperty(pSvrItem->GetServerID(), NULL, TF_XML_BODY_CHGLEADER_APPOINT, pGrpItem))
					enuResult = TF_CMD_OK;
			}
			else
			{
				// 存在していたらオーナー存在エラー
				enuResult = TF_CMD_GRP_GROUPOWNERFOUND;
			}
		}
	}
	else
	{
		// 失敗
		if (m_cTrans.GetLastError() == TF_RESULT_NOTFOUND)
			enuResult = TF_CMD_OK_ERROR;
		else
			enuResult = TF_CMD_FAIL;
	}

	return enuResult;
}
