/*
 * $Id$
 */

#include <libpkcmd/PKCmdBase.h>
#include <libteamfile/TFResourcePropTFGroup.h>

#define PKGRPRROOT	".management/GROUP/"

class CPKCmdGrp :
	public CPKCmdBase
{
public:
	CPKCmdGrp(void);
	~CPKCmdGrp(void);

	bool OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod);
	bool OnShowResource(CTFResourceItem* pItem);

	void OnQueryProgramInfo(CPKPROGINFO &info);
	bool OnFoundParam(const int nKey, const TFXMLByte* pszValue);
	bool OnQueryUsage(const int nOpt, OI_STRING_A& strUsage);
	void OnKnownOptions(OI_STRING_A& strOpt);
	CMDRESULT OnIsValid(CMDMODE enuMode);
	void OnErrorPrint(const OI_RESULT oResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod);
	int OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem);

private:
	CMDRESULT execAdd(CTFServerResource* pSvrItem, TF_STRING_W& strGrpUri);
	CMDRESULT execDelete(CTFServerResource* pSvrItem, TF_STRING_W&);
	CMDRESULT execView(CTFServerResource* pSvrItem);
	CMDRESULT execUpdate(CTFServerResource* pSvrItem, TF_STRING_W&);
	void printPlain(CTFResourcePropTFGroup& pGrp, CTFDavResourceList& cList);
	void printXML(CTFResourcePropTFGroup& pGrp, CTFDavResourceList* pList);
	CMDRESULT changeLeader(CTFServerResource* pSvrItem, CMDMODE enuMode);

private:
	CTFResourcePropTFGroup	m_cGrpItem;
	TF_STRING_W				m_strUsers;
	TF_STRING_W				m_strFolders;
	bool					m_bUntochedUse;
	TF_STRING_W				m_strNewName;
	OI_SIZE_T				m_nCAll;
	bool					m_bqFlag;			//< 強制削除フラグ
	bool					m_bmFlag;			//< グループオーナー解任
	TF_STRING_W				m_strActive;		//< アクティブ
	TF_STRING_W				m_strConstraints;	//< グループ制約
	bool					m_bSkipAvailableUser;	//< 所属ユーザをスキップする
	TF_STRING_W				m_strOwnerID;		//< グループオーナーID
	bool					m_bhFlag;			//< ユーザ一覧まで表示する

	TF_STRING_W				m_strLastID;		//< View時に利用するカレントグループID
};
