#include "PKCmdGrpXmlPrinter.h"

CPKCmdGrpXmlPrinter::CPKCmdGrpXmlPrinter(void)
{
}

CPKCmdGrpXmlPrinter::~CPKCmdGrpXmlPrinter(void)
{
}

/**
 *	グループをXML出力する
 */
void 
CPKCmdGrpXmlPrinter::PrintGroupItem(CTFResourcePropTFGroup& cGroupItem, CTFDavResourceList* pList)
{

	CTFXmlBodyBuilder	cXMLBuilder;
	cXMLBuilder.Initialize(C2W("groupinformation"), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));
	cXMLBuilder.AddDefaultNameSpace();
	cXMLBuilder.AddPropChild(C2W("group"), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	cXMLBuilder.AddPropGroupID(cGroupItem.GetID());
	cXMLBuilder.AddPropName(cGroupItem.GetName());
	cXMLBuilder.AddPropCreationDt(cGroupItem.GetCreationDate());
	cXMLBuilder.AddPropUpdateDt(cGroupItem.GetLastModified());
	cXMLBuilder.AddPropComment(cGroupItem.GetComment());
	cXMLBuilder.AddPropGroupMailWatch(cGroupItem.GetGrpMailWatch());
	cXMLBuilder.AddPropGroupUri(cGroupItem.GetGroupCollectionUri());
	cXMLBuilder.AddPropGroupConstraints(cGroupItem.GetGroupConstraints());
	cXMLBuilder.AddPropGroupState(cGroupItem.GetGroupState());

	XNS(DOMElement)* pParent = 	cXMLBuilder.AddPropFamily(C2W("availableuser"), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (pList != NULL && pList->GetItemCount() > 0)
	{
		XNS(DOMElement)* pOneUsr;
		XNS(DOMElement)* pNode;

		CTFResourcePropTFUser* pItem;
		for (;pItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFUser, pList->GetNextItem());)
		{
			pOneUsr = cXMLBuilder.AddPropChild(pParent, C2W("user"));

			pNode = cXMLBuilder.AddPropChild(pOneUsr, C2W(TF_PROP_USERID));
			if (pNode)
				cXMLBuilder.AddPropNodeValue(pNode, pItem->GetUID());

			pNode = cXMLBuilder.AddPropChild(pOneUsr, C2W(TF_PROP_NAME));
			if (pNode)
				cXMLBuilder.AddPropNodeValue(pNode, pItem->GetName(), true);

			pNode = cXMLBuilder.AddPropChild(pOneUsr, C2W(TF_PROP_MAILADDR));
			if (pNode)
				cXMLBuilder.AddPropNodeValue(pNode, pItem->GetMailAddr(), true);

		}
	}

	cXMLBuilder.Print(cXMLBuilder.GetElementByName(C2W("group")));
}

