#include "PKCmdList.h"
#include <libteamfile/TFResourcePropTF.h>

CPKCmdList::CPKCmdList(void)
{
	m_baFlag = false;
	m_blFlag = false;
	m_strTargetURI.erase();
	m_bOneFlag = false;
}

CPKCmdList::~CPKCmdList(void)
{
}

bool
CPKCmdList::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{
	TF_STRING_W strValue;
	OI_STRING_A strAscii;

	strValue = (const TFXMLCh*)X(pszValue);
	strAscii = (const char*)X(pszValue);

	switch(nKey)
	{
		case 'a':	// all hide .
			m_baFlag = true;
			break;

		case 'l':	// long format
			m_blFlag = true;
			break;

		case 't':	// ターゲットURI
			m_strTargetURI = strValue;
			break;

		case '1':	// URIだけを出力
			m_bOneFlag = true;
			break;

		default:
			return false;
			break;
	}

	return true;
}

bool
CPKCmdList::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{
	bool bResult = true;

	switch(nOpt)
	{
		case 'a':
			strUsage = "do not hide entries starting with .";
			break;

		case 'l':
			strUsage = "use a long list format";
			break;

		case 't':
			strUsage = "target uri";
			break;

		case '1':
			strUsage = "list one file per line";
			break;

		default:
			bResult = false;
			break;
	}

	return bResult;
}

void
CPKCmdList::OnQueryProgramInfo(CPKPROGINFO &info)
{
	info.strProgName = "tflist";
	info.strVersion  = TFCMDVERSION;
	info.strDisc	 = "TeamFile PROPFIND CommandLine";
}

void
CPKCmdList::OnKnownOptions(OI_STRING_A& strOpt)
{
	strOpt = "alt:1";
}

CMDRESULT
CPKCmdList::OnIsValid(CMDMODE enuMode)
{
	return TF_CMD_OK;
}

int
CPKCmdList::OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem)
{
	TF_STRING_W	strFile;
	TF_STRING_W strFiles;
	CMDRESULT cmdResult = TF_CMD_FAIL;

	CTFDavResource		cDavItem;
	TF_STRING_W			strURI = pSvrItem->GetURI();
	strURI += m_strTargetURI;
	cDavItem.SetURI(strURI.c_str());
	cDavItem.SetServerID(pSvrItem->GetServerID());

	// 一覧表を取得する
	CTFResourceProp* pProp=0;
	m_cTrans.SetKeepSession(true);
	if (!m_cTrans.List(&cDavItem, &pProp))
	{
		switch(m_cTrans.GetLastError())
		{
			case TF_RESULT_NOTFOUND:
				cmdResult = TF_CMD_PARENTFOLDER_NOTFOUND;
				break;

			case TF_RESULT_INTERNALSERVERERROR:
				cmdResult = TF_CMD_SERVER_ERROR;
				break;

			case TF_RESULT_SOCKGENERICERROR:
				cmdResult = TF_CMD_CON_FAILED;
				break;

			case TF_RESULT_WRONGUSERPASSWORD:
			case TF_RESULT_PROXYTUNNELFAIL:
				cmdResult = TF_CMD_PRM_AUTH_PROXY_FAIL;
				break;

			default:
				cmdResult  = TF_CMD_FAIL;
		}
	}
	else 
	{
		cmdResult = TF_CMD_OK;
	}

	m_cTrans.SetKeepSession(false);
	if (pProp) delete pProp;

	return cmdResult;

}
bool
CPKCmdList::OnShowResource(CTFResourceItem* pItem)
{
	CTFDavResource* pDavItem = TFLIB_DYNAMIC_CAST(CTFDavResource, pItem);
	CTFResourcePropTF* pTFProp = TFLIB_DYNAMIC_CAST(CTFResourcePropTF, pItem);

	if (m_baFlag) 
	{
		RemoveSlash(m_strTargetURI);
		CTFURL cURL(m_strTargetURI.c_str());
		if (TF_STRING_W(pItem->GetName()).compare(cURL.m_strName) == 0)
		{
			return true;
		}
	}

	// 更新日
	TF_STRING_A strTime;
	time_t tLast = pTFProp->GetLastModified();
	FormatTimeJapan(strTime, tLast);

	// 更新者
	TF_STRING_A strUser = (const char*)X(pTFProp->GetLastModifire());
	// パーミッション
	char chpar[11] = {0};

	TF_STRING_A strMe, strGrp, strOther;
	if (pTFProp->IsCollection())
		strMe = strGrp = strOther = "rwx";
	else
		strMe = strGrp = strOther = "rw-";

	TFUSERPRIV nPriv = pTFProp->GetUserPrivilegeGrantSet();

	// カラム 意味
	// 1      ディレクトリならd
	// 2      ユーザ権限 rwx
	// 3      グループ権限 rwx
	// 4      その他ユーザ権限 rwx
	sprintf(chpar, "%s%s%s%s", pTFProp->IsCollection() ? "d" : "-", strMe.c_str(), strGrp.c_str(), strOther.c_str()); 
//	sprintf(chpar, "%srw-rw-rw-", pTFProp->IsCollection() ? "d" : "-"); 

	// ファイルの長さ
	char chLen[64] = {0};
	sprintf(chLen, "%10d", pTFProp->GetContentLength());

	if (m_bOneFlag)
	{
		if (m_blFlag)
			std::cout << (const char*)X(pDavItem->GetURI()) << std::endl;
		else
		{
			std::cout << (const char*)X(pDavItem->GetName());
			if (pTFProp->IsCollection()) std::cout << "/";
			std::cout << std::endl;
		}
	}
	else
	{
		std::cout << chpar << " " << " " << strUser.c_str() << " " << strTime.c_str() << "  " << chLen << " " << (const char*)X(pDavItem->GetName()) << std::endl;
	}

	return true;
}
