#ifndef __TF_CMD_PKCMDPUT_H_
#define __TF_CMD_PKCMDPUT_H_

#include <libpkcmd/PKCmdBase.h>
#include "libteamfile/TFRegex.h"
#include "libteamfile/TFLocalFileUtils.h"

class CPKCmdPut :
	public CPKCmdBase
{
public:
	CPKCmdPut(void);
	~CPKCmdPut(void);

	void OnQueryProgramInfo(CPKPROGINFO &info);
	bool OnFoundParam(const int nKey, const TFXMLByte* pszValue);
	bool OnQueryUsage(const int nOpt, OI_STRING_A& strUsage);
	void OnKnownOptions(OI_STRING_A& strOpt);
	CMDRESULT OnIsValid(CMDMODE enuMode);
	int OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem);

	void OnResultLocalResource( const TFTRANSMODE enuMode,
								const TFDAVMETHOD enuMethod, 
									  CTFLocalFileItem* pItem,
								const TFRESULT nResult);

	bool OnQueryRecursiveLocalResource(TF_SIZE_T stratum, CTFLocalFileItem* pItem);
	bool OnQueryDetailLocalResource(CTFLocalFileItem* pLocalItem, TFTRANSMODE enuMode);

protected:
	CTFLocalFileUtils*	m_pLocalFileUtils;	//　ローカルファイルユーティリティ
	CTFLocalFileItem*	m_pCmpItem;			//　比較対象のアイテム

private:
	TF_STRING_W		m_strDateTime;	//< アップロード条件の日付
	time_t			m_tjst;			//< 上のtime_tに変換した値
	TF_STRING_W		m_strFiles;		//< ファイル一覧
	TF_STRING_W		m_strTargetURI;	//< ターゲットURI
	bool			m_bRecarsive;	//< １階層のみ処理
	bool			m_bCreateFolder;//< ターゲットフォルダを作成
	
};

#endif

