#include "PKCmdStat.h"
#include <iostream>
#include <time.h>

#include "PKCmdStatXmlPrinter.h"

CPKCmdStat::CPKCmdStat(void)
:m_nLimit(95),
 m_nType(CMD_STAT_HEAD_NONE),
 m_nCntAll(0),
 m_nCntRO(0),
 m_nCntUO(0),
 m_nCntRW(0),
 m_nCntSV(0),
 m_nCntExpired(0),
 m_nCntAdmin(0),
 m_nCntNormal(0),
 m_nCntLimited(0),
 m_nResUsedTotal(0),
 m_nResMaxTotal(0),
 m_nStoUsedTotal(0),
 m_nStoMaxTotal(0),
 m_nCntGroupLeader(0)
{
}

CPKCmdStat::~CPKCmdStat(void)
{
}

bool
CPKCmdStat::OnShowResource(CTFResourceItem* pItem)
{
	CTFResourcePropTFStatus* pStatItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFStatus, pItem);
	if (!pStatItem) return false;
	
	OI_SIZE_T	nResUsed=0;
	OI_SIZE_T	nResMax=0;
	OI_SIZE_T	nStoUsed=0;
	OI_SIZE_T	nStoMax=0;
	// 合計
	m_nCntAll++;
	nResUsed = pStatItem->GetResources(TF_STAT_USED);
	nResMax  = pStatItem->GetResources(TF_STAT_MAX);
	nStoUsed = pStatItem->GetStorages(TF_STAT_USED);
	nStoMax  = pStatItem->GetStorages(TF_STAT_MAX);

	if (m_nType & CMD_STAT_HEAD_LIST)
	{
		if (m_enuOutFmt & PKCMDOUTFMT_XML)
		{
			if (m_nCntAll == 1)
			{
				printf("<?xml version=\"1.0\" encoding=\"UTF8\" standalone=\"no\" ?>\n");
				printf("<statusinformation>");
			}

			printXML(m_nCntAll, *pStatItem);
		}
		else
			printPlain(m_nCntAll, *pStatItem);
	}
	
	if (m_nType & CMD_STAT_HEAD_COUNT)
	{
		if (pStatItem->GetUserType() == TF_USER_TYPE_ADMIN)
		{
			m_nCntAdmin++;
		}
		if (pStatItem->GetUserType() == TF_USER_TYPE_GROUPLEADER)
		{
			m_nCntGroupLeader++;
		}

		if (pStatItem->GetUserType() == TF_USER_TYPE_LIMITED)
		{
			m_nCntLimited++;
		}

		if (pStatItem->GetPrivilege() & TF_USER_PRIV_READ)
		{
			m_nCntRO++;
		}
		if (pStatItem->GetPrivilege() & TF_USER_PRIV_UPLOAD)
		{
			m_nCntUO++;
		}
		
		if (pStatItem->GetPrivilege() & TF_USER_PRIV_READWRITE)
		{
			m_nCntRW++;
		}

		if (pStatItem->GetPrivilege() & TF_USER_PRIV_SET_VIEW)
		{
			m_nCntSV++;
		}

		if (pStatItem->GetExpiration() >0)
		{
			m_nCntExpired++;
		}

		// 全体合計
		m_nResUsedTotal += nResUsed;
		m_nResMaxTotal  += nResMax;
		m_nStoUsedTotal += nStoUsed;
		m_nStoMaxTotal  += nStoMax;
	}
	
	// ワーニング
	if (m_nType & (CMD_STAT_HEAD_WARNING | CMD_STAT_HEAD_NOTICE))
	{
		// メールアドレスが空白のユーザ
		if (TF_STRING_W(pStatItem->GetMailAddr()).empty())
			m_cNonMailUser.AddItem((CTFResourcePropTFStatus*)pStatItem->Clone());

		// リソース数がオーバーしそうなユーザ
		if (nResMax > 0)
		{
			if ((pStatItem->GetResources(TF_STAT_USED) * 100) / pStatItem->GetResources(TF_STAT_MAX) >= m_nLimit)
				m_cOverRes.AddItem((CTFResourcePropTFStatus*)pStatItem->Clone());
		}

		// ストレージ容量がオーバーしそうなユーザ
		if (nStoMax > 0)
		{
			if ((pStatItem->GetStorages(TF_STAT_USED) * 100) / pStatItem->GetStorages(TF_STAT_MAX) >= m_nLimit)
				m_cOverSto.AddItem((CTFResourcePropTFStatus*)pStatItem->Clone());
		}

	}
	
	// 通知系
	if (m_nType & CMD_STAT_HEAD_NOTICE)
	{
	
	}
	
	return false;	//　アイテムはリストに追加させない
}

void 
CPKCmdStat::OnQueryProgramInfo(CPKPROGINFO &info)
{
	info.strDisc = "TeamFile Statisitical info CommandLine";
	info.strProgName = "tfstat";
	info.strVersion = TFCMDVERSION;
}

bool
CPKCmdStat::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{

	if (pszValue == NULL) return false;

	OI_STRING_A strLine;

	strLine = (const char*)X(pszValue);

	if (nKey == 'h')
	{
		OI_STRING_A strValue;
		MakeLowerA(strLine);
		CDavStringTokenizer cToken(strLine.c_str(), ",");
		while(cToken.GetNextToken(strValue))
		{
			TrimRightA(strValue);
			TrimLeftA(strValue);
			if (strValue.compare("list") == 0)
			{
				m_nType |= CMD_STAT_HEAD_LIST;
				continue;
			}

			if (strValue.compare("count") == 0)
			{
				m_nType |= CMD_STAT_HEAD_COUNT;
				continue;
			}

			if (strValue.compare("warning") == 0)
			{
				m_nType |= CMD_STAT_HEAD_WARNING;
				continue;
			}

			if (strValue.compare("notice") == 0)
			{
				m_nType |= CMD_STAT_HEAD_NOTICE;
				continue;
			}

			return false;	// 該当しない値だった場合はエラー
		}
	}

	// リミット
	if (nKey == 'l')
	{
		if (strLine.empty()) return false;
		int nPer = atoi(strLine.c_str());
		if (nPer < 1 || nPer > 100) return false;
		m_nLimit = nPer;
	}

	
	return true;
}

bool 
CPKCmdStat::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{
	strUsage = "";
	switch(nOpt)
	{
		case 'h':
			strUsage = "Output Header [ list | count | warning | notice ]";
			break;

		case 'l':
			strUsage = "Warning Limit (parcent) (ex.: -l 95) default 95";
			break;

		default:
			break;
	}

	return true;
}

void
CPKCmdStat::OnKnownOptions(OI_STRING_A& strOpt)
{
	strOpt = "h:l:";
}

CMDRESULT
CPKCmdStat::OnIsValid(CMDMODE enuMode)
{
	if (m_nType == CMD_STAT_HEAD_NONE)
		return TF_CMD_PRM_INVALID_PARAM;

	return TF_CMD_OK;
}

int
CPKCmdStat::OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem)
{
	bool		bResult = false;
	TF_STRING_W	strURI;
	strURI  = pSvrItem->GetURI();
	strURI += X(TF_URI_MNG_STATUS);

	CTFDavResource cItem;
	cItem.SetServerID(pSvrItem->GetServerID());
	cItem.SetURI(strURI.c_str());
	CTFResourceProp* pItems=0;

	bResult = m_cTrans.SearchStatus(&cItem, &pItems);
	if (!bResult) return TF_CMD_FAIL;
	if (pItems) delete pItems;
	
	// リスト表示を行なう
	if (m_nType & CMD_STAT_HEAD_LIST)
	{
		if (m_nCntAll && m_enuOutFmt == PKCMDOUTFMT_XML)
			std::cout << "\n</statusinformation>" << std::endl;
	}

	// カウント表示を行う
	if (m_nType & CMD_STAT_HEAD_COUNT)
	{
		printf("<< Account Report >>\n");
		printf("Total User　　:%6d\n", m_nCntAll);
		printf("　Admin   　　:%6d\n", m_nCntAdmin);
		printf("  GroupLeader :%6d\n", m_nCntGroupLeader);
		printf("　General     :%6d\n", m_nCntAll - m_nCntAdmin - m_nCntLimited - m_nCntGroupLeader);
		printf("　Limited     :%6d\n", m_nCntLimited);
		printf("\n");
		
		printf("<< Privilege Report >>\n");
		printf("Read Only User  :%6d\n", m_nCntRO);
		printf("Upload Only User:%6d\n", m_nCntUO);
		printf("Read/Write User :%6d\n", m_nCntRW);
		printf("Public User     :%6d\n", m_nCntSV);
		printf("Expired User    :%6d\n", m_nCntExpired);
		printf("\n");
		
		printf("<< Storage Report >>\n");
		char ch[160];
		sprintf(ch, OI_SIZEFORMAT " / " OI_SIZEFORMAT, m_nResUsedTotal, m_nResMaxTotal);
		printf("Resource (Used / Max) :%s\n", ch);
		sprintf(ch, OI_SIZEFORMAT " MB / " OI_SIZEFORMAT" MB", m_nStoUsedTotal / 1024 / 1024,  m_nStoMaxTotal / 1024 / 1024);
		printf("Storages (Used / Max) :%s\n", ch);
		printf("\n");
	}

	CTFResourcePropTFStatus* pStatItem;
	//警告系の表示を行う
	if (m_nType & CMD_STAT_HEAD_WARNING)
	{
		if (m_cNonMailUser.GetItemCount() > 0)
			std::cout << "[ メールアドレスが存在しないユーザ (ユーザID)]" << std::endl;

		for (int i=1; pStatItem = (CTFResourcePropTFStatus*)m_cNonMailUser.GetNextItem();i++ )
		{
			std::cout << i << ": " << (const char*)X(pStatItem->GetName()) << " (" << (const char*)X(pStatItem->GetUID()) << ")" << std::endl;
		}
	}

	// 通知系の表示を行う
	if (m_nType & CMD_STAT_HEAD_NOTICE)
	{
		if (m_cOverRes.GetItemCount() > 0)
			std::cout << "[ ファイル数が " << m_nLimit << "% " << "オーバーしているユーザ ]" << std::endl;

		for (int i=1; pStatItem = (CTFResourcePropTFStatus*)m_cOverRes.GetNextItem(); i++ )
		{
			std::cout << i << "\t: " << (const char*)X(pStatItem->GetName()) << std::endl;
		}

		if (m_cOverSto.GetItemCount() > 0)
			std::cout << "[ 利用容量が " << m_nLimit << "% " << "オーバーしているユーザ ]" << std::endl;

		for (int i=1; pStatItem = (CTFResourcePropTFStatus*)m_cOverSto.GetNextItem(); i++ )
		{
			std::cout << i << "\t: " << (const char*)X(pStatItem->GetName()) << std::endl;
		}
	}

	return TF_CMD_OK;

}

void
CPKCmdStat::OnErrorPrint(const OI_RESULT oResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod)
{
}

void 
CPKCmdStat::printPlain(const OI_SIZE_T& nCnt, CTFResourcePropTFStatus& cStatItem)
{
/*
---------------------------------------------------------------
   123: 名前(ユーザID)	最終アクセスクライアント
		<メールアドレス>
		
        

*/
	printf("----------------------------------------------------------\n");
	printf("%6d:", nCnt);	// カウント
	std::cout << " " << (const char*)X(cStatItem.GetName());						// 名前
	std::cout << "(" << (const char*)X(cStatItem.GetUID()) << ")";				// ユーザID
	std::cout << "\t" << (const char*)X(cStatItem.GetLastAccessClient()) << std::endl;
	printf("%6s","");
	OI_STRING_A strMailAddr = (const char*)X(cStatItem.GetMailAddr());
	if (strMailAddr.empty()) strMailAddr = "Unknown Mail address";
	std::cout << "\t<" << strMailAddr.c_str() << ">" << std::endl;	// メールアドレス
	printf("%6s","");
	char ch[160];
	sprintf(ch, OI_SIZEFORMAT " / " OI_SIZEFORMAT "\n", cStatItem.GetStorages(TF_STAT_USED), cStatItem.GetStorages(TF_STAT_MAX));
	printf("%s\n",ch);
}

void
CPKCmdStat::printXML(const OI_SIZE_T& nCnt, CTFResourcePropTFStatus& cStatItem)
{
	CPKCmdStatXmlPrinter	cXMLPrinter;
	cXMLPrinter.PrintStatusItem(cStatItem);
}

