/*
 * $Id$
 */
#include "libpkcmd/PKCmdBase.h"
#include "libteamfile/TFLibDefinition.h"
#include "libteamfile/TFResourcePropTFStatus.h"

enum CMDSTATHEAD {
	CMD_STAT_HEAD_NONE		= 0x00,
	CMD_STAT_HEAD_BASE		= 0x01,
	CMD_STAT_HEAD_COUNT		= 0x02,
	CMD_STAT_HEAD_WARNING	= 0x04,
	CMD_STAT_HEAD_NOTICE	= 0x08,
	CMD_STAT_HEAD_LIST		= 0x10
};

class CPKCmdStat :
	public CPKCmdBase
{
public:
	CPKCmdStat(void);
	~CPKCmdStat(void);

	void OnQueryProgramInfo(CPKPROGINFO &info);
	bool OnFoundParam(const int nKey, const TFXMLByte* pszValue);
	bool OnQueryUsage(const int nOpt, OI_STRING_A& strUsage);
	void OnKnownOptions(OI_STRING_A& strOpt);
	void OnErrorPrint(const OI_RESULT oResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod);
	CMDRESULT OnIsValid(CMDMODE enuMode);
	int OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem);

	// libteamfileハンドラ
	virtual bool OnShowResource(CTFResourceItem* pItem);

protected:
	void printHeader(CMDMODE enuMode, CTFServerResource* pSvrItem);
	void printPlain(const OI_SIZE_T& nCnt, CTFResourcePropTFStatus& cStatItem);
	void printXML(const OI_SIZE_T& nCnt, CTFResourcePropTFStatus& cStatItem);

private:
	int		m_nType;		// 出力タイプ
	int		m_nLimit;		// リミット

	OI_SIZE_T m_nCntAll;	// 全体人数
	OI_SIZE_T m_nCntRO;		// 読み込み専用ユーザ数
	OI_SIZE_T m_nCntUO;		// アップロード専用ユーザ数
	OI_SIZE_T m_nCntRW;		// 読み書き可能ユーザ
	OI_SIZE_T m_nCntSV;		// 公開リソース権限者数
	OI_SIZE_T m_nCntExpired;// 期限切れユーザ数
	OI_SIZE_T m_nCntAdmin;	// 管理者数
	OI_SIZE_T m_nCntNormal;	// 一般人数
	OI_SIZE_T m_nCntLimited;// 制限ユーザ数
	OI_SIZE_T m_nCntGroupLeader;//グループリーダー数
	OI_SIZE_T m_nResUsedTotal;	// 利用リソース合計
	OI_SIZE_T m_nResMaxTotal;	// 全体リソースMAX	
	OI_SIZE_T m_nStoUsedTotal;	// 利用ストレージ容量
	OI_SIZE_T m_nStoMaxTotal;		// 利用される最大ストレージ容量 

	CTFDavResourceList	m_cNonMailUser;
	CTFDavResourceList	m_cOverRes;
	CTFDavResourceList	m_cOverSto;
};
