#include "PKCmdStatXmlPrinter.h"

CPKCmdStatXmlPrinter::CPKCmdStatXmlPrinter(void)
{
}

CPKCmdStatXmlPrinter::~CPKCmdStatXmlPrinter(void)
{
}

/**
 *	ステータスをXML出力する
 */
void 
CPKCmdStatXmlPrinter::PrintStatusItem(CTFResourcePropTFStatus& cStatItem)
{
	CTFXmlBodyBuilder	cXMLBuilder;
	cXMLBuilder.Initialize(C2W("status"));
	cXMLBuilder.AddDefaultNameSpace();
	cXMLBuilder.AddPropChild(C2W("user"), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	cXMLBuilder.AddPropUID(cStatItem.GetUID());
	cXMLBuilder.AddPropName(cStatItem.GetName());
	cXMLBuilder.AddPropPassword(cStatItem.GetPassWord());
	cXMLBuilder.AddPropAdmin(cStatItem.GetAdminFlag());
	cXMLBuilder.AddPropMailAddr(cStatItem.GetMailAddr());
	cXMLBuilder.AddPropComment(cStatItem.GetComment());
	cXMLBuilder.AddPropAccessDeny(cStatItem.GetAccessDeny());
	cXMLBuilder.AddPropUsedResource(cStatItem.GetResources(TF_STAT_USED));
	cXMLBuilder.AddPropMaxResource(cStatItem.GetResources(TF_STAT_MAX));
	cXMLBuilder.AddPropUsedStorage(cStatItem.GetStorages(TF_STAT_USED));
	cXMLBuilder.AddPropMaxStorage(cStatItem.GetStorages(TF_STAT_MAX));
	cXMLBuilder.AddPropUserStatus(cStatItem.GetStatus());
	cXMLBuilder.AddPropUserPrivilege(cStatItem.GetPrivilege());
	cXMLBuilder.AddPropUserType(C2W(cStatItem.GetUserTypeString()));
	cXMLBuilder.AddPropLastAccessClient(cStatItem.GetLastAccessClient());
	cXMLBuilder.AddPropCreationDt(cStatItem.GetCreationDate());
	cXMLBuilder.AddPropLastAccessDt(cStatItem.GetLastModified());
	cXMLBuilder.AddPropExpiration(cStatItem.GetExpiration());

	cXMLBuilder.Print(cXMLBuilder.GetLastElement());
}
