#include "PKCmdUsr.h"
#include "PKCmdUsrXmlPrinter.h"
#include <libteamfile/TFTransaction.h>
#include <libteamfile/TFResourcePropTFGroup.h>
#include <libteamfile/TFStringTokenizer.h>
#include <iostream>
#include <time.h>

CPKCmdUsr::CPKCmdUsr(void):
				 m_bPassView(false)
				,m_nPriv(TF_USER_PRIV_UNKNOWN)
				,m_bUntochedUse(false)
{
	m_baFlag = false;
	m_bbFlag = false;
	m_bdFlag = false;
	m_beFlag = false;
	m_bzflag = false;
	m_blFlag = false;
	m_bvFlag = false;
	m_bqFlag = false;
	m_brFlag = false;
	m_bfFlag = false;
	m_buFlag = false;
	m_boFlag = false;
	m_nCntAll= 0;
	m_bSkipAvailableGroup = false;
	m_btFlag=false;
	m_nAccess = TF_USER_PRIV_NONE;
	m_bOtherControl = false;
	m_bPublish = false;
	m_bhFlag = false;
}

CPKCmdUsr::~CPKCmdUsr(void)
{
}

bool 
CPKCmdUsr::OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod)
{
	// deleteトランザクション時のdelete前のPROPFINDは行わない
	if (enuMode == TF_TRANS_DELETE && enuMethod == TF_DAV_DELETE)
	{
		return false;
	}
	
	return true;
}

void
CPKCmdUsr::OnQueryProgramInfo(CPKPROGINFO &info)
{
	info.strProgName = "tfusr";
	info.strVersion  = TFCMDVERSION;
	info.strDisc	 = "TeamFile UserManagement CommandLine";
}

bool
CPKCmdUsr::OnFoundParam(const int nKey, const TFXMLByte* pszValue)
{

	TF_STRING_W strValue;
	OI_STRING_A strAscii;

	strValue = (const TFXMLCh*)X(pszValue);
	strAscii = (const char*)X(pszValue);

	OI_STRING_A	strExpiration;
	TF_STRING_W strZone;

	switch(nKey)
	{
		case 'a':	//アクセス権限
			MakeLowerA(strAscii);
			if ((strAscii.compare("rw") != 0) &&
				(strAscii.compare("ro") != 0) &&
				(strAscii.compare("uo") != 0)) return false;
			if (strAscii.compare("rw") == 0) m_nAccess |= TF_USER_PRIV_READWRITE;
			if (strAscii.compare("ro") == 0) m_nAccess |= TF_USER_PRIV_READ;
			if (strAscii.compare("uo") == 0) m_nAccess |= TF_USER_PRIV_UPLOAD;
			m_baFlag = true;
			break;

		case 'b':	//リソース公開権限
			m_bbFlag = true;
			MakeLowerA(strAscii);
			m_bPublish = (strAscii.compare("on") == 0);
			break;

		case 'c':	// コメント
			m_cUsrItem.SetComment(strValue.c_str());
			break;

		case 'd':	// ユーザ非アクティブ
			MakeLowerA(strAscii);
			if (strAscii.compare("active") == 0) m_cUsrItem.SetStatus(TF_USER_STATUS_ACTIVE);
			if (strAscii.compare("inactive") == 0) m_cUsrItem.SetStatus(TF_USER_STATUS_INACTIVE);
			break;

		case 'e':	// 有効期限
			// 2005-04-20T14:59:59Z
			m_beFlag = true;
			if (strAscii.compare("0") != 0)
			{
				if (ParseTimeISO8601(strAscii.c_str()) < 0) return false;
			}
			m_cUsrItem.SetExpiration(ParseTimeISO8601(strAscii.c_str()));
			break;

		case 'i':	// ユーザID
			m_cUsrItem.SetUID(strValue.c_str());
			break;

		case 'k':	// 管理者権限
			m_cUsrItem.SetAdminFlag(true);
			m_bdFlag = true;
			break;

		case 'n':	// ユーザ名
			m_cUsrItem.SetName(strValue.c_str());
			break;

		case 'o':	// 他ユーザを管理する
			MakeLowerA(strAscii);
			m_boFlag = true;
			m_bOtherControl = (strAscii.compare("on") == 0);
			break;

		case 'm':	// メールアドレス
			m_cUsrItem.SetMailAddr(strValue.c_str());
			break;

		case 'p':	// パスワード
			m_cUsrItem.SetPassWord(strValue.c_str());
			break;

		case 'q':	// 強制削除フラグ
			m_bqFlag = true;
			break;

		case 'r':	// リミット（容量）
			m_brFlag = true;
			m_cUsrItem.SetStorages(strValue.c_str(), TF_STAT_MAX);
			break;

		case 's':	// サーバの値を利用
			m_bUntochedUse = true;
			break;

		case 't':	// グループ制約を無視する
			m_btFlag = true;
			MakeLowerA(strAscii);
			if (strAscii.compare("on") == 0)
				m_nPriv |= TF_USER_PRIV_GROUPCONSTRAINTSIGNORE;
			break;

		case 'u':	// 作成可能ユーザ数
			m_cUsrItem.SetMaxuserCreation(strValue.c_str());
			m_buFlag = true;
			break;

		case 'f':	// リミット（ファイル数）
			m_bfFlag = true;
			m_cUsrItem.SetResources(strValue.c_str(), TF_STAT_MAX);
			break;

		case 'l':	// アクセス制限
			m_blFlag = true;
			m_nAccessDeny = parseAccessDeny(strAscii.c_str());
			break;

		case 'h':	// グループ一覧を表示する
			m_bhFlag = true;
			break;

		case 'z':	// ユーザ属性
			MakeLowerA(strAscii);
			m_cUsrItem.SetUserType(strValue.c_str());
			m_bzflag = true;
			break;

		case 'g':	// 所属グループ
			m_strAvailableGroup = strValue.c_str();
			break;

		case 'v':	// ユーザチェック
			m_bvFlag = true;
			break;

		case '2':
			m_strDstUserID = strValue.c_str();
			break;

		case 'x':	// パスワードを表示してしまう
			m_bPassView = true;
			break;
	}

	return true;
}

bool
CPKCmdUsr::OnQueryUsage(const int nOpt, OI_STRING_A& strUsage)
{
	strUsage.erase();
	switch(nOpt)
	{
		case 'a':
			strUsage = "access authority (RW: full access, RO: read only, UO: upload only)";
			break;

		case 'b':
			strUsage = "permit publishing resources [ on | off ]";
			break;

		case 'e':
			strUsage = "undefinite account ISO8601 format (UTC) YYYY-MM-DDThh:mm:ssZ";
			break;
			
		case 'i':
			strUsage = "user ID (*)";
			break;

		case 'o':
			strUsage = "control other user [ on | off ]";
			break;

		case 'n':
			strUsage = "user name (*)";
			break;

		case 'm':
			strUsage = "mail address";
			break;

		case 'p':
			strUsage = "password";
			break;

		case 'q':
			strUsage = "force Delete";
			break;

		case 'd':
			strUsage = "active [ active | inactive ]";
			break;

		case 'g':
			strUsage = "available group (ex. group1, group2)";
			break;

		case 'k':
			strUsage = "admin (exclusion -z)";
			break;

		case 'c':
			strUsage = "comment";
			break;

		case 'r':
			strUsage = "file quota (default:unlimited)";
			break;

		case 's':
			strUsage = "the item not specified uses value of the response. (update only)";
			break;
		
		case 't':
			strUsage = "Impervious to constraints group [ on | off ]";
			break;

		case 'u':
			strUsage = "max user creations (add only and usertype is groupleader only)";
			break;

		case 'f':
			strUsage = "file count quota(default: unlimited)";
			break;

		case 'l':
			strUsage = "access limitation ( user | group | db | repos | adm | adm-user | adm-group | adm-sql | adm-stat | adm-dbms | adm-update | adm-db-test | adm-msg | simple-user | simple-user-non-private | simple-admin )";
			break;

		case 'z':
			strUsage = "user type [ admin | groupleader | normal | limited ](exclusion -k)";
			break;

		case 'v':
			strUsage = "user status response";
			break;

		case 'h':
			strUsage = "show available group (slow)";
			break;

		case '2':
			strUsage = "distination user ID (update only)";
			break;

		case 'x':
			// このオプションはおしえない
			return false;
			break;
		
		default:
			break;

	}

	return true;
}

void
CPKCmdUsr::OnKnownOptions(OI_STRING_A& strOpt)
{
	strOpt = "a:b:c:d:e:f:g:hi:kl:n:m:o:p:qr:st:u:vxz:2:";
}

CMDRESULT 
CPKCmdUsr::OnIsValid(CMDMODE enuMode)
{

	// モードに関係なく必須
	if (TF_STRING_W(m_cUsrItem.GetUID()).empty())
		return TF_CMD_PRM_UID_UNKNOWN;

	// 非アクセスゾーンの設定
	if (m_blFlag)
	{
		if (m_nAccessDeny & TF_ZONE_BROKEN)
			return TF_CMD_PRM_INVALID_PARAM;
		else
		{
			TF_STRING_W strZone;
			BuildAccessZone(m_nAccessDeny, strZone);
			m_cUsrItem.SetAccessDeny(strZone.c_str());
		}
	}

	// サーバの値を利用するはアップデートしか使えない。
	if (m_bUntochedUse && enuMode != TFCMD_UPDATE)
		return TF_CMD_PRM_INVALID_PARAM;

	if (m_bUntochedUse && enuMode == TFCMD_UPDATE)
	{
		CTFResourcePropTFUser cUsrSvrItem;
		CTFResourceProp* ppItem=0;
		CTFDavResourceList* pNowList=0;
		bool bResult = m_cTrans.SearchUser(GetServerManager().GetServerItem(0)->GetServerID(), &m_cUsrItem, &ppItem, TF_SEARCH_UI_CONTENT);
		if (bResult)
		{
			pNowList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, ppItem);
			if (pNowList)
			{
				CTFResourcePropTFUser* pNowItem = (CTFResourcePropTFUser*)pNowList->GetNextItem();
				if (TF_STRING_W(m_cUsrItem.GetName()).empty())
					m_cUsrItem.SetName(pNowItem->GetName());

				// アクセス制限はフラグを立てていない場合だけサーバの値を取得する
				if (TF_STRING_W(m_cUsrItem.GetAccessDeny()).empty() && !m_blFlag)
					m_cUsrItem.SetAccessDeny(pNowItem->GetAccessDeny());
				
				if (TF_STRING_W(m_cUsrItem.GetPassWord()).empty())
					m_cUsrItem.SetPassWord(pNowItem->GetPassWord());

				if (TF_STRING_W(m_cUsrItem.GetMailAddr()).empty())
					m_cUsrItem.SetMailAddr(pNowItem->GetMailAddr());
					
				if (TF_STRING_W(m_cUsrItem.GetComment()).empty())
					m_cUsrItem.SetComment(pNowItem->GetComment());

				if (!m_brFlag)
					m_cUsrItem.SetStorages(pNowItem->GetStoragesString(TF_STAT_MAX), TF_STAT_MAX);

				if (!m_bfFlag)
					m_cUsrItem.SetResources(pNowItem->GetResourcesString(TF_STAT_MAX), TF_STAT_MAX);
				
				if (m_cUsrItem.GetUserType() == TF_USER_TYPE_UNKNOWN)
					m_cUsrItem.SetUserType(pNowItem->GetUserType());

				if (m_cUsrItem.GetStatus() == TF_USER_STATUS_NONE)
					m_cUsrItem.SetStatus(pNowItem->GetStatus());

				// 現状のPrivileageを取得
				int nPriv = pNowItem->GetPrivilege();

				// アクセス権限を設定
				if (!m_baFlag)
					m_nPriv |= nPriv & (TF_USER_PRIV_READ | TF_USER_PRIV_UPLOAD | TF_USER_PRIV_READWRITE);

				// 公開権限
				if (!m_bbFlag)
					m_nPriv |= nPriv & (TF_USER_PRIV_SET_VIEW);

				// グループ制約を無視するを設定する
				if (!m_btFlag)
					m_nPriv |= nPriv & (TF_USER_PRIV_GROUPCONSTRAINTSIGNORE);

				// 他ユーザを管理しないの設定
				if (!m_boFlag)
					m_nPriv |= nPriv & (TF_USER_PRIV_CONTROLOTHERUSER);

				// 有効期限
				if (m_cUsrItem.GetExpiration() && !m_beFlag)
					m_cUsrItem.SetExpiration(pNowItem->GetExpiration());

				// ユーザ作成可能人数を設定してない場合だけ
				if (!m_buFlag)
					m_cUsrItem.SetMaxuserCreation(pNowItem->GetMaxuserCreationString());
			}
		}
		else
		{
			// エラー(ユーザを取得して値をもらおうとしたけど・・）
			if (m_cTrans.GetLastError() == TF_RESULT_NORESULT)
				return TF_CMD_USR_NOT_FOUND;
			else
				return TF_CMD_FAIL;
		}
			
		if (ppItem) delete ppItem;
	}
	
	switch(enuMode)
	{
		case TFCMD_ADD:
			// パスワードは必須
			if (TF_STRING_W(m_cUsrItem.GetPassWord()).empty())
				return TF_CMD_PRM_PASS_UNKNOWN;

			// 排他のオプションはエラーとする
			if (m_bdFlag && m_bzflag)
				return TF_CMD_PRM_CONTRADICTION;

			// ユーザタイプが入っていない場合
			if (!m_bzflag)
				m_cUsrItem.SetUserType(TF_USER_TYPE_NORMAL);

			// 権限が設定されていない場合は読み書きがデフォルト
			if (!m_baFlag)
				m_nPriv |= TF_USER_PRIV_READWRITE;
			else
				m_nPriv |= m_nAccess;

			// -qフラグは付けられません。
			if (m_bqFlag)
				return TF_CMD_PRM_INVALID_PARAM;

			// グループリーダー以外がこの人数を設定できない
			if (m_cUsrItem.GetUserType() != TF_USER_TYPE_GROUPLEADER)
			{
				if (m_cUsrItem.GetMaxuserCreation() > 0) return TF_CMD_PRM_INVALID_PARAM;
				// 他ユーザの管理をグループリーダー以外に設定はできない
				if (m_boFlag) return TF_CMD_PRM_INVALID_PARAM;
			}

			// 制限ユーザは公開設定、他ユーザ管理、グループ制約無視はできません。
			if (m_cUsrItem.GetUserType() == TF_USER_TYPE_LIMITED)
			{
				if (m_bOtherControl) return TF_CMD_PRM_INVALID_PARAM;
				if (m_bPublish) return TF_CMD_PRM_INVALID_PARAM;
				if (m_nPriv & TF_USER_PRIV_GROUPCONSTRAINTSIGNORE)
					return TF_CMD_PRM_INVALID_PARAM;
			}

			// 管理者の場合は設定できないフラグがある
			if (m_cUsrItem.GetUserType() == TF_USER_TYPE_ADMIN)
			{
				if (m_bOtherControl) return TF_CMD_PRM_INVALID_PARAM;
				if (m_nPriv & TF_USER_PRIV_GROUPCONSTRAINTSIGNORE)
					return TF_CMD_PRM_INVALID_PARAM;
			}

			// 公開権限
			if (m_bPublish)
				m_nPriv |= TF_USER_PRIV_SET_VIEW;

			// 他ユーザを管理する
			if (m_bOtherControl)
				m_nPriv |= TF_USER_PRIV_CONTROLOTHERUSER;

			break;

		case TFCMD_UPDATE:
			// 変更ユーザが入っていない場合だけ利用する
			if (m_strDstUserID.empty())
			{
				// パスワードは必須
				if (TF_STRING_W(m_cUsrItem.GetPassWord()).empty())
					return TF_CMD_PRM_PASS_UNKNOWN;

				// 名前は必須項目
				if (TF_STRING_W(m_cUsrItem.GetName()).empty())
					return TF_CMD_PRM_NAME_UNKNOWN;

				// 排他のオプションはエラーとする
				if (m_bdFlag && m_bzflag)
					return TF_CMD_PRM_CONTRADICTION;

				// 不明なユーザタイプはエラー
				if (m_bzflag && m_cUsrItem.GetUserType() == TF_USER_TYPE_UNKNOWN)
					return TF_CMD_PRM_USERTYPE_UNKNOWN;

				// ユーザタイプがないのはエラー
				if (m_cUsrItem.GetUserType() == TF_USER_TYPE_UNKNOWN)
					return TF_CMD_PRM_USERTYPE_UNKNOWN;

				// ステータスがないのはエラー
				if (m_cUsrItem.GetStatus() == TF_USER_STATUS_NONE)
					return TF_CMD_PRM_INVALID_PARAM;

				// 公開権限設定
				if (m_bPublish)
					m_nPriv |= TF_USER_PRIV_SET_VIEW;

				// 他ユーザを管理
/*
				if (m_bOtherControl)
					m_nPriv |= TF_USER_PRIV_CONTROLOTHERUSER;
				else
					m_nPriv &= ~(TF_USER_PRIV_CONTROLOTHERUSER);
*/
				// Set-view権限は制限ユーザにはつけられない
				if ((m_nPriv & TF_USER_PRIV_SET_VIEW) && m_cUsrItem.GetUserType() == TF_USER_TYPE_LIMITED)
					return TF_CMD_PRM_LIMITATION;

				// 制限ユーザは公開設定、他ユーザ管理、グループ制約無視はできません。
				if (m_cUsrItem.GetUserType() == TF_USER_TYPE_LIMITED)
				{
					if (m_bOtherControl) return TF_CMD_PRM_INVALID_PARAM;
					if (m_bPublish) return TF_CMD_PRM_INVALID_PARAM;
					if (m_nPriv & TF_USER_PRIV_GROUPCONSTRAINTSIGNORE)
						return TF_CMD_PRM_INVALID_PARAM;
				}

				// 管理者の場合は設定できないフラグがある
				if (m_cUsrItem.GetUserType() == TF_USER_TYPE_ADMIN)
				{
					if (m_bOtherControl) return TF_CMD_PRM_INVALID_PARAM;
					if (m_nPriv & TF_USER_PRIV_GROUPCONSTRAINTSIGNORE)
						return TF_CMD_PRM_INVALID_PARAM;
				}

				//　アクセス権限
				if (m_baFlag)
				{
					// 全てを外して再設定
					m_nPriv &= ~(TF_USER_PRIV_READ | TF_USER_PRIV_UPLOAD | TF_USER_PRIV_READWRITE);
					m_nPriv |= m_nAccess;
				}

				// -qフラグは付けられません。
				if (m_bqFlag)
					return TF_CMD_PRM_INVALID_PARAM;

				// グループリーダーに対してしかこの人数を設定できない
				if (m_cUsrItem.GetUserType() != TF_USER_TYPE_GROUPLEADER &&
					m_cUsrItem.GetMaxuserCreation() > 0) return TF_CMD_PRM_INVALID_PARAM;

				if (m_cUsrItem.GetUserType() != TF_USER_TYPE_GROUPLEADER)
				{
					if (m_boFlag) return TF_CMD_PRM_INVALID_PARAM;
				}

			}
			break;

		case TFCMD_DELETE:
			break;

		case TFCMD_VIEW:
			// 標準出力フォーマット
			if (m_enuOutFmt == PKCMDOUTFMT_NONE)
				m_enuOutFmt = PKCMDOUTFMT_PLAIN;
			break;

		default:
			return TF_CMD_PRM_INVALID_PARAM;
			break;
	}

	// ユーザ権限を設定する
	m_cUsrItem.SetPrivilege(m_nPriv);

	return TF_CMD_OK;
}

int
CPKCmdUsr::OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem)
{
	TF_STRING_W	strURI;
	TF_STRING_W	strServerID = pSvrItem->GetServerID();
	strURI  = pSvrItem->GetURI();
	strURI += C2W(PKUSERROOT);

	// 親フォルダのダミー作成
	CTFDavResource cItem;
	cItem.SetServerID(pSvrItem->GetServerID());
	cItem.SetURI(strURI.c_str());

	strURI += m_cUsrItem.GetUID();
	strURI += C2W("/");

	m_cUsrItem.SetURI(strURI.c_str());

	m_cTrans.m_bSeqParentchk = false;	// 親フォルダのチェックをしない

	m_enuResult = TF_CMD_FAIL;	// デフォルト失敗

	// 追加
	if (enuMode == TFCMD_ADD)
	{
		bool bResult = true;
		bResult = m_cTrans.MakeColEx(&cItem, TF_XML_BODY_USR, (CTFResourceItem*)&m_cUsrItem);

		// グループ所属
		if (bResult)
		{
			if (!m_strAvailableGroup.empty())
			{
				TF_STRING_W strValue;
				CTFResourceItem cGrpItem;
				CTFResourceItemList cGrpList;
				CTFResourceItemList cUsrList;
				cUsrList.AddItem((CTFResourceItem*)m_cUsrItem.Clone());

				CTFStringTokenizer cToken(m_strAvailableGroup.c_str(), C2W(","));
				while(cToken.GetNextToken(strValue))
				{
					cGrpItem.SetName(strValue.c_str());
					cGrpItem.SetServerID(cItem.GetServerID());
					cGrpList.AddItem((CTFResourceItem*)cGrpItem.Clone());
				}

				bResult = m_cTrans.SetAvailableUser(cItem.GetServerID(), &cGrpList, &cUsrList);
				if (bResult) m_enuResult = TF_CMD_OK;
			}
			else
			{
				// グループ所属はない
				m_enuResult = TF_CMD_OK;
			}
		}
		else
		{
			// エラー（ユーザが既にいた）
			if (m_cTrans.GetLastError() == TF_RESULT_USEREXIST)	m_enuResult = TF_CMD_USR_EXIST;
		}
	}

	// 削除
	if (enuMode == TFCMD_DELETE)
	{
		bool bResult = false;
		bResult = m_cTrans.Delete(&cItem, (CTFResourceItem*)&m_cUsrItem, m_bqFlag);
		if (bResult)
		{
			std::cout << (const char*)X(m_cUsrItem.GetName()) << "(" << (const char*)X(m_cUsrItem.GetUID()) << ")" << " deleted." << std::endl;
			m_enuResult = TF_CMD_OK;
		}
		else
		{
			if (TF_RESULT_NOTFOUND ==  m_cTrans.GetLastError())
			{
				//　削除には失敗したが存在しなかった為のエラーの為正常とみなす。
				m_enuResult = TF_CMD_OK_ERROR;
			}
			else 
			{
				// 救えるかわからないがとりあえずエラー
				m_enuResult = TF_CMD_FAIL;

				// 削除に失敗した場合は非アクティブになるように勤める
				CTFResourceProp* pPropList=0;
				bResult = m_cTrans.SearchUser(strServerID.c_str(), &m_cUsrItem, &pPropList, TF_SEARCH_UI_CONTENT);
				if (bResult)
				{
					bResult = false;
					CTFDavResourceList* pNowList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pPropList);
					if (pNowList)
					{
						CTFResourcePropTFUser* pNowUser = (CTFResourcePropTFUser*)pNowList->GetNextItem();
						if (pNowUser)
						{
							TFUSERSTATUS nStat = TF_USER_STATUS_INACTIVE;
							pNowUser->SetStatus(nStat);
							bResult = m_cTrans.PatchProperty(pSvrItem->GetServerID(), cItem.GetURI(), TF_XML_BODY_USR, pNowUser);
							// 何とか非アクティブ（目的は達成）にした
							if (bResult) m_enuResult = TF_CMD_USR_INACTIVE_USR;
						}
					}
				}
				if (pPropList) delete pPropList;
			}
		}
	}

	// 更新
	if (enuMode == TFCMD_UPDATE)
	{
		bool bResult = true;

		if (m_strDstUserID.empty())
		{
			bResult = m_cTrans.PatchProperty(pSvrItem->GetServerID(), cItem.GetURI(), TF_XML_BODY_USR, (CTFResourceItem*)&m_cUsrItem);
			if (bResult)
			{
				CTFResourceItem cSetItem;
				CTFResourceItemList cSetGroupList;
				if (!m_strAvailableGroup.empty())
				{
					TF_STRING_W strValue;
					CTFStringTokenizer cToken(m_strAvailableGroup.c_str(), C2W(","));
					while(cToken.GetNextToken(strValue))
					{
						cSetItem.SetName(strValue.c_str());
						cSetItem.SetServerID(cItem.GetServerID());
						cSetGroupList.AddItem((CTFResourceItem*)cSetItem.Clone());
					}
				}

				// 更新するユーザのグループ保持状態を調べる
				CTFResourceProp* pGrpList=0;
				CTFDavResourceList* pSvrGrpList=0;
				if (m_cTrans.SearchUser(strServerID.c_str(), &m_cUsrItem, &pGrpList, TF_SEARCH_UI_AVAILABLEGROUP))
				{
					pSvrGrpList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pGrpList);
					if (pSvrGrpList && m_bUntochedUse == false)
					{
						// グループがサーバに登録されている（既に所属されている場合）
						// 一旦グループを全て解除
						CTFResourceItem* pDelItem;
						while(pDelItem = TFLIB_DYNAMIC_CAST(CTFResourceItem, pSvrGrpList->GetNextItem()))
						{
							bResult = m_cTrans.Delete(&cItem, pDelItem);
						}
					}
				}
				if (pGrpList) delete pGrpList;

				if (cSetGroupList.GetItemCount() > 0)
				{
					// 変更するグループがある場合
					CTFResourceItemList cUsrList;
					cUsrList.AddItem((CTFResourceItem*)m_cUsrItem.Clone());
					bResult = m_cTrans.SetAvailableUser(cItem.GetServerID(), &cSetGroupList, &cUsrList);
				}
				else {
					bResult = true;		// 終了
				}

				// 全て成功
				if (bResult) m_enuResult = TF_CMD_OK;

			} // bResult = m_cTrans.PatchProperty(&cItem, TF_XML_BODY_USR, pItem);
		}
		else
		{
			TF_STRING_W strDstURI, strSrcURI;
			strSrcURI  = cItem.GetURI();
			strSrcURI += m_cUsrItem.GetUID();

			strDstURI  = X(PKUSERROOT);
			strDstURI += m_strDstUserID;
			strDstURI += X("/");

			bResult = m_cTrans.ReName(strServerID.c_str(), strSrcURI.c_str(),  strDstURI.c_str());
			if (!bResult)
			{
				switch(m_cTrans.GetLastError())
				{
					// 名前変更しようとしたユーザが存在していたのでエラー
					case TF_RESULT_RESORCE_EXIST:
						m_enuResult = TF_CMD_USR_EXIST;
						break;

					// 名前変更したいユーザが存在しなかった。
					case TF_RESULT_NOTFOUND:
						m_enuResult = TF_CMD_USR_NOT_FOUND;
						break;

					default:
						m_enuResult = TF_CMD_FAIL;
						break;
				}
			}
			else
			{
				m_enuResult = TF_CMD_OK;
			}


		}

	} // if (enuMode == TFCMD_UPDATE)

	// 表示
	if (enuMode == TFCMD_VIEW)
	{
		CTFResourceProp* pList=0;
		CTFResourceProp* pList2=0;
		bool bResult = false;
		CTFDavResourceList*		pGrpList	= NULL;
		TF_SEARCH_UI			enuType		= (TF_STRING_W(m_cUsrItem.GetUID()).find(X("*"))!=TF_STRING_W::npos)?TF_SEARCH_UI_DETAILLIST:TF_SEARCH_UI_CONTENT;
		if (enuType == TF_SEARCH_UI_DETAILLIST)
			if (!m_bhFlag) m_bSkipAvailableGroup = true;

		bResult = m_cTrans.SearchUser(strServerID.c_str(), &m_cUsrItem, &pList,  enuType);
		if (!bResult)
		{
			if (TF_RESULT_NORESULT == m_cTrans.GetLastError())
				m_enuResult = TF_CMD_USR_NOT_FOUND;
			else
			if (TF_RESULT_WRONGUSERPASSWORD == m_cTrans.GetLastError())
				m_enuResult = TF_CMD_PRM_AUTH_FAIL;
			else
				m_enuResult = TF_CMD_FAIL;
		}
		else
		{
			// 成功
			m_enuResult = TF_CMD_OK;
		}

		if (m_enuOutFmt == PKCMDOUTFMT_XML)
		{
			if (m_nCntAll)
			{
				if (m_nCntAll) std::cout << "\n</userinformation>" << std::endl;
				m_enuResult = TF_CMD_OK;
			}
		}

		// ステータスだけを調べる
		if (enuType == TF_SEARCH_UI_CONTENT && m_bvFlag && m_enuResult == TF_CMD_OK)
		{
			CTFResourcePropTFUser*	pUsr		= NULL;
			CTFDavResourceList* pTmpList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pList);
			if (pTmpList)
			{
				 pUsr = (CTFResourcePropTFUser*)pTmpList->GetNextItem();
			}

			if (pUsr)
			{
				TFUSERSTATUS enuStatus = pUsr->GetStatus();
				if (enuStatus & TF_USER_STATUS_INACTIVE)
					m_enuResult = TF_CMD_USR_INACTIVE;
				else
				if (enuStatus & TF_USER_STATUS_EXPIRD)
					m_enuResult = TF_CMD_USR_EXPIRED;
			}
			else
			{
				m_enuResult = TF_CMD_FAIL;
			}
		}

		if (pList) delete pList;
		if (pList2) delete pList2;
	}
	
	return m_enuResult;
}

void 
CPKCmdUsr::OnErrorPrint(const OI_RESULT oResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod)
{
	switch(oResult)
	{
		case OIDENOTALLOWED:	// Method Not Allow
			std::cout << "Command Fail" << std::endl;
			break;

		case OI_OK:
			if (enuMethod == TF_DAV_MKCOL)
				std::cout << "Created" << std::endl;
			break;

		case OIDENOTFOUND:
			if (enuMethod == TF_DAV_DELETE)
				std::cout << "NotFound" << std::endl;
			break;

		default:
			break;
	}

}

int 
CPKCmdUsr::parseAccessDeny(const char* pszZone)
{
	int nRet = TF_ZONE_NONE;
	if (!OI_STRING_A(pszZone).empty())
	{
		OI_STRING_A strZone;
		CDavStringTokenizer cToken(pszZone, ",");
		while(cToken.GetNextToken(strZone))
		{
			bool bFound =false;
			MakeLowerA(strZone);
			for (int i=0; PKZONETABLE[i].pszName != NULL; i++)
			{
				if (strZone.compare(PKZONETABLE[i].pszName) == 0)
				{
					nRet |= PKZONETABLE[i].nZone;
					bFound = true;
				}
			}

			if (!bFound) return TF_ZONE_BROKEN;	// 存在しないゾーン名がある場合強制終了
		}
	}

	return nRet;
}

void 
CPKCmdUsr::printPlain(CTFResourcePropTFUser* pUsr, CTFDavResourceList* pGrpList)
{

	if (pUsr != NULL && !m_bvFlag)
	{
		OI_STRING_A strPassWord, strAdmin, strUserType, strPrivilege;
		strPassWord = (m_bPassView) ? (const char*)X(pUsr->GetPassWord()) : "**********";
		std::cout << "-------------------------------------------------"		<< std::endl;
		std::cout << "No        \t: "   << m_nCntAll							<< std::endl;
		std::cout << "Name      \t: "	<< (const char*)X(pUsr->GetName())		<< std::endl;
		std::cout << "UserID    \t: "	<< (const char*)X(pUsr->GetUID())		<< std::endl;
		std::cout << "PassWord  \t: "	<< strPassWord.c_str()					<< std::endl;
		std::cout << "MailAddress\t: "	<< (const char*)X(pUsr->GetMailAddr())	<< std::endl;
		std::cout << "Resources \t: "	<< pUsr->GetResources(TF_STAT_USED)		<< " / " << pUsr->GetResources(TF_STAT_MAX) << std::endl;
		std::cout << "Strorages \t: "	<< pUsr->GetStorages(TF_STAT_USED)		<< " / " << pUsr->GetStorages(TF_STAT_MAX)	<< std::endl;
		TF_USER_TYPE nUtype = pUsr->GetUserType();
		if (nUtype != TF_USER_TYPE_UNKNOWN)
		{
			switch(nUtype)
			{
				case TF_USER_TYPE_ADMIN:
					strUserType = "Administrator";
					break;

				case TF_USER_TYPE_GROUPLEADER:
					strUserType = "Group Leader";
					break;

				case TF_USER_TYPE_NORMAL:
					strUserType = "General User";
					break;

				case TF_USER_TYPE_LIMITED:
					strUserType = "Limited Access User";
					break;
			}

			std::cout << "User Type\t: "	<< strUserType.c_str()				<< std::endl;
		}
		else 
		{
			strAdmin = (pUsr->GetAdminFlag()) ? "Administrator" : "General user";
			std::cout << "AccesssAuthority\t: "	<< (const char*)strAdmin.c_str()		<< std::endl;					
		}

		TFUSERSTATUS nStat = pUsr->GetStatus();
		OI_STRING_A strStatus;
		if (nStat != TF_USER_STATUS_NONE)
		{
			if (TF_USER_STATUS_ACTIVE & nStat)
				strStatus = "Active";

			if (TF_USER_STATUS_INACTIVE & nStat)
				strStatus = "Inactive";

			if (TF_USER_STATUS_EXPIRD & nStat)
				strStatus = "Expired";
			std::cout << "Status	\t: "	<< strStatus.c_str()					<< std::endl;
		}

		TFUSERPRIV nPriv = pUsr->GetPrivilege();
		if (nPriv != TF_USER_PRIV_NONE)
		{
			if (TF_USER_PRIV_READ & nPriv)
				strPrivilege += " Read Only";

			if (TF_USER_PRIV_UPLOAD & nPriv)
				strPrivilege += " Upload Only";

			if (TF_USER_PRIV_READWRITE & nPriv)
				strPrivilege += " Read/Write";

			if (TF_USER_PRIV_SET_VIEW & nPriv)
				strPrivilege += ",Public";

			if (TF_USER_PRIV_GROUPCONSTRAINTSIGNORE & nPriv)
				strPrivilege += ",Impervios to constraints group";

			if (TF_USER_PRIV_CONTROLOTHERUSER & nPriv)
				strPrivilege += ",Control to other user";

			std::cout << "AccessAuthority\t:"	<< strPrivilege.c_str() << std::endl;
			std::cout << "Maxusercreation\t: "	<< pUsr->GetMaxuserCreation() << std::endl;
			std::cout << "Valid until\t: ";

			if (pUsr->GetExpiration() <=0)
				std::cout << "Unlimited" << std::endl;
			else
			{
				TF_STRING_A edate;
				FormatTimeISO8601(edate, pUsr->GetExpiration());
				std::cout << edate << std::endl;
			}
		}

		std::cout << "Owner Name  \t: " << (const char*)X(pUsr->GetOwnerName()) << std::endl;
		std::cout << "Owner ID    \t: " << (const char*)X(pUsr->GetOwnerID()) << std::endl;
		TF_STRING_A cdate,mdate;
		FormatTimeISO8601(cdate, pUsr->GetCreationDate());
		FormatTimeISO8601(mdate, pUsr->GetLastModified());
		std::cout << "Limited Zone\t: "	<< (const char*)X(pUsr->GetAccessDeny())	<< std::endl;
		std::cout << "Created     \t: "	<< cdate.c_str()	<< std::endl;
		std::cout << "Lastmodified\t: "	<< mdate.c_str()	<< std::endl;
		std::cout << "Comment     \t: "	<< (const char*)X(pUsr->GetComment())	<< std::endl;
		std::cout << "Available Group\t:";	// ここでは出力処理はしない

	} // if (pUsr != NULL)

	if (pGrpList != NULL && !m_bvFlag)
	{
		CTFResourcePropTFGroup*	pGrp = NULL;
		for (; pGrp = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup,  pGrpList->GetNextItem()); )
		{		
			std::cout << " " << (const char*)X(pGrp->GetName());
		}
	}

	if (!m_bvFlag)
	{
		std::cout << std::endl;
		std::cout << "-------------------------------------------------" << std::endl;
		std::cout << std::endl;
	}
}

bool
CPKCmdUsr::OnShowResource(CTFResourceItem* pItem)
{
	TFITEMTYPE enuType = pItem->GetType();
	CTFResourcePropTFUser* pUsrItem;

	// ユーザでなければ処理は行わない
	if (enuType == TFITEM_MNG_USR && m_enuOutFmt != PKCMDOUTFMT_NONE)
	{
		pUsrItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFUser, pItem);
		if (!pUsrItem) return false;
		m_nCntAll++;

		CTFResourceProp*	pProp=0;
		CTFDavResourceList*	pGrpList=NULL;

		if (!m_bSkipAvailableGroup)
		{
			m_cTrans.SearchUser(pItem->GetServerID(), pUsrItem, &pProp, TF_SEARCH_UI_AVAILABLEGROUP);
			pGrpList = TFLIB_DYNAMIC_CAST(CTFDavResourceList, pProp);
		}

		// xmlの場合のみ処理
		if (m_enuOutFmt & PKCMDOUTFMT_XML)
		{
			if (m_nCntAll == 1)
			{
				std::cout << "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>" << std::endl;
				std::cout << "<userinformation>" << std::endl;
			}

			CPKCmdUsrXmlPrinter cPrinter;
			cPrinter.PrintUserItem(*pUsrItem, pGrpList);
		}
		else 
		{
			printPlain(pUsrItem, pGrpList);
		}
	}


	return true;
}




