/*
 * コマンドライン（ユーザ管理）
 *
 * $Id$
 */

#ifndef __TF_CMD_PKCMDUSR_H_
#define __TF_CMD_PKCMDUSR_H_

#include <libpkcmd/PKCmdBase.h>
#include <libteamfile/TFResourcePropTFUser.h>

// ユーザ管理画面の親URI
#define PKUSERROOT	".management/USER/"

typedef struct tagPKZONECOL
{
	const char*		pszName;
	int				nZone;
} PKZONECOL;

const PKZONECOL PKZONETABLE[] = 
{
	{	"user",			TF_ZONE_USER		},
	{	"group",		TF_ZONE_GROUP		},
	{	"db",			TF_ZONE_DBLINK		},
	{	"repos",		TF_ZONE_REPOS		},
	{	"adm",			TF_ZONE_MANAGE		},
	{	"adm-user",		TF_ZONE_M_USER		},
	{	"adm-group",	TF_ZONE_M_GROUP		},
	{	"adm-sql",		TF_ZONE_M_SQL		},
	{	"adm-stat",		TF_ZONE_M_STATUS	},
	{	"adm-dbms",		TF_ZONE_M_DBMS		},
	{	"adm-update",	TF_ZONE_M_UPDATE	},
	{	"adm-db-test",	TF_ZONE_M_EXECSQL	},
	{	"adm-msg",		TF_ZONE_M_MSG		},

	{	"simple-user",	(	TF_ZONE_DBLINK	|
							TF_ZONE_REPOS	|
							TF_ZONE_MANAGE	
						)					},
	{	"simple-user-non-private",
						(	TF_ZONE_USER	|
							TF_ZONE_DBLINK	|
							TF_ZONE_REPOS	|
							TF_ZONE_MANAGE
						)					},

	{	"simple-admin",
						(	TF_ZONE_DBLINK	|
							TF_ZONE_REPOS	|
							TF_ZONE_M_DBMS	|
							TF_ZONE_M_SQL	|
							TF_ZONE_M_EXECSQL
						)					},

	{	"none",			TF_ZONE_NONE		},
	{	NULL,			TF_ZONE_NONE		}
};

class CPKCmdUsr :
	public CPKCmdBase
{
public:
	CPKCmdUsr(void);
	~CPKCmdUsr(void);

	bool OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod);
	
	void OnQueryProgramInfo(CPKPROGINFO &info);
	bool OnFoundParam(const int nKey, const TFXMLByte* pszValue);
	bool OnQueryUsage(const int nOpt, OI_STRING_A& strUsage);
	void OnKnownOptions(OI_STRING_A& strOpt);
	void OnErrorPrint(const OI_RESULT oResult, const TFXMLCh* pszURI, const TFDAVMETHOD enuMethod);
	CMDRESULT OnIsValid(CMDMODE enuMode);

	int OnExecute(CMDMODE enuMode, CTFServerResource* pSvrItem);
	bool OnShowResource(CTFResourceItem* pItem);

private:
	int parseAccessDeny(const char* pszZone);

	void printPlain(CTFResourcePropTFUser* pUsr, CTFDavResourceList* pGrpList);

protected:
	CTFResourcePropTFUser	m_cUsrItem;
	bool					m_bPassView;			///< パスワードを表示するか？
	TF_STRING_W				m_strAvailableGroup;	///< 所属グループ
	TFUSERPRIV				m_nPriv;				///< ユーザ権限
	bool					m_bUntochedUse;			///< 指定されていないパラメータはサーバからもらう
	int						m_nAccessDeny;			///< 非アクセスゾーン
	TF_SIZE_T				m_nCntAll;				///< 全体人数
	TF_STRING_W				m_strDstUserID;			///< 変更先ユーザID
	int						m_nAccess;				///< アクセス権限
	bool					m_bOtherControl;		///< 他ユーザを管理するか否か
	bool					m_bPublish;				///< 公開非公開ができるか否か

private:
	bool					m_baFlag;
	bool					m_bbFlag;
	bool					m_beFlag;				/// 有効期限を設定したかフラグ
	bool					m_bzflag;
	bool					m_bdFlag;
	bool					m_blFlag;
	bool					m_bvFlag;				///< ユーザのチェックだけを行なう
	bool					m_bqFlag;				///< 強制削除フラグ
	bool					m_brFlag;				///< 最大リソース
	bool					m_bfFlag;				///< 最大ファイル	
	bool					m_buFlag;				///< 最大作成人数を設定
	bool					m_bSkipAvailableGroup;	///< グループを検索しない
	bool					m_btFlag;				///< グループ制約無視設定フラグ
	bool					m_boFlag;				///< 他ユーザ管理フラグ
	bool					m_bhFlag;				///< グループ一覧も表示する
};

#endif
