#include "PKCmdUsrXmlPrinter.h"

CPKCmdUsrXmlPrinter::CPKCmdUsrXmlPrinter(void)
{
}

CPKCmdUsrXmlPrinter::~CPKCmdUsrXmlPrinter(void)
{
}

/**
 *	ユーザをXML出力する
 */
void 
CPKCmdUsrXmlPrinter::PrintUserItem(CTFResourcePropTFUser& cUserItem, CTFDavResourceList* pGrpList)
{
	CTFXmlBodyBuilder	cXMLBuilder;
	cXMLBuilder.Initialize(C2W("userinformation"));
	cXMLBuilder.AddDefaultNameSpace();
	cXMLBuilder.AddPropChild(C2W("user"), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	cXMLBuilder.AddPropUID(cUserItem.GetUID());
	cXMLBuilder.AddPropName(cUserItem.GetName());
	cXMLBuilder.AddPropPassword(cUserItem.GetPassWord());
	cXMLBuilder.AddPropMailAddr(cUserItem.GetMailAddr());
	cXMLBuilder.AddPropUsedStorage(cUserItem.GetStorages(TF_STAT_USED));
	cXMLBuilder.AddPropMaxStorage(cUserItem.GetStorages(TF_STAT_MAX));
	cXMLBuilder.AddPropUsedResource(cUserItem.GetResources(TF_STAT_USED));
	cXMLBuilder.AddPropMaxResource(cUserItem.GetResources(TF_STAT_MAX));
	cXMLBuilder.AddPropUserType(C2W(cUserItem.GetUserTypeString()));
	cXMLBuilder.AddPropUserStatus(cUserItem.GetStatus());
	cXMLBuilder.AddPropUserPrivilege(cUserItem.GetPrivilege());
	cXMLBuilder.AddPropAccessDeny(cUserItem.GetAccessDeny());
	cXMLBuilder.AddPropExpiration(cUserItem.GetExpiration());
	cXMLBuilder.AddPropCreationDt(cUserItem.GetCreationDate());
	cXMLBuilder.AddPropUpdateDt(cUserItem.GetLastModified());
	cXMLBuilder.AddPropComment(cUserItem.GetComment());
	cXMLBuilder.AddPropMaxusercreation(cUserItem.GetMaxuserCreation());
	cXMLBuilder.AddPropOwnerName(cUserItem.GetOwnerName());
	cXMLBuilder.AddPropOwnerID(cUserItem.GetOwnerID());
	cXMLBuilder.AddPropOtheruser(cUserItem.GetIsOtherUser());

	XNS(DOMElement)* pParent = 	cXMLBuilder.AddPropFamily(C2W("availablegroup"), C2W(TF_XML_NSURI), C2W(TF_XML_NAMESPACE_PREFIX));

	if (pGrpList && pGrpList->GetItemCount() > 0)
	{
		XNS(DOMElement)* pOneGrp;
		XNS(DOMElement)* pNode;
		CTFResourcePropTFGroup* pGrpItem;
		for (; pGrpItem = TFLIB_DYNAMIC_CAST(CTFResourcePropTFGroup, pGrpList->GetNextItem()); )
		{
			pOneGrp = cXMLBuilder.AddPropChild(pParent, C2W("group"));
			pNode = cXMLBuilder.AddPropChild(pOneGrp, C2W(TF_PROP_GROUPID));
			if (pNode)
				cXMLBuilder.AddPropNodeValue(pNode, pGrpItem->GetID());

			pNode = cXMLBuilder.AddPropChild(pOneGrp, C2W(TF_PROP_NAME));
			if (pNode)
				cXMLBuilder.AddPropNodeValue(pNode, pGrpItem->GetName(), true);
		}
	}

//	cXMLBuilder.Print(cXMLBuilder.GetLastElement());
	cXMLBuilder.Print(cXMLBuilder.GetElementByName(C2W("user")));

}

