/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFBrowser.h
 *	クラス名	:	CTFBrowser
 *	継承		:
 *
 *	機能　		:	クライアントアプリケーションから問い合わせることができる
 *					クラス。
 *
 *
 */

#ifndef	TF_LIB_TFBROWSER_H
#define	TF_LIB_TFBROWSER_H	1

#include "TFLibPublic.h"
#include "TFWsNotificationHandler.h"
#include "TFWsTransactionHandler.h"
#include "TFWsSystemInformationHandler.h"
#include "TFResourceItemList.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFBrowser
{
public:
	CTFBrowser(void);
	~CTFBrowser(void);

	/**
	 *	対象アイテムのサーバ存在確認を行なう。
	 *	@param	pItem	CTFResourceItem*
	 *	@param	bAnswer	bool				サーバの種別が知りたい場合TRUE
	 *	@return boolean
	 *	(note)
	 *	bAnswerをTRUEに設定した場合NotificationHandlerのOnAnswerServerType()で
	 *	結果が受け取れます。
	 *
	 */
	bool CheckServerExistence(CTFResourceItem* pItem, bool bAnswer);

	/**
	 *	リソースを開く
	 *	@param	pItem	CTFResourceItem*
	 *	@return bool
	 *
	 *	(note)
	 *	フォルダでもファイルでもこのメソッドでリクエストを行なってください。
	 */
	bool OpenResource(CTFResourceItem* pItem=NULL);

	/**
	 *	リソースを作成する
	 *	@param	pItem		CTFResourceItem*		作成するリソースの親アイテム
	 *	@param	enuType	TFRESOURCETYPE		リソースの種類（TF_RES_FILE ...)
	 *	@return bool
	 *
	 *	(note)
	 *	親アイテムの内容を確認して新りソースの作成ハンドラが呼ばれます
	 *	CTFTransactionHandler::QueryNewResourceName()
	 */
	bool CreateResource(CTFResourceItem* pParentItem, TFRESOURCETYPE enuType);

	/*
	 *	メッセージを新規作成する
	 *	@param	pParentItem		CTFResourceItem*		親フォルダ
	 *	
	 */
	bool CreateSystemMessage(CTFResourceItem* pParentItem);

	/**
	 *	リソースの内容を問い合わせる
	 *	@param	pItem	CTFResourceItem*
	 *
	 */
	bool QueryResource(CTFResourceItem* pItem);

	/**
	 *	リソースを削除する
	 *	@param	ppItem	CTFResourceItem*
	 *
	 */
	bool DeleteResource(CTFResourceItem* ppItem);

	/**
	 *	リソースをコピーする
	 *	@param ppItem	CTFResourceItem*
	 */
	bool CopyResource(CTFResourceItem* ppItem);

	/**
	 *	リソースを移動する
	 *	@param	ppItem	CTFResourceItem*
	 *
	 */
	bool MoveResource(CTFResourceItem* ppItem);

	/**
	 *	リソースをアップロードする
	 *	@param	pParentItem		CTFResourceItem*		アップロードするフォルダ（ターゲット）
	 *	@return boolean
	 *	(note)
	 *	ターゲットのアイテムが存在したらファイルの一覧を取得するハンドラが呼ばれます
	 */
	bool UploadResource(CTFResourceItem* pParentItem);

	/**
	 *	リソースの名前を変更する
	 *	@param	ppItem			CTFResourceItem*
	 *	@return boolean
	 */
	bool RenameResource(CTFResourceItem* ppItem);

	/**
	 *	リソースのオペレーションの可否を調べる
	 *	@param	pTgeItem		CTFResourceItem*
	 *	@param	pItemList		CTFResourceItemList*
	 *
	 *	(note)
	 *	ターゲットのコレクションが第二引数のリストの内容をどのように受け入れることが
	 *	可能であるかを調べます。可能でない場合TF_DL_NONEが戻ってきます。
	 *
	 */
	int QueryAcceptableDropEffect(CTFResourceItem* pTargetItem, CTFResourceItemList* pItemList);

	/**
	 *	現在利用しているサーバ証明書を開く
	 *	@param		pItem		CTFResourceItem*
	 *	@return	boolean
	 */
	bool OpenSSLCertificateList(CTFResourceItem* pItem);

	/**
	 *	システムで利用するハンドラ群
	 *	(note)
	 *	全て追加しないと正常に動作はしません。
	 *	登録されたハンドラは自己責任で削除してください。
	 *	このクラスが削除されてもDELETEは行ないません。
	 */
	void SetHandler(CTFWsTransactionHandler* pHandler);
	void SetHandler(CTFWsNotificationHandler* pHandler);
	void SetHandler(CTFWsSystemInformationHandler* pHandler);

private:
	void queryMethod(CTFResourceItem* pItem, int& nAllowMethod, TFSEARCHTYPE& nAllowDASLType, int& nDASLSubType);
	bool openbySEARCH(CTFResourceItem* pItem, TFSEARCHTYPE nAllowDASLType, int nDASLSubType);
	bool openbyPROPFIND(CTFResourceItem* pItem);
	bool openbyGET(CTFResourceItem* pItem);
	bool getServerItems(void);

	TFDAVMETHOD openServer(CTFResourceItem* pItem);

protected:
	CTFWsTransactionHandler*		m_pTransHandler;
	CTFWsTransactionHandler			m_cTransHandler;
	CTFWsNotificationHandler*		m_pNotifyHandler;
	CTFWsNotificationHandler		m_cNotifyHandler;
	CTFWsSystemInformationHandler*	m_pSysInfoHandler;
	CTFWsSystemInformationHandler	m_cSysInfoHandler;
};

TF_END_CLASSEXPORT

#endif

