/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFClassInfo.h
 *	クラス名	:	CTFClassInfo
 *	継承		:
 *
 *	機能　		:	クラス情報の保持を行う。CTFObjectクラスと共に用いる。
 *
 *
 */

#ifndef TF_LIB_TFCLASSINFO_H
#define TF_LIB_TFCLASSINFO_H	1

#include "TFLibPublic.h"

/// 動的生成メソッドのポインタを扱うための型定義
class CTFObject;
typedef CTFObject* (*TFCreateObjectFnc)();

/**
 *	クラス情報保持用クラス
 *
 *	このクラスは、CTFObjectのメンバー変数で使用される。
 *
 */
TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFClassInfo
{
public:
	CTFClassInfo(void);
	CTFClassInfo(TFCreateObjectFnc fncCO ,const char* szClassName);
	~CTFClassInfo(void);
	CTFObject* CreateObject();

	TFCreateObjectFnc	m_pfnCreateObject;	///< 動的生成用関数ポインタ
	const char*	m_szClassName;				///< クラス名を示す文字列
};

TF_END_CLASSEXPORT

/// クラス情報リスト格納用コンテナクラス
typedef std::vector<CTFClassInfo*> CTFClassInfoPtrList;


#endif	// TFLIB_HEADER_TFCLASSINFO_H

