/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFCriticalSection.h
 *	クラス名		:	CTFCriticalSection
 *	継承			:
 *
 *	機能　		:	
 *
 *
 */

#ifndef	TF_LIB_TFCRITICALSECTION_H
#define	TF_LIB_TFCRITICALSECTION_H	1

#include "TFLibDefinition.h"

TF_BEGIN_CLASSEXPORT

#ifdef _WIN32
	// WINDOWS独自ヘッダ
#elif defined(macintosh)
# ifdef __MACH__
   // Mach-O環境のMacintosh・・・MacOS X専用
	#include <pthread.h>
# else
   // Mach-O環境ではない（PEF環境の）Macintosh・・・MacOS 9/MacOS X両方
	#include <Multiprocessing.h>

# endif /* __MACH__ */
#else
  // その他
#endif

class TF_EXPORT CTFCriticalSection
{
public:
	CTFCriticalSection(void);
	virtual ~CTFCriticalSection(void);

	virtual void Enter(void);
	virtual void Leave(void);

private:

#ifdef _WIN32
	typedef char TFCritbuff[24];

	union {
		unsigned long	m_buffer1;
		TFCritbuff		m_buffer;
	};
#elif defined(macintosh)
# ifdef __MACH__

	// Mach-O環境のMacintosh・・・MacOS X専用
	pthread_mutex_t		m_SyncObj;
	int					m_refCount;
	pthread_t			m_refThreadID;

# else
   // Mach-O環境ではない（PEF環境の）Macintosh・・・MacOS 9/MacOS X両方
	MPCriticalRegionID 	m_SyncObj;	// for classic mac
# endif /* __MACH__ */
#else
  // その他
#endif
};

TF_END_CLASSEXPORT

#endif	// TF_LIB_TFCRITICALSECTION_H

