/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFDavResource.h
 *	クラス名	:	CTFDavResource
 *	継承		:	CTFResourceItem
 *
 *	機能　		:	DAVのリソースを管理するベースクラス
 *					このオブジェクトがどのURI(or URL)のものかを判断することができる。
 *
 *
 */
#ifndef TF_LIB_TFDAVRESOURCE_H
#define TF_LIB_TFDAVRESOURCE_H 1

#include "stdtypes.h"
#include "TFLibDefinition.h"
#include "TFResourceItem.h"
#include "TFURL.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFDavResource : public CTFResourceItem
{
public:
	CTFDavResource(void);
	virtual ~CTFDavResource(void);
	virtual void Import(const CTFObject& source);

	// URI
	const TFXMLCh* GetURI(void);
	void  SetURI(const TFXMLCh* strURI);
	bool  IsURI(const TFXMLCh* pszURI);
	const TFXMLCh* GetParentURI(void);

	// URL
	const TFXMLCh* GetURL(void);
	const TFXMLCh* GetParentURL(void);
	void  SetURL(const TFXMLCh* pszURL);
	bool  IsURL(const TFXMLCh* pszURL);

	// TrigerURI
	void  SetTrigerURI(const TFXMLCh* pszURI);
	const TFXMLCh* GetTrigerURI(void);

	// Validation
	bool			IsValid(void);
	virtual	bool	Validate(bool bValid = true);

protected:
	TF_STRING_W	m_strURI;				///< このオブジェクトのURI
	TF_STRING_W	m_strURL;				///< このオブジェクトのURL
	TF_STRING_W	m_strTrigerURI;			///< このオブジェクトを作ったきっかけURI
	CTFURL		m_cURL;					///< URIクラス
	bool		m_bValid;				///< このオブジェクトに有効なデータがある場合true
	TFLIB_DECLARE_CLASS(CTFDavResource)
};

/// CTFDavResourceのリストを保持するためのvectorクラス
typedef std::vector<CTFDavResource*> CTFDavResourcePtrVector;

TF_END_CLASSEXPORT

#endif

