/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *	$Id$
 *
 *	ファイル名	:	TFDavResourceList.h
 *	クラス名	:	CTFDavResourceList
 *	継承		:	CTFResourcePropTF
 *
 *	機能　		:	リソースリストを保持するクラス。
 *					CTFDavResourceオブジェクトの一覧(vector)を持つ。
 *					CTFResourcePropTFの派生クラスのため、
 *					自分自身もDavリソースの保持が可能。
 *
 */
#ifndef TF_LIB_TFDAVRESOURCELIST_H
#define TF_LIB_TFDAVRESOURCELIST_H 1

#include "TFDavResource.h"
#include "TFResourcePropTF.h"
#include "TFTmplItemList.h"
#include "TFObject.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFDavResourceList :
	public CTFResourcePropTF,
	public CTFTmplItemList<CTFDavResource>
{
public:
	CTFDavResourceList(void);
	virtual ~CTFDavResourceList(void);
	virtual void Import(const CTFObject& source);

	CTFDavResource* GetItemWithURI(const TFXMLCh* pszURI);
	CTFDavResource* GetItemWithServerID(const TFXMLCh* pszServerID);
	CTFDavResource* GetItemWithName(const TFXMLCh* pszName);
	CTFDavResource* GetItemWithIndex(int nIndex);

protected:
	virtual CTFDavResource* OnCloneItem(CTFDavResource* source);
	virtual bool OnCheckItem(CTFDavResource* target, int iHint, void* pHint);

	TFLIB_DECLARE_CLASS(CTFDavResourceList)
	
private:
	enum
	{
		TFDAVRESOURCELIST_FINDBYSERVERID,
		TFDAVRESOURCELIST_FINDBYURI,
		TFDAVRESOURCELIST_FINDBYNAME
	};	
};

TF_END_CLASSEXPORT

#endif	// TFLIB_HEADER_DAVRESOURCELIST_H

