#ifndef TF_LIB_TFDEFINITION_H
#define	TF_LIB_TFDEFINITION_H 1
/**
 *	$Id$
 *	ライブラリ内部で利用する定義ファイル
 *	外部からは絶対に利用してはいけません。
 */
#ifndef _WIN32
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#endif

#include "TFLibPublic.h"

// ユーザエージェント（デフォルト）
#define		TF_DEFAULT_USER_AGENT		"TeamFile-Client/0.00";
#define		TF_XML_NAMESPACE_PREFIX		"TF"
#define		TF_XML_NS_PREFIX			"TF:"
#define		DAV_XML_NAMESPACE_PREFIX	"D"
#define		TF_XML_NSURI				"http://www.teamfile.com/DTD/TF/"
#define		TF_DAV_XML_NSURI			"DAV:"

const char	TF_PROP_MAILWATCHOWNER[]=	"watchowner";
const char	TF_PROP_TRIGGERMETHOD[]	=	"triggermethod";
const char	TF_PROP_DELETER[]		=	"deleter";
const char	TF_PROP_DELETION[]		=	"deletion";

// live property
const char	TF_PROP_GETCONTENTLANGUAGE[]	= "getcontentlanguage";
const char	TF_PROP_GETCONTENTLENGTH[]		= "getcontentlength";
const char	TF_PROP_GETCONTENTTYPE[]		= "getcontenttype";
const char	TF_PROP_GETETAG[]				= "getetag";
const char	TF_PROP_GETLASTMODIFIED[]		= "getlastmodified";
const char	TF_PROP_RESOURCETYPE[]			= "resourcetype";
const char	TF_PROP_RESOURCE[]				= "resource";
const char	TF_PROP_SUPPORTEDLOCK[]			= "supportdlock";
const char	TF_PROP_LOCKDISCOVERY[]			= "lockdiscovery";
const char  TF_PROP_CREATIONDATE[]			= "creationdate";

// extention live property
const char	TF_PROP_CREATOR[]				=	"creator";
const char	TF_PROP_LASTMODIFIER[]			=	"lastmodifier";
const char	TF_PROP_SHAREDCOLLECTION[]		=	"sharedcollection";
const char	TF_PROP_MAILWATCH[]				=	"mailwatch";
const char	TF_PROP_TRASHINFORMATION[]		=	"trashinformation";
const char	TF_PROP_RESOURCESTATE[]			=	"resourcestate";
const char	TF_PROP_USERPRIVILEGEGRANTSET[]	=	"user-privilege-grant-set";
const char	TF_PROP_SYSTEMQUOTA[]			=	"systemquota";

// Root Tree Search Response
#define		TF_PROP_HREF				"href"
#define		TF_PROP_DISPLAYNAME			"displayname"
#define		TF_PROP_FOLDERTYPE			"foldertype"
#define		TF_PROP_DISPLAYORDER		"displayorder"
#define		TF_PROP_SQLNO				"sqlno"

//
//	サーチのモード
//
//
enum TF_SEARCH_MODE
{
	TF_SEARCH_MODE_UNKNOWN	= 0,
	TF_SEARCH_MODE_TREELIST,
	TF_SEARCH_MODE_DETAILLIST,
	TF_SEARCH_MODE_CONTENT,
	TF_SEARCH_MODE_AVAILABLEGROUP,
	TF_SEARCH_MODE_AVAILABLEUSER,
	TF_SEARCH_MODE_AVAILABLESQL,
	TF_SEARCH_MODE_ACTIVEDBMS,
	TF_SEARCH_MODE_LICENSEDDDBMS,
	TF_SEARCH_MODE_LINEUP,
	TF_SEARCH_MODE_ALLLIST,
	TF_SEARCH_MODE_SQLSTMT,
	TF_SEARCH_MODE_GROUPLIST,
	TF_SEARCH_MODE_REPOSDBSQLSTMT,
	TF_SEARCH_MODE_MANAGEMENT,
	TF_SEARCH_MODE_EXECSQLSTMT,
	TF_SEARCH_MODE_CURRENTMSG
};

typedef struct tagTFSEACHMODEROW
{
	// サーチモード
	TF_SEARCH_MODE	enuMode;

	// エレメント名
	const char*		pszName;
} TFSEARCHROW;

const TFSEARCHROW TFSEARCHMODETABLE[] =
{
	{	TF_SEARCH_MODE_TREELIST,		"treelist"			},
	{	TF_SEARCH_MODE_DETAILLIST,		"detaillist"		},
	{	TF_SEARCH_MODE_CONTENT,			"content"			},
	{	TF_SEARCH_MODE_AVAILABLEGROUP,	"availablegroup"	},
	{	TF_SEARCH_MODE_AVAILABLEUSER,	"availableuser"		},
	{	TF_SEARCH_MODE_ACTIVEDBMS,		"activeddbms"		},
	{	TF_SEARCH_MODE_LICENSEDDDBMS,	"licenseddbms"		},
	{	TF_SEARCH_MODE_LINEUP,			"lineup"			},
	{	TF_SEARCH_MODE_ALLLIST,			"alllist"			},
	{	TF_SEARCH_MODE_SQLSTMT,			"sqlstmt"			},
	{	TF_SEARCH_MODE_GROUPLIST,		"grouplist"			},
	{	TF_SEARCH_MODE_REPOSDBSQLSTMT,	"reposdbsqlstmt"	},
	{	TF_SEARCH_MODE_MANAGEMENT,		"management"		},
	{	TF_SEARCH_MODE_EXECSQLSTMT,		"execsqlstmt"		},
	{	TF_SEARCH_MODE_CURRENTMSG,		"currentmsg"		},
	{	TF_SEARCH_MODE_UNKNOWN,			NULL				}
};

// options respons header
#define		TF_OPHDR_ALLOW				"allow"
#define		TF_OPHDR_DASL				"dasl"

enum TF_PROP_DISCOVERY {
	TF_PROP_DISCOVERY_UNKNOWN = 0,
	TF_PROP_DISCOVERY_USER,
	TF_PROP_DISCOVERY_GROUP,
	TF_PROP_DISCOVERY_SYSMSG,
	TF_PROP_DISCOVERY_STATUS
};

typedef struct tagDASLROW
{
	// discoveryの種類
	TF_PROP_DISCOVERY	enuTypeDiscovery;

	// discovery名
	const char*			pszDiscoveryName;

	// サーチの種類
	TFSEARCHTYPE		enuTypeSearch;

	// Search名
	const char*			pszSearchName;
	
	// エレメント名
	const char*			pszInfoSub;
} TFDASLROW;

const TFDASLROW TFDASLTABLE[] =
{
	{TF_PROP_DISCOVERY_USER,	"userdiscovery",	TF_DASL_USERINFORMATION,	"userinformationsearch",	"userinfo"		},
	{TF_PROP_DISCOVERY_GROUP,	"groupdiscovery",	TF_DASL_GROUPINFORMATION,	"groupinformationsearch",	"groupinfo"		},
	{TF_PROP_DISCOVERY_STATUS,	"statusdiscovery",	TF_DASL_STATUSINFORMATION,	"statusinformationsearch",	"statusinfo"	},
	{TF_PROP_DISCOVERY_SYSMSG,	"sysmsgdiscovery",	TF_DASL_SYSMSGINFORMATION,	"sysmsginformationsearch",	"sysmsginfo"	},
	{TF_PROP_DISCOVERY_UNKNOWN,	NULL,				TF_DASL_ROOTTREE,			"roottreesearch",			NULL			},
	{TF_PROP_DISCOVERY_UNKNOWN,	NULL			,	TF_DASL_UNKNOWN,			NULL,						NULL			}
};

// User Discovery
const char	TF_PROP_USERID[]			=	"userid";
const char	TF_PROP_NAME[]				=	"name";
const char	TF_PROP_USEDSTORAGE[]		=	"usedstorage";
const char	TF_PROP_MAXSTORAGE[]		=	"maxstorage";
const char	TF_PROP_USEDRESOURCE[]		=	"usedresource";
const char	TF_PROP_MAXRESOURCE[]		=	"maxresource";
const char	TF_PROP_LASTACCESSDT[]		=	"lastaccessdt";
const char	TF_PROP_LASTACCESSCLIENT[]	=	"lastaccessclient";
const char	TF_PROP_MAILADDR[]			=	"mailaddr";
const char	TF_PROP_PASSWORD[]			=	"password";
const char	TF_PROP_COMMENT[]			=	"comment";
const char	TF_PROP_ACCESSDENY[]		=	"accessdeny";
const char	TF_PROP_ADMIN[]				=	"admin";
const char	TF_PROP_STATE[]				=	"state";
const char	TF_PROP_EXPIRATION[]		=	"expiration";
const char	TF_PROP_USER_PRIVILEGE[]	=	"user-privilege";
const char	TF_PROP_USER_TYPE[]			=	"usertype";
const char	TF_PROP_MAX_USERCREATION[]	=	"maxusercreation";
const char	TF_PROP_OWNER_NAME[]		=	"ownername";
const char	TF_PROP_OWNER_ID[]			=	"ownerid";
const char	TF_PROP_CHILDCOUND[]		=	"childcount";
const char	TF_PROP_ACTION[]			=	"action";
const char	TF_PROP_OTHERUSER[]			=	"otheruser";

// userstatus element
const char	TF_PROP_USER_STATE_ACTIVE[]		=	"active";
const char	TF_PROP_USER_STATE_INACTIVE[]	=	"inactive";
const char	TF_PROP_USER_STATE_EXPIRED[]	=	"expired";

// userprivilege element
const char	TF_PROP_USER_PRIV_READ[]		=	"read";
const char	TF_PROP_USER_PRIV_UPLOAD[]		=	"upload";
const char	TF_PROP_USER_PRIV_READWRITE[]	=	"readwrite";
const char	TF_PROP_USER_PRIV_SET_VIEW[]	=	"set-view";
const char	TF_PROP_USER_PRIV_REMOVE_VIEW[]	=	"remove-view";
const char	TF_PROP_USER_PRIV_APPEND_VIEW[]	=	"append-view";
const char	TF_PROP_USER_PRIV_BECOMEWATCHOWNER[]="becomewatchowner";
const char	TF_PROP_USER_PRIV_GROUPCONSTRAINTIGNORE[] = "group-constraints-ignore";
const char	TF_PROP_USER_PRIV_CONTROLOTHERUSER[] = "control-other-user";
const char	TF_PROP_USER_PRIV_APPOINTEDGROUPLEADER[]="appointed-groupleader";

// group constraints element
const char	TF_PROP_GROUP_CONSTRAINTS_WRITE[]	= "write";
const char	TF_PROP_GROUP_CONSTRAINTS_OPELOG[]	= "operationlog";
const char	TF_PROP_GROUP_CONSTRAINTS_SHOWPROPERTY[] ="showproperty";

// group state element
const char	TF_PROP_GROUP_STATE_ACTIVE[]		= "active";
const char	TF_PROP_GROUP_STATE_INACTIVE[]		= "inactive";

// resource state element
const char	TF_PROP_RESOURCESTATE_PUBLISHED[]	= "published";

// systemessage Information Search Response
const char	TF_PROP_MSGID[]				=	"msgid";
const char	TF_PROP_MSGTXT[]			=	"msgtxt";
const char	TF_PROP_ACTIVE[]			=	"active";
const char	TF_PROP_CREATEDT[]			=	"creationdt";
const char	TF_PROP_UPDATEDT[]			=	"updatedt";

// group Information Search Response
const char	TF_PROP_GROUPID[]			=	"groupid";
const char	TF_PROP_GROUPURI[]			=	"groupuri";
const char	TF_PROP_GROUPMAILWATCH[]	=	"groupmailwatch";
const char	TF_PROP_GROUPCOLLECTIONURI[]=	"groupcollectionuri";
const char	TF_PROP_CONSTRAINTS[]		=	"constraints";
const char	TF_PROP_GROUPSTATE[]		=	"state";

// change leader
const char	TF_PROP_CHANGELEADER[]		=	"changeleader";
const char	TF_PROP_CHANGELEADERAPPOINT[] =	"appoint";
const char	TF_PROP_CHANGELEADERDISMISS[] =	"dismiss";


// userinfomationで定義済み
//const char	TF_PROP_OWNER_NAME[]		=	"ownername";
//const char	TF_PROP_OWNER_ID[]			=	"ownerid";

// update Information Search Response
const char TF_PROP_VERSION[]			=	"version";
const char TF_PROP_LINEUP[]				=	"lineup";
const char TF_PROP_DIGEST[]				=	"digest";

// constant URI
#define		TF_RTURI_USER				"userinfo/"
#define		TF_RTURI_GROUP				"groupinfo/"
#define		TF_URI_MNG_USER				".management/USER/"
#define		TF_URI_MNG_GROUP			".management/GROUP/"
#define		TF_URI_MNG_STATUS			".management/STATUS/"

#define		TF_AVAILABLE_USER_PREFIX	".RU_"

// ROOTTREEで戻ってくる不明な内容を判断する為のDisplayNameの名前
const char	TF_MNG_STATUS[]			=	"STATUS";		//< ステータス
const char	TF_MNG_USER[]			=	"USER";			//< ユーザ
const char	TF_MNG_GROUP[]			=	"GROUP";		//< グループ
const char	TF_MNG_MSG[]			=	"MSG";			//< メッセージ
const char	TF_MNG_UPDATE[]			=	"UPDATE";		//< アップデート
const char	TF_MNG_DBMS[]			=	"DBMS";			//< データベース
const char	TF_MNG_EXECSQL[]		=	"EXECSQL";		//< テストデータベース
const char	TF_MNG_SQL[]			=	"SQL";			//< SQL

// Content-Type
const char	TF_CNTTYPE_TRASH[] = "httpd/trash-directory";

// 識別子の長さ
const int	TF_LENGTH_MESSAGE =	10;
const int	TF_LENGTH_UID	  = 60;

// ユーザのQUOTA種類
enum TF_STAT_QUOTA_TYPE
{
	// 利用量
	TF_STAT_USED = 1,
	// 可能利用量
	TF_STAT_MAX
};

typedef struct tagTFACCESSZONECOLUMN
{
	const char*		pszTagName;
	TFACCESSZONE	nZone;
} TFACCESSZONECOLUMN, *LPTFACCESSZONECOLUMN ;

const TFACCESSZONECOLUMN TFACCESSZONETABLE[] =
{
	{	"USER",			TF_ZONE_USER		},
	{	"GROUP",		TF_ZONE_GROUP		},
	{	"DBLINK",		TF_ZONE_DBLINK		},
	{	"REPOSDBLINK",	TF_ZONE_REPOS		},
	{	"MANAGEMENT",	TF_ZONE_MANAGE		},
	{	"M_UPDATE",		TF_ZONE_M_UPDATE	},
	{	"M_SQL",		TF_ZONE_M_SQL		},
	{	"M_GROUP",		TF_ZONE_M_GROUP		},
	{	"M_USER",		TF_ZONE_M_USER		},
	{	"M_STATUS",		TF_ZONE_M_STATUS	},
	{	"M_MSG",		TF_ZONE_M_MSG		},
	{	"M_DBMS",		TF_ZONE_M_DBMS		},
	{	"M_EXECSQL",	TF_ZONE_M_EXECSQL	},
	{	NULL,			TF_ZONE_NONE		}		// 最後の要素として必ず追加する事
};

/**
 *	ユーザの状態を表す
 */
enum TF_USER_STATUS
{
	TF_USER_STATUS_NONE		= 0x00,		//< 未設定
	TF_USER_STATUS_UNKNOWN	= 0x01,
	TF_USER_STATUS_ACTIVE   = 0x02,
	TF_USER_STATUS_INACTIVE	= 0x04,
	TF_USER_STATUS_EXPIRD   = 0x08
};
typedef int		TFUSERSTATUS;

typedef struct tagTFUSERSTATUSTBL
{
	const char*		pszName;
	TFUSERSTATUS	nStatus;
} TFUSERSTATUSTBL;

const TFUSERSTATUSTBL TFUSERSTATUSTABLE[] =
{
	{	TF_PROP_USER_STATE_ACTIVE,		TF_USER_STATUS_ACTIVE	},
	{	TF_PROP_USER_STATE_INACTIVE,	TF_USER_STATUS_INACTIVE	},
	{	TF_PROP_USER_STATE_EXPIRED,		TF_USER_STATUS_EXPIRD	},
	{	NULL,							TF_USER_STATUS_NONE		}
};

// グループ状態
typedef enum tagTFGROUPSTATE
{
	// 状態無し
	TF_GROUPSTATE_NONE					= 0x00000000,

	// アクティブ状態
	TF_GROUPSTATE_ACTIVE				= 0x00000001,

	// 非アクティブ状態
	TF_GROUPSTATE_INACTIVE				= 0x00000002,

	// マスク
	TF_GROUPSTATE_ACTIVE_MASK			= 0x0000000F
} TFGROUPSTATE;

typedef struct taTFGROUPSTATETABLE
{
	const char*			pszTagName;
	TFGROUPSTATE dwGroupState;
} TFGROUPSTATETABLE, *LPTFGROUPSTATETABLE;

const TFGROUPSTATETABLE TF_GROUPSTATE_TABLE[] = 
{
	{	"active",						TF_GROUPSTATE_ACTIVE		},
	{	"inactive",						TF_GROUPSTATE_INACTIVE		},
	{	NULL,							TF_GROUPSTATE_NONE			}
};

/**
 * リソース状態
 */
enum TF_RESOURCE_STATE
{
	TF_RES_STATE_NONE		= 0x00,		//< 未設定
	TF_RES_STATE_UNKNOWN	= 0x01,
	TF_RES_STATE_PUBLISHED	= 0x02
};
typedef int TFRESOURCESTATE;

/**
 *	ユーザ権限
 */
enum TF_USER_PRIVILEGE
{
	TF_USER_PRIV_UNKNOWN	= 0x00001,
	// 読み込み
	TF_USER_PRIV_READ		= 0x00002,
	// アップロード専用
	TF_USER_PRIV_UPLOAD		= 0x00004,
	// 読み書き
	TF_USER_PRIV_READWRITE	= 0x00008,
	// 公開権限
	TF_USER_PRIV_SET_VIEW	= 0x00010,
	TF_USER_PRIV_REMOVE_VIEW= 0x01000,
	TF_USER_PRIV_APPEND_VIEW= 0x02000,

	TF_USER_PRIV_BECOME_MAILWATCHOWNER=0x04000,

	// グループ制約を無視する
	TF_USER_PRIV_GROUPCONSTRAINTSIGNORE=0x08000,

	//　他ユーザを管理
	TF_USER_PRIV_CONTROLOTHERUSER=0x10000,

	// グループリーダーに任命されている
	TF_USER_PRIV_APPOINTEDGROUPLEADER=0x20000,

	// 何も無し
	TF_USER_PRIV_NONE		= 0x00000
};

typedef unsigned int TFUSERPRIV;

typedef struct tagTFPRIVILEGETBL
{
	const char*	pszName;
	TFUSERPRIV	nPriv;
} TFPRIVILEGETBL;

const TFPRIVILEGETBL TFPRIVILEGETABLE[] = 
{
	{	TF_PROP_USER_PRIV_READ,				TF_USER_PRIV_READ					},
	{	TF_PROP_USER_PRIV_UPLOAD,			TF_USER_PRIV_UPLOAD					},
	{	TF_PROP_USER_PRIV_READWRITE,		TF_USER_PRIV_READWRITE				},
	{	TF_PROP_USER_PRIV_SET_VIEW,			TF_USER_PRIV_SET_VIEW				},
	{	TF_PROP_USER_PRIV_REMOVE_VIEW,		TF_USER_PRIV_REMOVE_VIEW			},
	{	TF_PROP_USER_PRIV_APPEND_VIEW,		TF_USER_PRIV_APPEND_VIEW			},
	{	TF_PROP_USER_PRIV_BECOMEWATCHOWNER, TF_USER_PRIV_BECOME_MAILWATCHOWNER	},
	{	TF_PROP_USER_PRIV_GROUPCONSTRAINTIGNORE, TF_USER_PRIV_GROUPCONSTRAINTSIGNORE},
	{	TF_PROP_USER_PRIV_CONTROLOTHERUSER,	TF_USER_PRIV_CONTROLOTHERUSER		},
	{	TF_PROP_USER_PRIV_APPOINTEDGROUPLEADER, TF_USER_PRIV_APPOINTEDGROUPLEADER},
	{	NULL,								TF_USER_PRIV_NONE					}
};

// グループ制約
typedef enum tagTFGROUPCONSTRAINTS
{
	TF_GROUPCONSTRAINTS_NONE			= 0x00000000,		///< グループ制約未設定
	TF_GROUPCONSTRAINTS_WRITE			= 0x00000001,		///< 書き込み制約
	TF_GROUPCONSTRAINTS_OPELOG			= 0x00000002,		///< 操作ログ制約
	TF_GROUPCONSTRAINTS_SHOWPROPERTY	= 0x00000004,		///< 属性表示制約
	TF_GROUPCONSTRAINTS_MASK			= 0x0000000F		///< マスク
} TFGROUPCONSTRAINTS;

typedef struct tagTFGROUPCONSTRAINTSTABLE
{
	const char*				szTagName;
	TFGROUPCONSTRAINTS		dwConstraints;
} TFGROUPCONSTRAINTSTABLE, *LPTFGROUPCONSTRAINTSTABLE;

const TFGROUPCONSTRAINTSTABLE TF_GROUP_CONSTRAINTS_TABLE[] = 
{
	{	"write",		TF_GROUPCONSTRAINTS_WRITE			},
	{	"operationlog",	TF_GROUPCONSTRAINTS_OPELOG			},
	{	"showproperty", TF_GROUPCONSTRAINTS_SHOWPROPERTY	},
	{	NULL,			TF_GROUPCONSTRAINTS_NONE			}
};

/**
 *	ユーザタイプ
 */
enum TF_USER_TYPE
{
	//　分からない
	TF_USER_TYPE_UNKNOWN= 0x00,

	// 管理者
	TF_USER_TYPE_ADMIN	= 0x01,

	// グループリーダー
	TF_USER_TYPE_GROUPLEADER = 0x02,

	// 一般ユーザ
	TF_USER_TYPE_NORMAL	= 0x03,

	// 制限ユーザ
	TF_USER_TYPE_LIMITED= 0x04
};

typedef struct tagTFUSERTYPECOL
{
	const char*		pszName;
	TF_USER_TYPE	nType;
} TFUSERTYPECOL;

const TFUSERTYPECOL TFUSERTYPETABLE[] =
{
	{	"admin",		TF_USER_TYPE_ADMIN		},
	{	"groupleader",	TF_USER_TYPE_GROUPLEADER},
	{	"normal",		TF_USER_TYPE_NORMAL		},
	{	"limited",		TF_USER_TYPE_LIMITED	},
	{	NULL,			TF_USER_TYPE_UNKNOWN	}
};

/**
 *	追加ヘッダ関連
 */
const char	TF_HEADER_ACCEPTLANGUAGE[]		=	"Accept-Language";
const char	TF_HEADER_ACCEPTLANGUAGE_JA[]	=	"ja, en;q=0.8";
const char	TF_HEADER_ACCEPTLANGUAGE_EN[]	=	"en, ja;q=0.8";
const char	TF_HEADER_TF_AUTHORIZATION[]	=	"TF-Authorization";
const char	TF_HEADER_TF_FORCE_DELETE[]		=	"TF-Force-Delete";
const char	TF_HEADER_TF_CLIENT_INFO[]		=	"TF-Client-Info";

/**
 *	サーチの種類とプロパティ名
 */
typedef struct tagTFSEARCHTYPETABLE
{
	const char		*szURL;
	TFSEARCHTYPE	iType;
} TFSEARCHTYPETABLE, *PTFSEARCHTYPETABLE;

const TFSEARCHTYPETABLE TF_DASL_METHOD_TABLE[] =
{
	{	"basicsearch",						TF_DASL_BASIC				},
	{	"linkdbsearch",						TF_DASL_LINKDB				},
	{	"roottreesearch",					TF_DASL_ROOTTREE			},
	{	"userinformationsearch",			TF_DASL_USERINFORMATION		},
	{	"groupinformationsearch",			TF_DASL_GROUPINFORMATION	},
	{	"sqlinformationsearch",				TF_DASL_SQLINFORMATION		},
	{	"dbmsinformationsearch",			TF_DASL_DBMSINFORMATION		},
	{	"updateinformationsearch",			TF_DASL_UPDATEINFORMATION	},
	{	"statusinformationsearch",			TF_DASL_STATUSINFORMATION	},
	{	"sysmsginformationsearch",			TF_DASL_SYSMSGINFORMATION	},
	{	"mailinformationsearch",			TF_DASL_MAILINFORMATION		},
	{	"usershareinformationsearch",		TF_DASL_USERSHAREINFORMATIONSEARCH},
	{	"extendeduserinformationsearch",	TF_DASL_EXTENDEDUSERINFORMATIONSEARCH},
	{	NULL,								TF_DASL_UNKNOWN				}	//←必ず最後の要素にすること
};

// 一時アイテムの名前
#define TF_TEMP_ITEM_NAME		X("TEMPITEM")

/**
 *	ルートツリーで戻されるフォルダタイプとアイテムタイプとの対応表
 */
typedef	struct tagTFFOLDERTYPETABLE
{
	const char		*pszName;
	TFITEMTYPE		enuType;
} TFFOLDERTYPETABLE, *PTFFOLDERTYPETABLE;

const TFFOLDERTYPETABLE TF_FOLDER_TYPE_TABLE[] =
{
	{	"user",				TFITEM_USER			},		//< ユーザフォルダ（ROOT)
	{	"group",			TFITEM_GROUP_ROOT	},		//< グルーフォルダ（ROOT)
	{	"mgruop",			TFITEM_GROUP		},		//< グループフォルダの
	{	"dblink",			TFITEM_DBLINK_ROOT	},		//< データベースフォルダ（ROOT)
	{	"sqlstmt",			TFITEM_DBLINK		},		//< データベースフォルダ
	{	"reposdblink",		TFITEM_REPOSDB_ROOT	},		//< リポジトリデータベースフォルダ（ROOT)
	{	"reposdbsqlstmt",	TFITEM_REPOSDB		},		//< リポジトリデータベースフォルダ
	{	"management",		TFITEM_MNG_ROOT		},		//< マネージメントフォルダ（ROOT)
	{	"melement",			TFITEM_MNG_MELEMENT	},		//< マネージメントフォルダ各項目
	{	"execsqlstmt",		TFITEM_MNG_EXECSQL	},		//< テストDB
	{	NULL,				TFITEM_UNKNOWN		}
};

/**
 *	MKCOLのボディタイプ
 */
enum TFXMLBODYTYPE {
	TF_XML_BODY_NONE	= 0,
	TF_XML_BODY_MSG		= 1,
	TF_XML_BODY_USR		= 2,
	TF_XML_BODY_GRP		= 3,
	TF_XML_BODY_DBMS	= 4,
	TF_XML_BODY_SQL		= 5,
	TF_XML_BODY_LINKDB	= 6,
	TF_XML_BODY_SHARED	= 7,
	TF_XML_BODY_CHGLEADER_APPOINT=8,
	TF_XML_BODY_CHGLEADER_DISMISS=9
};

/*
 *	設定ファイルXML名
 */
#define		TF_CONF_XML_SERVER	"server.xml"

#endif

