#ifndef	TFLIB_HEADER_TFPUBLIC_H
#define TFLIB_HEADER_TFPUBLIC_H 1
/*
 *	$Id$
 *	TeamFileが共通で利用するタイプを定義しているヘッダ
 */

/* ライブラリで利用している型の別定義 */
#include "types.h"
#include "stdtypes.h"

// デバック
#ifdef _DEBUG
#  ifdef _WIN32
#    define TF_DEBUG TFDebugPrint
#  else
    /* TODO:その他のデバックメッセージ */
#  define TF_DEBUG   TFDebugPrint
#  endif
#else
#  define TF_DEBUG    if (0) TFDebugPrint
#endif

#define IS_EMPTY(x)		(((x) == NULL))
#define	IS_FILLED(x)		(((x) != NULL))

#define TF_TRUE			1
#define TF_FAIL			0

#define CRLF			"\r\n"
#define TAB				"\t"

typedef	std::vector<TF_STRING_A>            TFRID;
typedef	std::map<TF_STRING_A, TF_STRING_A>	TF_STRING_STRING_MAP;

/* onionのOI_AUTH_CLASSと同じ */
enum TF_AUTH_CLASS {
  TF_C_AUTH_INVALID   = 0,
  TF_C_AUTH_SERVER    = 1,
  TF_C_AUTH_PROXY     = 2
};

// SSL証明書を操作する為のハンドルタイプ
enum TF_SSL_CERT_HANDLE_TYPE {
	TF_SSL_CERT_UNKNOWN = 0,
	TF_SSL_CERT_VOID,
	TF_SSL_CERT_FILE
};

// SSL証明書の名前
enum TF_SSL_CERT_STORE_NAME
{
	TF_SSL_CERT_STORE_NAME_NONE	= 0,
	TF_SSL_CERT_STORE_NAME_ROOT	= 1,
	TF_SSL_CERT_STORE_NAME_CA	= 2
};

// 接続状態
enum TF_CONN_STATE {
	TF_CONN_IDLE		= 0,	// 未使用
	TF_CONN_DISCONNECT	= 1,	// 接続切断
	TF_CONN_ESTABLISHED = 2		// 使用中
};

// ドラッグ関係情報
enum TF_DL_INFO {
	TF_DL_NONE	= 0x00,
	TF_DL_MOVE	= 0x01,
	TF_DL_COPY	= 0x02
};

// 言語種別
typedef enum tagTFLANG
{
	TF_LANG_UNKNOWN	=	0x0000,
	TF_LANG_JA		=	0x0001,	// 日本語
	TF_LANG_EN		=	0x0010	// 英語
} TFLANG;

/*
 *	ローカルのXML設定ファイル系
 */
enum TFSETTINGXMLTAG {
	TFSETTINGXMLTAG_NONE		= 0,
	TFSETTINGXMLTAG_SERVER		= 1,
	TFSETTINGXMLTAG_PLATHOME	= 2,
	TFSETTINGXMLTAG_STATIC		= 3,
	TFSETTINGXMLTAG_PUBLIC		= 4,
	TFSETTINGXMLTAG_POLICY		= 5		// Onion policy file
};

/**
 *	ブラウズ（表示）関連
 */
typedef	enum tagNOTIFYTYPE
{
	TF_NOTIFY_NONE		= 0,
	TF_NOTIFY_NEW		= 1,
	TF_NOTIFY_DELETE	= 2,
	TF_NOTIFY_LOCK		= 3,
	TF_NOTIFT_UNLOCK	= 4
} TFNOTIFYTYPE;

// リソースの新規作成種別
typedef enum tagTFRESOURCETYPE
{
	TF_RES_UNKNOWN		= 0,
	TF_RES_FILE			= 1,
	TF_RES_COLLECTION	= 2
} TFRESOURCETYPE;

// グループリーダー設定タイプ
typedef enum tagTFCHANGELEADERTYPE
{
	TF_CHG_LEADER_APPOINTED = 1,	// 任命
	TF_CHG_LEADER_DISMISS   = 2		// 解任
} TFCHANGELEADERTYPE;

/**
 * DAVメソッド関連
 */
typedef enum tagTFDAVMETHOD
{
	TF_DAV_UNKNOWN =	0x00000000,
	TF_DAV_OPTIONS =	0x00000001,
	TF_DAV_HEAD =		0x00000002,
	TF_DAV_POST =		0x00000004,
	TF_DAV_GET =		0x00000008,
	TF_DAV_PUT =		0x00000010,
	TF_DAV_PROPFIND =	0x00000020,
	TF_DAV_PROPPATCH =	0x00000040,
	TF_DAV_DELETE	=	0x00000080,
	TF_DAV_COPY =		0x00000100,
	TF_DAV_MOVE =		0x00000200,
	TF_DAV_MKCOL =		0x00000400,
	TF_DAV_LOCK =		0x00001000,
	TF_DAV_UNLOCK =		0x00002000,
	TF_DAV_SEARCH =		0x00010000
} TFDAVMETHOD;


/**
 *	SEARCHの種類
 */
typedef enum tagTFSEARCHTYPE
{
	TF_DASL_ALL								= 0xFFFF,
	TF_DASL_UNKNOWN							= 0x0000,
	TF_DASL_BASIC							= 0x0001,
	TF_DASL_LINKDB							= 0x0002,
	TF_DASL_ROOTTREE						= 0x0004,
	TF_DASL_USERINFORMATION					= 0x0008,
	TF_DASL_GROUPINFORMATION				= 0x0010,
	TF_DASL_SQLINFORMATION					= 0x0020,
	TF_DASL_DBMSINFORMATION					= 0x0040,
	TF_DASL_UPDATEINFORMATION				= 0x0080,
	TF_DASL_STATUSINFORMATION				= 0x0100,
	TF_DASL_SYSMSGINFORMATION				= 0x0200,
	TF_DASL_MAILINFORMATION					= 0x0400,
	TF_DASL_TRASHINFORMATION				= 0x0800,
	TF_DASL_USERSHAREINFORMATIONSEARCH		= 0x1000,
	TF_DASL_EXTENDEDUSERINFORMATIONSEARCH	= 0x2000,

	// 古いサーバ向け
	TF_DASL_NON_EXTENDEDUSER				= ( TF_DASL_ALL & ~(TF_DASL_EXTENDEDUSERINFORMATIONSEARCH))

} TFSEARCHTYPE;

/**
 * RootTreeSearchのフラグ
 */
typedef enum tagTFSEARCH_RT
{
	TF_SEARCH_RT_NONE			= 0,
	TF_SEARCH_RT_ALL			= 1,	///< サーバフォルダ直下のフォルダのみ
	TF_SEARCH_RT_SQLSTMT		= 2,	///< データベースフォルダ
	TF_SEARCH_RT_GROUP			= 3,	///< グループフォルダ
	TF_SEARCH_RT_REPOSDBSQLSTMT	= 4,	///< リポジトリフォルダ
	TF_SEARCH_RT_MANAGEMENT		= 5,	///< 管理者フォルダの直下
	TF_SEARCH_RT_EXECSQLSTMT	= 6		///< 試しデータベースフォルダの直下
} TFSEARCH_RT;

/**
 * SysmsgInformationSearchのフラグ
 */
typedef enum tagTFSEARCH_SMI
{
	TF_SEARCH_SMI_NONE			= 0,	///< 未設定
	TF_SEARCH_SMI_DETAILLIST		= 1,	///< 詳細リスト
	TF_SEARCH_SMI_CURRENTMSG		= 2,	///< アクティブになっているメッセージすべて
	TF_SEARCH_SMI_CONTENT		= 3		///< 一件ごとの内容
} TF_SEARCH_SMI;

/**
 *	UserInformationSearchのフラグ
 */
typedef enum tagTF_SEARCH_UI
{
	TF_SEARCH_UI_NONE			= 0x00,
	TF_SEARCH_UI_TREELIST		= 0x01,
	TF_SEARCH_UI_DETAILLIST		= 0x02,
	TF_SEARCH_UI_CONTENT		= 0x04,
	TF_SEARCH_UI_AVAILABLEGROUP = 0x08
} TF_SEARCH_UI;

/**
 * group InformationSearchのフラグ
 */
typedef enum tagTF_SEARCH_GI
{
	TF_SEARCH_GI_NONE			= 0x00,
	TF_SEARCH_GI_TREELIST		= 0x01,
	TF_SEARCH_GI_DETAILLIST		= 0x02,
	TF_SEARCH_GI_CONTENT		= 0x04,
	TF_SEARCH_GI_AVAILABLEUSER	= 0x08,
	TF_SEARCH_GI_AVAILABLESQL	= 0x10
} TF_SEARCH_GI;

// DBMSInformationSearchのフラグ
typedef enum tagTFSEARCH_DI
{
	TF_SEARCH_DI_NONE			= 0x00,
	TF_SEARCH_DI_DETAILLIST		= 0x01,
	TF_SEARCH_DI_CONTENT		= 0x02,
	TF_SEARCH_DI_ACTIVEDBMS		= 0x04,
	TF_SEARCH_DI_LICENSEDDBMS	= 0x08
} TF_SEARCH_DI;

/*
 *	トランザクションモード
 */
enum TFTRANSMODE {
	TF_TRANS_UNKNOWN = 0,			//< トランザクション不明
	TF_TRANS_LIST,					//< PROPFIND実行中

	// MKCOL
	TF_TRANS_MAKEFOLDER,			//< フォルダ作成中
	TF_TRANS_MAKEUSER,				//< ユーザ作成中
	TF_TRANS_MAKEGROUP,				//< グループ作成中
	TF_TRANS_MAKEDBMS,				//< DBMS作成中
	TF_TRANS_MAKESQL,				//< SQL作成中
	TF_TRANS_MAKELINKDB,			//< LINKDB作成中
	TF_TRANS_MAKEMSG,				//< メッセージ作成中

	// SEARCH
	TF_TRANS_ROOTTREESEARCH,		//< ROOTTreeサーチ実行中
	TF_TRANS_STATUSSEARCH,			//< ステータスインフォメーションサーチ実行中
	TF_TRANS_USERSEARCH,			//< ユーザインフォメーションサーチ実行中
	TF_TRANS_GROUPSEARCH,			//< グループインフォメーションサーチ実行中
	TF_TRANS_SYSMEGSEARCH,			//< メッセージインフォメーションサーチ実行中
	TF_TRANS_DBMSSEARCH,			//< DBMSインフォメーションサーチ実行中
	TF_TRANS_UPDSEARCH,				//< UPDATEインフォメーションサーチ実行中

	// GET
	TF_TRANS_GETRESOURCE,			//< リソース取得中

	// PUT
	TF_TRANS_UPLOADRESOURCE,		//< リソースアップロード中
	TF_TRANS_MAKERESOURCE,			//< 新規りソース作成中

	// MOVE
	TF_TRANS_RENAME,				//< 名称変更中
	TF_TRANS_MOVE,					//< リソース変更中

	// DELETE
	TF_TRANS_DELETE,				//< リソース削除中

	// LOCK
	TF_TRANS_LOCK,					//< ロック中

	// UNLOCK
	TF_TRANS_UNLOCK,				//< ロック解除中

	// COPY
	TF_TRANS_AVAILABLEUSER,			//< ユーザをグループに所属中

	// PROPPATCH
	TF_TRANS_PATCHUSER,				//< ユーザ情報変更中
	TF_TRANS_PATCHGROUP,			//< グループ情報変更中
	TF_TRANS_PATCHMSG,				//< メッセージ変更中
	TF_TRANS_PATCHDBMS,				//< DBMS変更中
	TF_TRANS_PATCHSQL,				//< SQL変更中
	TF_TRANS_PATCHLINKDB,			//< LINKDB変更中
	TF_TRANS_CHANGELEADER			//< グループリーダー変更中
};

/**
 *	問合せの結果種類
 */
typedef enum tagTFDLGNOTIFYTYPE
{
	TF_DLG_NOTIFY_NONE	= 0x00,		//	問合せはない
	TF_DLG_NOTIFY_OK	= 0x01,		//	OK
	TF_DLG_NOTIFY_NO	= 0x02,		//	NO
	TF_DLG_NOTIFY_CANCEL= 0x04,		//	CANCEL
	TF_DLG_NOTIFY_ALLOK = 0x10,		//	ALLOK
	TF_DLG_NOTIFY_ALLNO = 0x20,		//	ALLNO
	TF_DLG_NOTIFY_ABORT = 0x80,		//	ABORT

	TF_DLG_NOTIFY_TRUE	= ( TF_DLG_NOTIFY_OK | TF_DLG_NOTIFY_ALLOK),
	TF_DLG_NOTIFY_FALSE	= ( TF_DLG_NOTIFY_NO | TF_DLG_NOTIFY_ALLNO),

	TF_DLG_NOTIFY_STD	= (	TF_DLG_NOTIFY_OK	|
							TF_DLG_NOTIFY_NO	|
							TF_DLG_NOTIFY_CANCEL|
							TF_DLG_NOTIFY_ALLOK	|
							TF_DLG_NOTIFY_ALLNO),

	TF_DLG_NOTIFY_ALL	= ( TF_DLG_NOTIFY_ALLOK |
							TF_DLG_NOTIFY_ALLNO)

} TFDLGNOTIFYTYPE;

typedef enum tagTFRESULT			// メッセージボックスに与えるエラーの種類
{
	TF_RESULT_NOERROR	= 0,		///< エラー無し（通常使用しない）
	TF_RESULT_OK,					///< 正常（エラーはない）
	TF_RESULT_SKIP,					///< 正常（スキップ）

//　設定ファイル系のエラー
	TF_RESULT_CONF_HOSTNOTFOUND,		///< クライアントのホスト（サーバ）が存在していなかった

// ローカルシステム系のエラー
	TF_RESULT_LSYS_BROKEN,			///< ローカルシステムが壊れている（情報の取得ができなかった）
	TF_RESULT_LSYS_PARENTDIRNOTFOUND,///< 親フォルダが存在しなかった
	TF_RESULT_LSYS_RESOURCE_EXIST,	///< リソースが既に存在した
	TF_RESULT_LSYS_NOTFOUND,		///< ローカルにファイルが存在しない
	TF_RESULT_LSYS_UNEXPECTED,		///< ローカルに何か問題があった。（ローカルシステム系の最後の項目とすること）

// DAVメソッドに関する報告
	TF_RESULT_FOUNDFOLDER,			///< フォルダの上書きを行った
	TF_RESULT_RESOURCE_NOCONTENT,	///< リソースの上書きを行った。

// 雑多なエラーコード（未整理）
	TF_RESULT_USERCANCELD,			///< ユーザがキャンセルしました。
	TF_RESULT_XMLERROR,				///< XMLエラー
	TF_RESULT_OVERWRITE,				///< 上書き確認？
	TF_RESULT_SOMEFILECANTWRITE,		///< 削除失敗 
	TF_RESULT_ALREADYLOCKED,			///< ロック済み
	TF_RESULT_LOCKFAILURE,			///< ロック失敗
	TF_RESULT_TIMEOUT,				///< タイムアウト
	TF_RESULT_HOSTNOTFOUND,			///< ホスト無し
	TF_RESULT_CLOSED,				///< 切断
	TF_RESULT_NOTFOUND,				///< ファイル無し
	TF_RESULT_PARENT_NOTFOUND,		///< 親フォルダがない
	TF_RESULT_FORBIDDEN,				///< アクセス拒否
	TF_RESULT_UNEXPECTED,			///< 想定外エラー
	TF_RESULT_NORESULT,				///< 検索結果無し
	TF_RESULT_CANTRENAME,			///< 名前変更失敗
	TF_RESULT_CANTCREATEFOLDER,		///< フォルダ作成失敗
	TF_RESULT_OVERWRITE2,			///< サーバー上書き確認
	TF_RESULT_DELETE,				///< 削除確認
	TF_RESULT_DELETE2,				///< 削除確認
	TF_RESULT_INSUFFICIENTSTRAGE,	///< ディスク容量不足
	TF_RESULT_SOMEFILECANTPROCESS,	///< 処理失敗
	TF_RESULT_USER_RESOURCE_EXIST,	///< ユーザにリソースが残っている
	TF_RESULT_GROUP_RESOURCE_EXIST,	///< グループにリソースが残っている
	TF_RESULT_FAILDDEPEND,			///< 依存エラー（Failed Dependency)
	TF_RESULT_INVALIDLICENSE,		///< ライセンス無効
	TF_RESULT_WRONGUSERPASSWORD,		///< IDまたはパスワードが正しくない
	TF_RESULT_HTTPPROTCOLERROR,		///< HTTPプロトコルエラー
	TF_RESULT_SSLGENERICERROR,		///< SSLのエラー
	TF_RESULT_SSLCONNECTIONERROR,		///< SSLによる接続に失敗
	TF_RESULT_SSLHANDSHAKEFAILED,		///< SSLのハンドシェイクエラー
	TF_RESULT_CONNECTIONFAIL,		///< 接続に失敗
	TF_RESULT_RESETBYSERVER,		///< サーバ側が切断した
	TF_RESULT_SOCKGENERICERROR,		///< ソケットエラー
	TF_RESULT_SOCKLINETOLONG,			///< ソケットのラインサイズがオーバー
	TF_RESULT_SERVICENOTAVAILABLE,	///< サービスが有効ではない.もしくは、プロキシ経由の接続に失敗
	TF_RESULT_PROXYTUNNELFAIL,		///< プロキシ経由の接続に失敗
	TF_RESULT_FORBIDDENNONSSL,		///< 非SSL通信は禁止されている
	TF_RESULT_NONSSLCONNECTION,		///< 非SSL通信の確認
	TF_RESULT_DOWNLOAD,				///< ダウンロード時の確認
	TF_RESULT_CHANGEFILEEXT,			///< 拡張子変更の確認
	TF_RESULT_EXECSQLFAIL,			///< お試しSQLの実行に失敗
	TF_RESULT_INSUFFICIENTLICENSE,	///< ライセンスが足りない。（登録アカウント数のオーバー)
	TF_RESULT_INTERNALSERVERERROR,	///< サーバーエラー（混み合っているかも）
	TF_RESULT_BADREQUEST,			///< 不正な要求
	TF_RESULT_USEREXIST,				///< ユーザが存在した
	TF_RESULT_CONNECTIONABORTED,		///< 切断（容量制限オーバー）
	TF_RESULT_RESORCE_EXIST,			///< リソースが既に存在している
	TF_RESULT_LIBNKDBFAIL,			///< データベースコラボレーションのエラー
	TF_RESULT_EXCEEDEDLICENSEDCAPACITY,	///< ライセンスされた容量・ファイル数を超えた
	TF_RESULT_UNSUPPORTEDAUTHSCHEME,	///< サポートされていない認証方式
	TF_RESULT_BADCOMPRESSEDHEADER,	///< 圧縮データのヘッダが不正
	TF_RESULT_BADCOMPRESSEDCONTENT,	///< 圧縮データの中身が不正
	TF_RESULT_TRASH_MOVE,			///< ごみ箱に移す
	TF_RESULT_TRASH_MOVE2,			///< ごみ箱に移す（複数）
	TF_NUMBEROFERRORCODE			///< ※この要素は一番後ろに置くこと
} TFRESULT;

/**
 *	アクセスゾーン
 */
typedef enum tagTFACCESSZONE
{
	TF_ZONE_USER		=	0x00000001,		//< ユーザフォルダ
	TF_ZONE_GROUP		=	0x00000002,		//< グループフォルダ
	TF_ZONE_DBLINK		=	0x00000004,		//< データベース連携
	TF_ZONE_REPOS		=	0x00000008,		//< リポジトリサーチ
	TF_ZONE_MANAGE		=	0x00000010,		//< マネージメントフォルダ
	TF_ZONE_MASK		=	0x0000001F,		//< マスク

	TF_ZONE_M_UPDATE	=	0x00000020,		//< アップデート管理
	TF_ZONE_M_SQL		=	0x00000040,		//< SQL管理
	TF_ZONE_M_GROUP		=	0x00000080,		//< グループ管理
	TF_ZONE_M_USER		=	0x00000100,		//< ユーザ管理
	TF_ZONE_M_STATUS	=	0x00000200,		//< ステータス管理
	TF_ZONE_M_MSG		=	0x00000400,		//< メッセージ管理
	TF_ZONE_M_DBMS		=	0x00000800,		//< データベース管理
	TF_ZONE_M_EXECSQL	=	0x00001000,		//< データベース実行管理
	TF_ZONE_M_MASK		=	0x00001FE0,		//< マスク

	TF_ZONE_BROKEN		=	0x10000000,		//< ゾーンが壊れている
	TF_ZONE_NONE		=	0x00000000		//< 無し
} TFACCESSZONE;

/*
 *	アイテムの種類
 */
typedef	enum tagTFITEMTYPE {
		TFITEM_UNKNOWN			= 0x00000000,	//< アイテムタイプ不明
		TFITEM_SERVER			= 0x00000001,	//< サーバ
		TFITEM_FOLDER			= 0x00000002,	//< フォルダ
		TFITEM_FILE				= 0x00000004,	//< ファイル
		TFITEM_USER				= 0x00000008,	//< ユーザフォルダ
		TFITEM_GROUP_ROOT		= 0x00000010,	//< グループフォルダ
		TFITEM_GROUP			= 0x00000020,	//< グループフォルダのグループ
		TFITEM_DBLINK_ROOT		= 0x00000040,	//< データベース連携フォルダ(ルート)
		TFITEM_DBLINK			= 0x00000080,	//< データベース連携フォルダ(各項目)
		TFITEM_REPOSDB_ROOT		= 0x00000100,	//< リポジトリデータベースフォルダ(ルート）
		TFITEM_REPOSDB			= 0x00000200,	//< リポジトリデータベースフォルダ(各項目)
		TFITEM_MNG_ROOT			= 0x00000400,	//< マネージメントフォルダ(ルート)
		TFITEM_MNG_MELEMENT		= 0x00000800,	//< マネージメントフォルダ（この時点では不明）
		TFITEM_MNG_CLIENT_ROOT	= 0x00001000,	//< マネージメントフォルダのクライアント更新(ルート)
		TFITEM_MNG_CLIENT		= 0x00002000,	//< マネージメントフォルダのクライアント更新
		TFITEM_MNG_MSG_ROOT		= 0x00004000,	//< マネージメントフォルダのメッセージ(ルート）
		TFITEM_MNG_MSG			= 0x00008000,	//< マネージメントフォルダのメッセージ
		TFITEM_MNG_USR_ROOT		= 0x00010000,	//< マネージメントフォルダのユーザ(ルート）
		TFITEM_MNG_USR			= 0x00020000,	//< マネージメントフォルダのユーザ
		TFITEM_MNG_GRP_ROOT		= 0x00040000,	//< マネージメントフォルダのグループ(ルート）
		TFITEM_MNG_GRP			= 0x00080000,	//< マネージメントフォルダのグループ
		TFITEM_MNG_STAT_ROOT	= 0x00100000,	//< マネージメントフォルダの統計(ルート）
		TFITEM_MNG_STAT			= 0x00200000,	//< マネージメントフォルダの統計
		TFITEM_MNG_SQL_ROOT		= 0x00400000,	//< マネージメントフォルダのSQL(ルート）
		TFITEM_MNG_SQL			= 0x00800000,	//< マネージメントフォルダのSQL
		TFITEM_MNG_DBMS_ROOT	= 0x01000000,	//< マネージメントフォルダのDBMS（ルート）
		TFITEM_MNG_DBMS			= 0x02000000,	//< マネージメントフォルダのDBMS
		TFITEM_MNG_EXECSQL_ROOT	= 0x04000000,	//< マネージメントフォルダのEXECSQL（ルート）
		TFITEM_MNG_EXECSQL		= 0x08000000,	//< マネージメントフォルダのEXECSSQL
		TFITEM_TRASH_FOLDER		= 0x10000000	//< ごみ箱フォルダ
} TFITEMTYPE;

#ifdef SHAREDLIB
#	if defined(_MSC_VER)
#		define TF_EXPORT __declspec( dllexport )
#		define TF_BEGIN_CLASSEXPORT	__pragma( warning( disable: 4251 ) )
#		define TF_END_CLASSEXPORT	__pragma( warning( default: 4251 ) )
#		define TF_BEGIN_CPPFUNCTIONEXPORT
#		define TF_END_CPPFUNCTIONEXPORT
#		define TF_BEGIN_CFUNCTIONEXPORT	extern "C" {
#		define TF_END_CFUNCTIONEXPORT	}
#	elif defined(__MWERKS__)
#		define TF_EXPORT
#		define TF_IMPORT
#		define TF_BEGIN_CLASSEXPORT	_Pragma("export on")
#		define TF_END_CLASSEXPORT	_Pragma("export off")
#		define TF_BEGIN_CPPFUNCTIONEXPORT		_Pragma("export on")
#		define TF_END_CPPFUNCTIONEXPORT	_Pragma("export off")
#		define TF_BEGIN_CFUNCTIONEXPORT	_Pragma("export on")	\
										extern "C" {
#		define TF_END_CFUNCTIONEXPORT	}	\
										_Pragma("export off")
#	endif
#else
#	if defined(_MSC_VER)
#		define TF_EXPORT __declspec( dllimport )
#		define TF_BEGIN_CLASSEXPORT	__pragma( warning( disable: 4251 ) )
#		define TF_END_CLASSEXPORT	__pragma( warning( default: 4251 ) )
#		define TF_BEGIN_CPPFUNCTIONEXPORT
#		define TF_END_CPPFUNCTIONEXPORT
#		define TF_BEGIN_CFUNCTIONEXPORT	extern "C" {
#		define TF_END_CFUNCTIONEXPORT	}
#	endif
#endif /*SHAREDLIB*/
#ifndef TF_EXPORT
#	define TF_EXPORT
#endif
#ifndef TF_BEGIN_CLASSEXPORT
#		define TF_BEGIN_CLASSEXPORT
#endif
#ifndef TF_END_CLASSEXPORT
#		define TF_END_CLASSEXPORT
#endif
#ifndef TF_BEGIN_CPPFUNCTIONEXPORT
#		define TF_BEGIN_CPPFUNCTIONEXPORT
#endif
#ifndef TF_END_CPPFUNCTIONEXPORT
#		define TF_END_CPPFUNCTIONEXPORT
#endif
#ifndef TF_BEGIN_CFUNCTIONEXPORT
#		define TF_BEGIN_CFUNCTIONEXPORT
#endif
#ifndef TF_END_CFUNCTIONEXPORT
#		define TF_END_CFUNCTIONEXPORT
#endif

#endif

