/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFLibTransactionBase.h
 *	クラス名		:	CTFLibTransactionBase
 *	継承			:
 *
 *	機能　		:	TeamFileのトランザクションで利用される共通メソッドクラス
 *
 */

#ifndef	TF_LIB_TRANSACTIONBASE_H
#define	TF_LIB_TRANSACTIONBASE_H	1

#include "TFLibWorkSessionWrapper.h"
#include "TFWsNotificationHandler.h"
#include "TFWsTransactionHandler.h"
#include "TFResourceItem.h"
#include "TFPlatformsFactory.h"

class CTFLibWorkSessionWorker;

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFLibTransactionBase 
{
public:
	CTFLibTransactionBase(void);
	virtual ~CTFLibTransactionBase(void);

	void SetHandler(CTFWsNotificationHandler* pHandler);
	void SetHandler(CTFWsTransactionHandler* pHandler);
	void SetHandler(CTFWsSystemInformationHandler *pHandler);
	
	TFDAVMETHOD GetServerOptions(CTFResourceItem* pItem, CTFLibWorkSessionWorker* pWsWorker, int& nAllowMethods, int& nAllowDASL);

	/**
	 *	デバッグモードを設定する
	 *	@param bDebug	デバックモード			true : on / false : off
	 *	@param nFD		ファイルディスクリプタ	
	 */
	void SetDebugMode(bool bDebug=true, int nFD=-1);

	/**
	 *	トランザクションで起こったエラーステータスを返す
	 */
	TFRESULT GetLastError(void);

protected:
	bool GetLock(CTFResourceItem* pItem, CTFLibWorkSessionWorker* pWsWorker);
	OI_RESULT GetLock(const TFXMLCh* pszURI, CTFLibWorkSessionWorker* pWsWorker, OI_STRING_A& strLockToken, long lTimeOut=0);
	OI_RESULT UnLock(const TFXMLCh* pszURI, const char* pszLockToken, CTFLibWorkSessionWorker* pWsWorker);
	bool ExistResource(const TFXMLCh* pszURI, LOCKLIST& vLock, OI_RESULT& oResult, CTFLibWorkSessionWorker* pWsWorker);
	bool GetOneResource(const TFXMLCh* pszURI, CTFResourceProp** pItem, CTFLibWorkSessionWorker* pWsWorker);
	bool GetResourceListRecursive(const TFXMLCh* pszURI, CTFResourceProp** pItem, CTFLibWorkSessionWorker* pWsWorker);

protected:
	/**
	 *	トランザクションの中で発生したエラーを解析する
	 */
	TFDLGNOTIFYTYPE QueryDAVError(TFTRANSMODE enuMode, TFDAVMETHOD enuDAVMethod, OI_RESULT oResult, CTFObject* pObj);
	TFDLGNOTIFYTYPE QueryDAVError_Default(OI_RESULT oResult);
	TFRESULT					m_enuLastResult;
	bool						m_bDebug;			// デバッグモード
	int							m_nDebugFD;				// デバッグディスクリプタ

protected:
	CTFWsNotificationHandler*	m_pNotifyHandler;
	CTFWsNotificationHandler	m_cNotifyHandlerDef;		//< デフォルトのNotifyハンドラ
	CTFWsTransactionHandler*	m_pTransHandler;
	CTFWsTransactionHandler		m_cTransHandlerDef;		//< デフォルトのトランザクションハンドラ
	CTFWsSystemInformationHandler*	m_pSysHandler;
	CTFWsSystemInformationHandler	m_cSysHandler;

	CTFPlatformsFactory*			m_pPFFactory;		//< プラットフォーム依存クラスの生成クラス
};

TF_END_CLASSEXPORT

#endif		// TF_LIB_TRANSACTIONBASE_H

