/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFLibWorkSession.h
 *	クラス名	:	CTFLibWorkSession
 *	継承		:	CDavWorkSession
 *
 *	機能　		:	Onionライブラリの機能をラップするTeamFile
 *					のワークセッションクラス
 *
 */

#ifndef TF_LIB_WORKSESSION_H
#define	TF_LIB_WORKSESSION_H	1

#include "onion/DavWorkSession.h"
#include "onion/DavSSLCertificateList.h"
#include "TFServerResource.h"
#include "TFLibDefinition.h"
#include "TFWsNotificationHandler.h"
#include "TFWsTransactionHandler.h"
#include "TFWsSystemInformationHandler.h"

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFLibWorkSession :
	public CDavWorkSession
{
public:
	CTFLibWorkSession(void);
	~CTFLibWorkSession(void);

	void	SetServerInfo(const TFXMLCh* pszServerID);

	// onion ハンドラ
	virtual bool OnVerifyCertificates(CDavSSLCertificateList* pUnauthenticCerts);
	virtual bool OnProvideClientCertificate(CDavSSLClientCertificate* pCertOut,
											CDavSSLDName* pCAList, int nCount);
	virtual bool OnAuthentication(X& pszRealm, OI_STRING_A& strUsername,
							OI_STRING_A& strPasswd, int nRetry, OI_AUTH_CLASS enuAuthClass);

	virtual bool MatchServerString(const char* pszHeaderValue, const char* pszConfigValue);

	void	SetHandler(CTFWsNotificationHandler* pHandler);
	void	SetHandler(CTFWsTransactionHandler* pHandler);
	void	SetHandler(CTFWsSystemInformationHandler* pHandler);

	void	SetProgressHandle(TFHANDLE hProgress);

private:
	void	saveUserProfile(OI_AUTH_CLASS enuAuthClass, const char* strUsername, const char* pszPassWd);

protected:
	CTFWsNotificationHandler*	m_pNotifyHandler;
	CTFWsNotificationHandler	m_cNotifyHandlerDef;		//< デフォルトのNotifyハンドラ
	CTFWsTransactionHandler*	m_pTransHandler;
	CTFWsTransactionHandler		m_cTransHandlerDef;			//< デフォルトのTransactionハンドラ
	CTFWsSystemInformationHandler*	m_pSysHandler;
	CTFWsSystemInformationHandler	m_cSysHandlerDef;		//< デフォルトのSystemハンドラ

	TF_STRING_W					m_strServerID;				//< サーバID
	CTFServerResource*			m_pSvrResource;				//< サーバリソース

	TFHANDLE					m_hProgress;				//< プログレスハンドル
};

TF_END_CLASSEXPORT

#endif

