/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFLibWorkSessionManager.h
 *	クラス名	:	CTFLibWorkSessionManager
 *	継承		:	CTFLibWorkSessionWorker
 *
 *	機能　		:	ワークセッションを管理するクラス
 *
 */
#ifndef TF_LIB_WORKSESSIONMANAGER_H
#define	TF_LIB_WORKSESSIONMANAGER_H	1

#include "TFLibWorkSessionWorker.h"
#include "TFResourceItem.h"
#include "TFCriticalSection.h"
#include "TFWsSystemInformationHandler.h"

class CTFLibWorkSessionManager
{
public:
	CTFLibWorkSessionManager(void);
	virtual ~CTFLibWorkSessionManager(void);

	void Empty();
	static CTFLibWorkSessionWorker* GetSession(CTFResourceItem* pItem, TFHANDLE hProgress);
	static CTFLibWorkSessionWorker* GetSession(const TFXMLCh* pszServerID, TFHANDLE hProgress);
	static void CloseSession(CTFLibWorkSessionWorker* pSession, bool bPending=false);
	static void InitializeWorkSessionManager(void);
	static void TerminateWorkSessionManager(void);

protected:
	static CTFLibWorkSessionWorkerPtrVector	gs_vSession;		//< ワークセッション一覧
	static short m_snSessionCounter;
	static CTFCriticalSection	gs_cWsCtitSect;

};

#endif

