/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFLibWorkSessionWorker.h
 *	クラス名	:	CTFLibWorkSessionWorker
 *	継承		:	CTFObject
 *
 *	機能　		:	ひとつのワークセッションを保持管理しているクラス
 *
 */
#ifndef TF_LIB_WORKSESSIONWORKER_H
#define	TF_LIB_WORKSESSIONWORKER_H	1

#include "TFLibWorkSessionWrapper.h"
#include "TFLibDefinition.h"
#include "TFWsTransactionHandler.h"
#include "TFWsNotificationHandler.h"
#include "TFWsSystemInformationHandler.h"

class CTFServerResource;

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFLibWorkSessionWorker
{
public:
	CTFLibWorkSessionWorker(void);
	virtual ~CTFLibWorkSessionWorker(void);

	OI_RESULT SEARCH(const TFXMLCh* pszTargetURI, CTFResourceProp **pItem, CRBPVDXmlSearch *pXml);
	OI_RESULT OPTIONS(const TFXMLCh* pszTargetURI);
	OI_RESULT PROPFIND(const TFXMLCh* pszTargetURI,
					   CTFResourceProp **pItem,
					   OI_PFIND_DEPTH enuDepth		= D_PFIND_ONE,
					   TFLIVEPROP		enuLive		= LP_NONE,
					   TFLIVEPROPTF		enuLiveEx	= LP_EX_NONE,
					   TFDEADPROP		enuDead		= DP_NONE);

	OI_RESULT MKCOL(const TFXMLCh* pszTargetURI, const char* pszIfHeader, CRequestBodyProvider *pBodyProvider);
	OI_RESULT PROPPATCH(const TFXMLCh* pszTargetURI, CRBPVDXmlProppatch* cXml, const char* pszIfHeader=NULL); 
	OI_RESULT LOCK(const TFXMLCh* pszTargetURI, CDavLock* cLock, const char* pszIfHeader);
	OI_RESULT UNLOCK(const TFXMLCh* pszTargetURI, const char* pszLockToken);
	OI_RESULT GET(const TFXMLCh* pszTargetURI, const char* pszLocalPath, OICRANGE* pRange=NULL);
	OI_RESULT GET(const TFXMLCh* pszURI, int hFile, OICRANGE* pRange);
	OI_RESULT PUT(const TFXMLCh* pszURI, int hFile, const char* pszIfHeader, const char* pszContentType=NULL); 
#undef DELETE
	OI_RESULT DELETE(const TFXMLCh* pszTargetURI, const char* pszIfHeader, bool bForce=false);
	OI_RESULT MOVE(const TFXMLCh* pszSrc, const TFXMLCh* pszDest, CRBPVDXmlMove *pXml = NULL, bool bOverwrite = false, const char *pszIfHeader = NULL);
	OI_RESULT COPY(const TFXMLCh* pszSrc, const TFXMLCh* pszDest, CRBPVDXmlCopy *pXml = NULL, bool bOverwrite = false, const char *pszIfHeader = NULL);

	void SetHandler(CTFWsTransactionHandler* pHandler);
	void SetHandler(CTFWsNotificationHandler* pHandler);
	void SetHandler(CTFWsSystemInformationHandler* pHandler);

	void SetProgressHandle(TFHANDLE hProgress);

	int	GetAllowMethod(void);
	int GetAllowDASL(void);

	// server item
	void				SetServerItem(CTFServerResource* pSvrItem);
	CTFServerResource*	GetServerItem(void);
	const TFXMLCh*		GetServerID(void);

	bool CreateSession(void);

	void			SetStatus(TF_CONN_STATE enuStat);
	TF_CONN_STATE	GetStatus(void);


	int		AddRef(void);
	void	Release(void);
	int		GetRef(void);
	int		Detach(void);

	CTFLibWorkSessionWorker& operator =(const CTFLibWorkSessionWorker& source);
	
protected:
	CTFWsTransactionHandler*		m_pTransHandler;
	CTFWsTransactionHandler			m_cTransHandler;
	CTFWsNotificationHandler*		m_pNotifyHandler;
	CTFWsNotificationHandler		m_cNotifyHandler;
	CTFWsSystemInformationHandler*	m_pSysHandler;
	CTFWsSystemInformationHandler	m_cSysHandler;

private:
	void setHandler(void);
	void setAvailableMethods(OI_STRLIST_A vecAllow);
	void setAvailableDASL(OI_STRLIST_A vecURLs);
	void parseOptionsHeaders(OI_HEADERMAP mapHeaders);
	void rebuildSession(void);

public:
	TF_SIZE_T					m_unSessionID;		//< セッションID

private:
	int							m_unRefCount;		//< 参照数
	TF_CONN_STATE				m_enuState;			//< このセッションの状態
	time_t						m_tCreateTime;		//< 作成された時間
	CTFLibWorkSessionWrapper*	m_pSession;			//< ワークセッション
	TF_STRING_W					m_strServerID;		//< サーバID
	CTFServerResource*			m_pSvrItem;			//< サーバアイテム

	/*
	 * このワークセッションで作られたときに調べたサーバのOPTIONS
	 */
	int							m_iMethod;
	int							m_iDASL;

	// このワークセッションが利用できるプログレスハンドル
	TFHANDLE					m_hProgress;
};

TF_END_CLASSEXPORT

typedef std::vector<CTFLibWorkSessionWorker*>	CTFLibWorkSessionWorkerPtrVector;

#endif

